/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.RankVectorsScriptDocValues;
import org.elasticsearch.script.field.vectors.ByteRankVectors;
import org.elasticsearch.script.field.vectors.RankVectors;
import org.elasticsearch.script.field.vectors.RankVectorsDocValuesField;
import org.elasticsearch.script.field.vectors.VectorIterator;

public class ByteRankVectorsDocValuesField
extends RankVectorsDocValuesField {
    protected final BinaryDocValues input;
    private final BinaryDocValues magnitudes;
    protected final int dims;
    protected int numVecs;
    protected VectorIterator<byte[]> vectorValue;
    protected boolean decoded;
    protected BytesRef value;
    protected BytesRef magnitudesValue;
    private byte[] buffer;

    public ByteRankVectorsDocValuesField(BinaryDocValues input, BinaryDocValues magnitudes, String name, DenseVectorFieldMapper.ElementType elementType, int dims) {
        super(name, elementType);
        this.input = input;
        this.dims = dims;
        this.buffer = new byte[dims];
        this.magnitudes = magnitudes;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        this.decoded = false;
        if (this.input.advanceExact(docId)) {
            boolean magnitudesFound = this.magnitudes.advanceExact(docId);
            assert (magnitudesFound);
            this.value = this.input.binaryValue();
            assert (this.value.length % this.dims == 0);
            this.numVecs = this.value.length / this.dims;
            this.magnitudesValue = this.magnitudes.binaryValue();
            assert (this.magnitudesValue.length == this.numVecs * 4);
        } else {
            this.value = null;
            this.magnitudesValue = null;
            this.vectorValue = null;
            this.numVecs = 0;
        }
    }

    @Override
    public RankVectorsScriptDocValues toScriptDocValues() {
        return new RankVectorsScriptDocValues(this, this.dims);
    }

    protected RankVectors getVector() {
        return new ByteRankVectors(this.vectorValue, this.magnitudesValue, this.numVecs, this.dims);
    }

    @Override
    public RankVectors get() {
        if (this.isEmpty()) {
            return RankVectors.EMPTY;
        }
        this.decodeVectorIfNecessary();
        return this.getVector();
    }

    @Override
    public RankVectors get(RankVectors defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        this.decodeVectorIfNecessary();
        return this.getVector();
    }

    @Override
    public RankVectors getInternal() {
        return this.get(null);
    }

    private void decodeVectorIfNecessary() {
        if (!this.decoded && this.value != null) {
            this.vectorValue = new ByteVectorIterator(this.value, this.buffer, this.numVecs);
            this.decoded = true;
        }
    }

    @Override
    public int size() {
        return this.value == null ? 0 : this.value.length / this.dims;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    public static class ByteVectorIterator
    implements VectorIterator<byte[]> {
        private final byte[] buffer;
        private final BytesRef vectorValues;
        private final int size;
        private int idx = 0;

        public ByteVectorIterator(BytesRef vectorValues, byte[] buffer, int size) {
            assert (vectorValues.length == buffer.length * size);
            this.vectorValues = vectorValues;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.size;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new IllegalArgumentException("No more elements in the iterator");
            }
            System.arraycopy(this.vectorValues.bytes, this.vectorValues.offset + this.idx * this.buffer.length, this.buffer, 0, this.buffer.length);
            ++this.idx;
            return this.buffer;
        }

        @Override
        public Iterator<byte[]> copy() {
            return new ByteVectorIterator(this.vectorValues, new byte[this.buffer.length], this.size);
        }

        @Override
        public void reset() {
            this.idx = 0;
        }
    }
}

