/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.dangling;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.indices.dangling.delete.DeleteDanglingIndexRequest;
import org.elasticsearch.action.admin.indices.dangling.delete.TransportDeleteDanglingIndexAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestDeleteDanglingIndexAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_dangling/{index_uuid}"));
    }

    @Override
    public String getName() {
        return "delete_dangling_index";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeleteDanglingIndexRequest deleteRequest = new DeleteDanglingIndexRequest(request.param("index_uuid"), request.paramAsBoolean("accept_data_loss", false));
        deleteRequest.ackTimeout(RestUtils.getAckTimeout(request));
        deleteRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        return channel -> client.execute(TransportDeleteDanglingIndexAction.TYPE, deleteRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel, r -> RestStatus.ACCEPTED));
    }
}

