/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.SingleResultDeduplicator;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.ThrottledIterator;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Streams;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.RateLimitingInputStream;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.RepositoryStats;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.repositories.blobstore.FileRestoreContext;
import org.elasticsearch.repositories.blobstore.GetSnapshotInfoContext;
import org.elasticsearch.repositories.blobstore.ShardSnapshotTaskRunner;
import org.elasticsearch.snapshots.AbortedSnapshotException;
import org.elasticsearch.snapshots.PausedSnapshotException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotsServiceUtils;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger logger = LogManager.getLogger(BlobStoreRepository.class);
    protected volatile RepositoryMetadata metadata;
    protected final ThreadPool threadPool;
    public static final String STATELESS_SHARD_READ_THREAD_NAME = "stateless_shard_read";
    public static final String STATELESS_TRANSLOG_THREAD_NAME = "stateless_translog";
    public static final String STATELESS_SHARD_WRITE_THREAD_NAME = "stateless_shard_write";
    public static final String STATELESS_CLUSTER_STATE_READ_WRITE_THREAD_NAME = "stateless_cluster_state";
    public static final String STATELESS_SHARD_PREWARMING_THREAD_NAME = "stateless_prewarm";
    public static final String SEARCHABLE_SNAPSHOTS_CACHE_FETCH_ASYNC_THREAD_NAME = "searchable_snapshots_cache_fetch_async";
    public static final String SEARCHABLE_SNAPSHOTS_CACHE_PREWARMING_THREAD_NAME = "searchable_snapshots_cache_prewarming";
    public static final String INDEX_FILE_PREFIX = "index-";
    public static final String INDEX_LATEST_BLOB = "index.latest";
    private static final String TESTS_FILE = "tests-";
    public static final String METADATA_PREFIX = "meta-";
    public static final String SNAPSHOT_PREFIX = "snap-";
    public static final String METADATA_BLOB_NAME_SUFFIX = ".dat";
    public static final String METADATA_NAME_FORMAT = "meta-%s.dat";
    public static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    public static final String SNAPSHOT_INDEX_PREFIX = "index-";
    public static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    public static final String UPLOADED_DATA_BLOB_PREFIX = "__";
    public static final String URL_REPOSITORY_TYPE = "url";
    public static final String READONLY_SETTING_KEY = "readonly";
    private static final String VIRTUAL_DATA_BLOB_PREFIX = "v__";
    public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting("compress", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> CACHE_REPOSITORY_DATA = Setting.boolSetting("cache_repository_data", true, Setting.Property.DeprecatedWarning);
    public static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting("io_buffer_size", ByteSizeValue.parseBytesSizeValue("128kb", "io_buffer_size"), ByteSizeValue.parseBytesSizeValue("8kb", "buffer_size"), ByteSizeValue.parseBytesSizeValue("16mb", "io_buffer_size"), Setting.Property.NodeScope);
    public static final Setting<Boolean> SUPPORT_URL_REPO = Setting.boolSetting("support_url_repo", true, Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_SNAPSHOTS_SETTING = Setting.intSetting("max_number_of_snapshots", Integer.MAX_VALUE, 1, Setting.Property.NodeScope);
    public static final Setting<Boolean> USE_FOR_PEER_RECOVERY_SETTING = Setting.boolSetting("use_for_peer_recovery", false, new Setting.Property[0]);
    protected final boolean supportURLRepo;
    private final boolean compress;
    private final boolean cacheRepositoryData;
    private volatile RateLimiter snapshotRateLimiter;
    private volatile RateLimiter restoreRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    public static final ChecksumBlobStoreFormat<Metadata> GLOBAL_METADATA_FORMAT = new ChecksumBlobStoreFormat<Metadata>("metadata", "meta-%s.dat", (repoName, parser) -> Metadata.fromXContent(parser), ChunkedToXContent::wrapAsToXContent);
    public static final ChecksumBlobStoreFormat<IndexMetadata> INDEX_METADATA_FORMAT = new ChecksumBlobStoreFormat<IndexMetadata>("index-metadata", "meta-%s.dat", (repoName, parser) -> IndexMetadata.Builder.legacyFromXContent(parser), (repoName, parser) -> IndexMetadata.fromXContent(parser), Function.identity());
    private static final String SNAPSHOT_CODEC = "snapshot";
    public static final ChecksumBlobStoreFormat<SnapshotInfo> SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<SnapshotInfo>("snapshot", "snap-%s.dat", SnapshotInfo::fromXContentInternal, Function.identity());
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> INDEX_SHARD_SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot>("snapshot", "snap-%s.dat", (repoName, parser) -> BlobStoreIndexShardSnapshot.fromXContent(parser), Function.identity());
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> INDEX_SHARD_SNAPSHOTS_FORMAT = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots>("snapshots", "index-%s", (repoName, parser) -> BlobStoreIndexShardSnapshots.fromXContent(parser), Function.identity());
    public static final Setting<ByteSizeValue> MAX_SNAPSHOT_BYTES_PER_SEC = Setting.byteSizeSetting("max_snapshot_bytes_per_sec", ByteSizeValue.ofMb(40L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> MAX_RESTORE_BYTES_PER_SEC = Setting.byteSizeSetting("max_restore_bytes_per_sec", ByteSizeValue.ZERO, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final Set<String> DYNAMIC_SETTING_NAMES = Set.of(MAX_SNAPSHOT_BYTES_PER_SEC.getKey(), MAX_RESTORE_BYTES_PER_SEC.getKey());
    private final boolean readOnly;
    private final Object lock = new Object();
    private final SetOnce<BlobContainer> blobContainer = new SetOnce();
    private final SetOnce<BlobStore> blobStore = new SetOnce();
    private final BlobPath basePath;
    private final ClusterService clusterService;
    private final RecoverySettings recoverySettings;
    private final NamedXContentRegistry namedXContentRegistry;
    protected final BigArrays bigArrays;
    private boolean uncleanStart;
    private volatile boolean bestEffortConsistency;
    protected final int bufferSize;
    private final int maxSnapshotCount;
    private final ShardSnapshotTaskRunner shardSnapshotTaskRunner;
    private final ThrottledTaskRunner staleBlobDeleteRunner;
    private final SubscribableListener<Void> closedAndIdleListeners = new SubscribableListener();
    private final RefCounted activityRefs = AbstractRefCounted.of(() -> this.closedAndIdleListeners.onResponse(null));
    private final AtomicLong latestKnownRepoGen = new AtomicLong(-2L);
    private final AtomicReference<RepositoryData> latestKnownRepositoryData = new AtomicReference<RepositoryData>(RepositoryData.EMPTY);
    @Nullable
    private SubscribableListener<RepositoryData> repoDataInitialized;
    private final SingleResultDeduplicator<RepositoryData> repoDataLoadDeduplicator;
    public static final String READ_ONLY_USAGE_STATS_NAME = "read_only";
    public static final String READ_WRITE_USAGE_STATS_NAME = "read_write";

    public static String getRepositoryDataBlobName(long repositoryGeneration) {
        return "index-" + repositoryGeneration;
    }

    protected BlobStoreRepository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, BlobPath basePath) {
        this.metadata = metadata;
        this.threadPool = clusterService.getClusterApplierService().threadPool();
        this.clusterService = clusterService;
        this.bigArrays = bigArrays;
        this.recoverySettings = recoverySettings;
        this.compress = COMPRESS_SETTING.get(metadata.settings());
        this.supportURLRepo = SUPPORT_URL_REPO.get(metadata.settings());
        this.snapshotRateLimiter = this.getSnapshotRateLimiter();
        this.restoreRateLimiter = this.getRestoreRateLimiter();
        this.readOnly = metadata.settings().getAsBoolean(READONLY_SETTING_KEY, false);
        this.cacheRepositoryData = CACHE_REPOSITORY_DATA.get(metadata.settings());
        this.bufferSize = Math.toIntExact(BUFFER_SIZE_SETTING.get(metadata.settings()).getBytes());
        this.namedXContentRegistry = namedXContentRegistry;
        this.basePath = basePath;
        this.maxSnapshotCount = MAX_SNAPSHOTS_SETTING.get(metadata.settings());
        this.repoDataLoadDeduplicator = new SingleResultDeduplicator(this.threadPool.getThreadContext(), listener -> this.threadPool.executor("snapshot_meta").execute(ActionRunnable.wrap(listener, this::doGetRepositoryData)));
        this.shardSnapshotTaskRunner = new ShardSnapshotTaskRunner(this.threadPool.info(SNAPSHOT_CODEC).getMax(), this.threadPool.executor(SNAPSHOT_CODEC), this::doSnapshotShard, this::snapshotFile);
        this.staleBlobDeleteRunner = new ThrottledTaskRunner("cleanupStaleBlobs", this.threadPool.info(SNAPSHOT_CODEC).getMax(), this.threadPool.executor(SNAPSHOT_CODEC));
    }

    @Override
    protected void doStart() {
        this.uncleanStart = this.metadata.pendingGeneration() > -1L && this.metadata.generation() != this.metadata.pendingGeneration();
        ByteSizeValue chunkSize = this.chunkSize();
        if (chunkSize != null && chunkSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("the chunk size cannot be negative: [" + chunkSize + "]");
        }
    }

    @Override
    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        BlobStore store;
        this.activityRefs.decRef();
        Object object = this.lock;
        synchronized (object) {
            store = (BlobStore)this.blobStore.get();
        }
        if (store != null) {
            try {
                store.close();
            }
            catch (Exception t) {
                logger.warn("cannot close blob store", (Throwable)t);
            }
        }
    }

    @Override
    public void awaitIdle() {
        assert (this.lifecycle.closed());
        PlainActionFuture future = new PlainActionFuture();
        this.closedAndIdleListeners.addListener(future);
        future.actionGet();
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    @Override
    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, @Nullable ShardGeneration shardGeneration, ActionListener<ShardSnapshotResult> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot clone shard snapshot on a readonly repository", new Object[0]));
            return;
        }
        IndexId index = shardId.index();
        int shardNum = shardId.shardId();
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.supply(listener, () -> {
            BlobStoreIndexShardSnapshots existingSnapshots;
            ShardGeneration newGen;
            ShardGeneration existingShardGen;
            long startTime = this.threadPool.absoluteTimeInMillis();
            BlobContainer shardContainer = this.shardContainer(index, shardNum);
            if (shardGeneration == null) {
                Tuple<BlobStoreIndexShardSnapshots, Long> tuple = this.buildBlobStoreIndexShardSnapshots(shardContainer.listBlobsByPrefix(OperationPurpose.SNAPSHOT_METADATA, "index-").keySet(), shardContainer);
                existingShardGen = new ShardGeneration((Long)tuple.v2());
                newGen = new ShardGeneration((Long)tuple.v2() + 1L);
                existingSnapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
            } else {
                newGen = ShardGeneration.newGeneration();
                existingSnapshots = (BlobStoreIndexShardSnapshots)this.buildBlobStoreIndexShardSnapshots(index, shardNum, Collections.emptySet(), shardContainer, shardGeneration).v1();
                existingShardGen = shardGeneration;
            }
            SnapshotFiles existingTargetFiles = null;
            SnapshotFiles sourceFiles = null;
            for (SnapshotFiles existingSnapshot : existingSnapshots) {
                String snapshotName = existingSnapshot.snapshot();
                if (snapshotName.equals(target.getName())) {
                    existingTargetFiles = existingSnapshot;
                } else if (snapshotName.equals(source.getName())) {
                    sourceFiles = existingSnapshot;
                }
                if (sourceFiles == null || existingTargetFiles == null) continue;
                break;
            }
            if (sourceFiles == null) {
                throw new RepositoryException(this.metadata.name(), "Can't create clone of [" + shardId + "] for snapshot [" + target + "]. The source snapshot [" + source + "] was not found in the shard metadata.", new Object[0]);
            }
            if (existingTargetFiles != null) {
                if (existingTargetFiles.isSame(sourceFiles)) {
                    return new ShardSnapshotResult(existingShardGen, ByteSizeValue.ofBytes(existingTargetFiles.totalSize()), BlobStoreRepository.getSegmentInfoFileCount(existingTargetFiles.indexFiles()));
                }
                throw new RepositoryException(this.metadata.name(), "Can't create clone of [" + shardId + "] for snapshot [" + target + "]. A snapshot by that name already exists for this shard.", new Object[0]);
            }
            BlobStoreIndexShardSnapshot sourceMeta = this.loadShardSnapshot(shardContainer, source);
            logger.trace("[{}] [{}] writing shard snapshot file for clone", (Object)shardId, (Object)target);
            INDEX_SHARD_SNAPSHOT_FORMAT.write(sourceMeta.asClone(target.getName(), startTime, this.threadPool.absoluteTimeInMillis() - startTime), shardContainer, target.getUUID(), this.compress);
            INDEX_SHARD_SNAPSHOTS_FORMAT.write(existingSnapshots.withClone(source.getName(), target.getName()), shardContainer, newGen.getGenerationUUID(), this.compress);
            return new ShardSnapshotResult(newGen, ByteSizeValue.ofBytes(sourceMeta.totalSize()), BlobStoreRepository.getSegmentInfoFileCount(sourceMeta.indexFiles()));
        }));
    }

    private static int getSegmentInfoFileCount(List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles) {
        return Math.toIntExact(Math.min(Integer.MAX_VALUE, indexFiles.stream().filter(fi -> fi.physicalName().endsWith(".si")).count()));
    }

    @Override
    public boolean canUpdateInPlace(Settings updatedSettings, Set<String> ignoredSettings) {
        Settings current = this.metadata.settings();
        if (current.equals(updatedSettings)) {
            return true;
        }
        HashSet<String> changedSettingNames = new HashSet<String>(current.keySet());
        changedSettingNames.addAll(updatedSettings.keySet());
        changedSettingNames.removeAll(ignoredSettings);
        changedSettingNames.removeIf(setting -> Objects.equals(current.get((String)setting), updatedSettings.get((String)setting)));
        changedSettingNames.removeAll(DYNAMIC_SETTING_NAMES);
        return changedSettingNames.isEmpty();
    }

    @Override
    public void updateState(ClusterState state) {
        Settings previousSettings = this.metadata.settings();
        this.metadata = this.getRepoMetadata(state);
        Settings updatedSettings = this.metadata.settings();
        if (!updatedSettings.equals(previousSettings)) {
            this.snapshotRateLimiter = this.getSnapshotRateLimiter();
            this.restoreRateLimiter = this.getRestoreRateLimiter();
        }
        this.uncleanStart = this.uncleanStart && this.metadata.generation() != this.metadata.pendingGeneration();
        boolean wasBestEffortConsistency = this.bestEffortConsistency;
        boolean bl = this.bestEffortConsistency = this.uncleanStart || this.isReadOnly() || this.metadata.generation() == -2L;
        if (this.isReadOnly()) {
            return;
        }
        if (this.bestEffortConsistency) {
            long bestGenerationFromCS = this.bestGeneration(SnapshotsInProgress.get(state).forRepo(this.metadata.name()));
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(SnapshotDeletionsInProgress.get(state).getEntries());
            }
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(RepositoryCleanupInProgress.get(state).entries());
            }
            long finalBestGen = Math.max(bestGenerationFromCS, this.metadata.generation());
            this.latestKnownRepoGen.accumulateAndGet(finalBestGen, Math::max);
        } else {
            long previousBest = this.latestKnownRepoGen.getAndSet(this.metadata.generation());
            if (previousBest != this.metadata.generation()) {
                assert (wasBestEffortConsistency || this.metadata.generation() == -3L || previousBest < this.metadata.generation()) : "Illegal move from repository generation [" + previousBest + "] to generation [" + this.metadata.generation() + "]";
                logger.debug("Updated repository generation from [{}] to [{}]", (Object)previousBest, (Object)this.metadata.generation());
            }
        }
    }

    private long bestGeneration(Collection<? extends RepositoryOperation> operations) {
        String repoName = this.metadata.name();
        return operations.stream().filter(e -> e.repository().equals(repoName)).mapToLong(RepositoryOperation::repositoryStateId).max().orElse(-1L);
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    BlobContainer getBlobContainer() {
        return (BlobContainer)this.blobContainer.get();
    }

    protected BlobStore getBlobStore() {
        return (BlobStore)this.blobStore.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer blobContainer() {
        this.assertSnapshotOrStatelessPermittedThreadPool();
        if (!this.lifecycle.started()) {
            throw this.notStartedException();
        }
        BlobContainer blobContainer = (BlobContainer)this.blobContainer.get();
        if (blobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                blobContainer = (BlobContainer)this.blobContainer.get();
                if (blobContainer == null) {
                    blobContainer = this.blobStore().blobContainer(this.basePath());
                    this.blobContainer.set((Object)blobContainer);
                }
            }
        }
        return blobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStore blobStore() {
        this.assertSnapshotOrStatelessPermittedThreadPool();
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = (BlobStore)this.blobStore.get();
                if (store == null) {
                    if (!this.lifecycle.started()) {
                        throw this.notStartedException();
                    }
                    try {
                        store = this.createBlobStore();
                    }
                    catch (RepositoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RepositoryException(this.metadata.name(), "cannot create blob store", e, new Object[0]);
                    }
                    this.blobStore.set((Object)store);
                }
            }
        }
        return store;
    }

    protected abstract BlobStore createBlobStore() throws Exception;

    public BlobPath basePath() {
        return this.basePath;
    }

    protected final boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RepositoryStats stats() {
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            return RepositoryStats.EMPTY_STATS;
        }
        return new RepositoryStats(store.stats());
    }

    private RepositoryData safeRepositoryData(long repositoryDataGeneration, Map<String, BlobMetadata> rootBlobs) {
        RepositoryData cached;
        long genToLoad;
        long generation = this.latestGeneration(rootBlobs.keySet());
        if (this.bestEffortConsistency) {
            genToLoad = this.latestKnownRepoGen.accumulateAndGet(repositoryDataGeneration, Math::max);
            cached = null;
        } else {
            genToLoad = this.latestKnownRepoGen.get();
            cached = this.latestKnownRepositoryData.get();
        }
        if (genToLoad > generation) {
            logger.debug("Determined repository's generation from its contents to [" + generation + "] but current generation is at least [" + genToLoad + "]");
        }
        if (genToLoad != repositoryDataGeneration) {
            throw new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + repositoryDataGeneration + "], actual current generation [" + genToLoad + "]", new Object[0]);
        }
        if (cached != null && cached.getGenId() == genToLoad) {
            return cached;
        }
        return this.getRepositoryData(genToLoad);
    }

    protected ActionListener<RepositoryData> wrapWithWeakConsistencyProtection(ActionListener<RepositoryData> listener) {
        return listener;
    }

    @Override
    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryDataGeneration, IndexVersion minimumNodeVersion, ActionListener<RepositoryData> repositoryDataUpdateListener, Runnable onCompletion) {
        this.createSnapshotsDeletion(snapshotIds, repositoryDataGeneration, minimumNodeVersion, repositoryDataUpdateListener.delegateFailureAndWrap((l, snapshotsDeletion) -> snapshotsDeletion.runDelete((ActionListener<RepositoryData>)l, onCompletion)));
    }

    public void cleanup(long repositoryDataGeneration, IndexVersion repositoryFormatIndexVersion, ActionListener<DeleteResult> listener) {
        this.createSnapshotsDeletion(List.of(), repositoryDataGeneration, repositoryFormatIndexVersion, listener.delegateFailureAndWrap((delegate, snapshotsDeletion) -> snapshotsDeletion.runCleanup((ActionListener<DeleteResult>)delegate)));
    }

    private void createSnapshotsDeletion(Collection<SnapshotId> snapshotIds, long repositoryDataGeneration, IndexVersion minimumNodeVersion, ActionListener<SnapshotsDeletion> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "repository is readonly", new Object[0]));
        } else {
            this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.supply(listener, () -> {
                Map<String, BlobMetadata> originalRootBlobs = this.blobContainer().listBlobs(OperationPurpose.SNAPSHOT_METADATA);
                RepositoryData originalRepositoryData = this.safeRepositoryData(repositoryDataGeneration, originalRootBlobs);
                return new SnapshotsDeletion(snapshotIds, repositoryDataGeneration, SnapshotsServiceUtils.minCompatibleVersion(minimumNodeVersion, originalRepositoryData, snapshotIds), originalRootBlobs, this.blobStore().blobContainer(this.indicesPath()).children(OperationPurpose.SNAPSHOT_DATA), originalRepositoryData);
            }));
        }
    }

    @Override
    public void finalizeSnapshot(final FinalizeSnapshotContext finalizeSnapshotContext) {
        assert (ThreadPool.assertCurrentThreadPool(SNAPSHOT_CODEC));
        long repositoryStateId = finalizeSnapshotContext.repositoryStateId();
        SnapshotInfo snapshotInfo = finalizeSnapshotContext.snapshotInfo();
        assert (repositoryStateId > -2L) : "Must finalize based on a valid repository generation but received [" + repositoryStateId + "]";
        Collection<IndexId> indices = finalizeSnapshotContext.updatedShardGenerations().liveIndices().indices();
        final SnapshotId snapshotId = snapshotInfo.snapshotId();
        IndexVersion repositoryMetaVersion = finalizeSnapshotContext.repositoryMetaVersion();
        boolean writeShardGens = SnapshotsServiceUtils.useShardGenerations(repositoryMetaVersion);
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        boolean writeIndexGens = SnapshotsServiceUtils.useIndexGenerations(repositoryMetaVersion);
        SubscribableListener.newForked(listener -> this.getRepositoryData(executor, (ActionListener<RepositoryData>)listener)).andThen((l, existingRepositoryData) -> {
            int existingSnapshotCount = existingRepositoryData.getSnapshotIds().size();
            if (existingSnapshotCount >= this.maxSnapshotCount) {
                throw new RepositoryException(this.metadata.name(), "Cannot add another snapshot to this repository as it already contains [" + existingSnapshotCount + "] snapshots and is configured to hold up to [" + this.maxSnapshotCount + "] snapshots only.", new Object[0]);
            }
            record MetadataWriteResult(RepositoryData existingRepositoryData, Map<IndexId, String> indexMetas, Map<String, String> indexMetaIdentifiers) {
            }
            MetadataWriteResult metadataWriteResult = writeIndexGens ? new MetadataWriteResult((RepositoryData)existingRepositoryData, (Map<IndexId, String>)ConcurrentCollections.newConcurrentMap(), (Map<String, String>)ConcurrentCollections.newConcurrentMap()) : new MetadataWriteResult((RepositoryData)existingRepositoryData, null, null);
            try (RefCountingListener allMetaListeners = new RefCountingListener(l.map(ignored -> metadataWriteResult));){
                Metadata clusterMetadata = finalizeSnapshotContext.clusterMetadata();
                executor.execute(ActionRunnable.run(allMetaListeners.acquire(), (CheckedRunnable<Exception>)((CheckedRunnable)() -> GLOBAL_METADATA_FORMAT.write(clusterMetadata, this.blobContainer(), snapshotId.getUUID(), this.compress))));
                for (IndexId index : indices) {
                    executor.execute(ActionRunnable.run(allMetaListeners.acquire(), (CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                        IndexMetadata indexMetaData = clusterMetadata.index(index.getName());
                        if (writeIndexGens) {
                            String identifiers = IndexMetaDataGenerations.buildUniqueIdentifier(indexMetaData);
                            String metaUUID = existingRepositoryData.indexMetaDataGenerations().getIndexMetaBlobId(identifiers);
                            if (metaUUID == null) {
                                metaUUID = UUIDs.base64UUID();
                                INDEX_METADATA_FORMAT.write(indexMetaData, this.indexContainer(index), metaUUID, this.compress);
                                metadataWriteResult.indexMetaIdentifiers().put(identifiers, metaUUID);
                            }
                            metadataWriteResult.indexMetas().put(index, identifiers);
                        } else {
                            INDEX_METADATA_FORMAT.write(clusterMetadata.index(index.getName()), this.indexContainer(index), snapshotId.getUUID(), this.compress);
                        }
                    })));
                }
                assert (ThreadPool.assertCurrentThreadPool(SNAPSHOT_CODEC));
                ActionListener.completeWith(allMetaListeners.acquire(), () -> {
                    SNAPSHOT_FORMAT.write(snapshotInfo, this.blobContainer(), snapshotId.getUUID(), this.compress);
                    return null;
                });
            }
        }).andThen((l, metadataWriteResult) -> {
            assert (ThreadPool.assertCurrentThreadPool(SNAPSHOT_CODEC));
            RepositoryData.SnapshotDetails snapshotDetails = RepositoryData.SnapshotDetails.fromSnapshotInfo(snapshotInfo);
            RepositoryData existingRepositoryData = metadataWriteResult.existingRepositoryData();
            this.writeIndexGen(existingRepositoryData.addSnapshot(snapshotId, snapshotDetails, finalizeSnapshotContext.updatedShardGenerations(), metadataWriteResult.indexMetas(), metadataWriteResult.indexMetaIdentifiers()), repositoryStateId, repositoryMetaVersion, new Function<ClusterState, ClusterState>(){

                @Override
                public ClusterState apply(ClusterState state) {
                    return finalizeSnapshotContext.updatedClusterState(state);
                }

                public String toString() {
                    return "finalizing snapshot [" + BlobStoreRepository.this.metadata.name() + "][" + snapshotId + "]";
                }
            }, l.map(newRepositoryData -> {
                record RootBlobUpdateResult(RepositoryData oldRepositoryData, RepositoryData newRepositoryData) {
                }
                return new RootBlobUpdateResult(existingRepositoryData, (RepositoryData)newRepositoryData);
            }));
        }).andThen((l, rootBlobUpdateResult) -> {
            l.onResponse(rootBlobUpdateResult.newRepositoryData());
            this.cleanupOldMetadata(rootBlobUpdateResult.oldRepositoryData(), rootBlobUpdateResult.newRepositoryData(), finalizeSnapshotContext, writeShardGens);
        }).addListener(finalizeSnapshotContext.delegateResponse((l, e) -> l.onFailure(new SnapshotException(this.metadata.name(), snapshotId, "failed to update snapshot in repository", (Throwable)e))));
    }

    private void cleanupOldMetadata(RepositoryData existingRepositoryData, RepositoryData updatedRepositoryData, final FinalizeSnapshotContext finalizeSnapshotContext, boolean writeShardGenerations) {
        final HashSet<Object> toDelete = new HashSet<Object>();
        long newRepoGeneration = updatedRepositoryData.getGenId();
        for (long gen = Math.max(Math.max(existingRepositoryData.getGenId() - 1L, 0L), newRepoGeneration - 1000L); gen < newRepoGeneration; ++gen) {
            toDelete.add(BlobStoreRepository.getRepositoryDataBlobName(gen));
        }
        if (writeShardGenerations) {
            int prefixPathLen = this.basePath().buildAsString().length();
            updatedRepositoryData.shardGenerations().obsoleteShardGenerations(existingRepositoryData.shardGenerations()).forEach((indexId, gens) -> gens.forEach((shardId, oldGen) -> toDelete.add(this.shardPath((IndexId)indexId, (int)shardId).buildAsString().substring(prefixPathLen) + "index-" + oldGen.getGenerationUUID())));
            for (Map.Entry<RepositoryShardId, Set<ShardGeneration>> obsoleteEntry : finalizeSnapshotContext.obsoleteShardGenerations().entrySet()) {
                String containerPath = this.shardPath(obsoleteEntry.getKey().index(), obsoleteEntry.getKey().shardId()).buildAsString().substring(prefixPathLen) + "index-";
                for (ShardGeneration shardGeneration : obsoleteEntry.getValue()) {
                    toDelete.add(containerPath + shardGeneration);
                }
            }
        }
        if (!toDelete.isEmpty()) {
            this.threadPool.executor(SNAPSHOT_CODEC).execute(new AbstractRunnable(){

                @Override
                protected void doRun() throws Exception {
                    BlobStoreRepository.this.deleteFromContainer(OperationPurpose.SNAPSHOT_METADATA, BlobStoreRepository.this.blobContainer(), toDelete.iterator());
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn("Failed to clean up old metadata blobs", (Throwable)e);
                }

                @Override
                public void onAfter() {
                    finalizeSnapshotContext.onDone();
                }
            });
        } else {
            finalizeSnapshotContext.onDone();
        }
    }

    @Override
    public void getSnapshotInfo(Collection<SnapshotId> snapshotIds, boolean abortOnFailure, BooleanSupplier isCancelled, CheckedConsumer<SnapshotInfo, Exception> consumer, ActionListener<Void> listener) {
        GetSnapshotInfoContext context = new GetSnapshotInfoContext(snapshotIds, abortOnFailure, isCancelled, (ctx, sni) -> {
            try {
                consumer.accept(sni);
            }
            catch (Exception e) {
                ctx.onFailure(e);
            }
        }, listener);
        int workers = Math.min(this.threadPool.info("snapshot_meta").getMax(), context.snapshotIds().size());
        LinkedBlockingQueue<SnapshotId> queue = new LinkedBlockingQueue<SnapshotId>(context.snapshotIds());
        for (int i = 0; i < workers; ++i) {
            this.getOneSnapshotInfo(queue, context);
        }
    }

    private void getOneSnapshotInfo(BlockingQueue<SnapshotId> queue, GetSnapshotInfoContext context) {
        SnapshotId snapshotId = (SnapshotId)queue.poll();
        if (snapshotId == null) {
            return;
        }
        this.threadPool.executor("snapshot_meta").execute(() -> {
            if (context.done()) {
                return;
            }
            if (context.isCancelled()) {
                queue.clear();
                context.onFailure(new TaskCancelledException("task cancelled"));
                return;
            }
            Exception failure = null;
            SnapshotInfo snapshotInfo = null;
            try {
                snapshotInfo = SNAPSHOT_FORMAT.read(this.metadata.name(), this.blobContainer(), snapshotId.getUUID(), this.namedXContentRegistry);
            }
            catch (NoSuchFileException ex) {
                failure = new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
            }
            catch (IOException | NotXContentException ex) {
                failure = new SnapshotException(this.metadata.name(), snapshotId, "failed to get snapshot info" + snapshotId, ex);
            }
            catch (Exception e) {
                Exception exception = failure = e instanceof SnapshotException ? e : new SnapshotException(this.metadata.name(), snapshotId, "Snapshot could not be read", e);
            }
            if (failure != null) {
                if (context.abortOnFailure()) {
                    queue.clear();
                }
                context.onFailure(failure);
            } else {
                assert (snapshotInfo != null);
                context.onResponse(snapshotInfo);
            }
            this.getOneSnapshotInfo(queue, context);
        });
    }

    @Override
    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        try {
            return GLOBAL_METADATA_FORMAT.read(this.metadata.name(), this.blobContainer(), snapshotId.getUUID(), this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read global metadata", ex);
        }
    }

    @Override
    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) throws IOException {
        try {
            return INDEX_METADATA_FORMAT.read(this.metadata.name(), this.indexContainer(index), repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, index), this.namedXContentRegistry);
        }
        catch (NoSuchFileException e) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)e);
        }
    }

    private void deleteFromContainer(OperationPurpose purpose, final BlobContainer container, final Iterator<String> blobs) throws IOException {
        Iterator<String> wrappedIterator = logger.isTraceEnabled() ? new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return blobs.hasNext();
            }

            @Override
            public String next() {
                String blobName = (String)blobs.next();
                logger.trace("[{}] Deleting [{}] from [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)blobName, (Object)container.path());
                return blobName;
            }
        } : blobs;
        container.deleteBlobsIgnoringIfNotExists(purpose, wrappedIterator);
    }

    private BlobPath indicesPath() {
        return this.basePath().add("indices");
    }

    private BlobContainer indexContainer(IndexId indexId) {
        return this.blobStore().blobContainer(this.indexPath(indexId));
    }

    private BlobContainer shardContainer(IndexId indexId, ShardId shardId) {
        return this.shardContainer(indexId, shardId.getId());
    }

    private BlobPath indexPath(IndexId indexId) {
        return this.indicesPath().add(indexId.getId());
    }

    private BlobPath shardPath(IndexId indexId, int shardId) {
        return this.indexPath(indexId).add(Integer.toString(shardId));
    }

    public BlobContainer shardContainer(IndexId indexId, int shardId) {
        return this.blobStore().blobContainer(this.shardPath(indexId, shardId));
    }

    private RateLimiter getRateLimiter(RateLimiter rateLimiter, ByteSizeValue maxConfiguredBytesPerSec, String settingKey, boolean warnIfOverRecovery) {
        if (maxConfiguredBytesPerSec.getBytes() <= 0L) {
            return null;
        }
        ByteSizeValue effectiveRecoverySpeed = this.recoverySettings.getMaxBytesPerSec();
        if (warnIfOverRecovery && effectiveRecoverySpeed.getBytes() > 0L && maxConfiguredBytesPerSec.getBytes() > effectiveRecoverySpeed.getBytes()) {
            logger.warn("repository [{}] has a rate limit [{}={}] per second which is above the effective recovery rate limit [{}={}] per second, thus the repository rate limit will be superseded by the recovery rate limit", (Object)this.metadata.name(), (Object)settingKey, (Object)maxConfiguredBytesPerSec, (Object)RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.getKey(), (Object)effectiveRecoverySpeed);
        }
        if (rateLimiter != null) {
            rateLimiter.setMBPerSec(maxConfiguredBytesPerSec.getMbFrac());
            return rateLimiter;
        }
        return new RateLimiter.SimpleRateLimiter(maxConfiguredBytesPerSec.getMbFrac());
    }

    RateLimiter getSnapshotRateLimiter() {
        Settings repositorySettings = this.metadata.settings();
        ByteSizeValue maxConfiguredBytesPerSec = MAX_SNAPSHOT_BYTES_PER_SEC.get(repositorySettings);
        if (!MAX_SNAPSHOT_BYTES_PER_SEC.exists(repositorySettings) && this.recoverySettings.nodeBandwidthSettingsExist()) {
            assert (maxConfiguredBytesPerSec.getMb() == 40L);
            maxConfiguredBytesPerSec = ByteSizeValue.ZERO;
        }
        return this.getRateLimiter(this.snapshotRateLimiter, maxConfiguredBytesPerSec, MAX_SNAPSHOT_BYTES_PER_SEC.getKey(), this.recoverySettings.nodeBandwidthSettingsExist());
    }

    RateLimiter getRestoreRateLimiter() {
        return this.getRateLimiter(this.restoreRateLimiter, MAX_RESTORE_BYTES_PER_SEC.get(this.metadata.settings()), MAX_RESTORE_BYTES_PER_SEC.getKey(), true);
    }

    @Override
    public long getSnapshotThrottleTimeInNanos() {
        return this.snapshotRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRestoreThrottleTimeInNanos() {
        return this.restoreRateLimitingTimeInNanos.count();
    }

    private void assertSnapshotOrStatelessPermittedThreadPool() {
        assert (ThreadPool.assertCurrentThreadPool(SNAPSHOT_CODEC, "snapshot_meta", "generic", STATELESS_SHARD_READ_THREAD_NAME, STATELESS_TRANSLOG_THREAD_NAME, STATELESS_SHARD_WRITE_THREAD_NAME, STATELESS_CLUSTER_STATE_READ_WRITE_THREAD_NAME, STATELESS_SHARD_PREWARMING_THREAD_NAME, SEARCHABLE_SNAPSHOTS_CACHE_FETCH_ASYNC_THREAD_NAME, SEARCHABLE_SNAPSHOTS_CACHE_PREWARMING_THREAD_NAME));
    }

    @Override
    public String startVerification() {
        try {
            if (this.isReadOnly()) {
                this.latestIndexBlobId();
                return "read-only";
            }
            String seed = UUIDs.randomBase64UUID();
            byte[] testBytes = org.elasticsearch.common.Strings.toUTF8Bytes(seed);
            BlobContainer testContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            testContainer.writeBlobAtomic(OperationPurpose.SNAPSHOT_METADATA, "master.dat", new BytesArray(testBytes), true);
            return seed;
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "path " + this.basePath() + " is not accessible on master node", exp);
        }
    }

    @Override
    public void endVerification(String seed) {
        if (!this.isReadOnly()) {
            try {
                String testPrefix = BlobStoreRepository.testBlobPrefix(seed);
                this.blobStore().blobContainer(this.basePath().add(testPrefix)).delete(OperationPurpose.SNAPSHOT_METADATA);
            }
            catch (Exception exp) {
                throw new RepositoryVerificationException(this.metadata.name(), "cannot delete test data at " + this.basePath(), exp);
            }
        }
    }

    @Override
    public void getRepositoryData(Executor responseExecutor, ActionListener<RepositoryData> listener) {
        block5: {
            assert (this.clusterService.localNode().isMasterNode()) : "should only load repository data on master nodes";
            do {
                if (!this.lifecycle.started()) {
                    listener.onFailure(this.notStartedException());
                    return;
                }
                if (this.latestKnownRepoGen.get() == -3L) {
                    listener.onFailure(this.corruptedStateException(null, null));
                    return;
                }
                RepositoryData cached = this.latestKnownRepositoryData.get();
                if (!this.bestEffortConsistency && cached.getGenId() == this.latestKnownRepoGen.get()) {
                    listener.onResponse(cached);
                    return;
                }
                if (this.metadata.generation() != -2L || this.isReadOnly()) break block5;
                logger.debug("[{}] loading repository metadata for the first time, trying to determine correct generation and to store it in the cluster state", (Object)this.metadata.name());
            } while (!this.initializeRepoGenerationTracking(responseExecutor, listener));
            return;
        }
        logger.trace("[{}] loading un-cached repository data with best known repository generation [{}]", (Object)this.metadata.name(), (Object)this.latestKnownRepoGen);
        this.repoDataLoadDeduplicator.execute(new ThreadedActionListener<RepositoryData>(responseExecutor, listener));
    }

    private RepositoryException notStartedException() {
        return new RepositoryException(this.metadata.name(), "repository is not in started state", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeRepoGenerationTracking(Executor responseExecutor, ActionListener<RepositoryData> listener) {
        ActionListener<RepositoryData> listenerToComplete;
        SubscribableListener<RepositoryData> listenerToSubscribe;
        BlobStoreRepository blobStoreRepository = this;
        synchronized (blobStoreRepository) {
            if (this.repoDataInitialized == null) {
                if (this.metadata.generation() != -2L) {
                    return false;
                }
                logger.trace("[{}] initializing repository generation in cluster state", (Object)this.metadata.name());
                this.repoDataInitialized = listenerToSubscribe = new SubscribableListener();
                listenerToComplete = new ActionListener<RepositoryData>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private ActionListener<RepositoryData> acquireAndClearRepoDataInitialized() {
                        BlobStoreRepository blobStoreRepository = BlobStoreRepository.this;
                        synchronized (blobStoreRepository) {
                            assert (BlobStoreRepository.this.repoDataInitialized == listenerToSubscribe);
                            BlobStoreRepository.this.repoDataInitialized = null;
                            return listenerToSubscribe;
                        }
                    }

                    @Override
                    public void onResponse(RepositoryData repositoryData) {
                        this.acquireAndClearRepoDataInitialized().onResponse(repositoryData);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn(() -> Strings.format((String)"[%s] Exception when initializing repository generation in cluster state", (Object[])new Object[]{BlobStoreRepository.this.metadata.name()}), (Throwable)e);
                        this.acquireAndClearRepoDataInitialized().onFailure(e);
                    }
                };
            } else {
                logger.trace("[{}] waiting for existing initialization of repository metadata generation in cluster state", (Object)this.metadata.name());
                listenerToComplete = null;
                listenerToSubscribe = this.repoDataInitialized;
            }
        }
        if (listenerToComplete != null) {
            SubscribableListener.newForked(this.repoDataLoadDeduplicator::execute).andThen((l, repoData) -> this.submitUnbatchedTask("set initial safe repository generation [" + this.metadata.name() + "][" + repoData.getGenId() + "]", new ClusterStateUpdateTask((RepositoryData)repoData, (ActionListener)l){
                final /* synthetic */ RepositoryData val$repoData;
                final /* synthetic */ ActionListener val$l;
                {
                    this.val$repoData = repositoryData;
                    this.val$l = actionListener;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return BlobStoreRepository.this.getClusterStateWithUpdatedRepositoryGeneration(currentState, this.val$repoData);
                }

                @Override
                public void onFailure(Exception e) {
                    this.val$l.onFailure(e);
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    this.val$l.onResponse(this.val$repoData);
                }
            })).andThen((l, repoData) -> {
                logger.trace("[{}] initialized repository generation in cluster state to [{}]", (Object)this.metadata.name(), (Object)repoData.getGenId());
                this.threadPool.generic().execute(ActionRunnable.supply(ActionListener.runAfter(l, () -> logger.trace("[{}] called listeners after initializing repository to generation [{}]", (Object)this.metadata.name(), (Object)repoData.getGenId())), () -> repoData));
            }).addListener(listenerToComplete);
        }
        listenerToSubscribe.addListener(listener, responseExecutor, this.threadPool.getThreadContext());
        return true;
    }

    private ClusterState getClusterStateWithUpdatedRepositoryGeneration(ClusterState currentState, RepositoryData repoData) {
        RepositoryMetadata repoMetadata = this.getRepoMetadata(currentState);
        if (repoMetadata.generation() != -2L) {
            throw new RepositoryException(repoMetadata.name(), "Found unexpected initialized repo metadata [" + repoMetadata + "]", new Object[0]);
        }
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", RepositoriesMetadata.get(currentState).withUpdatedGeneration(repoMetadata.name(), repoData.getGenId(), repoData.getGenId()))).build();
    }

    private void doGetRepositoryData(ActionListener<RepositoryData> listener) {
        long lastFailedGeneration = -2L;
        while (true) {
            long genToLoad;
            if (this.bestEffortConsistency) {
                long generation;
                try {
                    generation = this.latestIndexBlobId();
                }
                catch (Exception e) {
                    listener.onFailure(new RepositoryException(this.metadata.name(), "Could not determine repository generation from root blobs", e, new Object[0]));
                    return;
                }
                genToLoad = this.latestKnownRepoGen.accumulateAndGet(generation, Math::max);
                if (genToLoad > generation) {
                    logger.info("Determined repository generation [{}] from repository contents but correct generation must be at least [{}]", (Object)generation, (Object)genToLoad);
                }
            } else {
                genToLoad = this.latestKnownRepoGen.get();
            }
            try {
                RepositoryData cached = this.latestKnownRepositoryData.get();
                if (!this.bestEffortConsistency && cached.getGenId() == genToLoad) {
                    listener.onResponse(cached);
                } else {
                    RepositoryData loaded = this.getRepositoryData(genToLoad);
                    if (cached == null || cached.getGenId() < genToLoad) {
                        this.cacheRepositoryData(loaded, IndexVersion.current());
                    }
                    if (loaded.getUuid().equals(this.metadata.uuid())) {
                        listener.onResponse(loaded);
                    } else {
                        RepositoriesService.updateRepositoryUuidInMetadata(this.clusterService, this.metadata.name(), loaded, new ThreadedActionListener<Void>(this.threadPool.generic(), listener.map(v -> loaded)));
                    }
                }
                return;
            }
            catch (RepositoryException e) {
                if (genToLoad != this.latestKnownRepoGen.get() && genToLoad != lastFailedGeneration) {
                    lastFailedGeneration = genToLoad;
                    logger.warn("Failed to load repository data generation [" + genToLoad + "] because a concurrent operation moved the current generation to [" + this.latestKnownRepoGen.get() + "]", (Throwable)e);
                    continue;
                }
                if (!this.bestEffortConsistency && ExceptionsHelper.unwrap(e, NoSuchFileException.class) != null) {
                    Tuple<Long, String> previousWriterInformation = null;
                    try {
                        previousWriterInformation = this.readLastWriterInfo();
                    }
                    catch (Exception ex) {
                        e.addSuppressed(ex);
                    }
                    Tuple<Long, String> finalLastInfo = previousWriterInformation;
                    this.markRepoCorrupted(genToLoad, e, listener.delegateFailureAndWrap((l, v) -> l.onFailure(this.corruptedStateException(e, finalLastInfo))));
                } else {
                    listener.onFailure(e);
                }
                return;
            }
            catch (Exception e) {
                listener.onFailure(new RepositoryException(this.metadata.name(), "Unexpected exception when loading repository data", e, new Object[0]));
                return;
            }
            break;
        }
    }

    private void cacheRepositoryData(RepositoryData repositoryData, IndexVersion version) {
        RepositoryData toCache;
        if (!this.cacheRepositoryData) {
            return;
        }
        if (SnapshotsServiceUtils.useShardGenerations(version)) {
            toCache = repositoryData;
        } else {
            toCache = repositoryData.withoutShardGenerations();
            assert (repositoryData.indexMetaDataGenerations().equals(IndexMetaDataGenerations.EMPTY)) : "repository data should not contain index generations at version [" + version.toReleaseVersion() + "] but saw [" + repositoryData.indexMetaDataGenerations() + "]";
        }
        assert (toCache.getGenId() >= 0L) : "No need to cache abstract generations but attempted to cache [" + toCache.getGenId() + "]";
        this.latestKnownRepositoryData.updateAndGet(known -> {
            if (known.getGenId() > toCache.getGenId()) {
                return known;
            }
            return toCache;
        });
    }

    private RepositoryException corruptedStateException(@Nullable Exception cause, @Nullable Tuple<Long, String> previousWriterInfo) {
        return new RepositoryException(this.metadata.name(), org.elasticsearch.common.Strings.format("The repository has been disabled to prevent data corruption because its contents were found not to match its expected state. This is either because something other than this cluster modified the repository contents, or because the repository's underlying storage behaves incorrectly. To re-enable this repository, first ensure that this cluster has exclusive write access to it, and then re-register the repository with this cluster. See %s for further information.%s", new Object[]{ReferenceDocs.CONCURRENT_REPOSITORY_WRITERS, BlobStoreRepository.previousWriterMessage(previousWriterInfo)}), cause, new Object[0]);
    }

    private static String previousWriterMessage(@Nullable Tuple<Long, String> previousWriterInfo) {
        return previousWriterInfo == null ? "" : " The last cluster to write to this repository was [" + (String)previousWriterInfo.v2() + "] at generation [" + previousWriterInfo.v1() + "].";
    }

    private void markRepoCorrupted(final long corruptedGeneration, final Exception originalException, final ActionListener<Void> listener) {
        assert (corruptedGeneration != -2L);
        assert (!this.bestEffortConsistency);
        logger.warn(() -> "Marking repository [" + this.metadata.name() + "] as corrupted", (Throwable)originalException);
        this.submitUnbatchedTask("mark repository corrupted [" + this.metadata.name() + "][" + corruptedGeneration + "]", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesMetadata state = RepositoriesMetadata.get(currentState);
                RepositoryMetadata repoState = state.repository(BlobStoreRepository.this.metadata.name());
                if (repoState.generation() != corruptedGeneration) {
                    throw new IllegalStateException("Tried to mark repo generation [" + corruptedGeneration + "] as corrupted but its state concurrently changed to [" + repoState + "]");
                }
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("repositories", state.withUpdatedGeneration(BlobStoreRepository.this.metadata.name(), -3L, repoState.pendingGeneration())).build()).build();
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed marking repository state as corrupted", ExceptionsHelper.useOrSuppress(e, originalException), new Object[0]));
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse(null);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RepositoryData getRepositoryData(long indexGen) {
        if (indexGen == -1L) {
            return RepositoryData.EMPTY;
        }
        try {
            String repositoryDataBlobName = BlobStoreRepository.getRepositoryDataBlobName(indexGen);
            try (InputStream blob = this.blobContainer().readBlob(OperationPurpose.SNAPSHOT_METADATA, repositoryDataBlobName);){
                RepositoryData repositoryData;
                block16: {
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);
                    try {
                        repositoryData = RepositoryData.snapshotsFromXContent(parser, indexGen, true);
                        if (parser == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return repositoryData;
            }
        }
        catch (IOException ioe) {
            if (this.bestEffortConsistency && this.latestKnownRepoGen.compareAndSet(indexGen, -1L)) {
                logger.warn("Resetting repository generation tracker because we failed to read generation [" + indexGen + "]", (Throwable)ioe);
            }
            throw new RepositoryException(this.metadata.name(), "could not read repository data from index blob", ioe, new Object[0]);
        }
    }

    private static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void writeIndexGen(RepositoryData repositoryData, final long expectedGen, IndexVersion version, final Function<ClusterState, ClusterState> stateFilter, final ActionListener<RepositoryData> listener) {
        logger.trace("[{}] writing repository data on top of expected generation [{}]", (Object)this.metadata.name(), (Object)expectedGen);
        assert (!this.isReadOnly());
        long currentGen = repositoryData.getGenId();
        if (currentGen != expectedGen) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + expectedGen + "], actual current generation [" + currentGen + "]", new Object[0]));
            return;
        }
        final ListenableFuture<Long> setPendingStep = new ListenableFuture<Long>();
        final String setPendingGenerationSource = "set pending repository generation [" + this.metadata.name() + "][" + expectedGen + "]";
        this.submitUnbatchedTask(setPendingGenerationSource, new ClusterStateUpdateTask(){
            private long newGen;

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean uninitializedMeta;
                RepositoryMetadata meta = BlobStoreRepository.this.getRepoMetadata(currentState);
                String repoName = BlobStoreRepository.this.metadata.name();
                if (RepositoriesService.isReadOnly(meta.settings())) {
                    throw new RepositoryException(meta.name(), "repository is readonly, cannot update root blob", new Object[0]);
                }
                long genInState = meta.generation();
                boolean bl = uninitializedMeta = meta.generation() == -2L || BlobStoreRepository.this.bestEffortConsistency;
                if (!uninitializedMeta && meta.pendingGeneration() != genInState) {
                    logger.info("Trying to write new repository data over unfinished write, repo [{}] is at safe generation [{}] and pending generation [{}]", (Object)meta.name(), (Object)genInState, (Object)meta.pendingGeneration());
                }
                assert (expectedGen == -1L || uninitializedMeta || expectedGen == meta.generation()) : "Expected non-empty generation [" + expectedGen + "] does not match generation tracked in [" + meta + "]";
                long safeGeneration = expectedGen == -1L ? -1L : (uninitializedMeta ? expectedGen : genInState);
                long nextPendingGen = BlobStoreRepository.this.metadata.pendingGeneration() + 1L;
                long l = this.newGen = uninitializedMeta ? Math.max(expectedGen + 1L, nextPendingGen) : nextPendingGen;
                assert (this.newGen > BlobStoreRepository.this.latestKnownRepoGen.get()) : "Attempted new generation [" + this.newGen + "] must be larger than latest known generation [" + BlobStoreRepository.this.latestKnownRepoGen.get() + "]";
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", RepositoriesMetadata.get(currentState).withUpdatedGeneration(repoName, safeGeneration, this.newGen)).build()).build();
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to execute cluster state update [" + setPendingGenerationSource + "]", e, new Object[0]));
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                logger.trace("[{}] successfully set pending repository generation to [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)this.newGen);
                setPendingStep.onResponse(this.newGen);
            }

            public String toString() {
                return org.elasticsearch.common.Strings.format("start RepositoryData update from generation [%d], stateFilter=[%s]", expectedGen, stateFilter);
            }
        });
        ListenableFuture<RepositoryData> filterRepositoryDataStep = new ListenableFuture<RepositoryData>();
        setPendingStep.addListener(listener.delegateFailureAndWrap((delegate, newGen) -> this.threadPool().executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(delegate, l -> {
            final List<SnapshotId> snapshotIdsWithMissingDetails = repositoryData.getSnapshotIds().stream().filter(repositoryData::hasMissingDetails).toList();
            if (!snapshotIdsWithMissingDetails.isEmpty()) {
                ConcurrentHashMap extraDetailsMap = new ConcurrentHashMap();
                this.getSnapshotInfo(snapshotIdsWithMissingDetails, false, () -> false, (CheckedConsumer<SnapshotInfo, Exception>)((CheckedConsumer)snapshotInfo -> extraDetailsMap.put(snapshotInfo.snapshotId(), RepositoryData.SnapshotDetails.fromSnapshotInfo(snapshotInfo))), ActionListener.runAfter(new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void aVoid) {
                        logger.info("Successfully loaded all snapshots' detailed information for {} from snapshot metadata", (Object)AllocationService.firstListElementsToCommaDelimitedString(snapshotIdsWithMissingDetails, SnapshotId::toString, logger.isDebugEnabled()));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("Failure when trying to load missing details from snapshot metadata", (Throwable)e);
                    }
                }, () -> filterRepositoryDataStep.onResponse(repositoryData.withExtraDetails(extraDetailsMap))));
            } else {
                filterRepositoryDataStep.onResponse(repositoryData);
            }
        }))));
        filterRepositoryDataStep.addListener(listener.delegateFailureAndWrap((delegate, filteredRepositoryData) -> {
            final long newGen = (Long)setPendingStep.result();
            final RepositoryData newRepositoryData = this.updateRepositoryData((RepositoryData)filteredRepositoryData, version, newGen);
            if (this.latestKnownRepoGen.get() >= newGen) {
                throw new IllegalArgumentException("Tried writing generation [" + newGen + "] but repository is at least at generation [" + this.latestKnownRepoGen.get() + "] already");
            }
            if (!this.ensureSafeGenerationExists(expectedGen, delegate::onFailure)) {
                return;
            }
            String indexBlob = BlobStoreRepository.getRepositoryDataBlobName(newGen);
            logger.debug("Repository [{}] writing new index generational blob [{}]", (Object)this.metadata.name(), (Object)indexBlob);
            this.writeAtomic(OperationPurpose.SNAPSHOT_METADATA, this.blobContainer(), indexBlob, (CheckedConsumer<OutputStream, IOException>)((CheckedConsumer)out -> {
                try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder((OutputStream)Streams.noCloseStream((OutputStream)out));){
                    newRepositoryData.snapshotsToXContent(xContentBuilder, version);
                }
            }), true);
            this.maybeWriteIndexLatest(newGen);
            if (filteredRepositoryData.getUuid().equals("_na_") && SnapshotsServiceUtils.includesUUIDs(version)) {
                assert (!newRepositoryData.getUuid().equals("_na_"));
                logger.info(org.elasticsearch.common.Strings.format("Generated new repository UUID [%s] for repository [%s] in generation [%d]", newRepositoryData.getUuid(), this.metadata.name(), newGen));
            } else assert (filteredRepositoryData.getUuid().equals(newRepositoryData.getUuid())) : filteredRepositoryData.getUuid() + " vs " + newRepositoryData.getUuid();
            String setSafeGenerationSource = "set safe repository generation [" + this.metadata.name() + "][" + newGen + "]";
            this.submitUnbatchedTask(setSafeGenerationSource, new ClusterStateUpdateTask((ActionListener)delegate, setSafeGenerationSource, version){
                final /* synthetic */ ActionListener val$delegate;
                final /* synthetic */ String val$setSafeGenerationSource;
                final /* synthetic */ IndexVersion val$version;
                {
                    this.val$delegate = actionListener;
                    this.val$setSafeGenerationSource = string;
                    this.val$version = indexVersion;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RepositoryMetadata meta = BlobStoreRepository.this.getRepoMetadata(currentState);
                    if (meta.generation() != expectedGen) {
                        throw new IllegalStateException("Tried to update repo generation to [" + newGen + "] but saw unexpected generation in state [" + meta + "]");
                    }
                    if (meta.pendingGeneration() != newGen) {
                        throw new IllegalStateException("Tried to update from unexpected pending repo generation [" + meta.pendingGeneration() + "] after write to generation [" + newGen + "]");
                    }
                    RepositoriesMetadata withGenerations = RepositoriesMetadata.get(currentState).withUpdatedGeneration(BlobStoreRepository.this.metadata.name(), newGen, newGen);
                    RepositoriesMetadata withUuid = meta.uuid().equals(newRepositoryData.getUuid()) ? withGenerations : withGenerations.withUuid(BlobStoreRepository.this.metadata.name(), newRepositoryData.getUuid());
                    ClusterState newClusterState = (ClusterState)stateFilter.apply(ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", withUuid)).build());
                    return BlobStoreRepository.this.updateRepositoryGenerationsIfNecessary(newClusterState, expectedGen, newGen);
                }

                @Override
                public void onFailure(Exception e) {
                    this.val$delegate.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to execute cluster state update [" + this.val$setSafeGenerationSource + "]", e, new Object[0]));
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    logger.trace("[{}] successfully set safe repository generation to [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)newGen);
                    BlobStoreRepository.this.cacheRepositoryData(newRepositoryData, this.val$version);
                    this.val$delegate.onResponse(newRepositoryData);
                }

                public String toString() {
                    return org.elasticsearch.common.Strings.format("complete RepositoryData update from generation [%d] to generation [%d], stateFilter=[%s]", expectedGen, newGen, stateFilter);
                }
            });
        }));
    }

    private RepositoryData updateRepositoryData(RepositoryData repositoryData, IndexVersion repositoryMetaversion, long newGen) {
        if (SnapshotsServiceUtils.includesUUIDs(repositoryMetaversion)) {
            String clusterUUID = this.clusterService.state().metadata().clusterUUID();
            if (!repositoryData.getClusterUUID().equals(clusterUUID)) {
                repositoryData = repositoryData.withClusterUuid(clusterUUID);
            }
        }
        return repositoryData.withGenId(newGen);
    }

    private void maybeWriteIndexLatest(long newGen) {
        if (this.supportURLRepo) {
            logger.debug("Repository [{}] updating index.latest with generation [{}]", (Object)this.metadata.name(), (Object)newGen);
            try {
                this.writeAtomic(OperationPurpose.SNAPSHOT_METADATA, this.blobContainer(), INDEX_LATEST_BLOB, (CheckedConsumer<OutputStream, IOException>)((CheckedConsumer)out -> out.write(Numbers.longToBytes(newGen))), false);
            }
            catch (Exception e) {
                logger.warn(() -> Strings.format((String)"Failed to write index.latest blob. If you do not intend to use this repository as the basis for a URL repository you may turn off attempting to write the index.latest blob by setting repository setting [%s] to [false]", (Object[])new Object[]{SUPPORT_URL_REPO.getKey()}), (Throwable)e);
            }
        }
    }

    private boolean ensureSafeGenerationExists(long safeGeneration, final Consumer<Exception> onFailure) throws IOException {
        logger.debug("Ensure generation [{}] that is the basis for this write exists in [{}]", (Object)safeGeneration, (Object)this.metadata.name());
        if (safeGeneration != -1L && !this.blobContainer().blobExists(OperationPurpose.SNAPSHOT_METADATA, BlobStoreRepository.getRepositoryDataBlobName(safeGeneration))) {
            Tuple<Long, String> previousWriterInfo = null;
            Exception readRepoDataEx = null;
            try {
                previousWriterInfo = this.readLastWriterInfo();
            }
            catch (Exception ex) {
                readRepoDataEx = ex;
            }
            final RepositoryException exception = new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + safeGeneration + "] but it was not found in the repository." + BlobStoreRepository.previousWriterMessage(previousWriterInfo), new Object[0]);
            if (readRepoDataEx != null) {
                exception.addSuppressed(readRepoDataEx);
            }
            this.markRepoCorrupted(safeGeneration, exception, new ActionListener<Void>(){

                @Override
                public void onResponse(Void aVoid) {
                    onFailure.accept(exception);
                }

                @Override
                public void onFailure(Exception e) {
                    onFailure.accept(e);
                }
            });
            return false;
        }
        return true;
    }

    private Tuple<Long, String> readLastWriterInfo() throws IOException {
        assert (!this.bestEffortConsistency) : "This should only be used for adding information to errors in consistent mode";
        long latestGeneration = this.latestIndexBlobId();
        RepositoryData actualRepositoryData = this.getRepositoryData(latestGeneration);
        return Tuple.tuple((Object)latestGeneration, (Object)actualRepositoryData.getClusterUUID());
    }

    private ClusterState updateRepositoryGenerationsIfNecessary(ClusterState state, long oldGen, long newGen) {
        String repoName = this.metadata.name();
        boolean changedSnapshots = false;
        ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(state);
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(repoName)) {
            if (entry.repositoryStateId() == oldGen) {
                snapshotEntries.add(entry.withRepoGen(newGen));
                changedSnapshots = true;
                continue;
            }
            snapshotEntries.add(entry);
        }
        SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? snapshotsInProgress.withUpdatedEntriesForRepo(repoName, snapshotEntries) : null;
        boolean changedDeletions = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> deletionEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : SnapshotDeletionsInProgress.get(state).getEntries()) {
            if (entry.repository().equals(repoName) && entry.repositoryStateId() == oldGen) {
                deletionEntries.add(entry.withRepoGen(newGen));
                changedDeletions = true;
                continue;
            }
            deletionEntries.add(entry);
        }
        SnapshotDeletionsInProgress updatedDeletionsInProgress = changedDeletions ? SnapshotDeletionsInProgress.of(deletionEntries) : null;
        return SnapshotsServiceUtils.updateWithSnapshots(state, updatedSnapshotsInProgress, updatedDeletionsInProgress);
    }

    private RepositoryMetadata getRepoMetadata(ClusterState state) {
        RepositoryMetadata repositoryMetadata = RepositoriesMetadata.get(state).repository(this.metadata.name());
        assert (repositoryMetadata != null || this.lifecycle.stoppedOrClosed()) : "did not find metadata for repo [" + this.metadata.name() + "] in state [" + this.lifecycleState() + "]";
        return repositoryMetadata;
    }

    long latestIndexBlobId() throws IOException {
        try {
            return this.listBlobsToGetLatestIndexId();
        }
        catch (UnsupportedOperationException e) {
            try {
                return this.readSnapshotIndexLatestBlob();
            }
            catch (NoSuchFileException nsfe) {
                return -1L;
            }
        }
    }

    long readSnapshotIndexLatestBlob() throws IOException {
        BytesReference content = org.elasticsearch.common.io.Streams.readFully(org.elasticsearch.common.io.Streams.limitStream(this.blobContainer().readBlob(OperationPurpose.SNAPSHOT_METADATA, INDEX_LATEST_BLOB), 9L));
        if (content.length() != 8) {
            throw new RepositoryException(this.metadata.name(), "exception reading blob [index.latest]: expected 8 bytes but blob was " + (String)(content.length() < 8 ? content.length() + " bytes" : "longer"), new Object[0]);
        }
        return Numbers.bytesToLong(content.toBytesRef());
    }

    private long listBlobsToGetLatestIndexId() throws IOException {
        return this.latestGeneration(this.blobContainer().listBlobsByPrefix(OperationPurpose.SNAPSHOT_METADATA, "index-").keySet());
    }

    private long latestGeneration(Collection<String> rootBlobs) {
        long latest = -1L;
        for (String blobName : rootBlobs) {
            if (!blobName.startsWith("index-")) continue;
            try {
                long curr = Long.parseLong(blobName.substring("index-".length()));
                latest = Math.max(latest, curr);
            }
            catch (NumberFormatException nfe) {
                logger.warn("[{}] Unknown blob in the repository: {}", (Object)this.metadata.name(), (Object)blobName);
            }
        }
        return latest;
    }

    private void writeAtomic(OperationPurpose purpose, BlobContainer container, String blobName, CheckedConsumer<OutputStream, IOException> writer, boolean failIfAlreadyExists) throws IOException {
        logger.trace(() -> Strings.format((String)"[%s] Writing [%s] to %s atomically", (Object[])new Object[]{this.metadata.name(), blobName, container.path()}));
        container.writeMetadataBlob(purpose, blobName, failIfAlreadyExists, true, writer);
    }

    @Override
    public void snapshotShard(SnapshotShardContext context) {
        this.shardSnapshotTaskRunner.enqueueShardSnapshot(context);
    }

    private void doSnapshotShard(SnapshotShardContext context) {
        if (this.isReadOnly()) {
            context.onFailure(new RepositoryException(this.metadata.name(), "cannot snapshot shard on a readonly repository", new Object[0]));
            return;
        }
        Store store = context.store();
        ShardId shardId = store.shardId();
        SnapshotId snapshotId = context.snapshotId();
        IndexShardSnapshotStatus snapshotStatus = context.status();
        long startTime = this.threadPool.absoluteTimeInMillis();
        try {
            Runnable afterWriteSnapBlob;
            ShardGeneration indexGeneration;
            List indexCommitPointFiles;
            Set<Object> blobs;
            ShardGeneration generation = snapshotStatus.generation();
            BlobContainer shardContainer = this.shardContainer(context.indexId(), shardId);
            logger.debug("[{}][{}] snapshot to [{}][{}][{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)context.indexId(), (Object)generation);
            if (generation == null) {
                snapshotStatus.ensureNotAborted();
                try {
                    blobs = shardContainer.listBlobsByPrefix(OperationPurpose.SNAPSHOT_METADATA, "index-").keySet();
                }
                catch (IOException e2) {
                    throw new IndexShardSnapshotFailedException(shardId, "failed to list blobs", e2);
                }
            } else {
                blobs = Collections.singleton("index-" + generation);
            }
            snapshotStatus.ensureNotAborted();
            Tuple<BlobStoreIndexShardSnapshots, ShardGeneration> tuple = this.buildBlobStoreIndexShardSnapshots(context.indexId(), shardId.id(), blobs, shardContainer, generation);
            BlobStoreIndexShardSnapshots snapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
            ShardGeneration fileListGeneration = (ShardGeneration)tuple.v2();
            if (snapshots.snapshots().stream().anyMatch(sf -> sf.snapshot().equals(snapshotId.getName()))) {
                throw new IndexShardSnapshotFailedException(shardId, "Duplicate snapshot name [" + snapshotId.getName() + "] detected, aborting");
            }
            List filesFromSegmentInfos = Optional.ofNullable(context.stateIdentifier()).map(id -> {
                for (SnapshotFiles snapshotFileSet : snapshots.snapshots()) {
                    if (!id.equals(snapshotFileSet.shardStateIdentifier())) continue;
                    return snapshotFileSet.indexFiles();
                }
                return null;
            }).orElse(null);
            int indexIncrementalFileCount = 0;
            int indexTotalNumberOfFiles = 0;
            long indexIncrementalSize = 0L;
            long indexTotalFileSize = 0L;
            LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>();
            int filesInShardMetadataCount = 0;
            long filesInShardMetadataSize = 0L;
            if (store.indexSettings().getIndexMetadata().isSearchableSnapshot()) {
                indexCommitPointFiles = Collections.emptyList();
            } else if (filesFromSegmentInfos == null) {
                Collection fileNames;
                Store.MetadataSnapshot metadataFromStore;
                indexCommitPointFiles = new ArrayList();
                try (Object ignored = context.withCommitRef();){
                    try {
                        IndexCommit snapshotIndexCommit = context.indexCommit();
                        logger.trace("[{}] [{}] Loading store metadata using index commit [{}]", (Object)shardId, (Object)snapshotId, (Object)snapshotIndexCommit);
                        metadataFromStore = store.getMetadata(snapshotIndexCommit);
                        fileNames = snapshotIndexCommit.getFileNames();
                    }
                    catch (IOException e3) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to get store file metadata", e3);
                    }
                }
                ignored = fileNames.iterator();
                while (ignored.hasNext()) {
                    String fileName = (String)ignored.next();
                    BlobStoreRepository.ensureNotAborted(shardId, snapshotId, snapshotStatus, fileName);
                    logger.trace("[{}] [{}] Processing [{}]", (Object)shardId, (Object)snapshotId, (Object)fileName);
                    StoreFileMetadata md = metadataFromStore.get(fileName);
                    BlobStoreIndexShardSnapshot.FileInfo existingFileInfo = snapshots.findPhysicalIndexFile(md);
                    boolean needsWrite = !md.hashEqualsContents();
                    indexTotalFileSize += md.length();
                    ++indexTotalNumberOfFiles;
                    if (existingFileInfo == null) {
                        ++indexIncrementalFileCount;
                        indexIncrementalSize += md.length();
                        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = new BlobStoreIndexShardSnapshot.FileInfo((needsWrite ? UPLOADED_DATA_BLOB_PREFIX : VIRTUAL_DATA_BLOB_PREFIX) + UUIDs.randomBase64UUID(), md, this.chunkSize());
                        indexCommitPointFiles.add(snapshotFileInfo);
                        if (needsWrite) {
                            filesToSnapshot.add(snapshotFileInfo);
                            continue;
                        }
                        assert (BlobStoreRepository.assertFileContentsMatchHash(snapshotStatus, snapshotFileInfo, store));
                        ++filesInShardMetadataCount;
                        filesInShardMetadataSize += md.length();
                        continue;
                    }
                    indexCommitPointFiles.add(existingFileInfo);
                }
            } else {
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesFromSegmentInfos) {
                    ++indexTotalNumberOfFiles;
                    indexTotalFileSize += fileInfo.length();
                }
                indexCommitPointFiles = filesFromSegmentInfos;
            }
            snapshotStatus.moveToStarted(startTime, indexIncrementalFileCount, indexTotalNumberOfFiles, indexIncrementalSize, indexTotalFileSize);
            boolean writeShardGens = SnapshotsServiceUtils.useShardGenerations(context.getRepositoryMetaVersion());
            boolean writeFileInfoWriterUUID = SnapshotsServiceUtils.includeFileInfoWriterUUID(context.getRepositoryMetaVersion());
            BlobStoreIndexShardSnapshots updatedBlobStoreIndexShardSnapshots = snapshots.withAddedSnapshot(new SnapshotFiles(snapshotId.getName(), indexCommitPointFiles, context.stateIdentifier()));
            if (writeShardGens) {
                indexGeneration = ShardGeneration.newGeneration();
                try {
                    Map<String, String> serializationParams = Collections.singletonMap("serialize_writer_uuid", Boolean.toString(writeFileInfoWriterUUID));
                    INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedBlobStoreIndexShardSnapshots, shardContainer, indexGeneration.getGenerationUUID(), this.compress, serializationParams);
                    snapshotStatus.addProcessedFiles(filesInShardMetadataCount, filesInShardMetadataSize);
                }
                catch (IOException e4) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write shard level snapshot metadata for [" + snapshotId + "] to [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(indexGeneration.getGenerationUUID()) + "]", e4);
                }
                afterWriteSnapBlob = () -> {};
            } else {
                long newGen = Long.parseLong(fileListGeneration.getGenerationUUID()) + 1L;
                indexGeneration = new ShardGeneration(newGen);
                List<String> blobsToDelete = blobs.stream().filter(blob -> blob.startsWith("index-")).toList();
                assert (blobsToDelete.stream().mapToLong(b -> Long.parseLong(b.replaceFirst("index-", ""))).max().orElse(-1L) < Long.parseLong(indexGeneration.toString())) : "Tried to delete an index-N blob newer than the current generation [" + indexGeneration + "] when deleting index-N blobs " + blobsToDelete;
                int finalFilesInShardMetadataCount = filesInShardMetadataCount;
                long finalFilesInShardMetadataSize = filesInShardMetadataSize;
                afterWriteSnapBlob = () -> {
                    try {
                        Map<String, String> serializationParams = Collections.singletonMap("serialize_writer_uuid", Boolean.toString(writeFileInfoWriterUUID));
                        this.writeShardIndexBlobAtomic(shardContainer, newGen, updatedBlobStoreIndexShardSnapshots, serializationParams);
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to finalize snapshot creation [" + snapshotId + "] with shard index [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(indexGeneration.getGenerationUUID()) + "]", e);
                    }
                    snapshotStatus.addProcessedFiles(finalFilesInShardMetadataCount, finalFilesInShardMetadataSize);
                    try {
                        this.deleteFromContainer(OperationPurpose.SNAPSHOT_METADATA, shardContainer, blobsToDelete.iterator());
                    }
                    catch (IOException e) {
                        logger.warn(() -> Strings.format((String)"[%s][%s] failed to delete old index-N blobs during finalization", (Object[])new Object[]{snapshotId, shardId}), (Throwable)e);
                    }
                };
            }
            AtomicReference fileToCleanUp = new AtomicReference(List.copyOf(filesToSnapshot));
            ActionListener<Collection<Void>> allFilesUploadedListener = ActionListener.assertOnce(ActionListener.wrap(ignore -> {
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize();
                logger.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
                BlobStoreIndexShardSnapshot blobStoreIndexShardSnapshot = new BlobStoreIndexShardSnapshot(snapshotId.getName(), indexCommitPointFiles, lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), lastSnapshotStatus.getIncrementalFileCount(), lastSnapshotStatus.getIncrementalSize());
                fileToCleanUp.set(List.of());
                try {
                    String snapshotUUID = snapshotId.getUUID();
                    Map<String, String> serializationParams = Collections.singletonMap("serialize_writer_uuid", Boolean.toString(writeFileInfoWriterUUID));
                    INDEX_SHARD_SNAPSHOT_FORMAT.write(blobStoreIndexShardSnapshot, shardContainer, snapshotUUID, this.compress, serializationParams);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point", e);
                }
                afterWriteSnapBlob.run();
                ShardSnapshotResult shardSnapshotResult = new ShardSnapshotResult(indexGeneration, ByteSizeValue.ofBytes(blobStoreIndexShardSnapshot.totalSize()), BlobStoreRepository.getSegmentInfoFileCount(blobStoreIndexShardSnapshot.indexFiles()));
                snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), shardSnapshotResult);
                context.onResponse(shardSnapshotResult);
            }, e -> {
                try {
                    shardContainer.deleteBlobsIgnoringIfNotExists(OperationPurpose.SNAPSHOT_DATA, Iterators.flatMap(((List)fileToCleanUp.get()).iterator(), f -> Iterators.forRange(0, f.numberOfParts(), f::partName)));
                }
                catch (Exception innerException) {
                    e.addSuppressed(innerException);
                }
                context.onFailure((Exception)e);
            }));
            if (indexIncrementalFileCount == 0 || filesToSnapshot.isEmpty()) {
                allFilesUploadedListener.onResponse(Collections.emptyList());
                return;
            }
            this.snapshotFiles(context, filesToSnapshot, allFilesUploadedListener);
        }
        catch (Exception e5) {
            context.onFailure(e5);
        }
    }

    private static void ensureNotAborted(ShardId shardId, SnapshotId snapshotId, IndexShardSnapshotStatus snapshotStatus, String fileName) {
        try {
            snapshotStatus.ensureNotAborted();
        }
        catch (Exception e) {
            logger.debug("[{}] [{}] {} on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)e.getMessage(), (Object)fileName);
            assert (e instanceof AbortedSnapshotException || e instanceof PausedSnapshotException) : e;
            throw e;
        }
    }

    protected void snapshotFiles(SnapshotShardContext context, BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot, ActionListener<Collection<Void>> allFilesUploadedListener) {
        int noOfFilesToSnapshot = filesToSnapshot.size();
        ActionListener<Void> filesListener = BlobStoreRepository.fileQueueListener(filesToSnapshot, noOfFilesToSnapshot, allFilesUploadedListener);
        for (int i = 0; i < noOfFilesToSnapshot; ++i) {
            this.shardSnapshotTaskRunner.enqueueFileSnapshot(context, filesToSnapshot::poll, filesListener);
        }
    }

    private static boolean assertFileContentsMatchHash(IndexShardSnapshotStatus snapshotStatus, BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) {
        block16: {
            if (store.tryIncRef()) {
                try (IndexInput indexInput = store.openVerifyingInput(fileInfo.physicalName(), IOContext.READONCE, fileInfo.metadata());){
                    byte[] tmp = new byte[Math.toIntExact(fileInfo.metadata().length())];
                    indexInput.readBytes(tmp, 0, tmp.length);
                    assert (fileInfo.metadata().hash().bytesEquals(new BytesRef(tmp)));
                    break block16;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                finally {
                    store.decRef();
                }
            }
            try {
                snapshotStatus.ensureNotAborted();
                assert (false) : "if the store is already closed we must have been aborted";
            }
            catch (Exception e) {
                if ($assertionsDisabled || e instanceof AbortedSnapshotException) break block16;
                throw new AssertionError((Object)e);
            }
        }
        return true;
    }

    @Override
    public void restoreShard(final Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        ShardId shardId = store.shardId();
        ActionListener<Void> restoreListener = listener.delegateResponse((l, e) -> l.onFailure(new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + snapshotId + "]", (Throwable)e)));
        final ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        final BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        if (store.isClosing()) {
            restoreListener.onFailure((Exception)((Object)new AlreadyClosedException("store is closing")));
            return;
        }
        if (!this.lifecycle.started()) {
            restoreListener.onFailure((Exception)((Object)new AlreadyClosedException("repository [" + this.metadata.name() + "] closed")));
            return;
        }
        if (!this.activityRefs.tryIncRef()) {
            restoreListener.onFailure((Exception)((Object)new AlreadyClosedException("repository [" + this.metadata.name() + "] closing")));
            return;
        }
        executor.execute(ActionRunnable.wrap(ActionListener.runBefore(restoreListener, () -> ((RefCounted)this.activityRefs).decRef()), l -> {
            BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(container, snapshotId);
            final SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles(), null);
            new FileRestoreContext(this.metadata.name(), shardId, snapshotId, recoveryState){

                @Override
                protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store2, ActionListener<Void> listener) {
                    if (filesToRecover.isEmpty()) {
                        listener.onResponse(null);
                    } else {
                        int workers = Math.min(BlobStoreRepository.this.threadPool.info(BlobStoreRepository.SNAPSHOT_CODEC).getMax(), snapshotFiles.indexFiles().size());
                        LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>(filesToRecover);
                        ActionListener<Void> allFilesListener = BlobStoreRepository.fileQueueListener(files, workers, listener.map(v -> null));
                        for (int i = 0; i < workers; ++i) {
                            try {
                                this.executeOneFileRestore(files, allFilesListener);
                                continue;
                            }
                            catch (Exception e) {
                                allFilesListener.onFailure(e);
                            }
                        }
                    }
                }

                private void executeOneFileRestore(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, ActionListener<Void> allFilesListener) throws InterruptedException {
                    BlobStoreIndexShardSnapshot.FileInfo fileToRecover = files.poll(0L, TimeUnit.MILLISECONDS);
                    if (fileToRecover == null) {
                        allFilesListener.onResponse(null);
                    } else {
                        executor.execute(ActionRunnable.wrap(allFilesListener, filesListener -> {
                            store.incRef();
                            try {
                                this.restoreFile(fileToRecover, store);
                            }
                            finally {
                                store.decRef();
                            }
                            this.executeOneFileRestore(files, (ActionListener<Void>)filesListener);
                        }));
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void restoreFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, final Store store2) throws IOException {
                    this.ensureNotClosing(store2);
                    logger.trace(() -> Strings.format((String)"[%s] restoring [%s] to [%s]", (Object[])new Object[]{BlobStoreRepository.this.metadata.name(), fileInfo, store2}));
                    boolean success = false;
                    try {
                        try (IndexOutput indexOutput = store2.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                            if (fileInfo.name().startsWith(BlobStoreRepository.VIRTUAL_DATA_BLOB_PREFIX)) {
                                BytesRef hash = fileInfo.metadata().hash();
                                indexOutput.writeBytes(hash.bytes, hash.offset, hash.length);
                                this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), hash.length);
                            } else {
                                try (InputStream stream = BlobStoreRepository.this.maybeRateLimitRestores(new SlicedInputStream(fileInfo.numberOfParts()){

                                    @Override
                                    protected InputStream openSlice(int slice) throws IOException {
                                        this.ensureNotClosing(store2);
                                        return container.readBlob(OperationPurpose.SNAPSHOT_DATA, fileInfo.partName(slice));
                                    }

                                    @Override
                                    public boolean markSupported() {
                                        return false;
                                    }
                                });){
                                    int length;
                                    byte[] buffer = new byte[Math.toIntExact(Math.min((long)BlobStoreRepository.this.bufferSize, fileInfo.length()))];
                                    while ((length = stream.read(buffer)) > 0) {
                                        this.ensureNotClosing(store2);
                                        indexOutput.writeBytes(buffer, 0, length);
                                        this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), length);
                                    }
                                }
                            }
                            Store.verify(indexOutput);
                            indexOutput.close();
                            store2.directory().sync(Collections.singleton(fileInfo.physicalName()));
                            success = true;
                        }
                        if (success) return;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        try {
                            try {
                                store2.markStoreCorrupted((IOException)ex);
                                throw ex;
                            }
                            catch (IOException e) {
                                logger.warn("store cannot be marked as corrupted", (Throwable)e);
                            }
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            if (success) throw throwable;
                            store2.deleteQuiet(fileInfo.physicalName());
                            throw throwable;
                        }
                    }
                    store2.deleteQuiet(fileInfo.physicalName());
                    return;
                }

                void ensureNotClosing(Store store2) throws AlreadyClosedException {
                    assert (store2.refCount() > 0);
                    if (store2.isClosing()) {
                        throw new AlreadyClosedException("store is closing");
                    }
                    if (!BlobStoreRepository.this.lifecycle.started()) {
                        throw new AlreadyClosedException("repository [" + BlobStoreRepository.this.metadata.name() + "] closed");
                    }
                }
            }.restore(snapshotFiles, store, (ActionListener<Void>)l);
        }));
    }

    private static ActionListener<Void> fileQueueListener(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, int numberOfFiles, ActionListener<Collection<Void>> listener) {
        return new GroupedActionListener(numberOfFiles, listener).delegateResponse((l, e) -> {
            files.clear();
            l.onFailure((Exception)e);
        });
    }

    private static InputStream maybeRateLimit(InputStream stream, Supplier<RateLimiter> rateLimiterSupplier, RateLimitingInputStream.Listener throttleListener) {
        return new RateLimitingInputStream(stream, rateLimiterSupplier, throttleListener);
    }

    public InputStream maybeRateLimitRestores(InputStream stream) {
        return this.maybeRateLimitRestores(stream, this.restoreRateLimitingTimeInNanos::inc);
    }

    public InputStream maybeRateLimitRestores(InputStream stream, RateLimitingInputStream.Listener throttleListener) {
        return BlobStoreRepository.maybeRateLimit(BlobStoreRepository.maybeRateLimit(stream, () -> this.restoreRateLimiter, throttleListener), this.recoverySettings::rateLimiter, throttleListener);
    }

    public InputStream maybeRateLimitSnapshots(InputStream stream) {
        return this.maybeRateLimitSnapshots(stream, this.snapshotRateLimitingTimeInNanos::inc);
    }

    public InputStream maybeRateLimitSnapshots(InputStream stream, RateLimitingInputStream.Listener throttleListener) {
        InputStream rateLimitStream = BlobStoreRepository.maybeRateLimit(stream, () -> this.snapshotRateLimiter, throttleListener);
        if (this.recoverySettings.nodeBandwidthSettingsExist()) {
            rateLimitStream = BlobStoreRepository.maybeRateLimit(rateLimitStream, this.recoverySettings::rateLimiter, throttleListener);
        }
        return rateLimitStream;
    }

    @Override
    public IndexShardSnapshotStatus.Copy getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(this.shardContainer(indexId, shardId), snapshotId);
        return IndexShardSnapshotStatus.newDone(snapshot.startTime(), snapshot.time(), snapshot.incrementalFileCount(), snapshot.totalFileCount(), snapshot.incrementalSize(), snapshot.totalSize(), null);
    }

    @Override
    public void verify(String seed, DiscoveryNode localNode) {
        this.assertSnapshotOrStatelessPermittedThreadPool();
        if (this.isReadOnly()) {
            try {
                this.latestIndexBlobId();
            }
            catch (Exception e) {
                throw new RepositoryVerificationException(this.metadata.name(), "path " + this.basePath() + " is not accessible on node " + localNode, e);
            }
        }
        BlobContainer testBlobContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
        try {
            testBlobContainer.writeBlob(OperationPurpose.SNAPSHOT_METADATA, "data-" + localNode.getId() + METADATA_BLOB_NAME_SUFFIX, new BytesArray(seed), true);
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "store location [" + this.blobStore() + "] is not accessible on the node [" + localNode + "]", exp);
        }
        try (InputStream masterDat = testBlobContainer.readBlob(OperationPurpose.SNAPSHOT_METADATA, "master.dat");){
            String seedRead = org.elasticsearch.common.io.Streams.readFully(masterDat).utf8ToString();
            if (!seedRead.equals(seed)) {
                throw new RepositoryVerificationException(this.metadata.name(), "Seed read from master.dat was [" + seedRead + "] but expected seed [" + seed + "]");
            }
        }
        catch (NoSuchFileException e) {
            throw new RepositoryVerificationException(this.metadata.name(), "a file written by master to the store [" + this.blobStore() + "] cannot be accessed on the node [" + localNode + "]. This might indicate that the store [" + this.blobStore() + "] is not shared between this node and the master node or that permissions on the store don't allow reading files written by the master node", e);
        }
        catch (Exception e) {
            throw new RepositoryVerificationException(this.metadata.name(), "Failed to verify repository", e);
        }
    }

    public String toString() {
        return "BlobStoreRepository[[" + this.metadata.name() + "], [" + this.blobStore.get() + "]]";
    }

    private void writeShardIndexBlobAtomic(BlobContainer shardContainer, long indexGeneration, BlobStoreIndexShardSnapshots updatedSnapshots, Map<String, String> serializationParams) throws IOException {
        assert (indexGeneration >= 0L) : "Shard generation must not be negative but saw [" + indexGeneration + "]";
        logger.trace(() -> Strings.format((String)"[%s] Writing shard index [%s] to [%s]", (Object[])new Object[]{this.metadata.name(), indexGeneration, shardContainer.path()}));
        String blobName = INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(String.valueOf(indexGeneration));
        this.writeAtomic(OperationPurpose.SNAPSHOT_METADATA, shardContainer, blobName, (CheckedConsumer<OutputStream, IOException>)((CheckedConsumer)out -> INDEX_SHARD_SNAPSHOTS_FORMAT.serialize(updatedSnapshots, blobName, this.compress, serializationParams, (OutputStream)out)), true);
    }

    public BlobStoreIndexShardSnapshot loadShardSnapshot(BlobContainer shardContainer, SnapshotId snapshotId) {
        try {
            return INDEX_SHARD_SNAPSHOT_FORMAT.read(this.metadata.name(), shardContainer, snapshotId.getUUID(), this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read shard snapshot file for [" + shardContainer.path() + "]", ex);
        }
    }

    public BlobStoreIndexShardSnapshots getBlobStoreIndexShardSnapshots(IndexId indexId, int shardId, @Nullable ShardGeneration shardGen) throws IOException {
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        Set<String> blobs = Collections.emptySet();
        if (shardGen == null) {
            blobs = shardContainer.listBlobsByPrefix(OperationPurpose.SNAPSHOT_METADATA, "index-").keySet();
        }
        return (BlobStoreIndexShardSnapshots)this.buildBlobStoreIndexShardSnapshots(indexId, shardId, blobs, shardContainer, shardGen).v1();
    }

    private Tuple<BlobStoreIndexShardSnapshots, ShardGeneration> buildBlobStoreIndexShardSnapshots(IndexId indexId, int shardId, Set<String> blobs, BlobContainer shardContainer, @Nullable ShardGeneration generation) throws IOException {
        if (generation != null) {
            if (generation.equals(ShardGenerations.NEW_SHARD_GEN)) {
                return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)ShardGenerations.NEW_SHARD_GEN);
            }
            try {
                return new Tuple((Object)INDEX_SHARD_SNAPSHOTS_FORMAT.read(this.metadata.name(), shardContainer, generation.getGenerationUUID(), this.namedXContentRegistry), (Object)generation);
            }
            catch (NoSuchFileException noSuchFileException) {
                RepositoryData currentRepositoryData;
                try {
                    long latestGeneration = this.latestIndexBlobId();
                    currentRepositoryData = this.getRepositoryData(latestGeneration);
                }
                catch (Exception e) {
                    noSuchFileException.addSuppressed(e);
                    throw noSuchFileException;
                }
                ShardGeneration latestShardGen = currentRepositoryData.shardGenerations().getShardGen(indexId, shardId);
                if (latestShardGen == null || !latestShardGen.equals(generation)) {
                    throw noSuchFileException;
                }
                try {
                    String message = org.elasticsearch.common.Strings.format("index %s shard generation [%s] in [%s][%s] not found - falling back to reading all shard snapshots", indexId, generation, this.metadata.name(), shardContainer.path());
                    logger.error(message, (Throwable)noSuchFileException);
                    assert (!BlobStoreIndexShardSnapshots.areIntegrityAssertionsEnabled()) : new AssertionError(message, noSuchFileException);
                    Map<String, BlobMetadata> shardSnapshotBlobs = shardContainer.listBlobsByPrefix(OperationPurpose.SNAPSHOT_METADATA, SNAPSHOT_PREFIX);
                    BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots = BlobStoreIndexShardSnapshots.EMPTY;
                    StringBuilder messageBuilder = new StringBuilder();
                    int shardSnapshotBlobNameLengthBeforeExt = SNAPSHOT_PREFIX.length() + 22;
                    int shardSnapshotBlobNameLength = shardSnapshotBlobNameLengthBeforeExt + METADATA_BLOB_NAME_SUFFIX.length();
                    for (String shardSnapshotBlobName : shardSnapshotBlobs.keySet()) {
                        if (shardSnapshotBlobName.startsWith(SNAPSHOT_PREFIX) && shardSnapshotBlobName.endsWith(METADATA_BLOB_NAME_SUFFIX) && shardSnapshotBlobName.length() == shardSnapshotBlobNameLength) {
                            BlobStoreIndexShardSnapshot shardSnapshot = INDEX_SHARD_SNAPSHOT_FORMAT.read(this.metadata.name(), shardContainer, shardSnapshotBlobName.substring(SNAPSHOT_PREFIX.length(), shardSnapshotBlobNameLengthBeforeExt), this.namedXContentRegistry);
                            blobStoreIndexShardSnapshots = blobStoreIndexShardSnapshots.withAddedSnapshot(new SnapshotFiles(shardSnapshot.snapshot(), shardSnapshot.indexFiles(), null));
                            if (messageBuilder.length() > 0) {
                                messageBuilder.append(", ");
                            }
                            messageBuilder.append(shardSnapshotBlobName);
                            continue;
                        }
                        throw new IllegalStateException(org.elasticsearch.common.Strings.format("unexpected shard snapshot blob [%s] found in [%s][%s]", shardSnapshotBlobName, this.metadata.name(), shardContainer.path()));
                    }
                    logger.error("read shard snapshots [{}] due to missing shard generation [{}] for index {} in [{}][{}]", (Object)messageBuilder, (Object)generation, (Object)indexId, (Object)this.metadata.name(), (Object)shardContainer.path());
                    return new Tuple((Object)blobStoreIndexShardSnapshots, (Object)generation);
                }
                catch (Exception fallbackException) {
                    logger.error(org.elasticsearch.common.Strings.format("failed while reading all shard snapshots from [%s][%s]", this.metadata.name(), shardContainer.path()), (Throwable)fallbackException);
                    noSuchFileException.addSuppressed(fallbackException);
                    throw noSuchFileException;
                }
            }
        }
        Tuple<BlobStoreIndexShardSnapshots, Long> legacyIndex = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
        return new Tuple((Object)((BlobStoreIndexShardSnapshots)legacyIndex.v1()), (Object)new ShardGeneration((Long)legacyIndex.v2()));
    }

    private Tuple<BlobStoreIndexShardSnapshots, Long> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer) throws IOException {
        long latest = this.latestGeneration(blobs);
        if (latest >= 0L) {
            BlobStoreIndexShardSnapshots shardSnapshots = INDEX_SHARD_SNAPSHOTS_FORMAT.read(this.metadata.name(), shardContainer, Long.toString(latest), this.namedXContentRegistry);
            return new Tuple((Object)shardSnapshots, (Object)latest);
        }
        if (blobs.stream().anyMatch(b -> b.startsWith(SNAPSHOT_PREFIX) || b.startsWith("index-") || b.startsWith(UPLOADED_DATA_BLOB_PREFIX))) {
            logger.warn("Could not find a readable index-N file in a non-empty shard snapshot directory [" + shardContainer.path() + "]");
        }
        return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)latest);
    }

    protected void snapshotFile(SnapshotShardContext context, final BlobStoreIndexShardSnapshot.FileInfo fileInfo) throws IOException {
        IndexId indexId = context.indexId();
        Store store = context.store();
        final ShardId shardId = store.shardId();
        final IndexShardSnapshotStatus snapshotStatus = context.status();
        final SnapshotId snapshotId = context.snapshotId();
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        String file = fileInfo.physicalName();
        try (Releasable ignored = context.withCommitRef();
             IndexInput indexInput = store.openVerifyingInput(file, IOContext.READ, fileInfo.metadata());){
            for (int i = 0; i < fileInfo.numberOfParts(); ++i) {
                long partBytes = fileInfo.partBytes(i);
                FilterInputStream inputStream = new FilterInputStream(this.maybeRateLimitSnapshots(new InputStreamIndexInput(indexInput, partBytes))){

                    @Override
                    public int read() throws IOException {
                        this.checkAborted();
                        return super.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        this.checkAborted();
                        return super.read(b, off, len);
                    }

                    private void checkAborted() {
                        BlobStoreRepository.ensureNotAborted(shardId, snapshotId, snapshotStatus, fileInfo.physicalName());
                    }
                };
                String partName = fileInfo.partName(i);
                logger.trace("[{}] Writing [{}] to [{}]", (Object)this.metadata.name(), (Object)partName, (Object)shardContainer.path());
                long startMS = this.threadPool.relativeTimeInMillis();
                shardContainer.writeBlob(OperationPurpose.SNAPSHOT_DATA, partName, inputStream, partBytes, false);
                logger.trace("[{}] Writing [{}] of size [{}b] to [{}] took [{}ms]", (Object)this.metadata.name(), (Object)partName, (Object)partBytes, (Object)shardContainer.path(), (Object)(this.threadPool.relativeTimeInMillis() - startMS));
            }
            Store.verify(indexInput);
            snapshotStatus.addProcessedFile(fileInfo.length());
        }
        catch (Exception t) {
            BlobStoreRepository.failStoreIfCorrupted(store, t);
            snapshotStatus.addProcessedFile(0L);
            throw t;
        }
    }

    private static void failStoreIfCorrupted(Store store, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            try {
                store.markStoreCorrupted((IOException)e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                logger.warn("store cannot be marked as corrupted", (Throwable)inner);
            }
        }
    }

    public boolean supportURLRepo() {
        return this.supportURLRepo;
    }

    public boolean hasAtomicOverwrites() {
        return true;
    }

    public int getReadBufferSizeInBytes() {
        return this.bufferSize;
    }

    public String getAnalysisFailureExtraDetail() {
        return org.elasticsearch.common.Strings.format("Elasticsearch observed the storage system underneath this repository behaved incorrectly which indicates it is not suitable for use with Elasticsearch snapshots. See [%s] for further information.", new Object[]{ReferenceDocs.SNAPSHOT_REPOSITORY_ANALYSIS});
    }

    @Override
    public final Set<String> getUsageFeatures() {
        Set<String> extraUsageFeatures = this.getExtraUsageFeatures();
        assert (!extraUsageFeatures.contains(READ_ONLY_USAGE_STATS_NAME)) : extraUsageFeatures;
        assert (!extraUsageFeatures.contains(READ_WRITE_USAGE_STATS_NAME)) : extraUsageFeatures;
        return Set.copyOf(Stream.concat(Stream.of(this.isReadOnly() ? READ_ONLY_USAGE_STATS_NAME : READ_WRITE_USAGE_STATS_NAME), extraUsageFeatures.stream()).toList());
    }

    protected Set<String> getExtraUsageFeatures() {
        return Set.of();
    }

    class SnapshotsDeletion {
        private final Collection<SnapshotId> snapshotIds;
        private final long originalRepositoryDataGeneration;
        private final IndexVersion repositoryFormatIndexVersion;
        private final boolean useShardGenerations;
        private final Map<String, BlobMetadata> originalRootBlobs;
        private final Map<String, BlobContainer> originalIndexContainers;
        private final RepositoryData originalRepositoryData;
        private final Executor snapshotExecutor;
        private final AtomicLong blobsDeleted;
        private final AtomicLong bytesDeleted;
        private final ShardBlobsToDelete shardBlobsToDelete;

        SnapshotsDeletion(Collection<SnapshotId> snapshotIds, long originalRepositoryDataGeneration, IndexVersion repositoryFormatIndexVersion, Map<String, BlobMetadata> originalRootBlobs, Map<String, BlobContainer> originalIndexContainers, RepositoryData originalRepositoryData) {
            this.snapshotExecutor = BlobStoreRepository.this.threadPool.executor(BlobStoreRepository.SNAPSHOT_CODEC);
            this.blobsDeleted = new AtomicLong();
            this.bytesDeleted = new AtomicLong();
            this.shardBlobsToDelete = new ShardBlobsToDelete();
            this.snapshotIds = snapshotIds;
            this.originalRepositoryDataGeneration = originalRepositoryDataGeneration;
            this.repositoryFormatIndexVersion = repositoryFormatIndexVersion;
            this.useShardGenerations = SnapshotsServiceUtils.useShardGenerations(repositoryFormatIndexVersion);
            this.originalRootBlobs = originalRootBlobs;
            this.originalIndexContainers = originalIndexContainers;
            this.originalRepositoryData = originalRepositoryData;
        }

        void runDelete(ActionListener<RepositoryData> repositoryDataUpdateListener, Runnable onCompletion) {
            ActionListener<RepositoryData> releasingListener = repositoryDataUpdateListener.delegateResponse((l, e) -> {
                try {
                    this.shardBlobsToDelete.close();
                }
                finally {
                    l.onFailure((Exception)e);
                }
            });
            Runnable releasingOnCompletion = () -> {
                try {
                    this.shardBlobsToDelete.close();
                }
                finally {
                    onCompletion.run();
                }
            };
            if (this.useShardGenerations) {
                this.runWithUniqueShardMetadataNaming(releasingListener, releasingOnCompletion);
            } else {
                this.runWithLegacyNumericShardMetadataNaming(BlobStoreRepository.this.wrapWithWeakConsistencyProtection(releasingListener), releasingOnCompletion);
            }
        }

        private void runWithUniqueShardMetadataNaming(ActionListener<RepositoryData> repositoryDataUpdateListener, Runnable onCompletion) {
            SubscribableListener.newForked(this::writeUpdatedShardMetadataAndComputeDeletes).andThen(l -> this.updateRepositoryData(this.originalRepositoryData.removeSnapshots(this.snapshotIds, this.shardBlobsToDelete.getUpdatedShardGenerations()), (ActionListener<RepositoryData>)l)).andThen(this.snapshotExecutor, BlobStoreRepository.this.threadPool.getThreadContext(), (l, newRepositoryData) -> {
                l.onResponse(newRepositoryData);
                try (RefCountingRunnable refs = new RefCountingRunnable(onCompletion);){
                    this.cleanupUnlinkedRootAndIndicesBlobs((RepositoryData)newRepositoryData, refs.acquireListener());
                    this.cleanupUnlinkedShardLevelBlobs(refs.acquireListener());
                }
            }).addListener(repositoryDataUpdateListener);
        }

        private void runWithLegacyNumericShardMetadataNaming(ActionListener<RepositoryData> repositoryDataUpdateListener, Runnable onCompletion) {
            this.updateRepositoryData(this.originalRepositoryData.removeSnapshots(this.snapshotIds, ShardGenerations.EMPTY), repositoryDataUpdateListener.delegateFailure((delegate, newRepositoryData) -> {
                try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
                    delegate.onResponse(newRepositoryData);
                    onCompletion.run();
                });){
                    this.cleanupUnlinkedRootAndIndicesBlobs((RepositoryData)newRepositoryData, refs.acquireListener());
                    this.snapshotExecutor.execute(ActionRunnable.wrap(refs.acquireListener(), l0 -> this.writeUpdatedShardMetadataAndComputeDeletes(l0.delegateFailure((l, ignored) -> this.cleanupUnlinkedShardLevelBlobs((ActionListener<Void>)l)))));
                }
            }));
        }

        void runCleanup(ActionListener<DeleteResult> listener) {
            Set survivingIndexIds = this.originalRepositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
            List<String> staleRootBlobs = SnapshotsDeletion.staleRootBlobs(this.originalRepositoryData, this.originalRootBlobs.keySet());
            ActionListener<DeleteResult> releasingListener = ActionListener.releaseAfter(listener, this.shardBlobsToDelete);
            if (survivingIndexIds.equals(this.originalIndexContainers.keySet()) && staleRootBlobs.isEmpty()) {
                releasingListener.onResponse(DeleteResult.ZERO);
            } else {
                this.updateRepositoryData(this.originalRepositoryData, releasingListener.delegateFailureAndWrap((l, newRepositoryData) -> this.cleanupUnlinkedRootAndIndicesBlobs(this.originalRepositoryData, l.map(ignored -> DeleteResult.of(this.blobsDeleted.get(), this.bytesDeleted.get())))));
            }
        }

        private void writeUpdatedShardMetadataAndComputeDeletes(ActionListener<Void> listener) {
            RefCountingListener listeners = new RefCountingListener(listener);
            ThrottledIterator.run(this.originalRepositoryData.indicesToUpdateAfterRemovingSnapshot(this.snapshotIds), (ref, indexId) -> ActionListener.run(ActionListener.releaseAfter(listeners.acquire(), ref), l -> new IndexSnapshotsDeletion((IndexId)indexId).run((ActionListener<Void>)l)), BlobStoreRepository.this.threadPool.info(BlobStoreRepository.SNAPSHOT_CODEC).getMax(), listeners::close);
        }

        private void updateRepositoryData(RepositoryData newRepositoryData, ActionListener<RepositoryData> listener) {
            BlobStoreRepository.this.writeIndexGen(newRepositoryData, this.originalRepositoryDataGeneration, this.repositoryFormatIndexVersion, Function.identity(), listener);
        }

        private void cleanupUnlinkedShardLevelBlobs(ActionListener<Void> listener) {
            Iterator<String> filesToDelete = this.resolveFilesToDelete();
            if (!filesToDelete.hasNext()) {
                listener.onResponse(null);
                return;
            }
            this.snapshotExecutor.execute(ActionRunnable.wrap(listener, l -> {
                try {
                    BlobStoreRepository.this.deleteFromContainer(OperationPurpose.SNAPSHOT_DATA, BlobStoreRepository.this.blobContainer(), filesToDelete);
                    l.onResponse(null);
                }
                catch (Exception e) {
                    logger.warn(() -> Strings.format((String)"%s Failed to delete some blobs during snapshot delete", (Object[])new Object[]{this.snapshotIds}), (Throwable)e);
                    throw e;
                }
            }));
        }

        private Iterator<String> resolveFilesToDelete() {
            String basePath = BlobStoreRepository.this.basePath().buildAsString();
            int basePathLen = basePath.length();
            return Iterators.map(Iterators.concat(this.shardBlobsToDelete.getBlobPaths(), this.getUnreferencedIndexMetadata()), absolutePath -> {
                assert (absolutePath.startsWith(basePath));
                return absolutePath.substring(basePathLen);
            });
        }

        private Iterator<String> getUnreferencedIndexMetadata() {
            return Iterators.flatMap(this.originalRepositoryData.indexMetaDataToRemoveAfterRemovingSnapshots(this.snapshotIds).entrySet().iterator(), entry -> {
                String indexContainerPath = BlobStoreRepository.this.indexPath((IndexId)entry.getKey()).buildAsString();
                return Iterators.map(((Collection)entry.getValue()).iterator(), id -> indexContainerPath + INDEX_METADATA_FORMAT.blobName((String)id));
            });
        }

        private void cleanupUnlinkedRootAndIndicesBlobs(RepositoryData newRepositoryData, ActionListener<Void> listener) {
            try (RefCountingListener listeners = new RefCountingListener(listener);){
                List<String> staleRootBlobs = SnapshotsDeletion.staleRootBlobs(newRepositoryData, this.originalRootBlobs.keySet());
                if (!staleRootBlobs.isEmpty()) {
                    BlobStoreRepository.this.staleBlobDeleteRunner.enqueueTask(listeners.acquire(ref -> {
                        try (Releasable releasable = ref;){
                            this.logStaleRootLevelBlobs(newRepositoryData.getGenId() - 1L, this.snapshotIds, staleRootBlobs);
                            BlobStoreRepository.this.deleteFromContainer(OperationPurpose.SNAPSHOT_METADATA, BlobStoreRepository.this.blobContainer(), staleRootBlobs.iterator());
                            for (String staleRootBlob : staleRootBlobs) {
                                this.bytesDeleted.addAndGet(this.originalRootBlobs.get(staleRootBlob).length());
                            }
                            this.blobsDeleted.addAndGet(staleRootBlobs.size());
                        }
                        catch (Exception e) {
                            logger.warn(() -> Strings.format((String)"[%s] The following blobs are no longer part of any snapshot [%s] but failed to remove them", (Object[])new Object[]{BlobStoreRepository.this.metadata.name(), staleRootBlobs}), (Throwable)e);
                        }
                    }));
                }
                Set survivingIndexIds = newRepositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
                for (Map.Entry<String, BlobContainer> indexEntry : this.originalIndexContainers.entrySet()) {
                    String indexId = indexEntry.getKey();
                    if (survivingIndexIds.contains(indexId)) continue;
                    BlobStoreRepository.this.staleBlobDeleteRunner.enqueueTask(listeners.acquire(ref -> {
                        try (Releasable releasable = ref;){
                            logger.debug("[{}] Found stale index [{}]. Cleaning it up", (Object)BlobStoreRepository.this.metadata.name(), (Object)indexId);
                            DeleteResult deleteResult = ((BlobContainer)indexEntry.getValue()).delete(OperationPurpose.SNAPSHOT_DATA);
                            this.blobsDeleted.addAndGet(deleteResult.blobsDeleted());
                            this.bytesDeleted.addAndGet(deleteResult.bytesDeleted());
                            logger.debug("[{}] Cleaned up stale index [{}]", (Object)BlobStoreRepository.this.metadata.name(), (Object)indexId);
                        }
                        catch (IOException e) {
                            logger.warn(() -> Strings.format((String)"[%s] index %s is no longer part of any snapshot in the repository, but failed to clean up its index folder", (Object[])new Object[]{BlobStoreRepository.this.metadata.name(), indexId}), (Throwable)e);
                        }
                    }));
                }
            }
            BlobStoreRepository.this.staleBlobDeleteRunner.runSyncTasksEagerly(this.snapshotExecutor);
        }

        private static List<String> staleRootBlobs(RepositoryData newRepositoryData, Set<String> originalRootBlobNames) {
            Set allSnapshotIds = newRepositoryData.getSnapshotIds().stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
            return originalRootBlobNames.stream().filter(blob -> {
                if (FsBlobContainer.isTempBlobName(blob)) {
                    return true;
                }
                if (blob.endsWith(BlobStoreRepository.METADATA_BLOB_NAME_SUFFIX)) {
                    String foundUUID;
                    if (blob.startsWith(BlobStoreRepository.SNAPSHOT_PREFIX)) {
                        foundUUID = blob.substring(BlobStoreRepository.SNAPSHOT_PREFIX.length(), blob.length() - BlobStoreRepository.METADATA_BLOB_NAME_SUFFIX.length());
                        assert (SNAPSHOT_FORMAT.blobName(foundUUID).equals(blob));
                    } else if (blob.startsWith(BlobStoreRepository.METADATA_PREFIX)) {
                        foundUUID = blob.substring(BlobStoreRepository.METADATA_PREFIX.length(), blob.length() - BlobStoreRepository.METADATA_BLOB_NAME_SUFFIX.length());
                        assert (GLOBAL_METADATA_FORMAT.blobName(foundUUID).equals(blob));
                    } else {
                        return false;
                    }
                    return !allSnapshotIds.contains(foundUUID);
                }
                if (blob.startsWith("index-")) {
                    try {
                        return newRepositoryData.getGenId() > Long.parseLong(blob.substring("index-".length()));
                    }
                    catch (NumberFormatException nfe) {
                        return false;
                    }
                }
                return false;
            }).toList();
        }

        private void logStaleRootLevelBlobs(long newestStaleRepositoryDataGeneration, Collection<SnapshotId> snapshotIds, List<String> blobsToDelete) {
            if (logger.isInfoEnabled()) {
                Set blobNamesToIgnore = snapshotIds.stream().flatMap(snapshotId -> Stream.of(GLOBAL_METADATA_FORMAT.blobName(snapshotId.getUUID()), SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()), BlobStoreRepository.getRepositoryDataBlobName(newestStaleRepositoryDataGeneration))).collect(Collectors.toSet());
                List<String> blobsToLog = blobsToDelete.stream().filter(b -> !blobNamesToIgnore.contains(b)).toList();
                if (!blobsToLog.isEmpty()) {
                    logger.info("[{}] Found stale root level blobs {}. Cleaning them up", (Object)BlobStoreRepository.this.metadata.name(), blobsToLog);
                }
            }
        }

        private class IndexSnapshotsDeletion {
            private final IndexId indexId;
            private final Set<SnapshotId> snapshotsWithIndex;
            private final BlobContainer indexContainer;
            private int shardCount;

            IndexSnapshotsDeletion(IndexId indexId) {
                this.indexId = indexId;
                this.indexContainer = BlobStoreRepository.this.indexContainer(indexId);
                this.snapshotsWithIndex = Set.copyOf(SnapshotsDeletion.this.originalRepositoryData.getSnapshots(indexId));
            }

            private synchronized void updateShardCount(int newShardCount) {
                this.shardCount = Math.max(this.shardCount, newShardCount);
            }

            void run(ActionListener<Void> listener) {
                this.determineShardCount(listener.delegateFailureAndWrap((l, v) -> this.processShards((ActionListener<Void>)l)));
            }

            private void determineShardCount(ActionListener<Void> listener) {
                try (RefCountingListener listeners = new RefCountingListener(listener);){
                    for (String indexMetaGeneration : SnapshotsDeletion.this.snapshotIds.stream().filter(this.snapshotsWithIndex::contains).map(id -> SnapshotsDeletion.this.originalRepositoryData.indexMetaDataGenerations().indexMetaBlobId((SnapshotId)id, this.indexId)).collect(Collectors.toSet())) {
                        SnapshotsDeletion.this.snapshotExecutor.execute(ActionRunnable.run(listeners.acquire(), (CheckedRunnable<Exception>)((CheckedRunnable)() -> this.getOneShardCount(indexMetaGeneration))));
                    }
                }
            }

            private void getOneShardCount(String indexMetaGeneration) {
                try {
                    this.updateShardCount(INDEX_METADATA_FORMAT.read(BlobStoreRepository.this.metadata.name(), this.indexContainer, indexMetaGeneration, BlobStoreRepository.this.namedXContentRegistry).getNumberOfShards());
                }
                catch (Exception ex) {
                    logger.warn(() -> Strings.format((String)"[%s] [%s] failed to read metadata for index", (Object[])new Object[]{indexMetaGeneration, this.indexId.getName()}), (Throwable)ex);
                }
            }

            private void processShards(ActionListener<Void> listener) {
                Set<SnapshotId> survivingSnapshots = this.snapshotsWithIndex.stream().filter(id -> !SnapshotsDeletion.this.snapshotIds.contains(id)).collect(Collectors.toSet());
                try (RefCountingListener listeners = new RefCountingListener(listener);){
                    for (int shardId = 0; shardId < this.shardCount; ++shardId) {
                        SnapshotsDeletion.this.snapshotExecutor.execute(new ShardSnapshotsDeletion(shardId, survivingSnapshots, listeners.acquire()));
                    }
                }
            }

            private class ShardSnapshotsDeletion
            extends AbstractRunnable {
                private final int shardId;
                private final Set<SnapshotId> survivingSnapshots;
                private final ActionListener<Void> listener;
                private BlobContainer shardContainer;
                private Set<String> originalShardBlobs;

                ShardSnapshotsDeletion(int shardId, Set<SnapshotId> survivingSnapshots, ActionListener<Void> listener) {
                    this.shardId = shardId;
                    this.survivingSnapshots = survivingSnapshots;
                    this.listener = listener;
                }

                @Override
                protected void doRun() throws Exception {
                    BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots;
                    long newGen;
                    this.shardContainer = BlobStoreRepository.this.shardContainer(IndexSnapshotsDeletion.this.indexId, this.shardId);
                    this.originalShardBlobs = this.shardContainer.listBlobs(OperationPurpose.SNAPSHOT_DATA).keySet();
                    if (SnapshotsDeletion.this.useShardGenerations) {
                        newGen = -1L;
                        blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(IndexSnapshotsDeletion.this.indexId, this.shardId, this.originalShardBlobs, this.shardContainer, SnapshotsDeletion.this.originalRepositoryData.shardGenerations().getShardGen(IndexSnapshotsDeletion.this.indexId, this.shardId)).v1();
                    } else {
                        Tuple<BlobStoreIndexShardSnapshots, Long> tuple = BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(this.originalShardBlobs, this.shardContainer);
                        newGen = (Long)tuple.v2() + 1L;
                        blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
                    }
                    this.deleteFromShardSnapshotMeta(blobStoreIndexShardSnapshots.withRetainedSnapshots(this.survivingSnapshots), newGen);
                }

                private void deleteFromShardSnapshotMeta(BlobStoreIndexShardSnapshots updatedSnapshots, long indexGeneration) {
                    ShardGeneration writtenGeneration = null;
                    try {
                        if (updatedSnapshots.snapshots().isEmpty()) {
                            SnapshotsDeletion.this.shardBlobsToDelete.addShardDeleteResult(IndexSnapshotsDeletion.this.indexId, this.shardId, ShardGenerations.DELETED_SHARD_GEN, this.originalShardBlobs);
                        } else {
                            if (indexGeneration < 0L) {
                                writtenGeneration = ShardGeneration.newGeneration();
                                INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedSnapshots, this.shardContainer, writtenGeneration.getGenerationUUID(), BlobStoreRepository.this.compress);
                            } else {
                                writtenGeneration = new ShardGeneration(indexGeneration);
                                BlobStoreRepository.this.writeShardIndexBlobAtomic(this.shardContainer, indexGeneration, updatedSnapshots, Collections.emptyMap());
                            }
                            Set<String> survivingSnapshotUUIDs = this.survivingSnapshots.stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
                            SnapshotsDeletion.this.shardBlobsToDelete.addShardDeleteResult(IndexSnapshotsDeletion.this.indexId, this.shardId, writtenGeneration, ShardSnapshotsDeletion.unusedBlobs(this.originalShardBlobs, survivingSnapshotUUIDs, updatedSnapshots));
                        }
                    }
                    catch (IOException e) {
                        throw new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to finalize snapshot deletion " + SnapshotsDeletion.this.snapshotIds + " with shard index [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(writtenGeneration.getGenerationUUID()) + "]", e, new Object[0]);
                    }
                }

                private static List<String> unusedBlobs(Set<String> originalShardBlobs, Set<String> survivingSnapshotUUIDs, BlobStoreIndexShardSnapshots updatedSnapshots) {
                    return originalShardBlobs.stream().filter(blob -> blob.startsWith("index-") || blob.startsWith(BlobStoreRepository.SNAPSHOT_PREFIX) && blob.endsWith(BlobStoreRepository.METADATA_BLOB_NAME_SUFFIX) && !survivingSnapshotUUIDs.contains(blob.substring(BlobStoreRepository.SNAPSHOT_PREFIX.length(), blob.length() - BlobStoreRepository.METADATA_BLOB_NAME_SUFFIX.length())) || blob.startsWith(BlobStoreRepository.UPLOADED_DATA_BLOB_PREFIX) && updatedSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blob)) == null || FsBlobContainer.isTempBlobName(blob)).toList();
                }

                @Override
                public void onFailure(Exception ex) {
                    logger.warn(() -> Strings.format((String)"%s failed to delete shard data for shard [%s][%s]", (Object[])new Object[]{SnapshotsDeletion.this.snapshotIds, IndexSnapshotsDeletion.this.indexId.getName(), this.shardId}), (Throwable)ex);
                }

                @Override
                public void onAfter() {
                    this.listener.onResponse(null);
                }
            }
        }
    }

    class ShardBlobsToDelete
    implements Releasable {
        private final BytesStreamOutput shardDeleteResults;
        private int resultCount;
        private final StreamOutput compressed;
        private final ArrayList<Closeable> resources;
        private final ShardGenerations.Builder shardGenerationsBuilder;

        ShardBlobsToDelete() {
            this.shardDeleteResults = new ReleasableBytesStreamOutput(BlobStoreRepository.this.bigArrays);
            this.resultCount = 0;
            this.compressed = new OutputStreamStreamOutput(new BufferedOutputStream(new DeflaterOutputStream(org.elasticsearch.common.io.Streams.flushOnCloseStream(this.shardDeleteResults)), 4096));
            this.resources = new ArrayList();
            this.shardGenerationsBuilder = ShardGenerations.builder();
            this.resources.add(this.compressed);
            this.resources.add((Closeable)LeakTracker.wrap((Releasable)this.shardDeleteResults));
        }

        synchronized void addShardDeleteResult(IndexId indexId, int shardId, ShardGeneration newGeneration, Collection<String> blobsToDelete) {
            try {
                this.shardGenerationsBuilder.put(indexId, shardId, newGeneration);
                new ShardSnapshotMetaDeleteResult(Objects.requireNonNull(indexId.getId()), shardId, blobsToDelete).writeTo(this.compressed);
                ++this.resultCount;
            }
            catch (IOException e) {
                assert (false) : e;
                throw new UncheckedIOException(e);
            }
        }

        public ShardGenerations getUpdatedShardGenerations() {
            return this.shardGenerationsBuilder.build();
        }

        public Iterator<String> getBlobPaths() {
            InputStreamStreamInput input;
            try {
                this.compressed.close();
                input = new InputStreamStreamInput(new BufferedInputStream(new InflaterInputStream(this.shardDeleteResults.bytes().streamInput()), 4096));
                this.resources.add(input);
            }
            catch (IOException e) {
                assert (false) : e;
                throw new UncheckedIOException(e);
            }
            return Iterators.flatMap(Iterators.forRange(0, this.resultCount, i -> {
                try {
                    return new ShardSnapshotMetaDeleteResult(input);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }), shardResult -> {
                String shardPath = BlobStoreRepository.this.shardPath(new IndexId("_na_", shardResult.indexId), shardResult.shardId).buildAsString();
                return Iterators.map(shardResult.blobsToDelete.iterator(), blob -> shardPath + blob);
            });
        }

        public void close() {
            try {
                IOUtils.close(this.resources);
            }
            catch (IOException e) {
                assert (false) : e;
                throw new UncheckedIOException(e);
            }
        }

        int sizeInBytes() {
            return this.shardDeleteResults.size();
        }

        private record ShardSnapshotMetaDeleteResult(String indexId, int shardId, Collection<String> blobsToDelete) {
            ShardSnapshotMetaDeleteResult(StreamInput in) throws IOException {
                this(in.readString(), in.readVInt(), in.readStringCollectionAsImmutableList());
                assert (in.getTransportVersion().equals(TransportVersion.current()));
            }

            void writeTo(StreamOutput out) throws IOException {
                assert (out.getTransportVersion().equals(TransportVersion.current()));
                out.writeString(this.indexId);
                out.writeVInt(this.shardId);
                out.writeStringCollection(this.blobsToDelete);
            }
        }
    }
}

