/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.jdk.ModuleQualifiedExportsService;
import org.elasticsearch.nativeaccess.NativeAccessUtil;
import org.elasticsearch.plugins.ExtendedPluginsClassLoader;
import org.elasticsearch.plugins.ModuleSupport;
import org.elasticsearch.plugins.PluginBundle;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginsUtils;
import org.elasticsearch.plugins.UberModuleClassLoader;

public class PluginsLoader {
    private static final Logger logger = LogManager.getLogger(PluginsLoader.class);
    private static final Module serverModule = PluginsLoader.class.getModule();
    private final List<PluginDescriptor> moduleDescriptors;
    private final List<PluginDescriptor> pluginDescriptors;
    private final Map<String, LoadedPluginLayer> loadedPluginLayers;
    private final Set<PluginBundle> moduleBundles;
    private final Set<PluginBundle> pluginBundles;

    public static Set<PluginBundle> loadModulesBundles(Path modulesDirectory) {
        Set<PluginBundle> modules;
        if (modulesDirectory != null) {
            try {
                modules = PluginsUtils.getModuleBundles(modulesDirectory);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize modules", ex);
            }
        } else {
            modules = Collections.emptySet();
        }
        return modules;
    }

    public static Set<PluginBundle> loadPluginsBundles(Path pluginsDirectory) {
        Set<PluginBundle> plugins;
        if (pluginsDirectory != null) {
            try {
                if (FileSystemUtils.isAccessibleDirectory(pluginsDirectory, logger)) {
                    PluginsUtils.checkForFailedPluginRemovals(pluginsDirectory);
                    plugins = PluginsUtils.getPluginBundles(pluginsDirectory);
                }
                plugins = Collections.emptySet();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize plugins", ex);
            }
        } else {
            plugins = Collections.emptySet();
        }
        return plugins;
    }

    public static PluginsLoader createPluginsLoader(Set<PluginBundle> modules, Set<PluginBundle> plugins, Map<String, Set<String>> pluginsWithNativeAccess) {
        return PluginsLoader.createPluginsLoader(modules, plugins, pluginsWithNativeAccess, true);
    }

    public static PluginsLoader createPluginsLoader(Set<PluginBundle> modules, Set<PluginBundle> plugins, Map<String, Set<String>> pluginsWithNativeAccess, boolean withServerExports) {
        Map<String, List<ModuleQualifiedExportsService>> qualifiedExports;
        if (withServerExports) {
            qualifiedExports = new HashMap(ModuleQualifiedExportsService.getBootServices());
            PluginsLoader.addServerExportsService(qualifiedExports);
        } else {
            qualifiedExports = Collections.emptyMap();
        }
        LinkedHashSet<PluginBundle> seenBundles = new LinkedHashSet<PluginBundle>();
        seenBundles.addAll(modules);
        seenBundles.addAll(plugins);
        LinkedHashMap<String, LoadedPluginLayer> loadedPluginLayers = new LinkedHashMap<String, LoadedPluginLayer>();
        HashMap<String, Set<URL>> transitiveUrls = new HashMap<String, Set<URL>>();
        List<PluginBundle> sortedBundles = PluginsUtils.sortBundles(seenBundles);
        if (!sortedBundles.isEmpty()) {
            Set systemLoaderURLs = JarHell.parseModulesAndClassPath();
            for (PluginBundle bundle : sortedBundles) {
                PluginsUtils.checkBundleJarHell(systemLoaderURLs, bundle, transitiveUrls);
                Set<String> modulesWithNativeAccess = pluginsWithNativeAccess.getOrDefault(bundle.plugin.getName(), Set.of());
                PluginsLoader.loadPluginLayer(bundle, loadedPluginLayers, qualifiedExports, modulesWithNativeAccess);
            }
        }
        return new PluginsLoader(modules, plugins, loadedPluginLayers);
    }

    PluginsLoader(Set<PluginBundle> modules, Set<PluginBundle> plugins, Map<String, LoadedPluginLayer> loadedPluginLayers) {
        this.moduleBundles = modules;
        this.pluginBundles = plugins;
        this.moduleDescriptors = modules.stream().map(PluginBundle::pluginDescriptor).toList();
        this.pluginDescriptors = plugins.stream().map(PluginBundle::pluginDescriptor).toList();
        this.loadedPluginLayers = loadedPluginLayers;
    }

    public List<PluginDescriptor> moduleDescriptors() {
        return this.moduleDescriptors;
    }

    public List<PluginDescriptor> pluginDescriptors() {
        return this.pluginDescriptors;
    }

    public Stream<PluginLayer> pluginLayers() {
        return this.loadedPluginLayers.values().stream().map(Function.identity());
    }

    public Set<PluginBundle> moduleBundles() {
        return this.moduleBundles;
    }

    public Set<PluginBundle> pluginBundles() {
        return this.pluginBundles;
    }

    private static void loadPluginLayer(PluginBundle bundle, Map<String, LoadedPluginLayer> loaded, Map<String, List<ModuleQualifiedExportsService>> qualifiedExports, Set<String> modulesWithNativeAccess) {
        String name = bundle.plugin.getName();
        logger.debug(() -> "Loading bundle: " + name);
        PluginsUtils.verifyCompatibility(bundle.plugin);
        ArrayList<LoadedPluginLayer> extendedPlugins = new ArrayList<LoadedPluginLayer>();
        for (String extendedPluginName : bundle.plugin.getExtendedPlugins()) {
            LoadedPluginLayer extendedPlugin = loaded.get(extendedPluginName);
            assert (extendedPlugin != null);
            assert (extendedPlugin.spiClassLoader() != null) : "All non-classpath plugins should be loaded with a classloader";
            extendedPlugins.add(extendedPlugin);
        }
        ExtendedPluginsClassLoader parentLoader = ExtendedPluginsClassLoader.create(PluginsLoader.class.getClassLoader(), extendedPlugins.stream().map(LoadedPluginLayer::spiClassLoader).toList());
        LayerAndLoader spiLayerAndLoader = null;
        if (bundle.hasSPI()) {
            spiLayerAndLoader = PluginsLoader.createSPI(bundle, parentLoader, extendedPlugins, qualifiedExports);
        }
        ClassLoader pluginParentLoader = spiLayerAndLoader == null ? parentLoader : spiLayerAndLoader.loader();
        LayerAndLoader pluginLayerAndLoader = PluginsLoader.createPluginLayerAndLoader(bundle, pluginParentLoader, extendedPlugins, spiLayerAndLoader, qualifiedExports, modulesWithNativeAccess);
        ClassLoader pluginClassLoader = pluginLayerAndLoader.loader();
        if (spiLayerAndLoader == null) {
            spiLayerAndLoader = pluginLayerAndLoader;
        }
        loaded.put(name, new LoadedPluginLayer(bundle, pluginClassLoader, pluginLayerAndLoader.layer(), spiLayerAndLoader.loader, spiLayerAndLoader.layer));
    }

    static LayerAndLoader createSPI(PluginBundle bundle, ClassLoader parentLoader, List<LoadedPluginLayer> extendedPlugins, Map<String, List<ModuleQualifiedExportsService>> qualifiedExports) {
        PluginDescriptor plugin = bundle.plugin;
        if (plugin.getModuleName().isPresent()) {
            logger.debug(() -> "Loading bundle: " + plugin.getName() + ", creating spi, modular");
            return PluginsLoader.createSpiModuleLayer(bundle.spiUrls, parentLoader, extendedPlugins.stream().map(LoadedPluginLayer::spiModuleLayer).toList(), qualifiedExports);
        }
        logger.debug(() -> "Loading bundle: " + plugin.getName() + ", creating spi, non-modular");
        return LayerAndLoader.ofLoader(URLClassLoader.newInstance(bundle.spiUrls.toArray(new URL[0]), parentLoader));
    }

    private static LayerAndLoader createPluginLayerAndLoader(PluginBundle bundle, ClassLoader pluginParentLoader, List<LoadedPluginLayer> extendedPlugins, LayerAndLoader spiLayerAndLoader, Map<String, List<ModuleQualifiedExportsService>> qualifiedExports, Set<String> modulesWithNativeAccess) {
        PluginDescriptor plugin = bundle.plugin;
        if (plugin.getModuleName().isPresent()) {
            logger.debug(() -> "Loading bundle: " + plugin.getName() + ", modular");
            List<ModuleLayer> parentLayers = Stream.concat(Stream.ofNullable(spiLayerAndLoader != null ? spiLayerAndLoader.layer() : null), extendedPlugins.stream().map(LoadedPluginLayer::spiModuleLayer)).toList();
            return PluginsLoader.createPluginModuleLayer(bundle, pluginParentLoader, parentLayers, qualifiedExports, modulesWithNativeAccess);
        }
        if (plugin.isStable()) {
            logger.debug(() -> "Loading bundle: " + plugin.getName() + ", non-modular as synthetic module");
            return LayerAndLoader.ofUberModuleLoader(UberModuleClassLoader.getInstance(pluginParentLoader, ModuleLayer.boot(), "synthetic." + PluginsLoader.toModuleName(plugin.getName()), bundle.allUrls, Set.of("org.elasticsearch.server"), modulesWithNativeAccess));
        }
        logger.debug(() -> "Loading bundle: " + plugin.getName() + ", non-modular");
        return LayerAndLoader.ofLoader(URLClassLoader.newInstance((URL[])bundle.urls.toArray(URL[]::new), pluginParentLoader));
    }

    static LayerAndLoader createSpiModuleLayer(Set<URL> urls, ClassLoader parentLoader, List<ModuleLayer> parentLayers, Map<String, List<ModuleQualifiedExportsService>> qualifiedExports) {
        return PluginsLoader.createModuleLayer(null, PluginsLoader.spiModuleName(urls), PluginsLoader.urlsToPaths(urls), parentLoader, parentLayers, qualifiedExports, Set.of());
    }

    static LayerAndLoader createPluginModuleLayer(PluginBundle bundle, ClassLoader parentLoader, List<ModuleLayer> parentLayers, Map<String, List<ModuleQualifiedExportsService>> qualifiedExports, Set<String> modulesWithNativeAccess) {
        assert (bundle.plugin.getModuleName().isPresent());
        return PluginsLoader.createModuleLayer(bundle.plugin.getClassname(), bundle.plugin.getModuleName().get(), PluginsLoader.urlsToPaths(bundle.urls), parentLoader, parentLayers, qualifiedExports, modulesWithNativeAccess);
    }

    static LayerAndLoader createModuleLayer(String className, String moduleName, Path[] paths, ClassLoader parentLoader, List<ModuleLayer> parentLayers, Map<String, List<ModuleQualifiedExportsService>> qualifiedExports, Set<String> modulesWithNativeAccess) {
        logger.debug(() -> "Loading bundle: creating module layer and loader for module " + moduleName);
        ModuleFinder finder = ModuleFinder.of(paths);
        Configuration configuration = Configuration.resolveAndBind(ModuleFinder.of(new Path[0]), PluginsLoader.parentConfigurationOrBoot(parentLayers), finder, Set.of(moduleName));
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, PluginsLoader.parentLayersOrBoot(parentLayers), parentLoader);
        Module pluginModule = controller.layer().findModule(moduleName).get();
        PluginsLoader.ensureEntryPointAccessible(controller, pluginModule, className);
        ModuleQualifiedExportsService.exposeQualifiedExportsAndOpens((Module)pluginModule, qualifiedExports);
        PluginsLoader.addPluginExportsServices(qualifiedExports, controller);
        PluginsLoader.enableNativeAccess(moduleName, modulesWithNativeAccess, controller);
        logger.debug(() -> "Loading bundle: created module layer and loader for module " + moduleName);
        return new LayerAndLoader(controller.layer(), controller.layer().findLoader(moduleName));
    }

    static String spiModuleName(Set<URL> spiURLS) {
        ModuleFinder finder = ModuleFinder.of(PluginsLoader.urlsToPaths(spiURLS));
        Set<ModuleReference> mrefs = finder.findAll();
        assert (mrefs.size() == 1) : "Expected a single module, got:" + mrefs;
        return ((ModuleReference)mrefs.stream().findFirst().get()).descriptor().name();
    }

    static String toModuleName(String name) {
        String result = name.replaceAll("\\W+", ".").replaceAll("(^[^A-Za-z_]*)", "").replaceAll("\\.$", "").toLowerCase(Locale.getDefault());
        assert (ModuleSupport.isPackageName(result));
        return result;
    }

    static String toPackageName(String className) {
        assert (!className.endsWith("."));
        int index = className.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalStateException("invalid class name:" + className);
        }
        return className.substring(0, index);
    }

    @SuppressForbidden(reason="I need to convert URL's to Paths")
    static Path[] urlsToPaths(Set<URL> urls) {
        return (Path[])urls.stream().map(PluginsLoader::uncheckedToURI).map(PathUtils::get).toArray(Path[]::new);
    }

    static URI uncheckedToURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)new IOException(e));
        }
    }

    private static List<Configuration> parentConfigurationOrBoot(List<ModuleLayer> parentLayers) {
        if (parentLayers == null || parentLayers.isEmpty()) {
            return List.of(ModuleLayer.boot().configuration());
        }
        return parentLayers.stream().map(ModuleLayer::configuration).toList();
    }

    private static void ensureEntryPointAccessible(ModuleLayer.Controller controller, Module pluginModule, String className) {
        if (className != null) {
            controller.addOpens(pluginModule, PluginsLoader.toPackageName(className), serverModule);
        }
    }

    private static List<ModuleLayer> parentLayersOrBoot(List<ModuleLayer> parentLayers) {
        if (parentLayers == null || parentLayers.isEmpty()) {
            return List.of(ModuleLayer.boot());
        }
        return parentLayers;
    }

    private static void addServerExportsService(Map<String, List<ModuleQualifiedExportsService>> qualifiedExports) {
        ModuleQualifiedExportsService exportsService = new ModuleQualifiedExportsService(serverModule){

            protected void addExports(String pkg, Module target) {
                serverModule.addExports(pkg, target);
            }

            protected void addOpens(String pkg, Module target) {
                serverModule.addOpens(pkg, target);
            }
        };
        ModuleQualifiedExportsService.addExportsService(qualifiedExports, (ModuleQualifiedExportsService)exportsService, (String)serverModule.getName());
    }

    private static void addPluginExportsServices(Map<String, List<ModuleQualifiedExportsService>> qualifiedExports, final ModuleLayer.Controller controller) {
        for (Module module : controller.layer().modules()) {
            ModuleQualifiedExportsService exportsService = new ModuleQualifiedExportsService(module){

                protected void addExports(String pkg, Module target) {
                    controller.addExports(this.module, pkg, target);
                }

                protected void addOpens(String pkg, Module target) {
                    controller.addOpens(this.module, pkg, target);
                }
            };
            ModuleQualifiedExportsService.addExportsService(qualifiedExports, (ModuleQualifiedExportsService)exportsService, (String)module.getName());
        }
    }

    private static void enableNativeAccess(String mainModuleName, Set<String> modulesWithNativeAccess, ModuleLayer.Controller controller) {
        for (String moduleName : modulesWithNativeAccess) {
            Optional<Module> module = controller.layer().findModule(moduleName);
            module.ifPresentOrElse(m -> NativeAccessUtil.enableNativeAccess((ModuleLayer.Controller)controller, (Module)m), () -> {
                assert (false) : Strings.format("Native access not enabled for module [%s]: not a valid module name in layer [%s]", moduleName, mainModuleName);
            });
        }
    }

    private record LoadedPluginLayer(PluginBundle pluginBundle, ClassLoader pluginClassLoader, ModuleLayer pluginModuleLayer, ClassLoader spiClassLoader, ModuleLayer spiModuleLayer) implements PluginLayer
    {
        public LoadedPluginLayer {
            Objects.requireNonNull(pluginBundle);
            Objects.requireNonNull(pluginClassLoader);
            Objects.requireNonNull(spiClassLoader);
            Objects.requireNonNull(spiModuleLayer);
        }
    }

    public record LayerAndLoader(ModuleLayer layer, ClassLoader loader) {
        public LayerAndLoader {
            Objects.requireNonNull(layer);
            Objects.requireNonNull(loader);
        }

        public static LayerAndLoader ofLoader(ClassLoader loader) {
            return new LayerAndLoader(ModuleLayer.boot(), loader);
        }

        public static LayerAndLoader ofUberModuleLoader(UberModuleClassLoader loader) {
            return new LayerAndLoader(loader.getLayer(), loader);
        }
    }

    public static interface PluginLayer {
        public PluginBundle pluginBundle();

        public ClassLoader pluginClassLoader();

        public ModuleLayer pluginModuleLayer();
    }
}

