/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class PersistentTasksCustomMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "persistent_tasks";
    private static final String API_CONTEXT = Metadata.XContentContext.API.toString();
    static final Assignment LOST_NODE_ASSIGNMENT = new Assignment(null, "awaiting reassignment after node loss");
    private final Map<String, PersistentTask<?>> tasks;
    private final long lastAllocationId;
    private static final ObjectParser<Builder, Void> PERSISTENT_TASKS_PARSER = new ObjectParser("persistent_tasks", Builder::new);
    private static final ObjectParser<TaskBuilder<PersistentTaskParams>, Void> PERSISTENT_TASK_PARSER = new ObjectParser("tasks", TaskBuilder::new);
    public static final ConstructingObjectParser<Assignment, Void> ASSIGNMENT_PARSER = new ConstructingObjectParser("assignment", objects -> new Assignment((String)objects[0], (String)objects[1]));
    private static final ObjectParser.NamedObjectParser<TaskDescriptionBuilder<PersistentTaskParams>, Void> TASK_DESCRIPTION_PARSER;
    public static final Assignment INITIAL_ASSIGNMENT;

    public PersistentTasksCustomMetadata(long lastAllocationId, Map<String, PersistentTask<?>> tasks) {
        this.lastAllocationId = lastAllocationId;
        this.tasks = tasks;
    }

    public static PersistentTasksCustomMetadata getPersistentTasksCustomMetadata(ClusterState clusterState) {
        return (PersistentTasksCustomMetadata)clusterState.getMetadata().custom(TYPE);
    }

    public Collection<PersistentTask<?>> tasks() {
        return this.tasks.values();
    }

    public Map<String, PersistentTask<?>> taskMap() {
        return this.tasks;
    }

    public PersistentTask<?> getTask(String id) {
        return this.tasks.get(id);
    }

    public Collection<PersistentTask<?>> findTasks(String taskName, Predicate<PersistentTask<?>> predicate) {
        return this.tasks().stream().filter(p -> taskName.equals(p.getTaskName())).filter(predicate).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentTasksCustomMetadata that = (PersistentTasksCustomMetadata)o;
        return this.lastAllocationId == that.lastAllocationId && Objects.equals(this.tasks, that.tasks);
    }

    public int hashCode() {
        return Objects.hash(this.tasks, this.lastAllocationId);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public long getNumberOfTasksOnNode(String nodeId, String taskName) {
        return this.tasks.values().stream().filter(task -> taskName.equals(task.taskName) && nodeId.equals(task.assignment.executorNode)).count();
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public static PersistentTasksCustomMetadata fromXContent(XContentParser parser) {
        return ((Builder)PERSISTENT_TASKS_PARSER.apply(parser, null)).build();
    }

    public static <Params extends PersistentTaskParams> PersistentTask<Params> getTaskWithId(ClusterState clusterState, String taskId) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)clusterState.metadata().custom(TYPE);
        if (tasks != null) {
            return tasks.getTask(taskId);
        }
        return null;
    }

    public static ClusterState disassociateDeadNodes(ClusterState clusterState) {
        PersistentTasksCustomMetadata tasks = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata(clusterState);
        if (tasks == null) {
            return clusterState;
        }
        Builder taskBuilder = PersistentTasksCustomMetadata.builder(tasks);
        for (PersistentTask<?> task : tasks.tasks()) {
            if (task.getAssignment().getExecutorNode() == null || clusterState.nodes().nodeExists(task.getAssignment().getExecutorNode())) continue;
            taskBuilder.reassignTask(task.getId(), LOST_NODE_ASSIGNMENT);
        }
        if (!taskBuilder.isChanged()) {
            return clusterState;
        }
        Metadata.Builder metadataBuilder = Metadata.builder(clusterState.metadata());
        metadataBuilder.putCustom(TYPE, taskBuilder.build());
        return ClusterState.builder(clusterState).metadata(metadataBuilder).build();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    public PersistentTasksCustomMetadata(StreamInput in) throws IOException {
        this.lastAllocationId = in.readLong();
        this.tasks = in.readMap(PersistentTask::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.lastAllocationId);
        Map filteredTasks = this.tasks.values().stream().filter(t -> VersionedNamedWriteable.shouldSerialize(out, t.getParams())).collect(Collectors.toMap(PersistentTask::getId, Function.identity()));
        out.writeMap(filteredTasks, StreamOutput::writeWriteable);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return PersistentTasksCustomMetadata.readDiffFrom(Metadata.Custom.class, TYPE, in);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).field("last_allocation_id", this.lastAllocationId).array("tasks", this.tasks.values().iterator());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PersistentTasksCustomMetadata tasks) {
        return new Builder(tasks);
    }

    static {
        PERSISTENT_TASKS_PARSER.declareLong(Builder::setLastAllocationId, new ParseField("last_allocation_id", new String[0]));
        PERSISTENT_TASKS_PARSER.declareObjectArray(Builder::setTasks, PERSISTENT_TASK_PARSER, new ParseField("tasks", new String[0]));
        ObjectParser parser = new ObjectParser("named");
        parser.declareObject(TaskDescriptionBuilder::setParams, (p, c) -> (PersistentTaskParams)p.namedObject(PersistentTaskParams.class, c, null), new ParseField("params", new String[0]));
        parser.declareObject(TaskDescriptionBuilder::setState, (p, c) -> (PersistentTaskState)p.namedObject(PersistentTaskState.class, c, null), new ParseField("state", new String[]{"status"}));
        TASK_DESCRIPTION_PARSER = (p, c, name) -> (TaskDescriptionBuilder)parser.parse(p, new TaskDescriptionBuilder(name), (Object)name);
        ASSIGNMENT_PARSER.declareStringOrNull(ConstructingObjectParser.constructorArg(), new ParseField("executor_node", new String[0]));
        ASSIGNMENT_PARSER.declareStringOrNull(ConstructingObjectParser.constructorArg(), new ParseField("explanation", new String[0]));
        PERSISTENT_TASK_PARSER.declareString(TaskBuilder::setId, new ParseField("id", new String[0]));
        PERSISTENT_TASK_PARSER.declareString(TaskBuilder::setTaskName, new ParseField("name", new String[0]));
        PERSISTENT_TASK_PARSER.declareLong(TaskBuilder::setAllocationId, new ParseField("allocation_id", new String[0]));
        PERSISTENT_TASK_PARSER.declareNamedObjects((taskBuilder, objects) -> {
            if (objects.size() != 1) {
                throw new IllegalArgumentException("only one task description per task is allowed");
            }
            TaskDescriptionBuilder builder = (TaskDescriptionBuilder)objects.get(0);
            taskBuilder.setTaskName(builder.taskName);
            taskBuilder.setParams(builder.params);
            taskBuilder.setState(builder.state);
        }, TASK_DESCRIPTION_PARSER, new ParseField("task", new String[0]));
        PERSISTENT_TASK_PARSER.declareObject(TaskBuilder::setAssignment, ASSIGNMENT_PARSER, new ParseField("assignment", new String[0]));
        PERSISTENT_TASK_PARSER.declareLong(TaskBuilder::setAllocationIdOnLastStatusUpdate, new ParseField("allocation_id_on_last_status_update", new String[0]));
        INITIAL_ASSIGNMENT = new Assignment(null, "waiting for initial assignment");
    }

    public static class PersistentTask<P extends PersistentTaskParams>
    implements Writeable,
    ToXContentObject {
        private final String id;
        private final long allocationId;
        private final String taskName;
        private final P params;
        @Nullable
        private final PersistentTaskState state;
        private final Assignment assignment;
        @Nullable
        private final Long allocationIdOnLastStatusUpdate;

        public PersistentTask(String id, String name, P params, long allocationId, Assignment assignment) {
            this(id, allocationId, name, params, null, assignment, null);
        }

        public PersistentTask(PersistentTask<P> task, long allocationId, Assignment assignment) {
            this(task.id, allocationId, task.taskName, task.params, task.state, assignment, task.allocationId);
        }

        public PersistentTask(PersistentTask<P> task, PersistentTaskState state) {
            this(task.id, task.allocationId, task.taskName, task.params, state, task.assignment, task.allocationId);
        }

        private PersistentTask(String id, long allocationId, String name, P params, PersistentTaskState state, Assignment assignment, Long allocationIdOnLastStatusUpdate) {
            this.id = id;
            this.allocationId = allocationId;
            this.taskName = name;
            this.params = params;
            this.state = state;
            this.assignment = assignment;
            this.allocationIdOnLastStatusUpdate = allocationIdOnLastStatusUpdate;
            if (params != null && !params.getWriteableName().equals(this.taskName)) {
                throw new IllegalArgumentException("params have to have the same writeable name as task. params: " + params.getWriteableName() + " task: " + this.taskName);
            }
            if (state != null && !state.getWriteableName().equals(this.taskName)) {
                throw new IllegalArgumentException("status has to have the same writeable name as task. status: " + state.getWriteableName() + " task: " + this.taskName);
            }
        }

        public PersistentTask(StreamInput in) throws IOException {
            this.id = in.readString();
            this.allocationId = in.readLong();
            this.taskName = in.readString();
            this.params = in.readNamedWriteable(PersistentTaskParams.class);
            this.state = in.readOptionalNamedWriteable(PersistentTaskState.class);
            this.assignment = new Assignment(in.readOptionalString(), in.readString());
            this.allocationIdOnLastStatusUpdate = in.readOptionalLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeLong(this.allocationId);
            out.writeString(this.taskName);
            out.writeNamedWriteable((NamedWriteable)this.params);
            out.writeOptionalNamedWriteable(this.state);
            out.writeOptionalString(this.assignment.executorNode);
            out.writeString(this.assignment.explanation);
            out.writeOptionalLong(this.allocationIdOnLastStatusUpdate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersistentTask that = (PersistentTask)o;
            return Objects.equals(this.id, that.id) && this.allocationId == that.allocationId && Objects.equals(this.taskName, that.taskName) && Objects.equals(this.params, that.params) && Objects.equals(this.state, that.state) && Objects.equals(this.assignment, that.assignment) && Objects.equals(this.allocationIdOnLastStatusUpdate, that.allocationIdOnLastStatusUpdate);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.allocationId, this.taskName, this.params, this.state, this.assignment, this.allocationIdOnLastStatusUpdate);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public String getId() {
            return this.id;
        }

        public long getAllocationId() {
            return this.allocationId;
        }

        public String getTaskName() {
            return this.taskName;
        }

        @Nullable
        public P getParams() {
            return this.params;
        }

        @Nullable
        public String getExecutorNode() {
            return this.assignment.executorNode;
        }

        public Assignment getAssignment() {
            return this.assignment;
        }

        public boolean isAssigned() {
            return this.assignment.isAssigned();
        }

        @Nullable
        public PersistentTaskState getState() {
            return this.state;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params xParams) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            builder.startObject("task");
            builder.startObject(this.taskName);
            if (this.params != null) {
                builder.field("params", this.params, xParams);
            }
            if (this.state != null) {
                builder.field("state", (ToXContent)this.state, xParams);
            }
            builder.endObject();
            builder.endObject();
            if (API_CONTEXT.equals(xParams.param("context_mode", API_CONTEXT))) {
                builder.field("allocation_id", this.allocationId);
                builder.startObject("assignment");
                builder.field("executor_node", this.assignment.executorNode);
                builder.field("explanation", this.assignment.explanation);
                builder.endObject();
                if (this.allocationIdOnLastStatusUpdate != null) {
                    builder.field("allocation_id_on_last_status_update", this.allocationIdOnLastStatusUpdate);
                }
            }
            builder.endObject();
            return builder;
        }
    }

    public static class Builder {
        private final Map<String, PersistentTask<?>> tasks = new HashMap();
        private long lastAllocationId;
        private boolean changed;

        private Builder() {
        }

        private Builder(PersistentTasksCustomMetadata tasksInProgress) {
            if (tasksInProgress != null) {
                this.tasks.putAll(tasksInProgress.tasks);
                this.lastAllocationId = tasksInProgress.lastAllocationId;
            } else {
                this.lastAllocationId = 0L;
            }
        }

        public long getLastAllocationId() {
            return this.lastAllocationId;
        }

        private Builder setLastAllocationId(long currentId) {
            this.lastAllocationId = currentId;
            return this;
        }

        private <Params extends PersistentTaskParams> Builder setTasks(List<TaskBuilder<Params>> tasks) {
            for (TaskBuilder<Params> builder : tasks) {
                PersistentTask<Params> task = builder.build();
                this.tasks.put(task.getId(), task);
            }
            return this;
        }

        private long getNextAllocationId() {
            ++this.lastAllocationId;
            return this.lastAllocationId;
        }

        public <Params extends PersistentTaskParams> Builder addTask(String taskId, String taskName, Params params, Assignment assignment) {
            this.changed = true;
            PersistentTask<Params> previousTask = this.tasks.put(taskId, new PersistentTask<Params>(taskId, taskName, params, this.getNextAllocationId(), assignment));
            if (previousTask != null) {
                throw new ResourceAlreadyExistsException("Trying to override task with id {" + taskId + "}", new Object[0]);
            }
            return this;
        }

        public Builder reassignTask(String taskId, Assignment assignment) {
            PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress == null) {
                throw new ResourceNotFoundException("cannot reassign task with id {" + taskId + "}, the task no longer exists", new Object[0]);
            }
            this.changed = true;
            this.tasks.put(taskId, new PersistentTask(taskInProgress, this.getNextAllocationId(), assignment));
            return this;
        }

        public Builder updateTaskState(String taskId, PersistentTaskState taskState) {
            PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress == null) {
                throw new ResourceNotFoundException("cannot update task with id {" + taskId + "}, the task no longer exists", new Object[0]);
            }
            this.changed = true;
            this.tasks.put(taskId, new PersistentTask(taskInProgress, taskState));
            return this;
        }

        public Builder removeTask(String taskId) {
            if (this.tasks.remove(taskId) == null) {
                throw new ResourceNotFoundException("cannot remove task with id {" + taskId + "}, the task no longer exists", new Object[0]);
            }
            this.changed = true;
            return this;
        }

        public boolean hasTask(String taskId) {
            return this.tasks.containsKey(taskId);
        }

        public boolean hasTask(String taskId, long allocationId) {
            PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress != null) {
                return taskInProgress.getAllocationId() == allocationId;
            }
            return false;
        }

        Set<String> getCurrentTaskIds() {
            return this.tasks.keySet();
        }

        public boolean isChanged() {
            return this.changed;
        }

        public PersistentTasksCustomMetadata build() {
            return new PersistentTasksCustomMetadata(this.lastAllocationId, Collections.unmodifiableMap(this.tasks));
        }
    }

    public static class Assignment {
        @Nullable
        private final String executorNode;
        private final String explanation;

        public Assignment(String executorNode, String explanation) {
            this.executorNode = executorNode;
            assert (explanation != null);
            this.explanation = explanation;
        }

        @Nullable
        public String getExecutorNode() {
            return this.executorNode;
        }

        public String getExplanation() {
            return this.explanation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Assignment that = (Assignment)o;
            return Objects.equals(this.executorNode, that.executorNode) && Objects.equals(this.explanation, that.explanation);
        }

        public int hashCode() {
            return Objects.hash(this.executorNode, this.explanation);
        }

        public boolean isAssigned() {
            return this.executorNode != null;
        }

        public String toString() {
            return "node: [" + this.executorNode + "], explanation: [" + this.explanation + "]";
        }
    }

    private static class TaskDescriptionBuilder<Params extends PersistentTaskParams> {
        private final String taskName;
        private Params params;
        private PersistentTaskState state;

        private TaskDescriptionBuilder(String taskName) {
            this.taskName = taskName;
        }

        private TaskDescriptionBuilder<Params> setParams(Params params) {
            this.params = params;
            return this;
        }

        private TaskDescriptionBuilder<Params> setState(PersistentTaskState state) {
            this.state = state;
            return this;
        }
    }

    private static class TaskBuilder<Params extends PersistentTaskParams> {
        private String id;
        private long allocationId;
        private String taskName;
        private Params params;
        private PersistentTaskState state;
        private Assignment assignment = INITIAL_ASSIGNMENT;
        private Long allocationIdOnLastStatusUpdate;

        private TaskBuilder() {
        }

        public TaskBuilder<Params> setId(String id) {
            this.id = id;
            return this;
        }

        public TaskBuilder<Params> setAllocationId(long allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public TaskBuilder<Params> setTaskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public TaskBuilder<Params> setParams(Params params) {
            this.params = params;
            return this;
        }

        public TaskBuilder<Params> setState(PersistentTaskState state) {
            this.state = state;
            return this;
        }

        public TaskBuilder<Params> setAssignment(Assignment assignment) {
            this.assignment = assignment;
            return this;
        }

        public TaskBuilder<Params> setAllocationIdOnLastStatusUpdate(Long allocationIdOnLastStatusUpdate) {
            this.allocationIdOnLastStatusUpdate = allocationIdOnLastStatusUpdate;
            return this;
        }

        public PersistentTask<Params> build() {
            return new PersistentTask<Params>(this.id, this.allocationId, this.taskName, this.params, this.state, this.assignment, this.allocationIdOnLastStatusUpdate);
        }
    }
}

