/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ProcessStats
implements Writeable,
ToXContentFragment {
    private final long timestamp;
    private final long openFileDescriptors;
    private final long maxFileDescriptors;
    private final Cpu cpu;
    private final Mem mem;

    public ProcessStats(long timestamp, long openFileDescriptors, long maxFileDescriptors, Cpu cpu, Mem mem) {
        this.timestamp = timestamp;
        this.openFileDescriptors = openFileDescriptors;
        this.maxFileDescriptors = maxFileDescriptors;
        this.cpu = cpu;
        this.mem = mem;
    }

    public ProcessStats(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.openFileDescriptors = in.readLong();
        this.maxFileDescriptors = in.readLong();
        this.cpu = in.readOptionalWriteable(Cpu::new);
        this.mem = in.readOptionalWriteable(Mem::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeLong(this.openFileDescriptors);
        out.writeLong(this.maxFileDescriptors);
        out.writeOptionalWriteable(this.cpu);
        out.writeOptionalWriteable(this.mem);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getOpenFileDescriptors() {
        return this.openFileDescriptors;
    }

    public long getMaxFileDescriptors() {
        return this.maxFileDescriptors;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Mem getMem() {
        return this.mem;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("process");
        builder.field("timestamp", this.timestamp);
        builder.field("open_file_descriptors", this.openFileDescriptors);
        builder.field("max_file_descriptors", this.maxFileDescriptors);
        if (this.cpu != null) {
            builder.startObject("cpu");
            builder.field("percent", this.cpu.percent);
            builder.humanReadableField("total_in_millis", "total", (Object)new TimeValue(this.cpu.total));
            builder.endObject();
        }
        if (this.mem != null) {
            builder.startObject("mem");
            builder.humanReadableField("total_virtual_in_bytes", "total_virtual", (Object)ByteSizeValue.ofBytes(this.mem.totalVirtual));
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static class Cpu
    implements Writeable {
        private final short percent;
        private final long total;

        public Cpu(short percent, long total) {
            this.percent = percent;
            this.total = total;
        }

        public Cpu(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            out.writeLong(this.total);
        }

        public short getPercent() {
            return this.percent;
        }

        public TimeValue getTotal() {
            return new TimeValue(this.total);
        }
    }

    public static class Mem
    implements Writeable {
        private final long totalVirtual;

        public Mem(long totalVirtual) {
            this.totalVirtual = totalVirtual;
        }

        public Mem(StreamInput in) throws IOException {
            this.totalVirtual = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.totalVirtual);
        }

        public ByteSizeValue getTotalVirtual() {
            return ByteSizeValue.ofBytes(this.totalVirtual);
        }
    }

    static final class Fields {
        static final String PROCESS = "process";
        static final String TIMESTAMP = "timestamp";
        static final String OPEN_FILE_DESCRIPTORS = "open_file_descriptors";
        static final String MAX_FILE_DESCRIPTORS = "max_file_descriptors";
        static final String CPU = "cpu";
        static final String PERCENT = "percent";
        static final String TOTAL = "total";
        static final String TOTAL_IN_MILLIS = "total_in_millis";
        static final String MEM = "mem";
        static final String TOTAL_VIRTUAL = "total_virtual";
        static final String TOTAL_VIRTUAL_IN_BYTES = "total_virtual_in_bytes";

        Fields() {
        }
    }
}

