/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.injection.guice.Binder;
import org.elasticsearch.injection.guice.ConfigurationException;
import org.elasticsearch.injection.guice.Key;
import org.elasticsearch.injection.guice.Provider;
import org.elasticsearch.injection.guice.binder.AnnotatedBindingBuilder;
import org.elasticsearch.injection.guice.internal.AbstractBindingBuilder;
import org.elasticsearch.injection.guice.internal.BindingImpl;
import org.elasticsearch.injection.guice.internal.InstanceBindingImpl;
import org.elasticsearch.injection.guice.internal.LinkedBindingImpl;
import org.elasticsearch.injection.guice.internal.ProviderInstanceBindingImpl;
import org.elasticsearch.injection.guice.spi.Element;
import org.elasticsearch.injection.guice.spi.InjectionPoint;
import org.elasticsearch.injection.guice.spi.Message;

public class BindingBuilder<T>
extends AbstractBindingBuilder<T>
implements AnnotatedBindingBuilder<T> {
    public BindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        super(binder, elements, source, key);
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation) {
        Key<? extends T> linkedKey = Key.get(implementation);
        Objects.requireNonNull(linkedKey, "linkedKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), linkedKey));
        return this;
    }

    @Override
    public void toInstance(T instance) {
        Set<InjectionPoint> injectionPoints;
        this.checkNotTargetted();
        if (instance != null) {
            try {
                injectionPoints = InjectionPoint.forInstanceMethods(instance.getClass());
            }
            catch (ConfigurationException e) {
                for (Message message : e.getErrorMessages()) {
                    this.binder.addError(message);
                }
                injectionPoints = Set.copyOf((Collection)e.getPartialValue());
            }
        } else {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
            injectionPoints = Collections.emptySet();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new InstanceBindingImpl(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, instance));
    }

    @Override
    public BindingBuilder<T> toProvider(Provider<? extends T> provider) {
        Set<InjectionPoint> injectionPoints;
        Objects.requireNonNull(provider, "provider");
        this.checkNotTargetted();
        try {
            injectionPoints = InjectionPoint.forInstanceMethods(provider.getClass());
        }
        catch (ConfigurationException e) {
            for (Message message : e.getErrorMessages()) {
                this.binder.addError(message);
            }
            injectionPoints = Set.copyOf((Collection)e.getPartialValue());
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new ProviderInstanceBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, provider));
        return this;
    }

    public String toString() {
        return "BindingBuilder<" + this.getBinding().getKey().getTypeLiteral() + ">";
    }
}

