/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import org.elasticsearch.injection.guice.BindingProcessor;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.Key;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.internal.ErrorsException;
import org.elasticsearch.injection.guice.internal.InternalContext;
import org.elasticsearch.injection.guice.internal.InternalFactory;
import org.elasticsearch.injection.guice.internal.ToStringBuilder;
import org.elasticsearch.injection.guice.spi.Dependency;

class FactoryProxy<T>
implements InternalFactory<T>,
BindingProcessor.CreationListener {
    private final InjectorImpl injector;
    private final Key<T> key;
    private final Key<? extends T> targetKey;
    private final Object source;
    private InternalFactory<? extends T> targetFactory;

    FactoryProxy(InjectorImpl injector, Key<T> key, Key<? extends T> targetKey, Object source) {
        this.injector = injector;
        this.key = key;
        this.targetKey = targetKey;
        this.source = source;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.targetFactory = this.injector.getInternalFactory(this.targetKey, errors.withSource(this.source));
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
        return this.targetFactory.get(errors.withSource(this.targetKey), context, dependency);
    }

    public String toString() {
        return new ToStringBuilder(FactoryProxy.class).add("key", this.key).add("provider", this.targetFactory).toString();
    }
}

