/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.injection.spec.ExistingInstanceSpec;
import org.elasticsearch.injection.spec.InjectionSpec;
import org.elasticsearch.injection.spec.MethodHandleSpec;
import org.elasticsearch.injection.spec.ParameterSpec;
import org.elasticsearch.injection.step.InjectionStep;
import org.elasticsearch.injection.step.InstantiateStep;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

final class Planner {
    private static final Logger logger = LogManager.getLogger(Planner.class);
    final List<InjectionStep> plan;
    final Map<Class<?>, InjectionSpec> specsByClass;
    final Set<Class<?>> requiredTypes;
    final Set<Class<?>> allParameterTypes;
    final Set<InjectionSpec> startedPlanning;
    final Set<InjectionSpec> finishedPlanning;
    final Set<Class<?>> alreadyProxied;

    Planner(Map<Class<?>, InjectionSpec> specsByClass, Set<Class<?>> requiredTypes, Set<Class<?>> allParameterTypes) {
        this.requiredTypes = requiredTypes;
        this.plan = new ArrayList<InjectionStep>();
        this.specsByClass = Collections.unmodifiableMap(specsByClass);
        this.allParameterTypes = Collections.unmodifiableSet(allParameterTypes);
        this.startedPlanning = new HashSet<InjectionSpec>();
        this.finishedPlanning = new HashSet<InjectionSpec>();
        this.alreadyProxied = new HashSet();
    }

    List<InjectionStep> injectionPlan() {
        for (Class<?> c : this.requiredTypes) {
            this.planForClass(c, 0);
        }
        return this.plan;
    }

    private void planForClass(Class<?> requestedClass, int depth) {
        InjectionSpec spec = this.specsByClass.get(requestedClass);
        if (spec == null) {
            throw new IllegalStateException("Cannot instantiate " + requestedClass + ": no specification provided");
        }
        this.planForSpec(spec, depth);
    }

    private void planForSpec(InjectionSpec spec, int depth) {
        if (this.finishedPlanning.contains(spec)) {
            logger.trace("{}Already planned {}", new Object[]{Planner.indent(depth), spec});
            return;
        }
        logger.trace("{}Planning for {}", new Object[]{Planner.indent(depth), spec});
        if (!this.startedPlanning.add(spec)) {
            throw new IllegalStateException("Cyclic dependency involving " + spec);
        }
        if (spec instanceof MethodHandleSpec) {
            MethodHandleSpec m = (MethodHandleSpec)spec;
            for (ParameterSpec p : m.parameters()) {
                logger.trace("{}- Recursing into {} for actual parameter {}", new Object[]{Planner.indent(depth), p.injectableType(), p});
                this.planForClass(p.injectableType(), depth + 1);
            }
            this.addStep(new InstantiateStep(m), depth);
        } else if (spec instanceof ExistingInstanceSpec) {
            ExistingInstanceSpec e = (ExistingInstanceSpec)spec;
            logger.trace("{}- Plan {}", new Object[]{Planner.indent(depth), e});
        } else {
            throw new AssertionError((Object)("Unexpected injection spec: " + spec));
        }
        this.finishedPlanning.add(spec);
    }

    private void addStep(InjectionStep newStep, int depth) {
        logger.trace("{}- Add step {}", new Object[]{Planner.indent(depth), newStep});
        this.plan.add(newStep);
    }

    private static Supplier<String> indent(int depth) {
        return () -> "\t".repeat(depth);
    }
}

