/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.spec.MethodHandleSpec;
import org.elasticsearch.injection.spec.ParameterSpec;
import org.elasticsearch.injection.step.InjectionStep;
import org.elasticsearch.injection.step.InstantiateStep;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

final class PlanInterpreter {
    private static final Logger logger = LogManager.getLogger(PlanInterpreter.class);
    private final Map<Class<?>, Object> instances = new LinkedHashMap();

    PlanInterpreter(Map<Class<?>, Object> existingInstances) {
        existingInstances.forEach(this::addInstance);
    }

    void executePlan(List<InjectionStep> plan) {
        int numConstructorCalls = 0;
        for (InjectionStep step : plan) {
            if (step instanceof InstantiateStep) {
                InstantiateStep i = (InstantiateStep)step;
                MethodHandleSpec spec = i.spec();
                logger.trace("Instantiating {}", new Object[]{spec.requestedType().getSimpleName()});
                this.addInstance(spec.requestedType(), this.instantiate(spec));
                ++numConstructorCalls;
                continue;
            }
            assert (false) : "Unexpected step type: " + step.getClass().getSimpleName();
            throw new IllegalStateException("Unexpected step type: " + step.getClass().getSimpleName());
        }
        logger.debug("Instantiated {} objects", new Object[]{numConstructorCalls});
    }

    public <T> T theInstanceOf(Class<T> type) {
        Object instance = this.instances.get(type);
        if (instance == null) {
            throw new IllegalStateException("No object of type " + type.getSimpleName());
        }
        return type.cast(instance);
    }

    private void addInstance(Class<?> requestedType, Object instance) {
        Object old = this.instances.put(requestedType, instance);
        if (old != null) {
            throw new IllegalStateException("Multiple objects for " + requestedType);
        }
    }

    @SuppressForbidden(reason="Can't call invokeExact because we don't know the method argument types statically, since each constructor has a different signature")
    private Object instantiate(MethodHandleSpec spec) {
        Object[] args = spec.parameters().stream().map(this::parameterValue).toArray();
        try {
            return spec.methodHandle().invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unexpected exception while instantiating {}" + spec, e);
        }
    }

    private Object parameterValue(ParameterSpec parameterSpec) {
        return this.theInstanceOf(parameterSpec.formalType());
    }
}

