/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public record UnifiedCompletionRequest(List<Message> messages, @Nullable String model, @Nullable Long maxCompletionTokens, @Nullable List<String> stop, @Nullable Float temperature, @Nullable ToolChoice toolChoice, @Nullable List<Tool> tools, @Nullable Float topP) implements Writeable,
ToXContentFragment
{
    public static final String NAME_FIELD = "name";
    public static final String TOOL_CALL_ID_FIELD = "tool_call_id";
    public static final String TOOL_CALLS_FIELD = "tool_calls";
    public static final String ID_FIELD = "id";
    public static final String FUNCTION_FIELD = "function";
    public static final String ARGUMENTS_FIELD = "arguments";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String STRICT_FIELD = "strict";
    public static final String TOP_P_FIELD = "top_p";
    public static final String MESSAGES_FIELD = "messages";
    private static final String ROLE_FIELD = "role";
    private static final String CONTENT_FIELD = "content";
    private static final String STOP_FIELD = "stop";
    private static final String TEMPERATURE_FIELD = "temperature";
    private static final String TOOL_CHOICE_FIELD = "tool_choice";
    private static final String TOOL_FIELD = "tools";
    private static final String TEXT_FIELD = "text";
    private static final String TYPE_FIELD = "type";
    private static final String MODEL_FIELD = "model";
    private static final String MAX_COMPLETION_TOKENS_FIELD = "max_completion_tokens";
    private static final String MAX_TOKENS_FIELD = "max_tokens";
    private static final String MODEL_ID_PARAM = "model_id_value";
    private static final String MAX_TOKENS_PARAM = "max_tokens_field";
    public static final String INCLUDE_STREAM_OPTIONS_PARAM = "include_stream_options";
    public static final ConstructingObjectParser<UnifiedCompletionRequest, Void> PARSER = new ConstructingObjectParser(UnifiedCompletionRequest.class.getSimpleName(), args -> new UnifiedCompletionRequest((List)args[0], (String)args[1], (Long)args[2], (List)args[3], (Float)args[4], (ToolChoice)args[5], (List)args[6], (Float)args[7]));

    public UnifiedCompletionRequest(StreamInput in) throws IOException {
        this(in.readCollectionAsImmutableList(Message::new), in.readOptionalString(), in.readOptionalVLong(), in.readOptionalStringCollectionAsList(), in.readOptionalFloat(), in.readOptionalNamedWriteable(ToolChoice.class), in.readOptionalCollectionAsList(Tool::new), in.readOptionalFloat());
    }

    public static ToXContent.Params withMaxTokens(String modelId, ToXContent.Params params) {
        return new ToXContent.DelegatingMapParams(Map.ofEntries(Map.entry(MODEL_ID_PARAM, modelId), Map.entry(MAX_TOKENS_PARAM, MAX_TOKENS_FIELD)), params);
    }

    public static ToXContent.Params withMaxTokensAndSkipStreamOptionsField(String modelId, ToXContent.Params params) {
        return new ToXContent.DelegatingMapParams(Map.ofEntries(Map.entry(MODEL_ID_PARAM, modelId), Map.entry(MAX_TOKENS_PARAM, MAX_TOKENS_FIELD), Map.entry(INCLUDE_STREAM_OPTIONS_PARAM, Boolean.FALSE.toString())), params);
    }

    public static ToXContent.Params withMaxCompletionTokensTokens(String modelId, ToXContent.Params params) {
        return new ToXContent.DelegatingMapParams(Map.ofEntries(Map.entry(MODEL_ID_PARAM, modelId), Map.entry(MAX_TOKENS_PARAM, MAX_COMPLETION_TOKENS_FIELD)), params);
    }

    public static ToXContent.Params withMaxCompletionTokensTokens(ToXContent.Params params) {
        return new ToXContent.DelegatingMapParams(Map.of(MAX_TOKENS_PARAM, MAX_COMPLETION_TOKENS_FIELD), params);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(Content.class, "content_objects", ContentObjects::new), new NamedWriteableRegistry.Entry(Content.class, "content_string", ContentString::new), new NamedWriteableRegistry.Entry(ToolChoice.class, "tool_choice_object", ToolChoiceObject::new), new NamedWriteableRegistry.Entry(ToolChoice.class, "tool_choice_string", ToolChoiceString::new));
    }

    public static UnifiedCompletionRequest of(List<Message> messages) {
        return new UnifiedCompletionRequest(messages, null, null, null, null, null, null, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.messages);
        out.writeOptionalString(this.model);
        out.writeOptionalVLong(this.maxCompletionTokens);
        out.writeOptionalStringCollection(this.stop);
        out.writeOptionalFloat(this.temperature);
        out.writeOptionalNamedWriteable(this.toolChoice);
        out.writeOptionalCollection(this.tools);
        out.writeOptionalFloat(this.topP);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(MESSAGES_FIELD, this.messages);
        if (this.stop != null && !this.stop.isEmpty()) {
            builder.field(STOP_FIELD, this.stop);
        }
        if (this.temperature != null) {
            builder.field(TEMPERATURE_FIELD, this.temperature);
        }
        if (this.toolChoice != null) {
            this.toolChoice.toXContent(builder, params);
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            builder.field(TOOL_FIELD, this.tools);
        }
        if (this.topP != null) {
            builder.field(TOP_P_FIELD, this.topP);
        }
        if (this.maxCompletionTokens != null && params.param(MAX_TOKENS_PARAM) != null) {
            builder.field(params.param(MAX_TOKENS_PARAM), this.maxCompletionTokens);
        }
        if (params.param(MODEL_ID_PARAM) != null) {
            builder.field(MODEL_FIELD, params.param(MODEL_ID_PARAM));
        }
        return builder;
    }

    private static ToolChoice parseToolChoice(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            return (ToolChoice)ToolChoiceObject.PARSER.apply(parser, null);
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return ToolChoiceString.of(parser);
        }
        throw new XContentParseException("Unsupported token [" + token + "]");
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> Message.PARSER.apply(arg_0, arg_1), new ParseField(MESSAGES_FIELD, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(MODEL_FIELD, new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField(MAX_COMPLETION_TOKENS_FIELD, new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField(STOP_FIELD, new String[0]));
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TEMPERATURE_FIELD, new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> UnifiedCompletionRequest.parseToolChoice(p), new ParseField(TOOL_CHOICE_FIELD, new String[0]), ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> Tool.PARSER.apply(arg_0, arg_1), new ParseField(TOOL_FIELD, new String[0]));
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TOP_P_FIELD, new String[0]));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ToolChoice
    extends NamedWriteable,
    ToXContent {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Content
    extends NamedWriteable,
    ToXContent {
    }

    public record ContentObjects(List<ContentObject> contentObjects) implements Content,
    NamedWriteable
    {
        public static final String NAME = "content_objects";

        public ContentObjects(StreamInput in) throws IOException {
            this(in.readCollectionAsImmutableList(ContentObject::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.contentObjects);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(UnifiedCompletionRequest.CONTENT_FIELD, this.contentObjects);
        }
    }

    public record ContentString(String content) implements Content,
    NamedWriteable
    {
        public static final String NAME = "content_string";

        public ContentString(StreamInput in) throws IOException {
            this(in.readString());
        }

        public static ContentString of(XContentParser parser) throws IOException {
            String content = parser.text();
            return new ContentString(content);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.content);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public String toString() {
            return this.content;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(UnifiedCompletionRequest.CONTENT_FIELD, this.content);
        }
    }

    public record ToolChoiceObject(String type, FunctionField function) implements ToolChoice,
    NamedWriteable
    {
        public static final String NAME = "tool_choice_object";
        static final ConstructingObjectParser<ToolChoiceObject, Void> PARSER = new ConstructingObjectParser(ToolChoiceObject.class.getSimpleName(), args -> new ToolChoiceObject((String)args[0], (FunctionField)args[1]));

        public ToolChoiceObject(StreamInput in) throws IOException {
            this(in.readString(), new FunctionField(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            this.function.writeTo(out);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(UnifiedCompletionRequest.TOOL_CHOICE_FIELD);
            builder.field(UnifiedCompletionRequest.TYPE_FIELD, this.type);
            builder.field(UnifiedCompletionRequest.FUNCTION_FIELD, (ToXContent)this.function);
            return builder.endObject();
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.TYPE_FIELD, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> FunctionField.PARSER.apply(arg_0, arg_1), new ParseField(UnifiedCompletionRequest.FUNCTION_FIELD, new String[0]));
        }

        public record FunctionField(String name) implements Writeable,
        ToXContentObject
        {
            static final ConstructingObjectParser<FunctionField, Void> PARSER = new ConstructingObjectParser("tool_choice_function_field", args -> new FunctionField((String)args[0]));

            public FunctionField(StreamInput in) throws IOException {
                this(in.readString());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.name);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject().field(UnifiedCompletionRequest.NAME_FIELD, this.name).endObject();
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.NAME_FIELD, new String[0]));
            }
        }
    }

    public record ToolChoiceString(String value) implements ToolChoice,
    NamedWriteable
    {
        public static final String NAME = "tool_choice_string";

        public ToolChoiceString(StreamInput in) throws IOException {
            this(in.readString());
        }

        public static ToolChoiceString of(XContentParser parser) throws IOException {
            String content = parser.text();
            return new ToolChoiceString(content);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.value);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(UnifiedCompletionRequest.TOOL_CHOICE_FIELD, this.value);
        }
    }

    public record Message(Content content, String role, @Nullable String toolCallId, @Nullable List<ToolCall> toolCalls) implements Writeable,
    ToXContentObject
    {
        static final ConstructingObjectParser<Message, Void> PARSER = new ConstructingObjectParser(Message.class.getSimpleName(), args -> new Message((Content)args[0], (String)args[1], (String)args[2], (List)args[3]));

        public Message(StreamInput in) throws IOException {
            this(in.readOptionalNamedWriteable(Content.class), in.readString(), in.readOptionalString(), in.readOptionalCollectionAsList(ToolCall::new));
        }

        private static Content parseContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                List<ContentObject> parsedContentObjects = XContentParserUtils.parseList(parser, p -> (ContentObject)ContentObject.PARSER.apply(p, null));
                return new ContentObjects(parsedContentObjects);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                return ContentString.of(parser);
            }
            throw new XContentParseException("Expected an array start token or a value string token but found token [" + token + "]");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalNamedWriteable(this.content);
            out.writeString(this.role);
            out.writeOptionalString(this.toolCallId);
            out.writeOptionalCollection(this.toolCalls);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.content != null) {
                this.content.toXContent(builder, params);
            }
            builder.field(UnifiedCompletionRequest.ROLE_FIELD, this.role);
            if (this.toolCallId != null) {
                builder.field(UnifiedCompletionRequest.TOOL_CALL_ID_FIELD, this.toolCallId);
            }
            if (this.toolCalls != null) {
                builder.field(UnifiedCompletionRequest.TOOL_CALLS_FIELD, this.toolCalls);
            }
            return builder.endObject();
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Message.parseContent(p), new ParseField(UnifiedCompletionRequest.CONTENT_FIELD, new String[0]), ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.ROLE_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(UnifiedCompletionRequest.TOOL_CALL_ID_FIELD, new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> ToolCall.PARSER.apply(arg_0, arg_1), new ParseField(UnifiedCompletionRequest.TOOL_CALLS_FIELD, new String[0]));
        }
    }

    public record Tool(String type, FunctionField function) implements Writeable,
    ToXContentObject
    {
        static final ConstructingObjectParser<Tool, Void> PARSER = new ConstructingObjectParser(Tool.class.getSimpleName(), args -> new Tool((String)args[0], (FunctionField)args[1]));

        public Tool(StreamInput in) throws IOException {
            this(in.readString(), new FunctionField(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            this.function.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(UnifiedCompletionRequest.TYPE_FIELD, this.type);
            builder.field(UnifiedCompletionRequest.FUNCTION_FIELD, (ToXContent)this.function);
            return builder.endObject();
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.TYPE_FIELD, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> FunctionField.PARSER.apply(arg_0, arg_1), new ParseField(UnifiedCompletionRequest.FUNCTION_FIELD, new String[0]));
        }

        public record FunctionField(@Nullable String description, String name, @Nullable Map<String, Object> parameters, @Nullable Boolean strict) implements Writeable,
        ToXContentObject
        {
            static final ConstructingObjectParser<FunctionField, Void> PARSER = new ConstructingObjectParser("tool_function_field", args -> new FunctionField((String)args[0], (String)args[1], (Map)args[2], (Boolean)args[3]));

            public FunctionField(StreamInput in) throws IOException {
                this(in.readOptionalString(), in.readString(), in.readGenericMap(), in.readOptionalBoolean());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeOptionalString(this.description);
                out.writeString(this.name);
                out.writeGenericMap(this.parameters);
                out.writeOptionalBoolean(this.strict);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(UnifiedCompletionRequest.DESCRIPTION_FIELD, this.description);
                builder.field(UnifiedCompletionRequest.NAME_FIELD, this.name);
                builder.field(UnifiedCompletionRequest.PARAMETERS_FIELD, this.parameters);
                if (this.strict != null) {
                    builder.field(UnifiedCompletionRequest.STRICT_FIELD, this.strict);
                }
                return builder.endObject();
            }

            static {
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(UnifiedCompletionRequest.DESCRIPTION_FIELD, new String[0]));
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.NAME_FIELD, new String[0]));
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), new ParseField(UnifiedCompletionRequest.PARAMETERS_FIELD, new String[0]));
                PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField(UnifiedCompletionRequest.STRICT_FIELD, new String[0]));
            }
        }
    }

    public record ToolCall(String id, FunctionField function, String type) implements Writeable,
    ToXContentObject
    {
        static final ConstructingObjectParser<ToolCall, Void> PARSER = new ConstructingObjectParser(ToolCall.class.getSimpleName(), args -> new ToolCall((String)args[0], (FunctionField)args[1], (String)args[2]));

        public ToolCall(StreamInput in) throws IOException {
            this(in.readString(), new FunctionField(in), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            this.function.writeTo(out);
            out.writeString(this.type);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(UnifiedCompletionRequest.ID_FIELD, this.id);
            builder.field(UnifiedCompletionRequest.FUNCTION_FIELD, (ToXContent)this.function);
            builder.field(UnifiedCompletionRequest.TYPE_FIELD, this.type);
            return builder.endObject();
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.ID_FIELD, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> FunctionField.PARSER.apply(arg_0, arg_1), new ParseField(UnifiedCompletionRequest.FUNCTION_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.TYPE_FIELD, new String[0]));
        }

        public record FunctionField(String arguments, String name) implements Writeable,
        ToXContentObject
        {
            static final ConstructingObjectParser<FunctionField, Void> PARSER = new ConstructingObjectParser("tool_call_function_field", args -> new FunctionField((String)args[0], (String)args[1]));

            public FunctionField(StreamInput in) throws IOException {
                this(in.readString(), in.readString());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.arguments);
                out.writeString(this.name);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(UnifiedCompletionRequest.ARGUMENTS_FIELD, this.arguments);
                builder.field(UnifiedCompletionRequest.NAME_FIELD, this.name);
                return builder.endObject();
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.ARGUMENTS_FIELD, new String[0]));
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.NAME_FIELD, new String[0]));
            }
        }
    }

    public record ContentObject(String text, String type) implements Writeable,
    ToXContentObject
    {
        static final ConstructingObjectParser<ContentObject, Void> PARSER = new ConstructingObjectParser(ContentObject.class.getSimpleName(), args -> new ContentObject((String)args[0], (String)args[1]));

        public ContentObject(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.text);
            out.writeString(this.type);
        }

        @Override
        public String toString() {
            return this.text + ":" + this.type;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(UnifiedCompletionRequest.TEXT_FIELD, this.text);
            builder.field(UnifiedCompletionRequest.TYPE_FIELD, this.type);
            return builder.endObject();
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.TEXT_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UnifiedCompletionRequest.TYPE_FIELD, new String[0]));
        }
    }
}

