/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class SettingsConfiguration
implements Writeable,
ToXContentObject {
    @Nullable
    private final Object defaultValue;
    @Nullable
    private final String description;
    private final String label;
    private final boolean required;
    private final boolean sensitive;
    private final boolean updatable;
    private final SettingsConfigurationFieldType type;
    private final EnumSet<TaskType> supportedTaskTypes;
    static final ParseField DEFAULT_VALUE_FIELD = new ParseField("default_value", new String[0]);
    static final ParseField DESCRIPTION_FIELD = new ParseField("description", new String[0]);
    static final ParseField LABEL_FIELD = new ParseField("label", new String[0]);
    static final ParseField REQUIRED_FIELD = new ParseField("required", new String[0]);
    static final ParseField SENSITIVE_FIELD = new ParseField("sensitive", new String[0]);
    static final ParseField UPDATABLE_FIELD = new ParseField("updatable", new String[0]);
    static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    static final ParseField SUPPORTED_TASK_TYPES = new ParseField("supported_task_types", new String[0]);
    private static final ConstructingObjectParser<SettingsConfiguration, Void> PARSER = new ConstructingObjectParser("service_configuration", true, args -> {
        int i = 0;
        EnumSet<TaskType> supportedTaskTypes = EnumSet.noneOf(TaskType.class);
        List supportedTaskTypesListOfStrings = (List)args[i++];
        for (String supportedTaskTypeString : supportedTaskTypesListOfStrings) {
            supportedTaskTypes.add(TaskType.fromString(supportedTaskTypeString));
        }
        return new Builder(supportedTaskTypes).setDefaultValue(args[i++]).setDescription((String)args[i++]).setLabel((String)args[i++]).setRequired((Boolean)args[i++]).setSensitive((Boolean)args[i++]).setUpdatable((Boolean)args[i++]).setType((SettingsConfigurationFieldType)((Object)((Object)args[i++]))).build();
    });

    private SettingsConfiguration(Object defaultValue, String description, String label, boolean required, boolean sensitive, boolean updatable, SettingsConfigurationFieldType type, EnumSet<TaskType> supportedTaskTypes) {
        this.defaultValue = defaultValue;
        this.description = description;
        this.label = label;
        this.required = required;
        this.sensitive = sensitive;
        this.updatable = updatable;
        this.type = type;
        this.supportedTaskTypes = supportedTaskTypes;
    }

    public SettingsConfiguration(StreamInput in) throws IOException {
        this.defaultValue = in.readGenericValue();
        this.description = in.readOptionalString();
        this.label = in.readString();
        this.required = in.readBoolean();
        this.sensitive = in.readBoolean();
        this.updatable = in.readBoolean();
        this.type = in.readEnum(SettingsConfigurationFieldType.class);
        this.supportedTaskTypes = in.readEnumSet(TaskType.class);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public SettingsConfigurationFieldType getType() {
        return this.type;
    }

    public Set<TaskType> getSupportedTaskTypes() {
        return this.supportedTaskTypes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.defaultValue != null) {
            builder.field(DEFAULT_VALUE_FIELD.getPreferredName(), this.defaultValue);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD.getPreferredName(), this.description);
        }
        builder.field(LABEL_FIELD.getPreferredName(), this.label);
        builder.field(REQUIRED_FIELD.getPreferredName(), this.required);
        builder.field(SENSITIVE_FIELD.getPreferredName(), this.sensitive);
        builder.field(UPDATABLE_FIELD.getPreferredName(), this.updatable);
        if (this.type != null) {
            builder.field(TYPE_FIELD.getPreferredName(), this.type.toString());
        }
        builder.field(SUPPORTED_TASK_TYPES.getPreferredName(), this.supportedTaskTypes);
        builder.endObject();
        return builder;
    }

    public static SettingsConfiguration fromXContent(XContentParser parser) throws IOException {
        return (SettingsConfiguration)PARSER.parse(parser, null);
    }

    public static SettingsConfiguration fromXContentBytes(BytesReference source, XContentType xContentType) {
        SettingsConfiguration settingsConfiguration;
        block8: {
            XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, source, xContentType);
            try {
                settingsConfiguration = SettingsConfiguration.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse service configuration.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return settingsConfiguration;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.defaultValue);
        out.writeOptionalString(this.description);
        out.writeString(this.label);
        out.writeBoolean(this.required);
        out.writeBoolean(this.sensitive);
        out.writeBoolean(this.updatable);
        out.writeEnum(this.type);
        out.writeEnumSet(this.supportedTaskTypes);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DEFAULT_VALUE_FIELD.getPreferredName(), this.defaultValue);
        Optional.ofNullable(this.description).ifPresent(t -> map.put(DESCRIPTION_FIELD.getPreferredName(), t));
        map.put(LABEL_FIELD.getPreferredName(), this.label);
        map.put(REQUIRED_FIELD.getPreferredName(), this.required);
        map.put(SENSITIVE_FIELD.getPreferredName(), this.sensitive);
        map.put(UPDATABLE_FIELD.getPreferredName(), this.updatable);
        Optional.ofNullable(this.type).ifPresent(t -> map.put(TYPE_FIELD.getPreferredName(), t.toString()));
        map.put(SUPPORTED_TASK_TYPES.getPreferredName(), this.supportedTaskTypes);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingsConfiguration that = (SettingsConfiguration)o;
        return this.required == that.required && this.sensitive == that.sensitive && this.updatable == that.updatable && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.description, that.description) && Objects.equals(this.label, that.label) && this.type == that.type && Objects.equals(this.supportedTaskTypes, that.supportedTaskTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultValue, this.description, this.label, this.required, this.sensitive, this.updatable, this.type, this.supportedTaskTypes});
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), SUPPORTED_TASK_TYPES);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return p.text();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.numberValue();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                return Boolean.valueOf(p.booleanValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
        }, DEFAULT_VALUE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), DESCRIPTION_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), LABEL_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REQUIRED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SENSITIVE_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), UPDATABLE_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : SettingsConfigurationFieldType.fieldType(p.text()), TYPE_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
    }

    public static class Builder {
        private Object defaultValue;
        private String description;
        private String label;
        private boolean required;
        private boolean sensitive;
        private boolean updatable;
        private SettingsConfigurationFieldType type;
        private final EnumSet<TaskType> supportedTaskTypes;

        public Builder(EnumSet<TaskType> supportedTaskTypes) {
            this.supportedTaskTypes = TaskType.copyOf(Objects.requireNonNull(supportedTaskTypes));
        }

        public Builder setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setRequired(Boolean required) {
            this.required = Objects.requireNonNullElse(required, false);
            return this;
        }

        public Builder setSensitive(Boolean sensitive) {
            this.sensitive = Objects.requireNonNullElse(sensitive, false);
            return this;
        }

        public Builder setUpdatable(Boolean updatable) {
            this.updatable = Objects.requireNonNullElse(updatable, false);
            return this;
        }

        public Builder setType(SettingsConfigurationFieldType type) {
            this.type = type;
            return this;
        }

        public SettingsConfiguration build() {
            return new SettingsConfiguration(this.defaultValue, this.description, this.label, this.required, this.sensitive, this.updatable, this.type, this.supportedTaskTypes);
        }
    }
}

