/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;

public class RecoveryRequestTracker {
    private final Map<Long, ListenableFuture<Void>> ongoingRequests = Collections.synchronizedMap(new HashMap());
    private final LocalCheckpointTracker checkpointTracker = new LocalCheckpointTracker(-1L, -1L);

    @Nullable
    public synchronized ActionListener<Void> markReceivedAndCreateListener(long requestSeqNo, ActionListener<Void> listener) {
        if (this.checkpointTracker.hasProcessed(requestSeqNo)) {
            ListenableFuture<Void> existingFuture = this.ongoingRequests.get(requestSeqNo);
            if (existingFuture != null) {
                existingFuture.addListener(listener);
            } else {
                listener.onResponse(null);
            }
            return null;
        }
        this.checkpointTracker.markSeqNoAsProcessed(requestSeqNo);
        ListenableFuture<Void> future = new ListenableFuture<Void>();
        this.ongoingRequests.put(requestSeqNo, future);
        future.addListener(listener.safeMap(v -> {
            this.ongoingRequests.remove(requestSeqNo);
            return v;
        }));
        return future;
    }
}

