/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.transport.TransportRequest;

public interface SearchOperationListener {
    default public void onPreQueryPhase(SearchContext searchContext) {
    }

    default public void onFailedQueryPhase(SearchContext searchContext) {
    }

    default public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
    }

    default public void onPreFetchPhase(SearchContext searchContext) {
    }

    default public void onFailedFetchPhase(SearchContext searchContext) {
    }

    default public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
    }

    default public void onNewReaderContext(ReaderContext readerContext) {
    }

    default public void onFreeReaderContext(ReaderContext readerContext) {
    }

    default public void onNewScrollContext(ReaderContext readerContext) {
    }

    default public void onFreeScrollContext(ReaderContext readerContext) {
    }

    default public void validateReaderContext(ReaderContext readerContext, TransportRequest transportRequest) {
    }

    public static final class CompositeListener
    implements SearchOperationListener {
        private final SearchOperationListener[] listeners;
        private final Logger logger;

        CompositeListener(List<SearchOperationListener> listeners, Logger logger) {
            this.listeners = listeners.toArray(new SearchOperationListener[0]);
            this.logger = logger;
        }

        @Override
        public void onPreQueryPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onPreQueryPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onPreQueryPhase listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onFailedQueryPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFailedQueryPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onFailedQueryPhase listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onQueryPhase(searchContext, tookInNanos);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onQueryPhase listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onPreFetchPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onPreFetchPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onPreFetchPhase listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onFailedFetchPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFailedFetchPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onFailedFetchPhase listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFetchPhase(searchContext, tookInNanos);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onFetchPhase listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onNewReaderContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onNewReaderContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onNewContext listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onFreeReaderContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFreeReaderContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onFreeContext listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onNewScrollContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onNewScrollContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onNewScrollContext listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onFreeScrollContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFreeScrollContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "onFreeScrollContext listener [" + listener + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void validateReaderContext(ReaderContext readerContext, TransportRequest request) {
            Exception exception = null;
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.validateReaderContext(readerContext, request);
                }
                catch (Exception e) {
                    exception = ExceptionsHelper.useOrSuppress(exception, e);
                }
            }
            ExceptionsHelper.reThrowIfNotNull(exception);
        }
    }
}

