/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;

public interface NestedLookup {
    public static final NestedLookup EMPTY = new NestedLookup(){

        @Override
        public Map<String, NestedObjectMapper> getNestedMappers() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Query> getNestedParentFilters() {
            return Collections.emptyMap();
        }

        @Override
        public String getNestedParent(String path) {
            return null;
        }

        @Override
        public List<String> getImmediateChildMappers(String path) {
            return List.of();
        }
    };

    public Map<String, NestedObjectMapper> getNestedMappers();

    public Map<String, Query> getNestedParentFilters();

    public String getNestedParent(String var1);

    public List<String> getImmediateChildMappers(String var1);

    public static NestedLookup build(List<NestedObjectMapper> mappers) {
        if (mappers == null || mappers.isEmpty()) {
            return EMPTY;
        }
        mappers = mappers.stream().sorted(Comparator.comparing(ObjectMapper::fullPath)).toList();
        final HashMap<String, Query> parentFilters = new HashMap<String, Query>();
        final HashMap<String, NestedObjectMapper> mappersByName = new HashMap<String, NestedObjectMapper>();
        NestedObjectMapper previous = null;
        for (NestedObjectMapper mapper : mappers) {
            mappersByName.put(mapper.fullPath(), mapper);
            if (previous != null && mapper.fullPath().startsWith(previous.fullPath() + ".")) {
                parentFilters.put(previous.fullPath(), previous.nestedTypeFilter());
            }
            previous = mapper;
        }
        final List<String> nestedPathNames = mappers.stream().map(ObjectMapper::fullPath).toList();
        return new NestedLookup(){

            @Override
            public Map<String, NestedObjectMapper> getNestedMappers() {
                return mappersByName;
            }

            @Override
            public Map<String, Query> getNestedParentFilters() {
                return parentFilters;
            }

            @Override
            public String getNestedParent(String path) {
                if (!path.contains(".")) {
                    return null;
                }
                String parent = null;
                for (String parentPath : nestedPathNames) {
                    if (!path.startsWith(parentPath + ".")) continue;
                    parent = parentPath;
                }
                return parent;
            }

            @Override
            public List<String> getImmediateChildMappers(String path) {
                Object prefix = "".equals(path) ? "" : path + ".";
                ArrayList<String> childMappers = new ArrayList<String>();
                int parentPos = Collections.binarySearch(nestedPathNames, path);
                if (parentPos < -1 || parentPos >= nestedPathNames.size() - 1) {
                    return List.of();
                }
                int i = parentPos + 1;
                String lastChild = (String)nestedPathNames.get(i);
                if (lastChild.startsWith((String)prefix)) {
                    childMappers.add(lastChild);
                }
                ++i;
                while (i < nestedPathNames.size() && ((String)nestedPathNames.get(i)).startsWith((String)prefix)) {
                    if (((String)nestedPathNames.get(i)).startsWith(lastChild + ".")) {
                        ++i;
                        continue;
                    }
                    lastChild = (String)nestedPathNames.get(i);
                    childMappers.add(lastChild);
                    ++i;
                }
                return childMappers;
            }
        };
    }
}

