/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public abstract class BlockSourceReader
implements BlockLoader.RowStrideReader {
    private final ValueFetcher fetcher;
    private final List<Object> ignoredValues = new ArrayList<Object>();
    private final DocIdSetIterator iter;
    private final Thread creationThread;
    private int docId = -1;

    private BlockSourceReader(ValueFetcher fetcher, DocIdSetIterator iter) {
        this.fetcher = fetcher;
        this.iter = iter;
        this.creationThread = Thread.currentThread();
    }

    @Override
    public final void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
        if (this.canSkipLoading(docId)) {
            builder.appendNull();
            return;
        }
        List<Object> values = this.fetcher.fetchValues(storedFields.source(), docId, this.ignoredValues);
        this.ignoredValues.clear();
        if (values == null || values.isEmpty()) {
            builder.appendNull();
            return;
        }
        if (values.size() == 1) {
            this.append(builder, values.get(0));
            return;
        }
        builder.beginPositionEntry();
        for (Object v : values) {
            this.append(builder, v);
        }
        builder.endPositionEntry();
    }

    protected abstract void append(BlockLoader.Builder var1, Object var2);

    private boolean canSkipLoading(int docId) throws IOException {
        assert (docId >= this.docId);
        this.docId = docId;
        if (docId == this.iter.docID()) {
            return false;
        }
        return !(docId > this.iter.docID() && this.iter.advance(docId) == docId);
    }

    @Override
    public final boolean canReuse(int startingDocID) {
        return this.creationThread == Thread.currentThread() && this.docId <= startingDocID;
    }

    public static BytesRef toBytesRef(BytesRef scratch, String v) {
        int len = UnicodeUtil.maxUTF8Length((int)v.length());
        if (scratch.bytes.length < len) {
            scratch.bytes = new byte[len];
        }
        scratch.length = UnicodeUtil.UTF16toUTF8((CharSequence)v, (int)0, (int)v.length(), (byte[])scratch.bytes);
        return scratch;
    }

    public static LeafIteratorLookup lookupMatchingAll() {
        return new LeafIteratorLookup(){

            @Override
            public DocIdSetIterator lookup(LeafReaderContext ctx) throws IOException {
                return DocIdSetIterator.all((int)ctx.reader().maxDoc());
            }

            public String toString() {
                return "All";
            }
        };
    }

    public static LeafIteratorLookup lookupFromFieldNames(FieldNamesFieldMapper.FieldNamesFieldType fieldNames, final String fieldName) {
        if (!fieldNames.isEnabled()) {
            return BlockSourceReader.lookupMatchingAll();
        }
        return new LeafIteratorLookup(){
            private final BytesRef name;
            {
                this.name = new BytesRef((CharSequence)fieldName);
            }

            @Override
            public DocIdSetIterator lookup(LeafReaderContext ctx) throws IOException {
                Terms terms = ctx.reader().terms("_field_names");
                if (terms == null) {
                    return null;
                }
                TermsEnum termsEnum = terms.iterator();
                if (!termsEnum.seekExact(this.name)) {
                    return null;
                }
                return termsEnum.postings(null, 0);
            }

            public String toString() {
                return "FieldName";
            }
        };
    }

    public static LeafIteratorLookup lookupFromNorms(final String fieldName) {
        return new LeafIteratorLookup(){

            @Override
            public DocIdSetIterator lookup(LeafReaderContext ctx) throws IOException {
                return ctx.reader().getNormValues(fieldName);
            }

            public String toString() {
                return "Norms";
            }
        };
    }

    public static interface LeafIteratorLookup {
        public DocIdSetIterator lookup(LeafReaderContext var1) throws IOException;
    }

    private static class Ips
    extends BlockSourceReader {
        Ips(ValueFetcher fetcher, DocIdSetIterator iter) {
            super(fetcher, iter);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(new BytesRef(InetAddressPoint.encode((InetAddress)((InetAddress)v))));
        }

        public String toString() {
            return "BlockSourceReader.Ips";
        }
    }

    public static class IpsBlockLoader
    extends SourceBlockLoader {
        public IpsBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup) {
            super(fetcher, lookup);
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context, DocIdSetIterator iter) {
            return new Ips(this.fetcher, iter);
        }

        @Override
        protected String name() {
            return "Ips";
        }
    }

    private static class Longs
    extends BlockSourceReader {
        Longs(ValueFetcher fetcher, DocIdSetIterator iter) {
            super(fetcher, iter);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.LongBuilder)builder).appendLong(((Number)v).longValue());
        }

        public String toString() {
            return "BlockSourceReader.Longs";
        }
    }

    public static class LongsBlockLoader
    extends SourceBlockLoader {
        public LongsBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup) {
            super(fetcher, lookup);
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.longs(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context, DocIdSetIterator iter) {
            return new Longs(this.fetcher, iter);
        }

        @Override
        protected String name() {
            return "Longs";
        }
    }

    private static class Ints
    extends BlockSourceReader {
        Ints(ValueFetcher fetcher, DocIdSetIterator iter) {
            super(fetcher, iter);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.IntBuilder)builder).appendInt(((Number)v).intValue());
        }

        public String toString() {
            return "BlockSourceReader.Ints";
        }
    }

    public static class IntsBlockLoader
    extends SourceBlockLoader {
        public IntsBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup) {
            super(fetcher, lookup);
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.ints(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context, DocIdSetIterator iter) throws IOException {
            return new Ints(this.fetcher, iter);
        }

        @Override
        protected String name() {
            return "Ints";
        }
    }

    private static class DenseVectors
    extends BlockSourceReader {
        DenseVectors(ValueFetcher fetcher, DocIdSetIterator iter) {
            super(fetcher, iter);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.FloatBuilder)builder).appendFloat(((Number)v).floatValue());
        }

        public String toString() {
            return "BlockSourceReader.DenseVectors";
        }
    }

    public static class DenseVectorBlockLoader
    extends SourceBlockLoader {
        private final int dimensions;

        public DenseVectorBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup, int dimensions) {
            super(fetcher, lookup);
            this.dimensions = dimensions;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.denseVectors(expectedCount, this.dimensions);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context, DocIdSetIterator iter) {
            return new DenseVectors(this.fetcher, iter);
        }

        @Override
        protected String name() {
            return "DenseVectors";
        }
    }

    private static class Doubles
    extends BlockSourceReader {
        Doubles(ValueFetcher fetcher, DocIdSetIterator iter) {
            super(fetcher, iter);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.DoubleBuilder)builder).appendDouble(((Number)v).doubleValue());
        }

        public String toString() {
            return "BlockSourceReader.Doubles";
        }
    }

    public static class DoublesBlockLoader
    extends SourceBlockLoader {
        public DoublesBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup) {
            super(fetcher, lookup);
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.doubles(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context, DocIdSetIterator iter) {
            return new Doubles(this.fetcher, iter);
        }

        @Override
        protected String name() {
            return "Doubles";
        }
    }

    private static class Geometries
    extends BlockSourceReader {
        Geometries(ValueFetcher fetcher, DocIdSetIterator iter) {
            super(fetcher, iter);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            if (!(v instanceof byte[])) {
                throw new IllegalArgumentException("Unsupported source type for spatial geometry: " + v.getClass().getSimpleName());
            }
            byte[] wkb = (byte[])v;
            ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(new BytesRef(wkb));
        }

        public String toString() {
            return "BlockSourceReader.Geometries";
        }
    }

    private static class BytesRefs
    extends BlockSourceReader {
        private final BytesRef scratch = new BytesRef();

        BytesRefs(ValueFetcher fetcher, DocIdSetIterator iter) {
            super(fetcher, iter);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(BytesRefs.toBytesRef(this.scratch, (String)v));
        }

        public String toString() {
            return "BlockSourceReader.Bytes";
        }
    }

    public static class GeometriesBlockLoader
    extends SourceBlockLoader {
        public GeometriesBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup) {
            super(fetcher, lookup);
        }

        @Override
        public final BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        protected BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context, DocIdSetIterator iter) {
            return new Geometries(this.fetcher, iter);
        }

        @Override
        protected String name() {
            return "Geometries";
        }
    }

    public static class BytesRefsBlockLoader
    extends SourceBlockLoader {
        public BytesRefsBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup) {
            super(fetcher, lookup);
        }

        @Override
        public final BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        protected BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context, DocIdSetIterator iter) throws IOException {
            return new BytesRefs(this.fetcher, iter);
        }

        @Override
        protected String name() {
            return "Bytes";
        }
    }

    private static class Booleans
    extends BlockSourceReader {
        Booleans(ValueFetcher fetcher, DocIdSetIterator iter) {
            super(fetcher, iter);
        }

        @Override
        protected void append(BlockLoader.Builder builder, Object v) {
            ((BlockLoader.BooleanBuilder)builder).appendBoolean((Boolean)v);
        }

        public String toString() {
            return "BlockSourceReader.Booleans";
        }
    }

    public static class BooleansBlockLoader
    extends SourceBlockLoader {
        public BooleansBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup) {
            super(fetcher, lookup);
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.booleans(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context, DocIdSetIterator iter) {
            return new Booleans(this.fetcher, iter);
        }

        @Override
        protected String name() {
            return "Booleans";
        }
    }

    private static abstract class SourceBlockLoader
    implements BlockLoader {
        protected final ValueFetcher fetcher;
        private final LeafIteratorLookup lookup;

        private SourceBlockLoader(ValueFetcher fetcher, LeafIteratorLookup lookup) {
            this.fetcher = fetcher;
            this.lookup = lookup;
        }

        @Override
        public final BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            return null;
        }

        @Override
        public final StoredFieldsSpec rowStrideStoredFieldSpec() {
            return StoredFieldsSpec.NEEDS_SOURCE;
        }

        @Override
        public final boolean supportsOrdinals() {
            return false;
        }

        @Override
        public final SortedSetDocValues ordinals(LeafReaderContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            DocIdSetIterator iter = this.lookup.lookup(context);
            if (iter == null) {
                return new BlockLoader.ConstantNullsReader();
            }
            return this.rowStrideReader(context, iter);
        }

        protected abstract BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext var1, DocIdSetIterator var2) throws IOException;

        public final String toString() {
            return "BlockSourceReader." + this.name() + "[" + this.lookup + "]";
        }

        protected abstract String name();
    }
}

