/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public abstract class BlockDocValuesReader
implements BlockLoader.AllReader {
    private final Thread creationThread = Thread.currentThread();

    protected abstract int docId();

    @Override
    public final boolean canReuse(int startingDocID) {
        return this.creationThread == Thread.currentThread() && this.docId() <= startingDocID;
    }

    public abstract String toString();

    private static class Booleans
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;
        private int docID = -1;

        Booleans(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.BooleanBuilder builder = factory.booleansFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.docID) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BooleanBuilder)builder);
        }

        private void read(int doc, BlockLoader.BooleanBuilder builder) throws IOException {
            this.docID = doc;
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.docID;
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Booleans";
        }
    }

    private static class SingletonBooleans
    extends BlockDocValuesReader {
        private final NumericDocValues numericDocValues;

        SingletonBooleans(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.BooleanBuilder builder = factory.booleansFromDocValues(docs.count() - offset);){
                int lastDoc = -1;
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < lastDoc) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (this.numericDocValues.advanceExact(doc)) {
                        builder.appendBoolean(this.numericDocValues.longValue() != 0L);
                    } else {
                        builder.appendNull();
                    }
                    lastDoc = doc;
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.BooleanBuilder blockBuilder = (BlockLoader.BooleanBuilder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendBoolean(this.numericDocValues.longValue() != 0L);
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonBooleans";
        }
    }

    public static class BooleansBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public BooleansBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.BooleanBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.booleans(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
            if (docValues != null) {
                NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)docValues);
                if (singleton != null) {
                    return new SingletonBooleans(singleton);
                }
                return new Booleans(docValues);
            }
            NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonBooleans(singleton);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    private static class DenseVectorFromBinary
    extends BlockDocValuesReader {
        private final BinaryDocValues docValues;
        private final IndexVersion indexVersion;
        private final int dimensions;
        private final float[] scratch;
        private int docID = -1;

        DenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion) {
            this.docValues = docValues;
            this.scratch = new float[dims];
            this.indexVersion = indexVersion;
            this.dimensions = dims;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.FloatBuilder builder = factory.denseVectors(docs.count() - offset, this.dimensions);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.docID) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.FloatBuilder)builder);
        }

        private void read(int doc, BlockLoader.FloatBuilder builder) throws IOException {
            this.docID = doc;
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytesRef = this.docValues.binaryValue();
            assert (bytesRef.length > 0);
            VectorEncoderDecoder.decodeDenseVector(this.indexVersion, bytesRef, this.scratch);
            builder.beginPositionEntry();
            for (float value : this.scratch) {
                builder.appendFloat(value);
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.docID;
        }

        @Override
        public String toString() {
            return "DenseVectorFromBinary.Bytes";
        }
    }

    public static class DenseVectorFromBinaryBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;
        private final int dims;
        private final IndexVersion indexVersion;

        public DenseVectorFromBinaryBlockLoader(String fieldName, int dims, IndexVersion indexVersion) {
            this.fieldName = fieldName;
            this.dims = dims;
            this.indexVersion = indexVersion;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.denseVectors(expectedCount, this.dims);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            BinaryDocValues docValues = context.reader().getBinaryDocValues(this.fieldName);
            if (docValues == null) {
                return new BlockLoader.ConstantNullsReader();
            }
            return new DenseVectorFromBinary(docValues, this.dims, this.indexVersion);
        }
    }

    private static class BytesRefsFromBinary
    extends BlockDocValuesReader {
        private final BinaryDocValues docValues;
        private final ByteArrayStreamInput in = new ByteArrayStreamInput();
        private final BytesRef scratch = new BytesRef();
        private int docID = -1;

        BytesRefsFromBinary(BinaryDocValues docValues) {
            this.docValues = docValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.docID) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BytesRefBuilder)builder);
        }

        private void read(int doc, BlockLoader.BytesRefBuilder builder) throws IOException {
            this.docID = doc;
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytes = this.docValues.binaryValue();
            assert (bytes.length > 0);
            this.in.reset(bytes.bytes, bytes.offset, bytes.length);
            int count = this.in.readVInt();
            this.scratch.bytes = bytes.bytes;
            if (count == 1) {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                builder.appendBytesRef(this.scratch);
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                this.in.setPosition(this.scratch.offset + this.scratch.length);
                builder.appendBytesRef(this.scratch);
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.docID;
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Bytes";
        }
    }

    public static class BytesRefsFromBinaryBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public BytesRefsFromBinaryBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            BinaryDocValues docValues = context.reader().getBinaryDocValues(this.fieldName);
            if (docValues == null) {
                return new BlockLoader.ConstantNullsReader();
            }
            return new BytesRefsFromBinary(docValues);
        }
    }

    private static class Ordinals
    extends BlockDocValuesReader {
        private final SortedSetDocValues ordinals;

        Ordinals(SortedSetDocValues ordinals) {
            this.ordinals = ordinals;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.BytesRefBuilder builder = factory.bytesRefsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.ordinals.docID()) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BytesRefBuilder)builder);
        }

        private void read(int docId, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                builder.appendNull();
                return;
            }
            int count = this.ordinals.docValueCount();
            if (count == 1) {
                builder.appendBytesRef(this.ordinals.lookupOrd(this.ordinals.nextOrd()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendBytesRef(this.ordinals.lookupOrd(this.ordinals.nextOrd()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Ordinals";
        }
    }

    private static class SingletonOrdinals
    extends BlockDocValuesReader {
        private final SortedDocValues ordinals;

        SingletonOrdinals(SortedDocValues ordinals) {
            this.ordinals = ordinals;
        }

        private BlockLoader.Block readSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (this.ordinals.advanceExact(docId)) {
                BytesRef v = this.ordinals.lookupOrd(this.ordinals.ordValue());
                return factory.constantBytes(BytesRef.deepCopyOf((BytesRef)v), 1);
            }
            return factory.constantNulls(1);
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            if (docs.count() - offset == 1) {
                return this.readSingleDoc(factory, docs.get(offset));
            }
            try (BlockLoader.SingletonOrdinalsBuilder builder = factory.singletonOrdinalsBuilder(this.ordinals, docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.ordinals.docID()) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (this.ordinals.advanceExact(doc)) {
                        builder.appendOrd(this.ordinals.ordValue());
                        continue;
                    }
                    builder.appendNull();
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            if (this.ordinals.advanceExact(docId)) {
                ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(this.ordinals.lookupOrd(this.ordinals.ordValue()));
            } else {
                builder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonOrdinals";
        }
    }

    public static class BytesRefsFromOrdsBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public BytesRefsFromOrdsBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.BytesRefBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedSetDocValues docValues = context.reader().getSortedSetDocValues(this.fieldName);
            if (docValues != null) {
                SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)docValues);
                if (singleton != null) {
                    return new SingletonOrdinals(singleton);
                }
                return new Ordinals(docValues);
            }
            SortedDocValues singleton = context.reader().getSortedDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonOrdinals(singleton);
            }
            return new BlockLoader.ConstantNullsReader();
        }

        @Override
        public boolean supportsOrdinals() {
            return true;
        }

        @Override
        public SortedSetDocValues ordinals(LeafReaderContext context) throws IOException {
            return DocValues.getSortedSet((LeafReader)context.reader(), (String)this.fieldName);
        }

        public String toString() {
            return "BytesRefsFromOrds[" + this.fieldName + "]";
        }
    }

    private static class DenseVectorValuesBlockReader
    extends BlockDocValuesReader {
        private final FloatVectorValues floatVectorValues;
        private final int dimensions;

        DenseVectorValuesBlockReader(FloatVectorValues floatVectorValues, int dimensions) {
            this.floatVectorValues = floatVectorValues;
            this.dimensions = dimensions;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.FloatBuilder builder = factory.denseVectors(docs.count() - offset, this.dimensions);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.floatVectorValues.docID()) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.FloatBuilder)builder);
        }

        private void read(int doc, BlockLoader.FloatBuilder builder) throws IOException {
            if (this.floatVectorValues.advance(doc) == doc) {
                builder.beginPositionEntry();
                float[] floats = this.floatVectorValues.vectorValue();
                assert (floats.length == this.dimensions) : "unexpected dimensions for vector value; expected " + this.dimensions + " but got " + floats.length;
                for (float aFloat : floats) {
                    builder.appendFloat(aFloat);
                }
                builder.endPositionEntry();
            } else {
                builder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.floatVectorValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.FloatVectorValuesBlockReader";
        }
    }

    public static class DenseVectorBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;
        private final int dimensions;

        public DenseVectorBlockLoader(String fieldName, int dimensions) {
            this.fieldName = fieldName;
            this.dimensions = dimensions;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.denseVectors(expectedCount, this.dimensions);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            FloatVectorValues floatVectorValues = context.reader().getFloatVectorValues(this.fieldName);
            if (floatVectorValues != null) {
                return new DenseVectorValuesBlockReader(floatVectorValues, this.dimensions);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    private static class Doubles
    extends BlockDocValuesReader {
        private final SortedNumericDocValues docValues;
        private final ToDouble toDouble;
        private int docID = -1;

        Doubles(SortedNumericDocValues docValues, ToDouble toDouble) {
            this.docValues = docValues;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.DoubleBuilder builder = factory.doublesFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.docID) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.DoubleBuilder)builder);
        }

        private void read(int doc, BlockLoader.DoubleBuilder builder) throws IOException {
            this.docID = doc;
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.docValues.docValueCount();
            if (count == 1) {
                builder.appendDouble(this.toDouble.convert(this.docValues.nextValue()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendDouble(this.toDouble.convert(this.docValues.nextValue()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.docID;
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Doubles";
        }
    }

    private static class SingletonDoubles
    extends BlockDocValuesReader {
        private final NumericDocValues docValues;
        private final ToDouble toDouble;
        private int docID = -1;

        SingletonDoubles(NumericDocValues docValues, ToDouble toDouble) {
            this.docValues = docValues;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.DoubleBuilder builder = factory.doublesFromDocValues(docs.count() - offset);){
                int lastDoc = -1;
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < lastDoc) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (this.docValues.advanceExact(doc)) {
                        builder.appendDouble(this.toDouble.convert(this.docValues.longValue()));
                    } else {
                        builder.appendNull();
                    }
                    lastDoc = doc;
                    this.docID = doc;
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.docID = docId;
            BlockLoader.DoubleBuilder blockBuilder = (BlockLoader.DoubleBuilder)builder;
            if (this.docValues.advanceExact(this.docID)) {
                blockBuilder.appendDouble(this.toDouble.convert(this.docValues.longValue()));
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.docID;
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonDoubles";
        }
    }

    public static class DoublesBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;
        private final ToDouble toDouble;

        public DoublesBlockLoader(String fieldName, ToDouble toDouble) {
            this.fieldName = fieldName;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.doubles(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
            if (docValues != null) {
                NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)docValues);
                if (singleton != null) {
                    return new SingletonDoubles(singleton, this.toDouble);
                }
                return new Doubles(docValues, this.toDouble);
            }
            NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonDoubles(singleton, this.toDouble);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    public static interface ToDouble {
        public double convert(long var1);
    }

    private static class Ints
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;
        private int docID = -1;

        Ints(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.IntBuilder builder = factory.intsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.docID) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.IntBuilder)builder);
        }

        private void read(int doc, BlockLoader.IntBuilder builder) throws IOException {
            this.docID = doc;
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendInt(Math.toIntExact(this.numericDocValues.nextValue()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendInt(Math.toIntExact(this.numericDocValues.nextValue()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.docID;
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Ints";
        }
    }

    private static class SingletonInts
    extends BlockDocValuesReader {
        private final NumericDocValues numericDocValues;

        SingletonInts(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.IntBuilder builder = factory.intsFromDocValues(docs.count() - offset);){
                int lastDoc = -1;
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < lastDoc) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (this.numericDocValues.advanceExact(doc)) {
                        builder.appendInt(Math.toIntExact(this.numericDocValues.longValue()));
                    } else {
                        builder.appendNull();
                    }
                    lastDoc = doc;
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.IntBuilder blockBuilder = (BlockLoader.IntBuilder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendInt(Math.toIntExact(this.numericDocValues.longValue()));
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonInts";
        }
    }

    public static class IntsBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public IntsBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.ints(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
            if (docValues != null) {
                NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)docValues);
                if (singleton != null) {
                    return new SingletonInts(singleton);
                }
                return new Ints(docValues);
            }
            NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonInts(singleton);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    private static class Longs
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;
        private int docID = -1;

        Longs(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.LongBuilder builder = factory.longsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.docID) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.LongBuilder)builder);
        }

        private void read(int doc, BlockLoader.LongBuilder builder) throws IOException {
            this.docID = doc;
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendLong(this.numericDocValues.nextValue());
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendLong(this.numericDocValues.nextValue());
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.docID;
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Longs";
        }
    }

    private static class SingletonLongs
    extends BlockDocValuesReader {
        private final NumericDocValues numericDocValues;

        SingletonLongs(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            try (BlockLoader.LongBuilder builder = factory.longsFromDocValues(docs.count() - offset);){
                int lastDoc = -1;
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < lastDoc) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (this.numericDocValues.advanceExact(doc)) {
                        builder.appendLong(this.numericDocValues.longValue());
                    } else {
                        builder.appendNull();
                    }
                    lastDoc = doc;
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.LongBuilder blockBuilder = (BlockLoader.LongBuilder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendLong(this.numericDocValues.longValue());
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonLongs";
        }
    }

    public static class LongsBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public LongsBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.longs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
            if (docValues != null) {
                NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)docValues);
                if (singleton != null) {
                    return new SingletonLongs(singleton);
                }
                return new Longs(docValues);
            }
            NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonLongs(singleton);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    public static abstract class DocValuesBlockLoader
    implements BlockLoader {
        public abstract BlockLoader.AllReader reader(LeafReaderContext var1) throws IOException;

        @Override
        public final BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            return this.reader(context);
        }

        @Override
        public final BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            return this.reader(context);
        }

        @Override
        public final StoredFieldsSpec rowStrideStoredFieldSpec() {
            return StoredFieldsSpec.NO_REQUIREMENTS;
        }

        @Override
        public boolean supportsOrdinals() {
            return false;
        }

        @Override
        public SortedSetDocValues ordinals(LeafReaderContext context) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

