/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeRateLimiter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimitedIndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.engine.ElasticsearchMergeScheduler;
import org.elasticsearch.index.engine.MergeMemoryEstimateProvider;
import org.elasticsearch.index.engine.MergeTracking;
import org.elasticsearch.index.engine.ThreadPoolMergeExecutorService;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.shard.ShardId;

public class ThreadPoolMergeScheduler
extends MergeScheduler
implements ElasticsearchMergeScheduler {
    public static final Setting<Boolean> USE_THREAD_POOL_MERGE_SCHEDULER_SETTING = Setting.boolSetting("indices.merge.scheduler.use_thread_pool", true, Setting.Property.NodeScope, Setting.Property.Deprecated);
    private final ShardId shardId;
    private final MergeSchedulerConfig config;
    protected final Logger logger;
    private final MergeTracking mergeTracking;
    private final ThreadPoolMergeExecutorService threadPoolMergeExecutorService;
    private final PriorityQueue<MergeTask> backloggedMergeTasks = new PriorityQueue<MergeTask>(16, Comparator.comparingLong(MergeTask::estimatedRemainingMergeSize));
    private final Map<MergePolicy.OneMerge, MergeTask> runningMergeTasks = new HashMap<MergePolicy.OneMerge, MergeTask>();
    private final AtomicBoolean shouldThrottleIncomingMerges = new AtomicBoolean();
    private final AtomicLong submittedMergeTaskCount = new AtomicLong();
    private final AtomicLong doneMergeTaskCount = new AtomicLong();
    private final MergeMemoryEstimateProvider mergeMemoryEstimateProvider;
    private final CountDownLatch closedWithNoRunningMerges = new CountDownLatch(1);
    private volatile boolean closed = false;
    private volatile TragicEvent tragedy = null;

    public ThreadPoolMergeScheduler(ShardId shardId, IndexSettings indexSettings, ThreadPoolMergeExecutorService threadPoolMergeExecutorService, MergeMemoryEstimateProvider mergeMemoryEstimateProvider) {
        this.shardId = shardId;
        this.config = indexSettings.getMergeSchedulerConfig();
        this.logger = Loggers.getLogger(this.getClass(), shardId, new String[0]);
        this.mergeTracking = new MergeTracking(this.logger, () -> this.config.isAutoThrottle() ? ByteSizeValue.ofBytes(threadPoolMergeExecutorService.getTargetIORateBytesPerSec()).getMbFrac() : Double.POSITIVE_INFINITY);
        this.threadPoolMergeExecutorService = threadPoolMergeExecutorService;
        this.mergeMemoryEstimateProvider = mergeMemoryEstimateProvider;
    }

    @Override
    public Set<OnGoingMerge> onGoingMerges() {
        return this.mergeTracking.onGoingMerges();
    }

    @Override
    public MergeStats stats() {
        return this.mergeTracking.stats();
    }

    @Override
    public MergeScheduler getMergeScheduler() {
        return this;
    }

    @Override
    public void refreshConfig() {
        this.checkMergeTaskThrottling();
        this.enqueueBackloggedTasks();
    }

    public void merge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) {
        PendingMerge pendingMerge;
        block5: {
            if (this.closed || this.tragedy != null) {
                return;
            }
            pendingMerge = null;
            try {
                MergePolicy.OneMerge merge = mergeSource.getNextMerge();
                if (merge != null) {
                    pendingMerge = new PendingMerge(mergeSource, merge, trigger);
                }
            }
            catch (IllegalStateException e) {
                if (!this.verbose()) break block5;
                this.message("merge task poll failed, likely that index writer is failed");
            }
        }
        if (pendingMerge != null) {
            this.submitNewMergeTask(pendingMerge);
        }
    }

    public MergeScheduler clone() {
        return this;
    }

    protected void beforeMerge(OnGoingMerge merge) {
    }

    protected void afterMerge(OnGoingMerge merge) {
    }

    protected void mergeQueued(OnGoingMerge merge) {
    }

    protected void mergeExecutedOrAborted(OnGoingMerge merge) {
    }

    protected void enableIndexingThrottling(int numRunningMerges, int numQueuedMerges, int configuredMaxMergeCount) {
    }

    protected void disableIndexingThrottling(int numRunningMerges, int numQueuedMerges, int configuredMaxMergeCount) {
    }

    protected boolean shouldSkipMerge() {
        return false;
    }

    protected boolean isAutoThrottle() {
        return this.config.isAutoThrottle();
    }

    protected int getMaxMergeCount() {
        return this.config.getMaxMergeCount();
    }

    protected int getMaxThreadCount() {
        return this.config.getMaxThreadCount();
    }

    protected void handleMergeException(Throwable t) {
        throw new MergePolicy.MergeException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitNewMergeTask(PendingMerge pendingMerge) {
        boolean queued = false;
        try {
            MergeTask mergeTask = this.newMergeTask(pendingMerge.source(), pendingMerge.merge(), pendingMerge.trigger());
            if (this.tragedy == null) {
                this.mergeQueued(mergeTask.onGoingMerge);
                queued = this.threadPoolMergeExecutorService.submitMergeTask(mergeTask);
            } else {
                mergeTask.abort();
            }
        }
        finally {
            if (queued && this.tragedy != null) {
                this.abortQueuedMergesAfterTragedy(null);
            }
            this.checkMergeTaskThrottling();
        }
    }

    MergeTask newMergeTask(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge, MergeTrigger mergeTrigger) {
        boolean isAutoThrottle = mergeTrigger != MergeTrigger.CLOSING && merge.getStoreMergeInfo().mergeMaxNumSegments == -1;
        long estimateMergeMemoryBytes = this.mergeMemoryEstimateProvider.estimateMergeMemoryBytes(merge);
        ThreadPoolMergeScheduler owner = this;
        return new MergeTask(mergeSource, merge, isAutoThrottle && this.isAutoThrottle(), "Lucene Merge Task #" + this.submittedMergeTaskCount.incrementAndGet() + " for shard " + this.shardId, estimateMergeMemoryBytes, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMergeTaskThrottling() {
        long submittedMergesCount = this.submittedMergeTaskCount.get();
        long doneMergesCount = this.doneMergeTaskCount.get();
        int runningMergesCount = this.runningMergeTasks.size();
        int activeMerges = (int)(submittedMergesCount - doneMergesCount);
        int configuredMaxMergeCount = this.getMaxMergeCount();
        if (activeMerges > configuredMaxMergeCount && this.threadPoolMergeExecutorService.usingMaxTargetIORateBytesPerSec() && !this.shouldThrottleIncomingMerges.get()) {
            AtomicBoolean atomicBoolean = this.shouldThrottleIncomingMerges;
            synchronized (atomicBoolean) {
                if (!this.shouldThrottleIncomingMerges.getAndSet(true)) {
                    this.enableIndexingThrottling(runningMergesCount, activeMerges - runningMergesCount, configuredMaxMergeCount);
                }
            }
        }
        if (activeMerges <= configuredMaxMergeCount && this.shouldThrottleIncomingMerges.get()) {
            AtomicBoolean atomicBoolean = this.shouldThrottleIncomingMerges;
            synchronized (atomicBoolean) {
                if (this.shouldThrottleIncomingMerges.getAndSet(false)) {
                    this.disableIndexingThrottling(runningMergesCount, activeMerges - runningMergesCount, configuredMaxMergeCount);
                }
            }
        }
    }

    synchronized Schedule schedule(MergeTask mergeTask) {
        assert (!mergeTask.hasStartedRunning());
        if (this.closed || this.tragedy != null) {
            return Schedule.ABORT;
        }
        if (this.shouldSkipMerge()) {
            if (this.verbose()) {
                this.message(String.format(Locale.ROOT, "skipping merge task %s", mergeTask));
            }
            return Schedule.ABORT;
        }
        if (this.runningMergeTasks.size() < this.getMaxThreadCount()) {
            boolean added;
            boolean bl = added = this.runningMergeTasks.put(mergeTask.onGoingMerge.getMerge(), mergeTask) == null;
            assert (added) : "starting merge task [" + mergeTask + "] registered as already running";
            return Schedule.RUN;
        }
        assert (!mergeTask.hasStartedRunning());
        this.backloggedMergeTasks.add(mergeTask);
        return Schedule.BACKLOG;
    }

    synchronized void mergeTaskFinishedRunning(MergeTask mergeTask) {
        boolean removed;
        boolean bl = removed = this.runningMergeTasks.remove(mergeTask.onGoingMerge.getMerge()) != null;
        assert (removed) : "completed merge task [" + mergeTask + "] not registered as running";
        this.enqueueBackloggedTasks();
        this.maybeSignalAllMergesDoneAfterClose();
    }

    private void mergeTaskDone(OnGoingMerge merge) {
        this.doneMergeTaskCount.incrementAndGet();
        this.mergeExecutedOrAborted(merge);
        this.checkMergeTaskThrottling();
    }

    private void maybeSignalAllMergesDoneAfterClose() {
        assert (Thread.holdsLock(this));
        if ((this.closed || this.tragedy != null) && this.runningMergeTasks.isEmpty()) {
            this.closedWithNoRunningMerges.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTragicEvent(Throwable tragedy) {
        TragicEvent tragicEvent;
        assert (tragedy != null);
        assert (!(tragedy instanceof MergePolicy.MergeAbortedException));
        boolean shouldAbort = false;
        ThreadPoolMergeScheduler threadPoolMergeScheduler = this;
        synchronized (threadPoolMergeScheduler) {
            tragicEvent = this.tragedy;
            if (tragicEvent == null) {
                this.tragedy = tragicEvent = new TragicEvent(tragedy, new CountDownLatch(1));
                shouldAbort = true;
            }
        }
        if (shouldAbort) {
            this.abortQueuedMergesAfterTragedy(tragedy);
            this.closedWithNoRunningMerges.countDown();
            tragicEvent.latch().countDown();
            return;
        }
        try {
            tragicEvent.latch().await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            tragedy.addSuppressed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortQueuedMergesAfterTragedy(@Nullable Throwable throwable) {
        block6: {
            assert (this.tragedy != null);
            try {
                ThreadPoolMergeScheduler threadPoolMergeScheduler = this;
                synchronized (threadPoolMergeScheduler) {
                    this.abortBackloggedMergeTasks();
                    this.threadPoolMergeExecutorService.abortQueuedMergeTasks(mergeTask -> mergeTask.owner == this);
                }
            }
            catch (Exception e) {
                this.logger.warn("exception when aborting non-running merge tasks", (Throwable)e);
                if (throwable == null) break block6;
                throwable.addSuppressed(e);
            }
        }
    }

    private int abortBackloggedMergeTasks() throws Exception {
        MergeTask backlogged;
        assert (this.tragedy != null);
        assert (Thread.holdsLock(this));
        int count = 0;
        int maxExceptions = 10;
        Exception firstException = null;
        while ((backlogged = this.backloggedMergeTasks.poll()) != null) {
            try {
                this.abortMergeTask(backlogged);
                ++count;
            }
            catch (Exception e) {
                assert (false) : e;
                if (firstException != null && maxExceptions-- >= 0) {
                    firstException.addSuppressed(e);
                    continue;
                }
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        return count;
    }

    private void abortMergeTask(MergeTask mergeTask) {
        this.threadPoolMergeExecutorService.abortMergeTask(mergeTask);
    }

    private synchronized void enqueueBackloggedTasks() {
        MergeTask backloggedMergeTask;
        int maxBackloggedTasksToEnqueue = this.getMaxThreadCount() - this.runningMergeTasks.size();
        while ((this.closed || maxBackloggedTasksToEnqueue-- > 0) && (backloggedMergeTask = this.backloggedMergeTasks.poll()) != null) {
            this.threadPoolMergeExecutorService.reEnqueueBackloggedMergeTask(backloggedMergeTask);
        }
    }

    void doMerge(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge oneMerge) {
        block2: {
            try {
                mergeSource.merge(oneMerge);
            }
            catch (Throwable t) {
                if (t instanceof MergePolicy.MergeAbortedException) break block2;
                oneMerge.setAborted();
                this.handleMergeException(t);
            }
        }
    }

    public Directory wrapForMerge(MergePolicy.OneMerge merge, Directory in) {
        if (merge.isAborted()) {
            return in;
        }
        final MergeTask mergeTask = this.runningMergeTasks.get(merge);
        if (mergeTask == null) {
            throw new IllegalStateException("associated merge task for executing merge not found");
        }
        return new FilterDirectory(in){

            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                this.ensureOpen();
                assert (context.context == IOContext.Context.MERGE) : "got context=" + context.context;
                return new RateLimitedIndexOutput((RateLimiter)mergeTask.rateLimiter, this.in.createOutput(name, context));
            }
        };
    }

    protected boolean verbose() {
        if (this.logger.isTraceEnabled()) {
            return true;
        }
        return super.verbose();
    }

    protected void message(String message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}", (Object)message);
        }
        super.message(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ThreadPoolMergeScheduler threadPoolMergeScheduler = this;
        synchronized (threadPoolMergeScheduler) {
            this.closed = true;
            this.enqueueBackloggedTasks();
            this.maybeSignalAllMergesDoneAfterClose();
        }
        try {
            this.closedWithNoRunningMerges.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            super.close();
        }
    }

    PriorityQueue<MergeTask> getBackloggedMergeTasks() {
        return this.backloggedMergeTasks;
    }

    Map<MergePolicy.OneMerge, MergeTask> getRunningMergeTasks() {
        return this.runningMergeTasks;
    }

    private static double nsToSec(long ns) {
        return (double)ns / (double)TimeUnit.SECONDS.toNanos(1L);
    }

    private static double bytesToMB(long bytes) {
        return (double)bytes / 1024.0 / 1024.0;
    }

    private static String getSegmentName(MergePolicy.OneMerge merge) {
        return merge.getMergeInfo() != null ? merge.getMergeInfo().info.name : "_na_";
    }

    private static String rateToString(double mbPerSec) {
        if (mbPerSec == 0.0) {
            return "stopped";
        }
        if (mbPerSec == Double.POSITIVE_INFINITY) {
            return "unlimited";
        }
        return String.format(Locale.ROOT, "%.1f MB/sec", mbPerSec);
    }

    private record TragicEvent(Throwable throwable, CountDownLatch latch) {
    }

    record PendingMerge(MergeScheduler.MergeSource source, MergePolicy.OneMerge merge, MergeTrigger trigger) {
    }

    class MergeTask
    implements Runnable {
        private final String name;
        private final AtomicLong mergeStartTimeNS;
        private final MergeScheduler.MergeSource mergeSource;
        private final OnGoingMerge onGoingMerge;
        private final MergeRateLimiter rateLimiter;
        private final boolean supportsIOThrottling;
        private final long mergeMemoryEstimateBytes;
        private final Object owner;

        MergeTask(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge, boolean supportsIOThrottling, String name, long mergeMemoryEstimateBytes, Object owner) {
            this.name = name;
            this.mergeStartTimeNS = new AtomicLong();
            this.mergeSource = mergeSource;
            this.onGoingMerge = new OnGoingMerge(merge);
            this.rateLimiter = new MergeRateLimiter(merge.getMergeProgress());
            this.supportsIOThrottling = supportsIOThrottling;
            this.mergeMemoryEstimateBytes = mergeMemoryEstimateBytes;
            this.owner = owner;
        }

        Schedule schedule() {
            return ThreadPoolMergeScheduler.this.schedule(this);
        }

        public boolean supportsIOThrottling() {
            return this.supportsIOThrottling;
        }

        public void setIORateLimit(long ioRateLimitBytesPerSec) {
            if (!this.supportsIOThrottling) {
                throw new IllegalArgumentException("merge task cannot be IO throttled");
            }
            this.rateLimiter.setMBPerSec(ByteSizeValue.ofBytes(ioRateLimitBytesPerSec).getMbFrac());
        }

        public boolean hasStartedRunning() {
            boolean isRunning;
            boolean bl = isRunning = this.mergeStartTimeNS.get() > 0L;
            assert (isRunning || this.rateLimiter.getTotalBytesWritten() == 0L);
            return isRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block25: {
                assert (!this.hasStartedRunning());
                assert (ThreadPoolMergeScheduler.this.runningMergeTasks.containsKey(this.onGoingMerge.getMerge())) : "runNowOrBacklog must be invoked before actually running the merge task";
                try {
                    ThreadPoolMergeScheduler.this.beforeMerge(this.onGoingMerge);
                    try {
                        if (!this.mergeStartTimeNS.compareAndSet(0L, System.nanoTime())) {
                            throw new IllegalStateException("The merge task is already started or aborted");
                        }
                        ThreadPoolMergeScheduler.this.mergeTracking.mergeStarted(this.onGoingMerge);
                        if (ThreadPoolMergeScheduler.this.verbose()) {
                            ThreadPoolMergeScheduler.this.message(String.format(Locale.ROOT, "merge task %s start", this));
                        }
                        try {
                            ThreadPoolMergeScheduler.this.doMerge(this.mergeSource, this.onGoingMerge.getMerge());
                            if (ThreadPoolMergeScheduler.this.verbose()) {
                                ThreadPoolMergeScheduler.this.message(String.format(Locale.ROOT, "merge task %s merge segment [%s] done estSize=%.1f MB (written=%.1f MB) runTime=%.1fs (stopped=%.1fs, paused=%.1fs) rate=%s", this, ThreadPoolMergeScheduler.getSegmentName(this.onGoingMerge.getMerge()), ThreadPoolMergeScheduler.bytesToMB(this.onGoingMerge.getMerge().estimatedMergeBytes), ThreadPoolMergeScheduler.bytesToMB(this.rateLimiter.getTotalBytesWritten()), ThreadPoolMergeScheduler.nsToSec(System.nanoTime() - this.mergeStartTimeNS.get()), ThreadPoolMergeScheduler.nsToSec(this.rateLimiter.getTotalStoppedNS()), ThreadPoolMergeScheduler.nsToSec(this.rateLimiter.getTotalPausedNS()), ThreadPoolMergeScheduler.rateToString(this.rateLimiter.getMBPerSec())));
                            }
                        }
                        finally {
                            long tookMS = TimeValue.nsecToMSec((long)(System.nanoTime() - this.mergeStartTimeNS.get()));
                            ThreadPoolMergeScheduler.this.mergeTracking.mergeFinished(this.onGoingMerge.getMerge(), this.onGoingMerge, tookMS);
                        }
                    }
                    finally {
                        ThreadPoolMergeScheduler.this.afterMerge(this.onGoingMerge);
                    }
                    if (!ThreadPoolMergeScheduler.this.verbose()) break block25;
                }
                catch (Throwable throwable) {
                    if (ThreadPoolMergeScheduler.this.verbose()) {
                        ThreadPoolMergeScheduler.this.message(String.format(Locale.ROOT, "merge task %s end", this));
                    }
                    try {
                        ThreadPoolMergeScheduler.this.mergeTaskFinishedRunning(this);
                    }
                    finally {
                        ThreadPoolMergeScheduler.this.mergeTaskDone(this.onGoingMerge);
                    }
                    try {
                        ThreadPoolMergeScheduler.this.merge(this.mergeSource, MergeTrigger.MERGE_FINISHED);
                    }
                    catch (AlreadyClosedException alreadyClosedException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                ThreadPoolMergeScheduler.this.message(String.format(Locale.ROOT, "merge task %s end", this));
            }
            try {
                ThreadPoolMergeScheduler.this.mergeTaskFinishedRunning(this);
            }
            finally {
                ThreadPoolMergeScheduler.this.mergeTaskDone(this.onGoingMerge);
            }
            try {
                ThreadPoolMergeScheduler.this.merge(this.mergeSource, MergeTrigger.MERGE_FINISHED);
            }
            catch (AlreadyClosedException alreadyClosedException) {}
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void abort() {
            block8: {
                assert (!this.hasStartedRunning());
                assert (!ThreadPoolMergeScheduler.this.runningMergeTasks.containsKey(this.onGoingMerge.getMerge())) : "cannot abort a merge task that's already running";
                if (ThreadPoolMergeScheduler.this.verbose()) {
                    ThreadPoolMergeScheduler.this.message(String.format(Locale.ROOT, "merge task %s aborted", this));
                }
                this.onGoingMerge.getMerge().setAborted();
                try {
                    if (ThreadPoolMergeScheduler.this.verbose()) {
                        ThreadPoolMergeScheduler.this.message(String.format(Locale.ROOT, "merge task %s start abort", this));
                    }
                    if (!this.mergeStartTimeNS.compareAndSet(0L, System.nanoTime())) {
                        throw new IllegalStateException("The merge task is already started or aborted");
                    }
                    ThreadPoolMergeScheduler.this.doMerge(this.mergeSource, this.onGoingMerge.getMerge());
                    if (!ThreadPoolMergeScheduler.this.verbose()) break block8;
                }
                catch (Throwable throwable) {
                    if (ThreadPoolMergeScheduler.this.verbose()) {
                        ThreadPoolMergeScheduler.this.message(String.format(Locale.ROOT, "merge task %s end abort", this));
                    }
                    ThreadPoolMergeScheduler.this.mergeTaskDone(this.onGoingMerge);
                    throw throwable;
                }
                ThreadPoolMergeScheduler.this.message(String.format(Locale.ROOT, "merge task %s end abort", this));
            }
            ThreadPoolMergeScheduler.this.mergeTaskDone(this.onGoingMerge);
        }

        long estimatedRemainingMergeSize() {
            if (this.onGoingMerge.getMerge().isAborted()) {
                return 0L;
            }
            long estimatedMergeSize = this.onGoingMerge.getMerge().getStoreMergeInfo().estimatedMergeBytes;
            return Math.max(0L, estimatedMergeSize - this.rateLimiter.getTotalBytesWritten());
        }

        public long getMergeMemoryEstimateBytes() {
            return this.mergeMemoryEstimateBytes;
        }

        public OnGoingMerge getOnGoingMerge() {
            return this.onGoingMerge;
        }

        public String toString() {
            return this.name + (this.onGoingMerge.getMerge().isAborted() ? " (aborted)" : "");
        }
    }

    static enum Schedule {
        ABORT,
        RUN,
        BACKLOG;

    }
}

