/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node.tracker;

import org.elasticsearch.health.node.UpdateHealthInfoCacheAction;

public abstract class HealthTracker<T> {
    private volatile T lastDeterminedHealth;

    protected abstract T determineCurrentHealth();

    protected abstract void addToRequestBuilder(UpdateHealthInfoCacheAction.Request.Builder var1, T var2);

    public void addToRequestBuilder(UpdateHealthInfoCacheAction.Request.Builder builder) {
        this.addToRequestBuilder(builder, this.lastDeterminedHealth);
    }

    public boolean checkHealthChanged() {
        T health = this.determineCurrentHealth();
        assert (health != null) : "health trackers must return unknown health instead of null";
        if (health.equals(this.lastDeterminedHealth)) {
            return false;
        }
        this.lastDeterminedHealth = health;
        return true;
    }

    public void reset() {
        this.lastDeterminedHealth = null;
    }

    public T getLastDeterminedHealth() {
        return this.lastDeterminedHealth;
    }
}

