/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.io.Closeable;
import java.util.Collections;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.VersionInformation;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.ProbeConnectionResult;
import org.elasticsearch.discovery.TransportAddressConnector;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class HandshakingTransportAddressConnector
implements TransportAddressConnector {
    private static final Logger logger = LogManager.getLogger(HandshakingTransportAddressConnector.class);
    public static final Setting<TimeValue> PROBE_CONNECT_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.connect_timeout", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> PROBE_HANDSHAKE_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.handshake_timeout", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final TransportService transportService;
    private final ConnectionProfile handshakeConnectionProfile;

    public HandshakingTransportAddressConnector(Settings settings, TransportService transportService) {
        this.transportService = transportService;
        this.handshakeConnectionProfile = ConnectionProfile.buildSingleChannelProfile(TransportRequestOptions.Type.REG, PROBE_CONNECT_TIMEOUT_SETTING.get(settings), PROBE_HANDSHAKE_TIMEOUT_SETTING.get(settings), TimeValue.MINUS_ONE, null, null);
    }

    @Override
    public void connectToRemoteMasterNode(TransportAddress transportAddress, ActionListener<ProbeConnectionResult> listener) {
        new ConnectionAttempt(transportAddress).run(listener);
    }

    private class ConnectionAttempt {
        private final TransportAddress transportAddress;

        ConnectionAttempt(TransportAddress transportAddress) {
            this.transportAddress = transportAddress;
        }

        void run(ActionListener<ProbeConnectionResult> listener) {
            SubscribableListener.newForked(this::openProbeConnection).andThen(this::handshakeProbeConnection).andThen(this::openFullConnection).addListener(listener);
        }

        private void openProbeConnection(ActionListener<Transport.Connection> listener) {
            logger.trace("[{}] opening probe connection", (Object)this.transportAddress);
            HandshakingTransportAddressConnector.this.transportService.openConnection(new DiscoveryNode("", this.transportAddress.toString(), UUIDs.randomBase64UUID(Randomness.get()), this.transportAddress.address().getHostString(), this.transportAddress.getAddress(), this.transportAddress, Collections.emptyMap(), Collections.emptySet(), new VersionInformation(Version.CURRENT.minimumCompatibilityVersion(), IndexVersions.MINIMUM_COMPATIBLE, IndexVersions.MINIMUM_COMPATIBLE, IndexVersion.current())), HandshakingTransportAddressConnector.this.handshakeConnectionProfile, ActionListener.assertOnce(listener));
        }

        private void handshakeProbeConnection(final ActionListener<DiscoveryNode> listener, final Transport.Connection connection) {
            logger.trace("[{}] opened probe connection", (Object)this.transportAddress);
            TimeValue probeHandshakeTimeout = HandshakingTransportAddressConnector.this.handshakeConnectionProfile.getHandshakeTimeout();
            HandshakingTransportAddressConnector.this.transportService.handshake(connection, probeHandshakeTimeout, ActionListener.assertOnce(new ActionListener<DiscoveryNode>(){

                @Override
                public void onResponse(DiscoveryNode remoteNode) {
                    logger.trace("[{}] handshake successful: {}", (Object)ConnectionAttempt.this.transportAddress, (Object)remoteNode);
                    IOUtils.closeWhileHandlingException((Closeable)connection);
                    listener.onResponse(remoteNode);
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn(() -> "handshake to [" + ConnectionAttempt.this.transportAddress + "] failed", (Throwable)e);
                    IOUtils.closeWhileHandlingException((Closeable)connection);
                    listener.onFailure(e);
                }
            }));
        }

        private void openFullConnection(final ActionListener<ProbeConnectionResult> listener, final DiscoveryNode remoteNode) {
            if (remoteNode.equals(HandshakingTransportAddressConnector.this.transportService.getLocalNode())) {
                throw new ConnectTransportException(remoteNode, String.format(Locale.ROOT, "successfully discovered local node %s at [%s]", remoteNode.descriptionWithoutAttributes(), this.transportAddress));
            }
            if (!remoteNode.isMasterNode()) {
                throw new ConnectTransportException(remoteNode, String.format(Locale.ROOT, "successfully discovered master-ineligible node %s at [%s]; to suppress this message, remove address [%s] from your discovery configuration or ensure that traffic to this address is routed only to master-eligible nodes", remoteNode.descriptionWithoutAttributes(), this.transportAddress, this.transportAddress));
            }
            HandshakingTransportAddressConnector.this.transportService.connectToNode(remoteNode, ActionListener.assertOnce(new ActionListener<Releasable>(){

                @Override
                public void onResponse(Releasable connectionReleasable) {
                    logger.trace("[{}] completed full connection with [{}]", (Object)ConnectionAttempt.this.transportAddress, (Object)remoteNode);
                    listener.onResponse(new ProbeConnectionResult(remoteNode, connectionReleasable));
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn(() -> Strings.format((String)"Successfully discovered master-eligible node [%s] at address [%s] but could not connect to it at its publish address of [%s]. Each node in a cluster must be accessible at its publish address by all other nodes in the cluster. See %s for more information.", (Object[])new Object[]{remoteNode.descriptionWithoutAttributes(), ConnectionAttempt.this.transportAddress, remoteNode.getAddress(), ReferenceDocs.NETWORK_BINDING_AND_PUBLISHING}), (Throwable)e);
                    listener.onFailure(e);
                }
            }));
        }
    }
}

