/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.BytesReferenceStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ReleasableBytesReference
implements RefCounted,
Releasable,
BytesReference {
    private static final ReleasableBytesReference EMPTY = new ReleasableBytesReference((BytesReference)BytesArray.EMPTY, RefCounted.ALWAYS_REFERENCED);
    private BytesReference delegate;
    private final RefCounted refCounted;

    public static ReleasableBytesReference empty() {
        return EMPTY;
    }

    public ReleasableBytesReference(BytesReference delegate, Releasable releasable) {
        this(delegate, (RefCounted)new RefCountedReleasable(releasable));
    }

    public ReleasableBytesReference(BytesReference delegate, RefCounted refCounted) {
        this.delegate = delegate;
        this.refCounted = refCounted;
        assert (refCounted.hasReferences());
    }

    public static ReleasableBytesReference wrap(BytesReference reference) {
        assert (!(reference instanceof ReleasableBytesReference)) : "use #retain() instead of #wrap() on a " + reference.getClass();
        return reference.length() == 0 ? ReleasableBytesReference.empty() : new ReleasableBytesReference(reference, ALWAYS_REFERENCED);
    }

    public void incRef() {
        this.refCounted.incRef();
    }

    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    public boolean decRef() {
        boolean res = this.refCounted.decRef();
        if (res) {
            this.delegate = null;
        }
        return res;
    }

    public boolean hasReferences() {
        boolean hasRef = this.refCounted.hasReferences();
        assert (this.delegate != null || !this.refCounted.hasReferences());
        return hasRef;
    }

    public ReleasableBytesReference retain() {
        this.refCounted.mustIncRef();
        return this;
    }

    public ReleasableBytesReference retainedSlice(int from, int length) {
        assert (this.hasReferences());
        if (from == 0 && this.length() == length) {
            return this.retain();
        }
        BytesReference slice = this.delegate.slice(from, length);
        this.refCounted.incRef();
        return new ReleasableBytesReference(slice, this.refCounted);
    }

    public void close() {
        this.refCounted.decRef();
    }

    @Override
    public byte get(int index) {
        assert (this.hasReferences());
        return this.delegate.get(index);
    }

    @Override
    public int getInt(int index) {
        assert (this.hasReferences());
        return this.delegate.getInt(index);
    }

    @Override
    public int getIntLE(int index) {
        assert (this.hasReferences());
        return this.delegate.getIntLE(index);
    }

    @Override
    public long getLongLE(int index) {
        assert (this.hasReferences());
        return this.delegate.getLongLE(index);
    }

    @Override
    public double getDoubleLE(int index) {
        assert (this.hasReferences());
        return this.delegate.getDoubleLE(index);
    }

    @Override
    public int indexOf(byte marker, int from) {
        assert (this.hasReferences());
        return this.delegate.indexOf(marker, from);
    }

    @Override
    public int length() {
        assert (this.hasReferences());
        return this.delegate.length();
    }

    @Override
    public BytesReference slice(int from, int length) {
        assert (this.hasReferences());
        return this.delegate.slice(from, length);
    }

    @Override
    public long ramBytesUsed() {
        assert (this.hasReferences());
        return this.delegate.ramBytesUsed();
    }

    @Override
    public StreamInput streamInput() throws IOException {
        assert (this.hasReferences());
        return new BytesReferenceStreamInput(this.delegate){

            private ReleasableBytesReference retainAndSkip(int len) throws IOException {
                if (len == 0) {
                    return ReleasableBytesReference.empty();
                }
                ReleasableBytesReference result = ReleasableBytesReference.this.retainedSlice(this.offset(), len);
                this.skip(len);
                return result;
            }

            @Override
            public ReleasableBytesReference readReleasableBytesReference() throws IOException {
                int len = this.readVInt();
                return this.retainAndSkip(len);
            }

            @Override
            public ReleasableBytesReference readAllToReleasableBytesReference() throws IOException {
                return this.retainAndSkip(ReleasableBytesReference.this.length() - this.offset());
            }

            @Override
            public boolean supportReadAllToReleasableBytesReference() {
                return true;
            }
        };
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        assert (this.hasReferences());
        this.delegate.writeTo(os);
    }

    @Override
    public String utf8ToString() {
        assert (this.hasReferences());
        return this.delegate.utf8ToString();
    }

    @Override
    public BytesRef toBytesRef() {
        assert (this.hasReferences());
        return this.delegate.toBytesRef();
    }

    @Override
    public BytesRefIterator iterator() {
        assert (this.hasReferences());
        return this.delegate.iterator();
    }

    @Override
    public int compareTo(BytesReference o) {
        assert (this.hasReferences());
        return this.delegate.compareTo(o);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (this.hasReferences());
        return this.delegate.toXContent(builder, params);
    }

    public boolean isFragment() {
        assert (this.hasReferences());
        return this.delegate.isFragment();
    }

    public boolean equals(Object obj) {
        assert (this.hasReferences());
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        assert (this.hasReferences());
        return this.delegate.hashCode();
    }

    @Override
    public boolean hasArray() {
        assert (this.hasReferences());
        return this.delegate.hasArray();
    }

    @Override
    public byte[] array() {
        assert (this.hasReferences());
        return this.delegate.array();
    }

    @Override
    public int arrayOffset() {
        assert (this.hasReferences());
        return this.delegate.arrayOffset();
    }

    private static final class RefCountedReleasable
    extends AbstractRefCounted {
        private final Releasable releasable;

        RefCountedReleasable(Releasable releasable) {
            this.releasable = releasable;
        }

        protected void closeInternal() {
            Releasables.closeExpectNoException((Releasable)this.releasable);
        }
    }
}

