/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class IndexVersionAllocationDecider
extends AllocationDecider {
    public static final String NAME = "index_version";

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            if (shardRouting.currentNodeId() == null) {
                if (shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
                    return IndexVersionAllocationDecider.isVersionCompatible((RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource(), node, allocation);
                }
                return allocation.decision(Decision.YES, NAME, "no existing allocation, assuming compatible", new Object[0]);
            }
            return IndexVersionAllocationDecider.isIndexVersionCompatibleRelocatePrimary(allocation.routingNodes(), shardRouting.currentNodeId(), node, allocation);
        }
        ShardRouting primary = allocation.routingNodes().activePrimary(shardRouting.shardId());
        if (primary != null) {
            return IndexVersionAllocationDecider.isIndexVersionCompatibleAllocatingReplica(allocation.routingNodes(), primary.currentNodeId(), node, allocation);
        }
        return allocation.decision(Decision.YES, NAME, "no active primary shard yet", new Object[0]);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    private static Decision isIndexVersionCompatibleRelocatePrimary(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().getMaxIndexVersion().onOrAfter(source.node().getMaxIndexVersion())) {
            return allocation.decision(Decision.YES, NAME, "can relocate primary shard from a node with index version [%s] to a node with equal-or-newer index version [%s]", source.node().getMaxIndexVersion().toReleaseVersion(), target.node().getMaxIndexVersion().toReleaseVersion());
        }
        return allocation.decision(Decision.NO, NAME, "cannot relocate primary shard from a node with index version [%s] to a node with older index version [%s]", source.node().getMaxIndexVersion().toReleaseVersion(), target.node().getMaxIndexVersion().toReleaseVersion());
    }

    private static Decision isIndexVersionCompatibleAllocatingReplica(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().getMaxIndexVersion().onOrAfter(source.node().getMaxIndexVersion())) {
            return allocation.decision(Decision.YES, NAME, "can allocate replica shard to a node with index version [%s] since this is equal-or-newer than the primary index version [%s]", target.node().getMaxIndexVersion().toReleaseVersion(), source.node().getMaxIndexVersion().toReleaseVersion());
        }
        return allocation.decision(Decision.NO, NAME, "cannot allocate replica shard to a node with index version [%s] since this is older than the primary index version [%s]", target.node().getMaxIndexVersion().toReleaseVersion(), source.node().getMaxIndexVersion().toReleaseVersion());
    }

    private static Decision isVersionCompatible(RecoverySource.SnapshotRecoverySource recoverySource, RoutingNode target, RoutingAllocation allocation) {
        if (target.node().getMaxIndexVersion().onOrAfter(recoverySource.version())) {
            return allocation.decision(Decision.YES, NAME, "max supported index version [%s] is the same or newer than snapshot version [%s]", target.node().getMaxIndexVersion().toReleaseVersion(), recoverySource.version().toReleaseVersion());
        }
        return allocation.decision(Decision.NO, NAME, "max supported index version [%s] is older than the snapshot version [%s]", target.node().getMaxIndexVersion().toReleaseVersion(), recoverySource.version().toReleaseVersion());
    }
}

