/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

public abstract class ContinuousComputation<T> {
    private static final Logger logger = LogManager.getLogger(ContinuousComputation.class);
    private final Executor executor;
    private final AtomicReference<T> enqueuedInput = new AtomicReference();
    private final Processor processor = new Processor();

    public ContinuousComputation(Executor executor) {
        this.executor = executor;
    }

    public void onNewInput(T input) {
        assert (input != null);
        if (this.enqueuedInput.getAndSet(Objects.requireNonNull(input)) == null) {
            this.executor.execute(this.processor);
        }
    }

    protected boolean compareAndEnqueue(T expectedLatestKnownInput, T input) {
        assert (expectedLatestKnownInput != null);
        assert (input != null);
        return this.enqueuedInput.compareAndSet(Objects.requireNonNull(expectedLatestKnownInput), Objects.requireNonNull(input));
    }

    boolean isActive() {
        return this.enqueuedInput.get() != null;
    }

    protected boolean isFresh(T input) {
        return this.enqueuedInput.get() == input;
    }

    protected abstract void processInput(T var1);

    private class Processor
    extends AbstractRunnable {
        private Processor() {
        }

        @Override
        public void onFailure(Exception e) {
            logger.error(Strings.format("unexpected error processing [%s]", ContinuousComputation.this), (Throwable)e);
            assert (false) : e;
        }

        @Override
        public void onRejection(Exception e) {
            EsRejectedExecutionException esre;
            assert (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) : e;
            logger.debug("rejected", (Throwable)e);
        }

        @Override
        protected void doRun() {
            Object input = ContinuousComputation.this.enqueuedInput.get();
            assert (input != null);
            try {
                ContinuousComputation.this.processInput(input);
            }
            finally {
                if (!ContinuousComputation.this.enqueuedInput.compareAndSet(input, null)) {
                    ContinuousComputation.this.executor.execute(this);
                }
            }
        }

        public String toString() {
            return "ContinuousComputation$Processor[" + ContinuousComputation.this + "]";
        }
    }
}

