/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ResettableValue<T> {
    private static final ResettableValue<?> RESET = new ResettableValue<Object>(true, null);
    private static final ResettableValue<?> UNDEFINED = new ResettableValue<Object>(false, null);
    private static final String DISPLAY_RESET_VALUES = "display_reset";
    private static final Map<String, String> HIDE_RESET_VALUES_PARAMS = Map.of("display_reset", "false");
    private final T value;
    private final boolean isDefined;

    public static <T> ResettableValue<T> reset() {
        ResettableValue<?> t = RESET;
        return t;
    }

    public static <T> ResettableValue<T> undefined() {
        ResettableValue<?> t = UNDEFINED;
        return t;
    }

    public static <T> ResettableValue<T> create(T value) {
        if (value == null) {
            return ResettableValue.undefined();
        }
        return new ResettableValue<T>(true, value);
    }

    private ResettableValue(boolean isDefined, T value) {
        this.isDefined = isDefined;
        this.value = value;
    }

    public boolean shouldReset() {
        return this.isDefined && this.value == null;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    @Nullable
    public T get() {
        return this.value;
    }

    static <T> void write(StreamOutput out, ResettableValue<T> value, Writeable.Writer<T> writer) throws IOException {
        out.writeBoolean(value.isDefined);
        if (value.isDefined) {
            out.writeBoolean(value.shouldReset());
            if (!value.shouldReset()) {
                writer.write(out, value.get());
            }
        }
    }

    static <T> ResettableValue<T> read(StreamInput in, Writeable.Reader<T> reader) throws IOException {
        boolean isDefined = in.readBoolean();
        if (!isDefined) {
            return ResettableValue.undefined();
        }
        boolean shouldReset = in.readBoolean();
        if (shouldReset) {
            return ResettableValue.reset();
        }
        T value = reader.read(in);
        return ResettableValue.create(value);
    }

    public <U> U mapAndGet(Function<? super T, ? extends U> f) {
        if (!this.isDefined() || this.shouldReset()) {
            return null;
        }
        return f.apply(this.value);
    }

    public <U> ResettableValue<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isDefined) {
            return ResettableValue.undefined();
        }
        if (this.shouldReset()) {
            return ResettableValue.reset();
        }
        return ResettableValue.create(mapper.apply(this.value));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, String field) throws IOException {
        return this.toXContent(builder, params, field, Function.identity());
    }

    public <U> XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, String field, Function<T, U> transformValue) throws IOException {
        if (this.isDefined) {
            if (this.value != null) {
                builder.field(field, transformValue.apply(this.value));
            } else if (ResettableValue.shouldDisplayResetValue(params)) {
                builder.nullField(field);
            }
        }
        return builder;
    }

    public static boolean shouldDisplayResetValue(ToXContent.Params params) {
        return params.paramAsBoolean(DISPLAY_RESET_VALUES, true);
    }

    public static ToXContent.Params hideResetValues(ToXContent.Params params) {
        return new ToXContent.DelegatingMapParams(HIDE_RESET_VALUES_PARAMS, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResettableValue that = (ResettableValue)o;
        return this.isDefined == that.isDefined && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.isDefined);
    }

    public String toString() {
        return "ResettableValue{value=" + this.value + ", isDefined=" + this.isDefined + "}";
    }
}

