/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.AliasInfo;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;

public class DataStreamAlias
implements SimpleDiffable<DataStreamAlias>,
ToXContentFragment,
AliasInfo {
    public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
    public static final ParseField WRITE_DATA_STREAM_FIELD = new ParseField("write_data_stream", new String[0]);
    public static final ParseField OLD_FILTER_FIELD = new ParseField("filter", new String[0]);
    public static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    private static final Logger logger = LogManager.getLogger(DataStreamAlias.class);
    private static final ConstructingObjectParser<DataStreamAlias, String> PARSER = new ConstructingObjectParser("data_stream_alias", false, (args, name) -> {
        Map<String, CompressedXContent> dataStreamsToFilters = (Map<String, CompressedXContent>)args[3];
        CompressedXContent oldFilter = (CompressedXContent)args[2];
        List dataStreamNames = (List)args[0];
        if (dataStreamsToFilters == null && oldFilter != null && dataStreamNames != null) {
            logger.info("Reading in data stream alias [{}] with a pre-8.7.0-style data stream filter and using it for all data streams in the data stream alias", new Object[]{name});
            dataStreamsToFilters = new HashMap<String, CompressedXContent>();
            for (String dataStreamName : dataStreamNames) {
                dataStreamsToFilters.put(dataStreamName, oldFilter);
            }
        }
        if (dataStreamsToFilters == null) {
            dataStreamsToFilters = Map.of();
        }
        return new DataStreamAlias((String)name, (List<String>)dataStreamNames, dataStreamsToFilters, (String)args[1]);
    });
    private final String name;
    private final List<String> dataStreams;
    private final String writeDataStream;
    final Map<String, CompressedXContent> dataStreamToFilterMap;

    private DataStreamAlias(String name, List<String> dataStreams, Map<String, CompressedXContent> dataStreamsToFilters, String writeDataStream) {
        this.name = Objects.requireNonNull(name);
        this.dataStreams = List.copyOf(dataStreams);
        this.writeDataStream = writeDataStream;
        this.dataStreamToFilterMap = new HashMap<String, CompressedXContent>(dataStreamsToFilters);
        assert (writeDataStream == null || dataStreams.contains(writeDataStream));
    }

    public DataStreamAlias(String name, List<String> dataStreams, String writeDataStream, Map<String, Map<String, Object>> dataStreamsToFilters) {
        this(name, dataStreams, DataStreamAlias.compressFiltersMap(dataStreamsToFilters), writeDataStream);
    }

    private static Map<String, CompressedXContent> compressFiltersMap(Map<String, Map<String, Object>> dataStreamToUncompressedFilterMap) {
        if (dataStreamToUncompressedFilterMap == null) {
            return Map.of();
        }
        return dataStreamToUncompressedFilterMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataStreamAlias.compress((Map)entry.getValue())));
    }

    private static CompressedXContent compress(Map<String, Object> filterAsMap) {
        if (filterAsMap == null) {
            return null;
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().map(filterAsMap);
            return new CompressedXContent(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map<String, Object> decompress(CompressedXContent filter) {
        String filterAsString = filter.string();
        return XContentHelper.convertToMap(XContentFactory.xContent((CharSequence)filterAsString), filterAsString, true);
    }

    public DataStreamAlias(StreamInput in) throws IOException {
        this.name = in.readString();
        this.dataStreams = in.readStringCollectionAsList();
        this.writeDataStream = in.readOptionalString();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            this.dataStreamToFilterMap = in.readMap(CompressedXContent::readCompressedString);
        } else {
            CompressedXContent filter;
            this.dataStreamToFilterMap = new HashMap<String, CompressedXContent>();
            CompressedXContent compressedXContent = filter = in.readBoolean() ? CompressedXContent.readCompressedString(in) : null;
            if (filter != null) {
                for (String dataStream : this.dataStreams) {
                    this.dataStreamToFilterMap.put(dataStream, filter);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.getName();
    }

    public List<String> getDataStreams() {
        return this.dataStreams;
    }

    public String getWriteDataStream() {
        return this.writeDataStream;
    }

    public CompressedXContent getFilter(String dataStreamName) {
        return this.dataStreamToFilterMap.get(dataStreamName);
    }

    public boolean filteringRequired() {
        return !this.dataStreamToFilterMap.isEmpty();
    }

    public DataStreamAlias update(String dataStream, Boolean isWriteDataStream, Map<String, Object> filterAsMap) {
        CompressedXContent previousFilter;
        String writeDataStream = this.writeDataStream;
        if (isWriteDataStream != null) {
            if (isWriteDataStream.booleanValue()) {
                writeDataStream = dataStream;
            } else if (dataStream.equals(writeDataStream)) {
                writeDataStream = null;
            }
        }
        boolean filterUpdated = filterAsMap != null ? ((previousFilter = this.dataStreamToFilterMap.get(dataStream)) == null ? true : !filterAsMap.equals(DataStreamAlias.decompress(previousFilter))) : this.hasOrphanedFilter(dataStream);
        HashSet<String> dataStreams = new HashSet<String>(this.dataStreams);
        boolean added = dataStreams.add(dataStream);
        if (added || !Objects.equals(this.writeDataStream, writeDataStream) || filterUpdated) {
            HashMap<String, CompressedXContent> newDataStreamToFilterMap = new HashMap<String, CompressedXContent>(this.dataStreamToFilterMap);
            if (filterAsMap != null) {
                newDataStreamToFilterMap.put(dataStream, DataStreamAlias.compress(filterAsMap));
            } else if (filterUpdated) {
                newDataStreamToFilterMap.remove(dataStream);
            }
            return new DataStreamAlias(this.name, List.copyOf(dataStreams), newDataStreamToFilterMap, writeDataStream);
        }
        return this;
    }

    private boolean hasOrphanedFilter(String dataStream) {
        return this.dataStreamToFilterMap.containsKey(dataStream) && !this.dataStreams.contains(dataStream);
    }

    public DataStreamAlias removeDataStream(String dataStream) {
        HashSet<String> dataStreams = new HashSet<String>(this.dataStreams);
        boolean removed = dataStreams.remove(dataStream);
        if (!removed && !this.dataStreamToFilterMap.containsKey(dataStream)) {
            return this;
        }
        if (dataStreams.isEmpty()) {
            return null;
        }
        String writeDataStream = this.writeDataStream;
        if (dataStream.equals(writeDataStream)) {
            writeDataStream = null;
        }
        Map<String, CompressedXContent> updatedDataStreamMap = this.dataStreamToFilterMap;
        if (this.dataStreamToFilterMap.containsKey(dataStream)) {
            updatedDataStreamMap = new HashMap<String, CompressedXContent>(this.dataStreamToFilterMap);
            updatedDataStreamMap.remove(dataStream);
        }
        return new DataStreamAlias(this.name, List.copyOf(dataStreams), updatedDataStreamMap, writeDataStream);
    }

    public DataStreamAlias intersect(Predicate<String> filter) {
        String writeDataStream;
        List<String> intersectingDataStreams = this.dataStreams.stream().filter(filter).toList();
        if (!intersectingDataStreams.contains(writeDataStream = this.writeDataStream)) {
            writeDataStream = null;
        }
        return new DataStreamAlias(this.name, intersectingDataStreams, this.dataStreamToFilterMap, writeDataStream);
    }

    public DataStreamAlias restore(DataStreamAlias previous, String renamePattern, String renameReplacement) {
        HashSet<String> mergedDataStreams = previous != null ? new HashSet<String>(previous.getDataStreams()) : new HashSet();
        String writeDataStream = this.writeDataStream;
        if (renamePattern != null && renameReplacement != null) {
            this.dataStreams.stream().map(s -> s.replaceAll(renamePattern, renameReplacement)).forEach(mergedDataStreams::add);
            if (writeDataStream != null) {
                writeDataStream = writeDataStream.replaceAll(renamePattern, renameReplacement);
            }
        } else {
            mergedDataStreams.addAll(this.dataStreams);
        }
        if (previous != null) {
            if (writeDataStream != null && previous.getWriteDataStream() != null) {
                String previousWriteDataStream = previous.getWriteDataStream();
                if (renamePattern != null && renameReplacement != null) {
                    previousWriteDataStream = previousWriteDataStream.replaceAll(renamePattern, renameReplacement);
                }
                if (!writeDataStream.equals(previousWriteDataStream)) {
                    throw new IllegalArgumentException("cannot merge alias [" + this.name + "], write data stream of this [" + writeDataStream + "] and write data stream of other [" + previous.getWriteDataStream() + "] are different");
                }
            } else if (writeDataStream == null && previous.getWriteDataStream() != null) {
                assert (mergedDataStreams.contains(previous.getWriteDataStream()));
                writeDataStream = previous.getWriteDataStream();
            }
        }
        return new DataStreamAlias(this.name, List.copyOf(mergedDataStreams), this.dataStreamToFilterMap, writeDataStream);
    }

    public static Diff<DataStreamAlias> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStreamAlias::new, in);
    }

    public static DataStreamAlias fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token", new Object[0]);
        }
        String name = parser.currentName();
        return (DataStreamAlias)PARSER.parse(parser, (Object)name);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.stringListField(DATA_STREAMS_FIELD.getPreferredName(), this.dataStreams);
        if (this.writeDataStream != null) {
            builder.field(WRITE_DATA_STREAM_FIELD.getPreferredName(), this.writeDataStream);
        }
        boolean binary = params.paramAsBoolean("binary", false);
        builder.startObject("filters");
        for (Map.Entry<String, CompressedXContent> entry : this.dataStreamToFilterMap.entrySet()) {
            if (binary) {
                builder.field(entry.getKey(), entry.getValue().compressed());
                continue;
            }
            builder.field(entry.getKey(), (Map)XContentHelper.convertToMap(entry.getValue().uncompressed(), true).v2());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.dataStreams);
        out.writeOptionalString(this.writeDataStream);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            out.writeMap(this.dataStreamToFilterMap, StreamOutput::writeWriteable);
        } else if (this.dataStreamToFilterMap.isEmpty()) {
            out.writeBoolean(false);
        } else {
            this.dataStreamToFilterMap.values().iterator().next().writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStreamAlias that = (DataStreamAlias)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dataStreams, that.dataStreams) && Objects.equals(this.writeDataStream, that.writeDataStream) && Objects.equals(this.dataStreamToFilterMap, that.dataStreamToFilterMap);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataStreams, this.writeDataStream, this.dataStreamToFilterMap);
    }

    public String toString() {
        return "DataStreamAlias{name='" + this.name + "', dataStreams=" + this.dataStreams + ", writeDataStream='" + this.writeDataStream + "', dataStreamToFilterMap=" + this.dataStreamToFilterMap.keySet().stream().map(key -> key + "=" + this.dataStreamToFilterMap.get(key)).collect(Collectors.joining(", ", "{", "}")) + "}";
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), DATA_STREAMS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), WRITE_DATA_STREAM_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_EMBEDDED_OBJECT || p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new CompressedXContent(p.binaryValue());
            }
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentBuilder builder = XContentFactory.jsonBuilder().map(p.mapOrdered());
                return new CompressedXContent(BytesReference.bytes(builder));
            }
            assert (false) : "unexpected token [" + p.currentToken() + " ]";
            return null;
        }, OLD_FILTER_FIELD, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(HashMap::new, xContentParser -> {
            if (p.currentToken() == XContentParser.Token.VALUE_EMBEDDED_OBJECT || p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new CompressedXContent(p.binaryValue());
            }
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentBuilder builder = XContentFactory.jsonBuilder().map(p.mapOrdered());
                return new CompressedXContent(BytesReference.bytes(builder));
            }
            assert (false) : "unexpected token [" + p.currentToken() + " ]";
            return null;
        }), FILTERS_FIELD);
    }
}

