/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.PrintStream;
import java.util.Objects;
import org.elasticsearch.injection.guice.CreationException;
import org.elasticsearch.injection.guice.spi.Message;

public final class StartupException
extends Exception {
    static final int STACKTRACE_LIMIT = 30;
    static final String GUICE_PACKAGE = "org.elasticsearch.injection.guice";

    public StartupException(Throwable cause) {
        super(Objects.requireNonNull(cause));
    }

    @Override
    public void printStackTrace(PrintStream err) {
        String basePath;
        Throwable originalCause = this.getCause();
        Throwable cause = originalCause;
        if (cause instanceof CreationException) {
            cause = StartupException.getFirstGuiceCause((CreationException)cause);
        }
        String message = cause.toString();
        err.println(message);
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause != originalCause && !message.equals(cause.toString())) {
            err.println("Likely root cause: " + cause);
        }
        StackTraceElement[] stack = cause.getStackTrace();
        int linesWritten = 0;
        for (int i = 0; i < stack.length; ++i) {
            if (linesWritten == 30) {
                err.println("\t<<<truncated>>>");
                break;
            }
            String line = stack[i].toString();
            if (line.startsWith(GUICE_PACKAGE)) {
                while (i + 1 < stack.length && stack[i + 1].toString().startsWith(GUICE_PACKAGE)) {
                    ++i;
                }
                err.println("\tat <<<guice>>>");
                ++linesWritten;
                continue;
            }
            err.println("\tat " + line);
            ++linesWritten;
        }
        if (!(originalCause instanceof CreationException) && (basePath = System.getProperty("es.logs.base_path")) != null) {
            String logPath = System.getProperty("es.logs.base_path") + System.getProperty("file.separator") + System.getProperty("es.logs.cluster_name") + ".log";
            err.println("For complete error details, refer to the log at " + logPath);
        }
    }

    private static Throwable getFirstGuiceCause(CreationException guice) {
        for (Message message : guice.getErrorMessages()) {
            Throwable cause = message.getCause();
            if (cause == null) continue;
            return cause;
        }
        return guice;
    }
}

