/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.WriteResponse;
import org.elasticsearch.action.support.replication.PostWriteRefresh;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportWriteAction<Request extends ReplicatedWriteRequest<Request>, ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportReplicationAction<Request, ReplicaRequest, Response> {
    protected final IndexingPressure indexingPressure;
    protected final SystemIndices systemIndices;
    protected final ExecutorSelector executorSelector;
    protected final PostWriteRefresh postWriteRefresh;
    private final BiFunction<ExecutorSelector, IndexShard, Executor> executorFunction;

    protected TransportWriteAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, Writeable.Reader<Request> request, Writeable.Reader<ReplicaRequest> replicaRequest, BiFunction<ExecutorSelector, IndexShard, Executor> executorFunction, TransportReplicationAction.PrimaryActionExecution primaryActionExecution, IndexingPressure indexingPressure, SystemIndices systemIndices, TransportReplicationAction.ReplicaActionExecution replicaActionExecution) {
        super(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, request, replicaRequest, EsExecutors.DIRECT_EXECUTOR_SERVICE, TransportReplicationAction.SyncGlobalCheckpointAfterOperation.AttemptAfterSuccess, primaryActionExecution, replicaActionExecution);
        this.executorFunction = executorFunction;
        this.indexingPressure = indexingPressure;
        this.systemIndices = systemIndices;
        this.executorSelector = systemIndices.getExecutorSelector();
        this.postWriteRefresh = new PostWriteRefresh(transportService);
    }

    protected Executor executor(IndexShard shard) {
        return this.executorFunction.apply(this.executorSelector, shard);
    }

    @Override
    protected Releasable checkOperationLimits(Request request) {
        return this.indexingPressure.markPrimaryOperationStarted(this.primaryOperationCount(request), this.primaryOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected boolean force(ReplicatedWriteRequest<?> request) {
        return this.forceExecutionOnPrimary || this.isSystemShard(request.shardId);
    }

    protected boolean isSystemShard(ShardId shardId) {
        IndexAbstraction abstraction = (IndexAbstraction)this.clusterService.state().metadata().getIndicesLookup().get(shardId.getIndexName());
        return abstraction != null ? abstraction.isSystem() : this.systemIndices.isSystemIndex(shardId.getIndexName());
    }

    @Override
    protected Releasable checkPrimaryLimits(Request request, boolean rerouteWasLocal, boolean localRerouteInitiatedByNodeClient) {
        if (rerouteWasLocal) {
            if (localRerouteInitiatedByNodeClient) {
                return this.indexingPressure.markPrimaryOperationLocalToCoordinatingNodeStarted(this.primaryOperationCount(request), this.primaryOperationSize(request));
            }
            return () -> {};
        }
        return this.indexingPressure.markPrimaryOperationStarted(this.primaryOperationCount(request), this.primaryOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected long primaryOperationSize(Request request) {
        return 0L;
    }

    protected int primaryOperationCount(Request request) {
        return 0;
    }

    @Override
    protected Releasable checkReplicaLimits(ReplicaRequest request) {
        return this.indexingPressure.markReplicaOperationStarted(this.replicaOperationCount(request), this.replicaOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected long replicaOperationSize(ReplicaRequest request) {
        return 0L;
    }

    protected int replicaOperationCount(ReplicaRequest request) {
        return 0;
    }

    protected static Translog.Location syncOperationResultOrThrow(Engine.Result operationResult, Translog.Location currentLocation) throws Exception {
        if (operationResult.getFailure() != null) {
            Exception failure = operationResult.getFailure();
            assert (failure instanceof MapperParsingException) : "expected mapper parsing failures. got " + failure;
            throw failure;
        }
        Translog.Location location = TransportWriteAction.locationToSync(currentLocation, operationResult.getTranslogLocation());
        return location;
    }

    public static Translog.Location locationToSync(Translog.Location current, Translog.Location next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    @Override
    protected ReplicationOperation.Replicas<ReplicaRequest> newReplicasProxy() {
        return new WriteActionReplicasProxy();
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>> listener) {
        this.executorFunction.apply(this.executorSelector, primary).execute(new ActionRunnable<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>>(listener, (ReplicatedWriteRequest)request, primary){
            final /* synthetic */ ReplicatedWriteRequest val$request;
            final /* synthetic */ IndexShard val$primary;
            {
                this.val$request = replicatedWriteRequest;
                this.val$primary = indexShard;
                super(listener);
            }

            @Override
            protected void doRun() {
                TransportWriteAction.this.dispatchedShardOperationOnPrimary(this.val$request, this.val$primary, this.listener);
            }

            @Override
            public boolean isForceExecution() {
                return TransportWriteAction.this.force(this.val$request);
            }
        });
    }

    protected abstract void dispatchedShardOperationOnPrimary(Request var1, IndexShard var2, ActionListener<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>> var3);

    @Override
    protected void shardOperationOnReplica(final ReplicaRequest request, final IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        this.executorFunction.apply(this.executorSelector, replica).execute(new ActionRunnable<TransportReplicationAction.ReplicaResult>(listener){

            @Override
            protected void doRun() {
                TransportWriteAction.this.dispatchedShardOperationOnReplica(request, replica, this.listener);
            }

            @Override
            public boolean isForceExecution() {
                return true;
            }
        });
    }

    protected abstract void dispatchedShardOperationOnReplica(ReplicaRequest var1, IndexShard var2, ActionListener<TransportReplicationAction.ReplicaResult> var3);

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    class WriteActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        WriteActionReplicasProxy() {
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            if (!TransportActions.isShardNotAvailableException(exception)) {
                TransportWriteAction.this.logger.warn(() -> Strings.format((String)"[%s] %s", (Object[])new Object[]{replica.shardId(), message}), (Throwable)exception);
            }
            TransportWriteAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, true, message, exception, listener);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportWriteAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }

    static final class AsyncAfterWriteAction {
        private final Translog.Location location;
        private final boolean needsRefreshAction;
        private final boolean sync;
        private final AtomicInteger pendingOps = new AtomicInteger(1);
        private final AtomicBoolean refreshed = new AtomicBoolean(false);
        private final AtomicReference<Exception> refreshFailure = new AtomicReference<Object>(null);
        private final AtomicReference<Exception> syncFailure = new AtomicReference<Object>(null);
        private final RespondingWriteResult respond;
        private final IndexShard indexShard;
        private final WriteRequest<?> request;
        private final Logger logger;
        private final PostWriteRefresh postWriteRefresh;
        private final Consumer<Runnable> postWriteAction;
        private final TimeValue postWriteRefreshTimeout;

        AsyncAfterWriteAction(IndexShard indexShard, ReplicatedWriteRequest<?> request, @Nullable Translog.Location location, RespondingWriteResult respond, Logger logger, @Nullable PostWriteRefresh postWriteRefresh, @Nullable Consumer<Runnable> postWriteAction) {
            this.indexShard = indexShard;
            this.request = request;
            this.needsRefreshAction = request.getRefreshPolicy() != WriteRequest.RefreshPolicy.NONE;
            this.respond = respond;
            this.location = location;
            this.postWriteRefresh = postWriteRefresh;
            this.postWriteAction = postWriteAction;
            if (this.needsRefreshAction) {
                this.pendingOps.incrementAndGet();
            }
            if (this.sync = indexShard.getTranslogDurability() == Translog.Durability.REQUEST && location != null) {
                this.pendingOps.incrementAndGet();
            }
            if (postWriteAction != null) {
                this.pendingOps.incrementAndGet();
            }
            this.logger = logger;
            this.postWriteRefreshTimeout = request.timeout();
            assert (this.pendingOps.get() >= 0 && this.pendingOps.get() <= 3) : "pendingOps was: " + this.pendingOps.get();
        }

        private void maybeFinish() {
            int numPending = this.pendingOps.decrementAndGet();
            if (numPending == 0) {
                if (this.syncFailure.get() != null) {
                    this.respond.onFailure(this.syncFailure.get());
                } else if (this.refreshFailure.get() != null) {
                    this.respond.onFailure(this.refreshFailure.get());
                } else {
                    this.respond.onSuccess(this.refreshed.get());
                }
            }
            assert (numPending >= 0 && numPending <= 2) : "numPending must either 2, 1 or 0 but was " + numPending;
        }

        void run() {
            this.indexShard.afterWriteOperation();
            this.maybeFinish();
            if (this.needsRefreshAction) {
                assert (this.pendingOps.get() > 0);
                ActionListener<Boolean> refreshListener = new ActionListener<Boolean>(){

                    @Override
                    public void onResponse(Boolean forceRefresh) {
                        if (forceRefresh.booleanValue() && request.getRefreshPolicy() == WriteRequest.RefreshPolicy.WAIT_UNTIL) {
                            logger.warn("block until refresh ran out of slots and forced a refresh: [{}]", request);
                        }
                        refreshed.set(forceRefresh);
                        this.maybeFinish();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        refreshFailure.set(e);
                        this.maybeFinish();
                    }
                };
                if (this.postWriteRefresh != null) {
                    this.postWriteRefresh.refreshShard(this.request.getRefreshPolicy(), this.indexShard, this.location, refreshListener, this.postWriteRefreshTimeout);
                } else {
                    PostWriteRefresh.refreshReplicaShard(this.request.getRefreshPolicy(), this.indexShard, this.location, refreshListener);
                }
            }
            if (this.sync) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.syncAfterWrite(this.location, e -> {
                    this.syncFailure.set((Exception)e);
                    this.maybeFinish();
                });
            }
            if (this.postWriteAction != null) {
                this.postWriteAction.accept(this::maybeFinish);
            }
        }
    }

    static interface RespondingWriteResult {
        public void onSuccess(boolean var1);

        public void onFailure(Exception var1);
    }

    public static class WriteReplicaResult<ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>>
    extends TransportReplicationAction.ReplicaResult {
        public final Translog.Location location;
        private final ReplicaRequest request;
        private final IndexShard replica;
        private final Logger logger;
        private final Consumer<Runnable> postWriteAction;

        public WriteReplicaResult(ReplicaRequest request, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard replica, Logger logger) {
            this(request, location, operationFailure, replica, logger, null);
        }

        public WriteReplicaResult(ReplicaRequest request, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard replica, Logger logger, Consumer<Runnable> postWriteAction) {
            super(operationFailure);
            this.location = location;
            this.request = request;
            this.replica = replica;
            this.logger = logger;
            this.postWriteAction = postWriteAction;
        }

        @Override
        public void runPostReplicaActions(final ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                new AsyncAfterWriteAction(this.replica, (ReplicatedWriteRequest<?>)this.request, this.location, new RespondingWriteResult(){

                    @Override
                    public void onSuccess(boolean forcedRefresh) {
                        listener.onResponse(null);
                    }

                    @Override
                    public void onFailure(Exception ex) {
                        listener.onFailure(ex);
                    }
                }, this.logger, null, this.postWriteAction).run();
            }
        }
    }

    public static class WritePrimaryResult<ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>, Response extends ReplicationResponse>
    extends TransportReplicationAction.PrimaryResult<ReplicaRequest, Response> {
        public final Translog.Location location;
        public final IndexShard primary;
        private final Logger logger;
        private final PostWriteRefresh postWriteRefresh;
        private final Consumer<Runnable> postWriteAction;

        public WritePrimaryResult(ReplicaRequest request, @Nullable Response finalResponse, @Nullable Translog.Location location, IndexShard primary, Logger logger, PostWriteRefresh postWriteRefresh) {
            this(request, finalResponse, location, primary, logger, postWriteRefresh, null);
        }

        public WritePrimaryResult(ReplicaRequest request, @Nullable Response finalResponse, @Nullable Translog.Location location, IndexShard primary, Logger logger, PostWriteRefresh postWriteRefresh, @Nullable Consumer<Runnable> postWriteAction) {
            super(request, finalResponse);
            this.location = location;
            this.primary = primary;
            this.logger = logger;
            this.postWriteRefresh = postWriteRefresh;
            this.postWriteAction = postWriteAction;
        }

        @Override
        public void runPostReplicationActions(final ActionListener<Void> listener) {
            new AsyncAfterWriteAction(this.primary, (ReplicatedWriteRequest)this.replicaRequest(), this.location, new RespondingWriteResult(){

                @Override
                public void onSuccess(boolean forcedRefresh) {
                    ((WriteResponse)((Object)replicationResponse)).setForcedRefresh(forcedRefresh);
                    listener.onResponse(null);
                }

                @Override
                public void onFailure(Exception ex) {
                    listener.onFailure(ex);
                }
            }, this.logger, this.postWriteRefresh, this.postWriteAction).run();
        }
    }
}

