/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.VersionCheckingStreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.transport.RemoteClusterAware;

public final class TransportSearchHelper {
    private static final String INCLUDE_CONTEXT_UUID = "include_context_uuid";

    static InternalScrollSearchRequest internalScrollSearchRequest(ShardSearchContextId id, SearchScrollRequest request) {
        return new InternalScrollSearchRequest(request, id);
    }

    static String buildScrollId(AtomicArray<? extends SearchPhaseResult> searchPhaseResults) {
        BytesReference bytesReference;
        try (BytesStreamOutput encodedStreamOutput = new BytesStreamOutput();){
            try (OutputStreamStreamOutput out = new OutputStreamStreamOutput(Base64.getUrlEncoder().wrap(encodedStreamOutput));){
                out.writeString(INCLUDE_CONTEXT_UUID);
                out.writeString(searchPhaseResults.length() == 1 ? "queryAndFetch" : "queryThenFetch");
                out.writeCollection(searchPhaseResults.asList(), (o, searchPhaseResult) -> {
                    o.writeString(searchPhaseResult.getContextId().getSessionId());
                    o.writeLong(searchPhaseResult.getContextId().getId());
                    SearchShardTarget searchShardTarget = searchPhaseResult.getSearchShardTarget();
                    if (searchShardTarget.getClusterAlias() != null) {
                        o.writeString(RemoteClusterAware.buildRemoteIndexName(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId()));
                    } else {
                        o.writeString(searchShardTarget.getNodeId());
                    }
                });
            }
            bytesReference = encodedStreamOutput.bytes();
        }
        catch (IOException e) {
            assert (false) : e;
            throw new UncheckedIOException(e);
        }
        BytesRef bytesRef = bytesReference.toBytesRef();
        return new String(bytesRef.bytes, bytesRef.offset, bytesRef.length, StandardCharsets.ISO_8859_1);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static ParsedScrollId parseScrollId(String scrollId) {
        try (InputStream decodedInputStream = Base64.getUrlDecoder().wrap(new ByteArrayInputStream(scrollId.getBytes(StandardCharsets.ISO_8859_1)));){
            ParsedScrollId parsedScrollId;
            try (InputStreamStreamInput in = new InputStreamStreamInput(decodedInputStream);){
                String type;
                boolean includeContextUUID;
                String firstChunk = in.readString();
                if (INCLUDE_CONTEXT_UUID.equals(firstChunk)) {
                    includeContextUUID = true;
                    type = in.readString();
                } else {
                    includeContextUUID = false;
                    type = firstChunk;
                }
                SearchContextIdForNode[] context = in.readArray(includeContextUUID ? TransportSearchHelper::readSearchContextIdForNodeIncludingContextUUID : TransportSearchHelper::readSearchContextIdForNodeExcludingContextUUID, SearchContextIdForNode[]::new);
                if (in.available() > 0) {
                    throw new IllegalArgumentException("Not all bytes were read");
                }
                parsedScrollId = new ParsedScrollId(type, context);
            }
            return parsedScrollId;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse scroll id", e);
        }
    }

    private static SearchContextIdForNode readSearchContextIdForNodeIncludingContextUUID(StreamInput in) throws IOException {
        return TransportSearchHelper.innerReadSearchContextIdForNode(in.readString(), in);
    }

    private static SearchContextIdForNode readSearchContextIdForNodeExcludingContextUUID(StreamInput in) throws IOException {
        return TransportSearchHelper.innerReadSearchContextIdForNode("", in);
    }

    private static SearchContextIdForNode innerReadSearchContextIdForNode(String contextUUID, StreamInput in) throws IOException {
        long id = in.readLong();
        String[] split = RemoteClusterAware.splitIndexName(in.readString());
        String clusterAlias = split[0];
        String target = split[1];
        return new SearchContextIdForNode(clusterAlias, target, new ShardSearchContextId(contextUUID, id));
    }

    public static void checkCCSVersionCompatibility(Writeable writeableRequest) {
        try {
            writeableRequest.writeTo(new VersionCheckingStreamOutput(TransportVersion.minimumCCSVersion()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("[" + writeableRequest.getClass() + "] is not compatible with version " + TransportVersion.minimumCCSVersion().toReleaseVersion() + " and the '" + SearchService.CCS_VERSION_CHECK_SETTING.getKey() + "' setting is enabled.", e);
        }
    }

    private TransportSearchHelper() {
    }
}

