/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.CountedCollector;
import org.elasticsearch.action.search.ExpandSearchPhase;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.RankDocShardInfo;
import org.elasticsearch.transport.Transport;

class FetchSearchPhase
extends SearchPhase {
    static final String NAME = "fetch";
    private final AtomicArray<SearchPhaseResult> searchPhaseShardResults;
    private final AbstractSearchAsyncAction<?> context;
    private final Logger logger;
    private final SearchProgressListener progressListener;
    private final AggregatedDfs aggregatedDfs;
    @Nullable
    private final SearchPhaseResults<SearchPhaseResult> resultConsumer;
    private final SearchPhaseController.ReducedQueryPhase reducedQueryPhase;

    FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, AggregatedDfs aggregatedDfs, AbstractSearchAsyncAction<?> context, @Nullable SearchPhaseController.ReducedQueryPhase reducedQueryPhase) {
        super(NAME);
        if (context.getNumShards() != resultConsumer.getNumShards()) {
            throw new IllegalStateException("number of shards must match the length of the query results but doesn't:" + context.getNumShards() + "!=" + resultConsumer.getNumShards());
        }
        this.searchPhaseShardResults = resultConsumer.getAtomicArray();
        this.aggregatedDfs = aggregatedDfs;
        this.context = context;
        this.logger = context.getLogger();
        this.progressListener = context.getTask().getProgressListener();
        this.reducedQueryPhase = reducedQueryPhase;
        this.resultConsumer = reducedQueryPhase == null ? resultConsumer : null;
    }

    protected SearchPhase nextPhase(SearchResponseSections searchResponseSections, AtomicArray<SearchPhaseResult> queryPhaseResults) {
        return new ExpandSearchPhase(this.context, searchResponseSections, queryPhaseResults);
    }

    @Override
    protected void run() {
        this.context.execute(new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                FetchSearchPhase.this.innerRun();
            }

            @Override
            public void onFailure(Exception e) {
                FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.NAME, "", e);
            }
        });
    }

    private void innerRun() throws Exception {
        boolean queryAndFetchOptimization;
        assert (this.reducedQueryPhase == null ^ this.resultConsumer == null);
        SearchPhaseController.ReducedQueryPhase reducedQueryPhase = this.reducedQueryPhase == null ? this.resultConsumer.reduce() : this.reducedQueryPhase;
        int numShards = this.context.getNumShards();
        boolean bl = queryAndFetchOptimization = numShards == 1 && !this.context.getRequest().hasKnnSearch() && reducedQueryPhase.queryPhaseRankCoordinatorContext() == null && (this.context.getRequest().source() == null || this.context.getRequest().source().rankBuilder() == null);
        if (queryAndFetchOptimization) {
            assert (this.assertConsistentWithQueryAndFetchOptimization());
            this.moveToNextPhase(this.searchPhaseShardResults, reducedQueryPhase);
        } else {
            ScoreDoc[] scoreDocs = reducedQueryPhase.sortedTopDocs().scoreDocs();
            if (scoreDocs.length == 0) {
                this.searchPhaseShardResults.asList().forEach(searchPhaseShardResult -> FetchSearchPhase.releaseIrrelevantSearchContext(searchPhaseShardResult, this.context));
                this.moveToNextPhase(new AtomicArray(0), reducedQueryPhase);
            } else {
                this.innerRunFetch(scoreDocs, numShards, reducedQueryPhase);
            }
        }
    }

    private void innerRunFetch(ScoreDoc[] scoreDocs, int numShards, SearchPhaseController.ReducedQueryPhase reducedQueryPhase) {
        int i;
        ArraySearchPhaseResults fetchResults = new ArraySearchPhaseResults(numShards);
        List<Map<Integer, RankDoc>> rankDocsPerShard = false == this.shouldExplainRankScores(this.context.getRequest()) ? null : this.splitRankDocsPerShard(scoreDocs, numShards);
        ScoreDoc[] lastEmittedDocPerShard = this.context.getRequest().scroll() != null ? SearchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, numShards) : null;
        List<Integer>[] docIdsToLoad = SearchPhaseController.fillDocIdsToLoad(numShards, scoreDocs);
        CountedCollector<FetchSearchResult> counter = new CountedCollector<FetchSearchResult>(fetchResults, docIdsToLoad.length, () -> {
            try (ArraySearchPhaseResults arraySearchPhaseResults = fetchResults;){
                this.moveToNextPhase(fetchResults.getAtomicArray(), reducedQueryPhase);
            }
        }, this.context);
        for (i = 0; i < docIdsToLoad.length; ++i) {
            List<Integer> entry = docIdsToLoad[i];
            SearchPhaseResult shardPhaseResult = this.searchPhaseShardResults.get(i);
            if (entry == null) {
                if (shardPhaseResult != null) {
                    this.progressListener.notifyFetchResult(i);
                }
                counter.countDown();
                continue;
            }
            this.executeFetch(shardPhaseResult, counter, entry, rankDocsPerShard == null || rankDocsPerShard.get(i).isEmpty() ? null : new RankDocShardInfo(rankDocsPerShard.get(i)), lastEmittedDocPerShard != null ? lastEmittedDocPerShard[i] : null);
        }
        for (i = 0; i < docIdsToLoad.length; ++i) {
            SearchPhaseResult shardPhaseResult;
            if (docIdsToLoad[i] != null || (shardPhaseResult = this.searchPhaseShardResults.get(i)) == null) continue;
            FetchSearchPhase.releaseIrrelevantSearchContext(shardPhaseResult, this.context);
        }
    }

    private List<Map<Integer, RankDoc>> splitRankDocsPerShard(ScoreDoc[] scoreDocs, int numShards) {
        ArrayList<Map<Integer, RankDoc>> rankDocsPerShard = new ArrayList<Map<Integer, RankDoc>>(numShards);
        for (int i = 0; i < numShards; ++i) {
            rankDocsPerShard.add(new HashMap());
        }
        for (ScoreDoc scoreDoc : scoreDocs) {
            assert (scoreDoc instanceof RankDoc) : "ScoreDoc is not a RankDoc";
            assert (scoreDoc.shardIndex >= 0 && scoreDoc.shardIndex <= numShards);
            RankDoc rankDoc = (RankDoc)scoreDoc;
            Map shardScoreDocs = (Map)rankDocsPerShard.get(rankDoc.shardIndex);
            shardScoreDocs.put(rankDoc.doc, rankDoc);
        }
        return rankDocsPerShard;
    }

    private boolean assertConsistentWithQueryAndFetchOptimization() {
        List<SearchPhaseResult> phaseResults = this.searchPhaseShardResults.asList();
        assert (phaseResults.isEmpty() || phaseResults.get(0).fetchResult() != null) : "phaseResults empty [" + phaseResults.isEmpty() + "], single result: " + phaseResults.get(0).fetchResult();
        return true;
    }

    private void executeFetch(final SearchPhaseResult shardPhaseResult, final CountedCollector<FetchSearchResult> counter, List<Integer> entry, RankDocShardInfo rankDocs, ScoreDoc lastEmittedDocForShard) {
        Transport.Connection connection;
        final SearchShardTarget shardTarget = shardPhaseResult.getSearchShardTarget();
        final int shardIndex = shardPhaseResult.getShardIndex();
        final ShardSearchContextId contextId = shardPhaseResult.queryResult() != null ? shardPhaseResult.queryResult().getContextId() : shardPhaseResult.rankFeatureResult().getContextId();
        var listener = new SearchActionListener<FetchSearchResult>(shardTarget, shardIndex){

            @Override
            public void innerOnResponse(FetchSearchResult result) {
                try {
                    FetchSearchPhase.this.progressListener.notifyFetchResult(shardIndex);
                    counter.onResult(result);
                }
                catch (Exception e) {
                    FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.NAME, "", e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    FetchSearchPhase.this.logger.debug(() -> "[" + contextId + "] Failed to execute fetch phase", (Throwable)e);
                    FetchSearchPhase.this.progressListener.notifyFetchFailure(shardIndex, shardTarget, e);
                    counter.onFailure(shardIndex, shardTarget, e);
                }
                finally {
                    SearchPhase.releaseIrrelevantSearchContext(shardPhaseResult, FetchSearchPhase.this.context);
                }
            }
        };
        try {
            connection = this.context.getConnection(shardTarget.getClusterAlias(), shardTarget.getNodeId());
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        this.context.getSearchTransport().sendExecuteFetch(connection, new ShardFetchSearchRequest(this.context.getOriginalIndices(shardPhaseResult.getShardIndex()), contextId, shardPhaseResult.getShardSearchRequest(), entry, rankDocs, lastEmittedDocForShard, shardPhaseResult.getRescoreDocIds(), this.aggregatedDfs), this.context.getTask(), listener);
    }

    private void moveToNextPhase(AtomicArray<? extends SearchPhaseResult> fetchResultsArr, SearchPhaseController.ReducedQueryPhase reducedQueryPhase) {
        this.context.executeNextPhase(NAME, () -> {
            SearchResponseSections resp = SearchPhaseController.merge(this.context.getRequest().scroll() != null, reducedQueryPhase, fetchResultsArr);
            this.context.addReleasable(resp);
            return this.nextPhase(resp, this.searchPhaseShardResults);
        });
    }

    private boolean shouldExplainRankScores(SearchRequest request) {
        return request.source() != null && request.source().explain() != null && request.source().explain() != false && request.source().rankBuilder() != null;
    }
}

