/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Base64;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ClosePointInTimeRequest
extends LegacyActionRequest
implements ToXContentObject {
    private static final ParseField ID = new ParseField("id", new String[0]);
    private final BytesReference id;

    public ClosePointInTimeRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readBytesReference();
    }

    public ClosePointInTimeRequest(BytesReference id) {
        this.id = id;
    }

    public BytesReference getId() {
        return this.id;
    }

    @Override
    public ActionRequestValidationException validate() {
        if (this.id.length() == 0) {
            return ValidateActions.addValidationError("id is empty", null);
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.id);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), (ToXContent)this.id);
        builder.endObject();
        return builder;
    }

    public static ClosePointInTimeRequest fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        BytesReference id = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME && parser.currentName().equals(ID.getPreferredName())) {
                token = parser.nextToken();
                if (!token.isValue()) {
                    throw new IllegalArgumentException("the request must contain only [" + ID.getPreferredName() + " field");
                }
                id = new BytesArray(Base64.getUrlDecoder().decode(parser.text()));
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter [" + parser.currentName() + "] in request body or parameter is of the wrong type[" + token + "] ");
        }
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("search context id is is not provided");
        }
        return new ClosePointInTimeRequest(id);
    }
}

