/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.index.FieldInfos;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.plugins.FieldPredicate;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.CancellableTask;

class FieldCapabilitiesFetcher {
    private final IndicesService indicesService;
    private final boolean includeEmptyFields;
    private final Map<String, Map<String, IndexFieldCapabilities>> indexMappingHashToResponses = new HashMap<String, Map<String, IndexFieldCapabilities>>();
    private static final boolean enableFieldHasValue = Booleans.parseBoolean((String)System.getProperty("es.field_caps_empty_fields_filter", Boolean.TRUE.toString()));

    FieldCapabilitiesFetcher(IndicesService indicesService, boolean includeEmptyFields) {
        this.indicesService = indicesService;
        this.includeEmptyFields = includeEmptyFields;
    }

    FieldCapabilitiesIndexResponse fetch(CancellableTask task, ShardId shardId, Predicate<String> fieldNameFilter, String[] filters, String[] fieldTypes, QueryBuilder indexFilter, long nowInMillis, Map<String, Object> runtimeFields) throws IOException {
        Engine.Searcher searcher;
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.getId());
        if (FieldCapabilitiesFetcher.alwaysMatches(indexFilter)) {
            indexShard.readAllowed();
            searcher = null;
        } else {
            searcher = indexShard.acquireSearcher("can_match");
        }
        try (Engine.Searcher searcher2 = searcher;){
            FieldCapabilitiesIndexResponse fieldCapabilitiesIndexResponse = this.doFetch(task, shardId, fieldNameFilter, filters, fieldTypes, indexFilter, nowInMillis, runtimeFields, indexService, searcher);
            return fieldCapabilitiesIndexResponse;
        }
    }

    private FieldCapabilitiesIndexResponse doFetch(CancellableTask task, ShardId shardId, Predicate<String> fieldNameFilter, String[] filters, String[] fieldTypes, QueryBuilder indexFilter, long nowInMillis, Map<String, Object> runtimeFields, IndexService indexService, @Nullable Engine.Searcher searcher) throws IOException {
        Map<String, IndexFieldCapabilities> existing;
        Object indexMappingHash;
        SearchExecutionContext searchExecutionContext = indexService.newSearchExecutionContext(shardId.id(), 0, searcher, () -> nowInMillis, null, runtimeFields);
        IndexMode indexMode = searchExecutionContext.getIndexSettings().getMode();
        if (searcher != null && !FieldCapabilitiesFetcher.canMatchShard(shardId, indexFilter, nowInMillis, searchExecutionContext)) {
            return new FieldCapabilitiesIndexResponse(shardId.getIndexName(), null, Collections.emptyMap(), false, indexMode);
        }
        MappingMetadata mapping = indexService.getMetadata().mapping();
        if (this.includeEmptyFields || !enableFieldHasValue) {
            indexMappingHash = mapping != null ? mapping.getSha256() + indexMode : null;
        } else {
            String shardUuid = indexService.getShard(shardId.getId()).getShardUuid();
            indexMappingHash = mapping == null ? shardUuid : shardUuid + mapping.getSha256();
        }
        FieldPredicate fieldPredicate = this.indicesService.getFieldFilter().apply(shardId.getIndexName());
        if (indexMappingHash != null && (existing = this.indexMappingHashToResponses.get(indexMappingHash = fieldPredicate.modifyHash((String)indexMappingHash))) != null) {
            return new FieldCapabilitiesIndexResponse(shardId.getIndexName(), (String)indexMappingHash, existing, true, indexMode);
        }
        task.ensureNotCancelled();
        Map<String, IndexFieldCapabilities> responseMap = FieldCapabilitiesFetcher.retrieveFieldCaps(searchExecutionContext, fieldNameFilter, filters, fieldTypes, fieldPredicate, (IndexShard)this.indicesService.getShardOrNull(shardId), this.includeEmptyFields);
        if (indexMappingHash != null) {
            this.indexMappingHashToResponses.put((String)indexMappingHash, responseMap);
        }
        return new FieldCapabilitiesIndexResponse(shardId.getIndexName(), (String)indexMappingHash, responseMap, true, indexMode);
    }

    static Map<String, IndexFieldCapabilities> retrieveFieldCaps(SearchExecutionContext context, Predicate<String> fieldNameFilter, String[] filters, String[] types, FieldPredicate fieldPredicate, IndexShard indexShard, boolean includeEmptyFields) {
        boolean includeParentObjects = FieldCapabilitiesFetcher.checkIncludeParents(filters);
        Predicate<MappedFieldType> filter = FieldCapabilitiesFetcher.buildFilter(filters, types, context);
        boolean isTimeSeriesIndex = context.getIndexSettings().getTimestampBounds() != null;
        FieldInfos fieldInfos = indexShard.getFieldInfos();
        includeEmptyFields = includeEmptyFields || !enableFieldHasValue;
        HashMap<String, IndexFieldCapabilities> responseMap = new HashMap<String, IndexFieldCapabilities>();
        for (Map.Entry<String, MappedFieldType> entry : context.getAllFields()) {
            String parentField;
            String field = entry.getKey();
            if (!fieldNameFilter.test(field)) continue;
            MappedFieldType ft = entry.getValue();
            if (!includeEmptyFields && !ft.fieldHasValue(fieldInfos) || !fieldPredicate.test(ft.name()) && !context.isMetadataField(ft.name()) || filter != null && !filter.test(ft)) continue;
            IndexFieldCapabilities fieldCap = new IndexFieldCapabilities(field, ft.familyTypeName(), context.isMetadataField(field), ft.isSearchable(), ft.isAggregatable(), isTimeSeriesIndex ? ft.isDimension() : false, isTimeSeriesIndex ? ft.getMetricType() : null, ft.meta());
            responseMap.put(field, fieldCap);
            if (ft instanceof RuntimeField || !includeParentObjects) continue;
            int dotIndex = ft.name().lastIndexOf(46);
            while (dotIndex > -1 && !responseMap.containsKey(parentField = ft.name().substring(0, dotIndex))) {
                if (context.getFieldType(parentField) == null) {
                    String type = context.nestedLookup().getNestedMappers().get(parentField) != null ? "nested" : "object";
                    IndexFieldCapabilities fieldCap2 = new IndexFieldCapabilities(parentField, type, false, false, false, false, null, Map.of());
                    responseMap.put(parentField, fieldCap2);
                }
                dotIndex = parentField.lastIndexOf(46);
            }
        }
        return responseMap;
    }

    private static boolean checkIncludeParents(String[] filters) {
        for (String filter : filters) {
            if (!"-parent".equals(filter)) continue;
            return false;
        }
        return true;
    }

    private static boolean canMatchShard(ShardId shardId, QueryBuilder indexFilter, long nowInMillis, SearchExecutionContext searchExecutionContext) {
        assert (!FieldCapabilitiesFetcher.alwaysMatches(indexFilter)) : "should not be called for always matching [" + indexFilter + "]";
        assert (nowInMillis != 0L);
        ShardSearchRequest searchRequest = new ShardSearchRequest(shardId, nowInMillis, AliasFilter.EMPTY);
        searchRequest.source(new SearchSourceBuilder().query(indexFilter));
        try {
            return SearchService.queryStillMatchesAfterRewrite(searchRequest, searchExecutionContext);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean alwaysMatches(QueryBuilder indexFilter) {
        return indexFilter == null || indexFilter instanceof MatchAllQueryBuilder;
    }

    private static Predicate<MappedFieldType> buildFilter(String[] filters, String[] fieldTypes, SearchExecutionContext context) {
        Predicate<MappedFieldType> fcf = null;
        if (fieldTypes.length > 0) {
            Set<String> acceptedTypes = Set.of(fieldTypes);
            fcf = ft -> acceptedTypes.contains(ft.familyTypeName());
        }
        Collection<InferenceFieldMetadata> inferenceFields = context.getMappingLookup().inferenceFields().values();
        for (InferenceFieldMetadata inferenceField : inferenceFields) {
            Predicate<MappedFieldType> next = ft -> !ft.name().startsWith(inferenceField.getName() + ".inference");
            fcf = fcf == null ? next : fcf.and(next);
        }
        for (String filter : filters) {
            if ("parent".equals(filter) || "-parent".equals(filter)) continue;
            Predicate<MappedFieldType> next = switch (filter) {
                case "+metadata" -> ft -> context.isMetadataField(ft.name());
                case "-metadata" -> ft -> !context.isMetadataField(ft.name());
                case "-nested" -> ft -> context.nestedLookup().getNestedParent(ft.name()) == null;
                case "-multifield" -> ft -> !context.isMultiField(ft.name());
                default -> throw new IllegalArgumentException("Unknown field caps filter [" + filter + "]");
            };
            fcf = fcf == null ? next : fcf.and(next);
        }
        return fcf;
    }
}

