/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class CreateDataStreamAction
extends ActionType<AcknowledgedResponse> {
    public static final CreateDataStreamAction INSTANCE = new CreateDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/create";

    private CreateDataStreamAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest {
        private final String name;
        private final long startTime;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String name) {
            super(masterNodeTimeout, ackTimeout);
            this.name = name;
            this.startTime = System.currentTimeMillis();
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String name, long startTime) {
            super(masterNodeTimeout, ackTimeout);
            this.name = name;
            this.startTime = startTime;
        }

        public String getName() {
            return this.name;
        }

        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (!Strings.hasText(this.name)) {
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
            return validationException;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.startTime = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeVLong(this.startTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.name.equals(request.name) && this.startTime == request.startTime;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.startTime);
        }

        @Override
        public String[] indices() {
            return new String[]{this.name};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }
    }
}

