/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.FailureStoreDocumentConverter;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.index.shard.ShardId;

final class BulkRequestModifier
implements Iterator<DocWriteRequest<?>> {
    private static final Logger logger = LogManager.getLogger(BulkRequestModifier.class);
    private static final String DROPPED_OR_FAILED_ITEM_WITH_AUTO_GENERATED_ID = "auto-generated";
    final BulkRequest bulkRequest;
    final SparseFixedBitSet failedSlots;
    final List<BulkItemResponse> itemResponses;
    final AtomicIntegerArray originalSlots;
    final FailureStoreDocumentConverter failureStoreDocumentConverter;
    volatile int currentSlot = -1;

    BulkRequestModifier(BulkRequest bulkRequest) {
        this.bulkRequest = bulkRequest;
        this.failedSlots = new SparseFixedBitSet(bulkRequest.requests().size());
        this.itemResponses = new ArrayList<BulkItemResponse>(bulkRequest.requests().size());
        this.originalSlots = new AtomicIntegerArray(bulkRequest.requests().size());
        this.failureStoreDocumentConverter = new FailureStoreDocumentConverter();
    }

    @Override
    public DocWriteRequest<?> next() {
        return this.bulkRequest.requests().get(++this.currentSlot);
    }

    @Override
    public boolean hasNext() {
        return this.currentSlot + 1 < this.bulkRequest.requests().size();
    }

    BulkRequest getBulkRequest() {
        if (this.itemResponses.isEmpty()) {
            return this.bulkRequest;
        }
        BulkRequest modifiedBulkRequest = this.bulkRequest.shallowClone();
        int slot = 0;
        List<DocWriteRequest<?>> requests = this.bulkRequest.requests();
        for (int i = 0; i < requests.size(); ++i) {
            DocWriteRequest<?> request = requests.get(i);
            if (this.failedSlots.get(i)) continue;
            modifiedBulkRequest.add(request);
            this.originalSlots.set(slot++, i);
        }
        return modifiedBulkRequest;
    }

    ActionListener<BulkResponse> wrapActionListenerIfNeeded(long ingestTookInMillis, ActionListener<BulkResponse> actionListener) {
        if (this.itemResponses.isEmpty()) {
            return actionListener.map(response -> new BulkResponse(response.getItems(), response.getTook().getMillis(), ingestTookInMillis, response.getIncrementalState()));
        }
        return actionListener.map(response -> {
            BulkItemResponse[] bulkResponses = response.getItems();
            BulkItemResponse[] allResponses = new BulkItemResponse[bulkResponses.length + this.itemResponses.size()];
            Iterator<BulkItemResponse> iterator = this.itemResponses.iterator();
            while (iterator.hasNext()) {
                BulkItemResponse item;
                allResponses[item.getItemId()] = item = iterator.next();
            }
            for (int i = 0; i < bulkResponses.length; ++i) {
                allResponses[this.originalSlots.get((int)i)] = bulkResponses[i];
            }
            if (Assertions.ENABLED) {
                this.assertResponsesAreCorrect(bulkResponses, allResponses);
            }
            return new BulkResponse(allResponses, response.getTook().getMillis(), ingestTookInMillis, response.getIncrementalState());
        });
    }

    private void assertResponsesAreCorrect(BulkItemResponse[] bulkResponses, BulkItemResponse[] allResponses) {
        Set failedIds = this.itemResponses.stream().map(BulkItemResponse::getItemId).collect(Collectors.toSet());
        Set responseIds = IntStream.range(0, bulkResponses.length).map(this.originalSlots::get).boxed().collect(Collectors.toSet());
        assert (Sets.haveEmptyIntersection(failedIds, responseIds)) : "bulk item response slots cannot have failed and been processed in the subsequent bulk request, failed ids: " + failedIds + ", response ids: " + responseIds;
        int expectedResponseCount = this.bulkRequest.requests.size();
        int actualResponseCount = failedIds.size() + responseIds.size();
        assert (expectedResponseCount == actualResponseCount) : "Expected [" + expectedResponseCount + "] responses, but found [" + actualResponseCount + "]";
        for (int i = 0; i < allResponses.length; ++i) {
            assert (allResponses[i] != null) : "BulkItemResponse at index [" + i + "] was null";
        }
    }

    synchronized void markItemAsFailed(int slot, Exception e, IndexDocFailureStoreStatus failureStoreStatus) {
        DocWriteRequest<?> docWriteRequest = this.bulkRequest.requests().get(slot);
        String id = Objects.requireNonNullElse(docWriteRequest.id(), DROPPED_OR_FAILED_ITEM_WITH_AUTO_GENERATED_ID);
        this.failedSlots.set(slot);
        BulkItemResponse.Failure failure = new BulkItemResponse.Failure(docWriteRequest.index(), id, e, failureStoreStatus);
        this.itemResponses.add(BulkItemResponse.failure(slot, docWriteRequest.opType(), failure));
    }

    synchronized void markItemAsDropped(int slot) {
        DocWriteRequest<?> docWriteRequest = this.bulkRequest.requests().get(slot);
        String id = Objects.requireNonNullElse(docWriteRequest.id(), DROPPED_OR_FAILED_ITEM_WITH_AUTO_GENERATED_ID);
        this.failedSlots.set(slot);
        UpdateResponse dropped = new UpdateResponse(new ShardId(docWriteRequest.index(), "_na_", 0), id, -2L, 0L, docWriteRequest.version(), DocWriteResponse.Result.NOOP);
        this.itemResponses.add(BulkItemResponse.success(slot, docWriteRequest.opType(), dropped));
    }

    public void markItemForFailureStore(int slot, String targetIndexName, Exception e) {
        IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(this.bulkRequest.requests().get(slot));
        if (indexRequest == null) {
            assert (false) : "Attempting to mark invalid write request type for failure store. Only IndexRequest or UpdateRequest allowed. type: [" + this.bulkRequest.requests().get(slot).getClass().getName() + "], index: [" + targetIndexName + "]";
            this.markItemAsFailed(slot, e, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
            logger.debug(() -> "Attempted to redirect an invalid write operation after ingest failure - type: [" + this.bulkRequest.requests().get(slot).getClass().getName() + "], index: [" + targetIndexName + "]");
        } else {
            try {
                IndexRequest errorDocument = this.failureStoreDocumentConverter.transformFailedRequest(indexRequest, e, targetIndexName);
                errorDocument.isPipelineResolved(true);
                errorDocument.setPipeline("_none");
                errorDocument.setFinalPipeline("_none");
                this.bulkRequest.requests.set(slot, errorDocument);
            }
            catch (IOException ioException) {
                e.addSuppressed(ioException);
                logger.debug(() -> "Encountered exception while attempting to redirect a failed ingest operation: index [" + targetIndexName + "], source: [" + indexRequest.source().utf8ToString() + "]", (Throwable)ioException);
                this.markItemAsFailed(slot, e, IndexDocFailureStoreStatus.FAILED);
            }
        }
    }
}

