/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresRequest;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThrottledIterator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesShardStoresAction
extends TransportMasterNodeReadAction<IndicesShardStoresRequest, IndicesShardStoresResponse> {
    public static final ActionType<IndicesShardStoresResponse> TYPE = new ActionType("indices:monitor/shard_stores");
    private static final Logger logger = LogManager.getLogger(TransportIndicesShardStoresAction.class);
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final NodeClient client;

    @Inject
    public TransportIndicesShardStoresAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, IndicesShardStoresRequest::new, IndicesShardStoresResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
    }

    @Override
    protected void masterOperation(Task task, IndicesShardStoresRequest request, ClusterState state, ActionListener<IndicesShardStoresResponse> listener) {
        DiscoveryNode[] nodes = state.nodes().getDataNodes().values().toArray(new DiscoveryNode[0]);
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request);
        RoutingTable routingTable = state.routingTable();
        Metadata metadata = state.metadata();
        logger.trace("using cluster state version [{}] to determine shards", (Object)state.version());
        assert (task instanceof CancellableTask);
        new AsyncAction((CancellableTask)task, concreteIndices, request.shardStatuses(), nodes, routingTable, metadata, request.maxConcurrentShardRequests(), listener).run();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesShardStoresRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    void listShardStores(TransportNodesListGatewayStartedShards.Request request, ActionListener<TransportNodesListGatewayStartedShards.NodesGatewayStartedShards> listener) {
        this.client.executeLocally(TransportNodesListGatewayStartedShards.TYPE, request, listener);
    }

    private final class AsyncAction {
        private final CancellableTask task;
        private final DiscoveryNode[] nodes;
        private final String[] concreteIndices;
        private final RoutingTable routingTable;
        private final Metadata metadata;
        private final Map<String, Map<Integer, List<IndicesShardStoresResponse.StoreStatus>>> indicesStatuses;
        private final int maxConcurrentShardRequests;
        private final Queue<IndicesShardStoresResponse.Failure> failures;
        private final EnumSet<ClusterHealthStatus> requestedStatuses;
        private final RefCountingListener outerListener;

        private AsyncAction(CancellableTask task, String[] concreteIndices, EnumSet<ClusterHealthStatus> requestedStatuses, DiscoveryNode[] nodes, RoutingTable routingTable, Metadata metadata, int maxConcurrentShardRequests, ActionListener<IndicesShardStoresResponse> listener) {
            this.task = task;
            this.nodes = nodes;
            this.concreteIndices = concreteIndices;
            this.routingTable = routingTable;
            this.metadata = metadata;
            this.requestedStatuses = requestedStatuses;
            this.indicesStatuses = Collections.synchronizedMap(Maps.newHashMapWithExpectedSize(concreteIndices.length));
            this.maxConcurrentShardRequests = maxConcurrentShardRequests;
            this.failures = new ConcurrentLinkedQueue<IndicesShardStoresResponse.Failure>();
            this.outerListener = new RefCountingListener(1, listener.map(ignored -> {
                task.ensureNotCancelled();
                return new IndicesShardStoresResponse(Map.copyOf(this.indicesStatuses), List.copyOf(this.failures));
            }));
        }

        private boolean isFailing() {
            return this.outerListener.isFailing() || this.task.isCancelled();
        }

        void run() {
            ThrottledIterator.run(Iterators.flatMap(Iterators.forArray(this.concreteIndices), this::getIndexIterator), this::doShardRequest, this.maxConcurrentShardRequests, this.outerListener::close);
        }

        private Iterator<ShardRequestContext> getIndexIterator(String indexName) {
            if (this.isFailing()) {
                return Collections.emptyIterator();
            }
            IndexRoutingTable indexRoutingTable = this.routingTable.index(indexName);
            if (indexRoutingTable == null) {
                return Collections.emptyIterator();
            }
            return new IndexRequestContext(indexRoutingTable).getShardRequestContexts();
        }

        private void doShardRequest(Releasable ref, ShardRequestContext shardRequestContext) {
            ActionListener.run(ActionListener.releaseAfter(shardRequestContext.listener(), ref), l -> {
                if (this.isFailing()) {
                    l.onResponse(null);
                } else {
                    TransportIndicesShardStoresAction.this.listShardStores(new TransportNodesListGatewayStartedShards.Request(shardRequestContext.shardId(), shardRequestContext.customDataPath(), this.nodes), (ActionListener<TransportNodesListGatewayStartedShards.NodesGatewayStartedShards>)l);
                }
            });
        }

        private class IndexRequestContext {
            private final IndexRoutingTable indexRoutingTable;
            private final Map<Integer, List<IndicesShardStoresResponse.StoreStatus>> indexResults;

            IndexRequestContext(IndexRoutingTable indexRoutingTable) {
                this.indexRoutingTable = indexRoutingTable;
                this.indexResults = Collections.synchronizedMap(Maps.newHashMapWithExpectedSize(indexRoutingTable.size()));
            }

            Iterator<ShardRequestContext> getShardRequestContexts() {
                try (RefCountingListener shardListeners = new RefCountingListener(1, AsyncAction.this.outerListener.acquire(ignored -> this.putResults()));){
                    String customDataPath = IndexMetadata.INDEX_DATA_PATH_SETTING.get(AsyncAction.this.metadata.index(this.indexRoutingTable.getIndex()).getSettings());
                    ArrayList<ShardRequestContext> shardRequestContexts = new ArrayList<ShardRequestContext>(this.indexRoutingTable.size());
                    for (int shardNum = 0; shardNum < this.indexRoutingTable.size(); ++shardNum) {
                        IndexShardRoutingTable indexShardRoutingTable = this.indexRoutingTable.shard(shardNum);
                        ClusterShardHealth clusterShardHealth = new ClusterShardHealth(shardNum, indexShardRoutingTable);
                        if (!AsyncAction.this.requestedStatuses.contains(clusterShardHealth.getStatus())) continue;
                        shardRequestContexts.add(new ShardRequestContext(indexShardRoutingTable.shardId(), customDataPath, shardListeners.acquire(fetchResponse -> this.handleFetchResponse(indexShardRoutingTable, (TransportNodesListGatewayStartedShards.NodesGatewayStartedShards)fetchResponse))));
                    }
                    Iterator<ShardRequestContext> iterator = shardRequestContexts.iterator();
                    return iterator;
                }
            }

            private void handleFetchResponse(IndexShardRoutingTable indexShardRoutingTable, TransportNodesListGatewayStartedShards.NodesGatewayStartedShards fetchResponse) {
                if (AsyncAction.this.isFailing()) {
                    return;
                }
                ShardId shardId = indexShardRoutingTable.shardId();
                for (FailedNodeException failure : fetchResponse.failures()) {
                    AsyncAction.this.failures.add(new IndicesShardStoresResponse.Failure(failure.nodeId(), shardId.getIndexName(), shardId.getId(), failure.getCause()));
                }
                List<IndicesShardStoresResponse.StoreStatus> shardStores = fetchResponse.getNodes().stream().filter(IndexRequestContext::shardExistsInNode).map(nodeResponse -> new IndicesShardStoresResponse.StoreStatus(nodeResponse.getNode(), nodeResponse.allocationId(), IndexRequestContext.getAllocationStatus(indexShardRoutingTable, nodeResponse.getNode()), nodeResponse.storeException())).sorted().toList();
                this.indexResults.put(shardId.getId(), shardStores);
            }

            private void putResults() {
                if (!AsyncAction.this.isFailing() && !this.indexResults.isEmpty()) {
                    AsyncAction.this.indicesStatuses.put(this.indexRoutingTable.getIndex().getName(), Map.copyOf(this.indexResults));
                }
            }

            private static boolean shardExistsInNode(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards response) {
                return response.storeException() != null || response.allocationId() != null;
            }

            private static IndicesShardStoresResponse.StoreStatus.AllocationStatus getAllocationStatus(IndexShardRoutingTable indexShardRoutingTable, DiscoveryNode node) {
                for (ShardRouting shardRouting : indexShardRoutingTable.assignedShards()) {
                    if (!node.getId().equals(shardRouting.currentNodeId())) continue;
                    return shardRouting.primary() ? IndicesShardStoresResponse.StoreStatus.AllocationStatus.PRIMARY : IndicesShardStoresResponse.StoreStatus.AllocationStatus.REPLICA;
                }
                return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
            }
        }
    }

    private record ShardRequestContext(ShardId shardId, String customDataPath, ActionListener<TransportNodesListGatewayStartedShards.NodesGatewayStartedShards> listener) {
    }
}

