/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class MinSizeCondition
extends Condition<ByteSizeValue> {
    public static final String NAME = "min_size";

    public MinSizeCondition(ByteSizeValue value) {
        super(NAME, Condition.Type.MIN);
        this.value = value;
    }

    public MinSizeCondition(StreamInput in) throws IOException {
        super(NAME, Condition.Type.MIN);
        this.value = ByteSizeValue.readFrom(in);
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        return new Condition.Result(this, stats.indexSize().getBytes() >= ((ByteSizeValue)this.value).getBytes());
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ((ByteSizeValue)this.value).writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(NAME, ((ByteSizeValue)this.value).getStringRep());
    }

    public static MinSizeCondition fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
            return new MinSizeCondition(ByteSizeValue.parseBytesSizeValue(parser.text(), NAME));
        }
        throw new IllegalArgumentException("invalid token when parsing min_size condition: " + parser.currentToken());
    }

    @Override
    boolean includedInVersion(TransportVersion version) {
        return version.onOrAfter(TransportVersions.V_8_4_0);
    }
}

