/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class RemoteClusterStatsResponse
extends ActionResponse {
    final String clusterUUID;
    final ClusterHealthStatus status;
    private final Set<String> versions;
    private final long nodesCount;
    private final long shardsCount;
    private final long indicesCount;
    private final long indicesBytes;
    private final long heapBytes;
    private final long memBytes;

    public Set<String> getVersions() {
        return this.versions;
    }

    public long getNodesCount() {
        return this.nodesCount;
    }

    public long getShardsCount() {
        return this.shardsCount;
    }

    public long getIndicesCount() {
        return this.indicesCount;
    }

    public long getIndicesBytes() {
        return this.indicesBytes;
    }

    public long getHeapBytes() {
        return this.heapBytes;
    }

    public long getMemBytes() {
        return this.memBytes;
    }

    public RemoteClusterStatsResponse(String clusterUUID, ClusterHealthStatus status, Set<String> versions, long nodesCount, long shardsCount, long indicesCount, long indicesBytes, long heapBytes, long memBytes) {
        this.clusterUUID = clusterUUID;
        this.status = status;
        this.versions = versions;
        this.nodesCount = nodesCount;
        this.shardsCount = shardsCount;
        this.indicesCount = indicesCount;
        this.indicesBytes = indicesBytes;
        this.heapBytes = heapBytes;
        this.memBytes = memBytes;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.clusterUUID);
        this.status.writeTo(out);
        out.writeStringCollection(this.versions);
        out.writeLong(this.nodesCount);
        out.writeLong(this.shardsCount);
        out.writeLong(this.indicesCount);
        out.writeLong(this.indicesBytes);
        out.writeLong(this.heapBytes);
        out.writeLong(this.memBytes);
    }

    public RemoteClusterStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterUUID = in.readString();
        this.status = ClusterHealthStatus.readFrom(in);
        this.versions = in.readCollectionAsSet(StreamInput::readString);
        this.nodesCount = in.readLong();
        this.shardsCount = in.readLong();
        this.indicesCount = in.readLong();
        this.indicesBytes = in.readLong();
        this.heapBytes = in.readLong();
        this.memBytes = in.readLong();
    }
}

