/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.SnapshotSortKey;
import org.elasticsearch.action.admin.cluster.snapshots.get.TransportGetSnapshotsAction;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.sort.SortOrder;

public class GetSnapshotsRequestBuilder
extends MasterNodeOperationRequestBuilder<GetSnapshotsRequest, GetSnapshotsResponse, GetSnapshotsRequestBuilder> {
    public GetSnapshotsRequestBuilder(ElasticsearchClient client, TimeValue masterNodeTimeout, String ... repositories) {
        super(client, TransportGetSnapshotsAction.TYPE, new GetSnapshotsRequest(masterNodeTimeout, repositories));
    }

    public GetSnapshotsRequestBuilder setRepositories(String ... repositories) {
        ((GetSnapshotsRequest)this.request).repositories(repositories);
        return this;
    }

    public GetSnapshotsRequestBuilder setPolicies(String ... policies) {
        ((GetSnapshotsRequest)this.request).policies(policies);
        return this;
    }

    public GetSnapshotsRequestBuilder setSnapshots(String ... snapshots) {
        ((GetSnapshotsRequest)this.request).snapshots(snapshots);
        return this;
    }

    public GetSnapshotsRequestBuilder setCurrentSnapshot() {
        ((GetSnapshotsRequest)this.request).snapshots(new String[]{"_current"});
        return this;
    }

    public GetSnapshotsRequestBuilder addSnapshots(String ... snapshots) {
        ((GetSnapshotsRequest)this.request).snapshots(ArrayUtils.concat(((GetSnapshotsRequest)this.request).snapshots(), snapshots));
        return this;
    }

    public GetSnapshotsRequestBuilder setIgnoreUnavailable(boolean ignoreUnavailable) {
        ((GetSnapshotsRequest)this.request).ignoreUnavailable(ignoreUnavailable);
        return this;
    }

    public GetSnapshotsRequestBuilder setVerbose(boolean verbose) {
        ((GetSnapshotsRequest)this.request).verbose(verbose);
        return this;
    }

    public GetSnapshotsRequestBuilder setAfter(String after) {
        return this.setAfter(after == null ? null : SnapshotSortKey.decodeAfterQueryParam(after));
    }

    public GetSnapshotsRequestBuilder setAfter(@Nullable SnapshotSortKey.After after) {
        ((GetSnapshotsRequest)this.request).after(after);
        return this;
    }

    public GetSnapshotsRequestBuilder setFromSortValue(@Nullable String fromSortValue) {
        ((GetSnapshotsRequest)this.request).fromSortValue(fromSortValue);
        return this;
    }

    public GetSnapshotsRequestBuilder setSort(SnapshotSortKey sort) {
        ((GetSnapshotsRequest)this.request).sort(sort);
        return this;
    }

    public GetSnapshotsRequestBuilder setSize(int size) {
        ((GetSnapshotsRequest)this.request).size(size);
        return this;
    }

    public GetSnapshotsRequestBuilder setOffset(int offset) {
        ((GetSnapshotsRequest)this.request).offset(offset);
        return this;
    }

    public GetSnapshotsRequestBuilder setOrder(SortOrder order) {
        ((GetSnapshotsRequest)this.request).order(order);
        return this;
    }

    public GetSnapshotsRequestBuilder setIncludeIndexNames(boolean indices) {
        ((GetSnapshotsRequest)this.request).includeIndexNames(indices);
        return this;
    }
}

