/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.wildcard.mapper;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.LowercaseNormalizer;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.StringBinaryIndexFieldData;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.wildcard.WildcardDocValuesField;
import org.elasticsearch.xpack.wildcard.mapper.BinaryDvConfirmedQuery;

public class WildcardFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "wildcard";
    public static short MAX_CLAUSES_IN_APPROXIMATION_QUERY = (short)10;
    private static final int WILDCARD_TERMS_EXPANSION_LIMIT = 16;
    public static final int NGRAM_SIZE = 3;
    static final NamedAnalyzer WILDCARD_ANALYZER_7_10 = new NamedAnalyzer("_wildcard_7_10", AnalyzerScope.GLOBAL, new Analyzer(){

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            NGramTokenizer tokenizer = new NGramTokenizer(3, 3);
            Object tok = new LowerCaseFilter((TokenStream)tokenizer);
            tok = new PunctuationFoldingFilter((TokenStream)tok);
            return new Analyzer.TokenStreamComponents(arg_0 -> ((Tokenizer)tokenizer).setReader(arg_0), (TokenStream)tok);
        }
    });
    @Deprecated
    static final NamedAnalyzer WILDCARD_ANALYZER_7_9 = new NamedAnalyzer("_wildcard", AnalyzerScope.GLOBAL, new Analyzer(){

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            NGramTokenizer tokenizer = new NGramTokenizer(3, 3);
            LowerCaseFilter tok = new LowerCaseFilter((TokenStream)tokenizer);
            return new Analyzer.TokenStreamComponents(arg_0 -> ((Tokenizer)tokenizer).setReader(arg_0), (TokenStream)tok);
        }
    });
    public static final FieldMapper.TypeParser PARSER = FieldMapper.TypeParser.createTypeParserWithLegacySupport(Builder::new);
    public static final char TOKEN_START_OR_END_CHAR = '\u0000';
    public static final String TOKEN_START_STRING = Character.toString('\u0000');
    public static final String TOKEN_END_STRING = TOKEN_START_STRING + TOKEN_START_STRING;
    private static final FieldType NGRAM_FIELD_TYPE;
    private final String nullValue;
    private final IndexMode indexMode;
    private final IndexVersion indexVersionCreated;
    private final int ignoreAboveDefault;
    private final Mapper.IgnoreAbove ignoreAbove;
    private final boolean storeIgnored;
    private final String originalName;

    private static WildcardFieldMapper toType(FieldMapper in) {
        return (WildcardFieldMapper)in;
    }

    private WildcardFieldMapper(String simpleName, WildcardFieldType mappedFieldType, boolean storeIgnored, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, builderParams);
        this.nullValue = (String)builder.nullValue.getValue();
        this.storeIgnored = storeIgnored;
        this.indexMode = builder.indexMode;
        this.indexVersionCreated = builder.indexCreatedVersion;
        this.ignoreAboveDefault = builder.ignoreAboveDefault;
        this.ignoreAbove = new Mapper.IgnoreAbove((Integer)builder.ignoreAbove.getValue(), builder.indexMode, builder.indexCreatedVersion);
        this.originalName = storeIgnored ? this.fullPath() + "._original" : null;
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.fieldType().analyzer);
    }

    Mapper.IgnoreAbove ignoreAbove() {
        return this.ignoreAbove;
    }

    public WildcardFieldType fieldType() {
        return (WildcardFieldType)super.fieldType();
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        String value = parser.currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull();
        LuceneDocument parseDoc = context.doc();
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        if (value != null) {
            if (this.ignoreAbove.isIgnored(value)) {
                context.addIgnoredField(this.fullPath());
                if (this.storeIgnored) {
                    parseDoc.add((IndexableField)new StoredField(this.originalName(), new BytesRef((CharSequence)value)));
                }
            } else {
                this.createFields(value, parseDoc, fields);
            }
        }
        parseDoc.addAll(fields);
    }

    private String originalName() {
        return this.originalName;
    }

    void createFields(String value, LuceneDocument parseDoc, List<IndexableField> fields) {
        String ngramValue = WildcardFieldMapper.addLineEndChars(value);
        Field ngramField = new Field(this.fieldType().name(), (CharSequence)ngramValue, (IndexableFieldType)NGRAM_FIELD_TYPE);
        fields.add((IndexableField)ngramField);
        BinaryFieldMapper.CustomBinaryDocValuesField dvField = (BinaryFieldMapper.CustomBinaryDocValuesField)parseDoc.getByKey((Object)this.fieldType().name());
        if (dvField == null) {
            dvField = new BinaryFieldMapper.CustomBinaryDocValuesField(this.fieldType().name(), value.getBytes(StandardCharsets.UTF_8));
            parseDoc.addWithKey((Object)this.fieldType().name(), (IndexableField)dvField);
        } else {
            dvField.add(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    static String addLineEndChars(String value) {
        return "\u0000" + value + "\u0000\u0000";
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.ignoreAboveDefault, this.indexMode, this.indexVersionCreated).init(this);
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> {
            ArrayList<Object> layers = new ArrayList<Object>();
            layers.add(new WildcardSyntheticFieldLoader());
            if (this.ignoreAbove.valuesPotentiallyIgnored()) {
                layers.add(new CompositeSyntheticFieldLoader.StoredFieldLayer(this.originalName()){

                    protected void writeValue(Object value, XContentBuilder b) throws IOException {
                        BytesRef r = (BytesRef)value;
                        b.utf8Value(r.bytes, r.offset, r.length);
                    }
                });
            }
            return new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), layers);
        });
    }

    static {
        FieldType ft = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
        ft.setTokenized(true);
        NGRAM_FIELD_TYPE = WildcardFieldMapper.freezeAndDeduplicateFieldType((FieldType)ft);
        assert (NGRAM_FIELD_TYPE.indexOptions() == IndexOptions.DOCS);
    }

    public static class Builder
    extends FieldMapper.Builder {
        final int ignoreAboveDefault;
        final FieldMapper.Parameter<Integer> ignoreAbove;
        final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam((String)"null_value", (boolean)false, m -> WildcardFieldMapper.toType((FieldMapper)m).nullValue, null).acceptsNull();
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final IndexMode indexMode;
        final IndexVersion indexCreatedVersion;

        public Builder(String name, IndexVersion indexVersionCreated) {
            this(name, Mapper.IgnoreAbove.getIgnoreAboveDefaultValue((IndexMode)IndexMode.STANDARD, (IndexVersion)indexVersionCreated), IndexMode.STANDARD, indexVersionCreated);
        }

        private Builder(String name, MappingParserContext mappingParserContext) {
            this(name, (Integer)IndexSettings.IGNORE_ABOVE_SETTING.get(mappingParserContext.getSettings()), mappingParserContext.getIndexSettings().getMode(), mappingParserContext.indexVersionCreated());
        }

        private Builder(String name, int ignoreAboveDefault, IndexMode indexMode, IndexVersion indexCreatedVersion) {
            super(name);
            this.ignoreAboveDefault = ignoreAboveDefault;
            this.indexMode = indexMode;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreAbove = FieldMapper.Parameter.ignoreAboveParam(m -> WildcardFieldMapper.toType((FieldMapper)m).ignoreAbove.get(), (int)ignoreAboveDefault);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.ignoreAbove, this.nullValue, this.meta};
        }

        Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue((Object)ignoreAbove);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue((Object)nullValue);
            return this;
        }

        public WildcardFieldMapper build(MapperBuilderContext context) {
            return new WildcardFieldMapper(this.leafName(), new WildcardFieldType(context.buildFullName(this.leafName()), this.indexCreatedVersion, (Map)this.meta.get(), this), context.isSourceSynthetic(), this.builderParams((Mapper.Builder)this, context), this);
        }
    }

    public static final class WildcardFieldType
    extends MappedFieldType {
        static Analyzer lowercaseNormalizer = new LowercaseNormalizer();
        private final String nullValue;
        private final NamedAnalyzer analyzer;
        private final Mapper.IgnoreAbove ignoreAbove;

        private WildcardFieldType(String name, IndexVersion version, Map<String, String> meta, Builder builder) {
            super(name, true, false, true, Defaults.TEXT_SEARCH_INFO, meta);
            this.analyzer = version.onOrAfter((VersionId)IndexVersions.V_7_10_0) ? WILDCARD_ANALYZER_7_10 : WILDCARD_ANALYZER_7_9;
            this.nullValue = (String)builder.nullValue.getValue();
            this.ignoreAbove = new Mapper.IgnoreAbove((Integer)builder.ignoreAbove.getValue(), builder.indexMode, builder.indexCreatedVersion);
        }

        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        public Query normalizedWildcardQuery(String value, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            return this.wildcardQuery(value, method, false, context);
        }

        public Query wildcardQuery(String wildcardPattern, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            Automaton automaton;
            BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
            Integer numClauses = this.getApproxWildCardQuery(wildcardPattern, rewritten);
            if (numClauses == null) {
                return new FieldExistsQuery(this.name());
            }
            Automaton automaton2 = automaton = caseInsensitive ? AutomatonQueries.toCaseInsensitiveWildcardAutomaton((Term)new Term(this.name(), wildcardPattern)) : WildcardQuery.toAutomaton((Term)new Term(this.name(), wildcardPattern));
            if (numClauses > 0) {
                BooleanQuery approxQuery = rewritten.build();
                return BinaryDvConfirmedQuery.fromAutomaton((Query)approxQuery, this.name(), wildcardPattern, automaton);
            }
            return BinaryDvConfirmedQuery.fromAutomaton((Query)new MatchAllDocsQuery(), this.name(), wildcardPattern, automaton);
        }

        private Integer getApproxWildCardQuery(String wildcardPattern, BooleanQuery.Builder rewritten) {
            LinkedHashSet<String> tokens = new LinkedHashSet<String>();
            boolean matchAll = this.breakIntoTokens(wildcardPattern, tokens);
            if (matchAll) {
                return null;
            }
            int clauseCount = 0;
            for (String string : tokens) {
                if (clauseCount >= MAX_CLAUSES_IN_APPROXIMATION_QUERY) break;
                this.addClause(string, rewritten, BooleanClause.Occur.MUST);
                ++clauseCount;
            }
            return clauseCount;
        }

        private boolean breakIntoTokens(String wildcardPattern, Set<String> tokens) {
            int length;
            String ngramIndexPattern = WildcardFieldMapper.addLineEndChars(wildcardPattern);
            StringBuilder sequence = new StringBuilder();
            int numWildcardChars = 0;
            int numWildcardStrings = 0;
            block5: for (int i = 0; i < ngramIndexPattern.length(); i += length) {
                int c = ngramIndexPattern.codePointAt(i);
                length = Character.charCount(c);
                switch (c) {
                    case 42: {
                        if (sequence.length() > 0) {
                            this.getNgramTokens(tokens, sequence.toString());
                            sequence = new StringBuilder();
                        }
                        ++numWildcardStrings;
                        continue block5;
                    }
                    case 63: {
                        if (sequence.length() > 0) {
                            this.getNgramTokens(tokens, sequence.toString());
                            sequence = new StringBuilder();
                        }
                        ++numWildcardChars;
                        continue block5;
                    }
                    case 92: {
                        if (i + length < ngramIndexPattern.length()) {
                            int nextChar = ngramIndexPattern.codePointAt(i + length);
                            length += Character.charCount(nextChar);
                            sequence.append(Character.toChars(nextChar));
                            continue block5;
                        }
                        sequence.append(Character.toChars(c));
                        continue block5;
                    }
                    default: {
                        sequence.append(Character.toChars(c));
                    }
                }
            }
            if (sequence.length() > 0) {
                this.getNgramTokens(tokens, sequence.toString());
            }
            return tokens.isEmpty() && (numWildcardChars == 0 || numWildcardStrings > 0);
        }

        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            if (value.length() == 0) {
                return new MatchNoDocsQuery();
            }
            RegExp regExp = new RegExp(value, syntaxFlags, matchFlags);
            Automaton a = regExp.toAutomaton();
            a = Operations.determinize((Automaton)a, (int)maxDeterminizedStates);
            if (Operations.isTotal((Automaton)(a = MinimizationOperations.minimize((Automaton)a, (int)maxDeterminizedStates)))) {
                return this.existsQuery(context);
            }
            RegExp ngramRegex = new RegExp(WildcardFieldMapper.addLineEndChars(value), syntaxFlags, matchFlags);
            Query approxBooleanQuery = WildcardFieldType.toApproximationQuery(ngramRegex);
            Query approxNgramQuery = this.rewriteBoolToNgramQuery(approxBooleanQuery);
            RegExp regex = new RegExp(value, syntaxFlags, matchFlags);
            Automaton automaton = regex.toAutomaton(maxDeterminizedStates);
            return BinaryDvConfirmedQuery.fromAutomaton(approxNgramQuery, this.name(), value, automaton);
        }

        public static Query toApproximationQuery(RegExp r) throws IllegalArgumentException {
            Query result = null;
            switch (r.kind) {
                case REGEXP_UNION: {
                    result = WildcardFieldType.createUnionQuery(r);
                    break;
                }
                case REGEXP_CONCATENATION: {
                    result = WildcardFieldType.createConcatenationQuery(r);
                    break;
                }
                case REGEXP_STRING: {
                    String normalizedString = WildcardFieldType.toLowerCase(r.s);
                    result = new TermQuery(new Term("", normalizedString));
                    break;
                }
                case REGEXP_CHAR: {
                    String cs = Character.toString(r.c);
                    String normalizedChar = WildcardFieldType.toLowerCase(cs);
                    result = new TermQuery(new Term("", normalizedChar));
                    break;
                }
                case REGEXP_REPEAT: {
                    result = new MatchAllDocsQuery();
                    break;
                }
                case REGEXP_REPEAT_MIN: 
                case REGEXP_REPEAT_MINMAX: {
                    if (r.min > 0) {
                        result = WildcardFieldType.toApproximationQuery(r.exp1);
                        if (!(result instanceof TermQuery)) break;
                        BooleanQuery.Builder wrapper = new BooleanQuery.Builder();
                        wrapper.add(result, BooleanClause.Occur.FILTER);
                        result = wrapper.build();
                        break;
                    }
                    result = new MatchAllDocsQuery();
                    break;
                }
                case REGEXP_ANYSTRING: {
                    result = new MatchAllDocsQuery();
                    break;
                }
                case REGEXP_OPTIONAL: 
                case REGEXP_INTERSECTION: 
                case REGEXP_COMPLEMENT: 
                case REGEXP_CHAR_RANGE: 
                case REGEXP_ANYCHAR: 
                case REGEXP_INTERVAL: 
                case REGEXP_EMPTY: 
                case REGEXP_AUTOMATON: 
                case REGEXP_PRE_CLASS: {
                    result = new MatchAllDocsQuery();
                }
            }
            assert (result != null);
            return result;
        }

        private static Query createConcatenationQuery(RegExp r) {
            BooleanQuery combined;
            ArrayList<Query> queries = new ArrayList<Query>();
            WildcardFieldType.findLeaves(r.exp1, RegExp.Kind.REGEXP_CONCATENATION, queries);
            WildcardFieldType.findLeaves(r.exp2, RegExp.Kind.REGEXP_CONCATENATION, queries);
            BooleanQuery.Builder bAnd = new BooleanQuery.Builder();
            StringBuilder sequence = new StringBuilder();
            for (Query query : queries) {
                if (query instanceof TermQuery) {
                    TermQuery tq = (TermQuery)query;
                    sequence.append(tq.getTerm().text());
                    continue;
                }
                if (sequence.length() > 0) {
                    bAnd.add((Query)new TermQuery(new Term("", sequence.toString())), BooleanClause.Occur.FILTER);
                    sequence = new StringBuilder();
                }
                bAnd.add(query, BooleanClause.Occur.FILTER);
            }
            if (sequence.length() > 0) {
                bAnd.add((Query)new TermQuery(new Term("", sequence.toString())), BooleanClause.Occur.FILTER);
            }
            if ((combined = bAnd.build()).clauses().size() > 0) {
                return combined;
            }
            return new MatchAllDocsQuery();
        }

        private static Query createUnionQuery(RegExp r) {
            ArrayList<Query> queries = new ArrayList<Query>();
            WildcardFieldType.findLeaves(r.exp1, RegExp.Kind.REGEXP_UNION, queries);
            WildcardFieldType.findLeaves(r.exp2, RegExp.Kind.REGEXP_UNION, queries);
            BooleanQuery.Builder bOr = new BooleanQuery.Builder();
            HashSet<Query> uniqueClauses = new HashSet<Query>();
            for (Query query : queries) {
                if (!uniqueClauses.add(query)) continue;
                bOr.add(query, BooleanClause.Occur.SHOULD);
            }
            if (uniqueClauses.size() > 0) {
                if (uniqueClauses.size() == 1) {
                    return (Query)uniqueClauses.iterator().next();
                }
                return bOr.build();
            }
            return new MatchAllDocsQuery();
        }

        private static void findLeaves(RegExp exp, RegExp.Kind kind, List<Query> queries) {
            if (exp.kind == kind) {
                WildcardFieldType.findLeaves(exp.exp1, kind, queries);
                WildcardFieldType.findLeaves(exp.exp2, kind, queries);
            } else {
                queries.add(WildcardFieldType.toApproximationQuery(exp));
            }
        }

        private static String toLowerCase(String string) {
            return lowercaseNormalizer.normalize(null, string).utf8ToString();
        }

        private Query rewriteBoolToNgramQuery(Query approxQuery) {
            if (approxQuery == null) {
                return null;
            }
            if (approxQuery instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)approxQuery;
                BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                short clauseCount = 0;
                for (BooleanClause clause : bq) {
                    Query q = this.rewriteBoolToNgramQuery(clause.getQuery());
                    if (q == null) continue;
                    if (clause.getOccur().equals((Object)BooleanClause.Occur.FILTER) && ++clauseCount >= MAX_CLAUSES_IN_APPROXIMATION_QUERY) break;
                    rewritten.add(q, clause.getOccur());
                }
                return rewritten.build();
            }
            if (approxQuery instanceof TermQuery) {
                TermQuery tq = (TermQuery)approxQuery;
                String s = tq.getTerm().text();
                if (s.equals(TOKEN_START_STRING) || s.equals(TOKEN_END_STRING)) {
                    return new MatchAllDocsQuery();
                }
                LinkedHashSet<String> tokens = new LinkedHashSet<String>();
                this.getNgramTokens(tokens, s);
                BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                for (String string : tokens) {
                    this.addClause(string, rewritten, BooleanClause.Occur.FILTER);
                }
                return rewritten.build();
            }
            if (approxQuery instanceof MatchAllDocsQuery) {
                return approxQuery;
            }
            throw new IllegalStateException("Invalid query type found parsing regex query:" + approxQuery);
        }

        private void getNgramTokens(Set<String> tokens, String fragment) {
            if (fragment.equals(TOKEN_START_STRING) || fragment.equals(TOKEN_END_STRING)) {
                return;
            }
            TokenStream tokenizer = this.analyzer.tokenStream(this.name(), fragment);
            CharTermAttribute termAtt = (CharTermAttribute)tokenizer.addAttribute(CharTermAttribute.class);
            int foundTokens = 0;
            try {
                tokenizer.reset();
                while (tokenizer.incrementToken()) {
                    String tokenValue = termAtt.toString();
                    tokens.add(tokenValue);
                    ++foundTokens;
                }
                tokenizer.end();
                tokenizer.close();
            }
            catch (IOException ioe) {
                throw new ElasticsearchParseException("Error parsing wildcard regex pattern fragment [" + fragment + "]", new Object[0]);
            }
            if (foundTokens == 0 && fragment.length() > 0) {
                fragment = WildcardFieldType.toLowerCase(fragment);
                if (this.analyzer == WILDCARD_ANALYZER_7_10) {
                    fragment = PunctuationFoldingFilter.normalize(fragment);
                }
                tokens.add(fragment);
            }
        }

        private void addClause(String token, BooleanQuery.Builder bqBuilder, BooleanClause.Occur occur) {
            assert (token.codePointCount(0, token.length()) <= 3);
            int tokenSize = token.codePointCount(0, token.length());
            if (tokenSize < 2 || token.equals(TOKEN_END_STRING)) {
                bqBuilder.add(new BooleanClause((Query)new MatchAllDocsQuery(), occur));
                return;
            }
            if (tokenSize == 3) {
                TermQuery tq = new TermQuery(new Term(this.name(), token));
                bqBuilder.add(new BooleanClause((Query)tq, occur));
            } else {
                PrefixQuery wq = new PrefixQuery(new Term(this.name(), token), MultiTermQuery.CONSTANT_SCORE_REWRITE);
                bqBuilder.add(new BooleanClause((Query)wq, occur));
            }
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
            BytesRef lower = lowerTerm == null ? null : BytesRefs.toBytesRef((Object)lowerTerm);
            BytesRef upper = upperTerm == null ? null : BytesRefs.toBytesRef((Object)upperTerm);
            BooleanQuery accelerationQuery = null;
            if (lowerTerm != null && upperTerm != null) {
                int cU;
                int cL;
                int length;
                StringBuilder commonPrefix = new StringBuilder();
                String lowerS = WildcardFieldMapper.addLineEndChars(lower.utf8ToString());
                String upperS = WildcardFieldMapper.addLineEndChars(upper.utf8ToString());
                for (int i = 0; i < Math.min(lowerS.length(), upperS.length()) && (cL = lowerS.codePointAt(i)) == (cU = upperS.codePointAt(i)); i += length) {
                    commonPrefix.append(Character.toChars(cL));
                    length = Character.charCount(cL);
                }
                if (commonPrefix.length() > 0) {
                    HashSet<String> tokens = new HashSet<String>();
                    this.getNgramTokens(tokens, commonPrefix.toString());
                    BooleanQuery.Builder bqBuilder = new BooleanQuery.Builder();
                    for (String token : tokens) {
                        int tokenSize = token.codePointCount(0, token.length());
                        if (tokenSize < 2 || token.equals(TOKEN_END_STRING)) continue;
                        if (tokenSize == 3) {
                            TermQuery tq = new TermQuery(new Term(this.name(), token));
                            bqBuilder.add(new BooleanClause((Query)tq, BooleanClause.Occur.FILTER));
                            continue;
                        }
                        PrefixQuery wq = new PrefixQuery(new Term(this.name(), token), MultiTermQuery.CONSTANT_SCORE_REWRITE);
                        bqBuilder.add(new BooleanClause((Query)wq, BooleanClause.Occur.FILTER));
                    }
                    BooleanQuery bq = bqBuilder.build();
                    if (bq.clauses().size() > 0) {
                        accelerationQuery = bq;
                    }
                }
            }
            Automaton automaton = TermRangeQuery.toAutomaton((BytesRef)lower, (BytesRef)upper, (boolean)includeLower, (boolean)includeUpper);
            if (accelerationQuery == null) {
                return BinaryDvConfirmedQuery.fromAutomaton((Query)new MatchAllDocsQuery(), this.name(), lower + "-" + upper, automaton);
            }
            return BinaryDvConfirmedQuery.fromAutomaton(accelerationQuery, this.name(), lower + "-" + upper, automaton);
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            String searchTerm = BytesRefs.toString((Object)value);
            try {
                FuzzyQuery fq;
                BooleanQuery.Builder approxBuilder = new BooleanQuery.Builder();
                String postPrefixString = searchTerm;
                if (prefixLength > 0) {
                    LinkedHashSet<String> prefixTokens = new LinkedHashSet<String>();
                    postPrefixString = searchTerm.substring(prefixLength);
                    String prefixCandidate = "\u0000" + searchTerm.substring(0, prefixLength);
                    this.getNgramTokens(prefixTokens, prefixCandidate);
                    for (String prefixToken : prefixTokens) {
                        this.addClause(prefixToken, approxBuilder, BooleanClause.Occur.MUST);
                    }
                }
                TokenStream tokenizer = this.analyzer.tokenStream(this.name(), postPrefixString);
                CharTermAttribute termAtt = (CharTermAttribute)tokenizer.addAttribute(CharTermAttribute.class);
                ArrayList<String> postPrefixTokens = new ArrayList<String>();
                String firstToken = null;
                tokenizer.reset();
                int tokenNumber = 0;
                while (tokenizer.incrementToken()) {
                    if (tokenNumber == 0) {
                        String token = termAtt.toString();
                        if (firstToken == null) {
                            firstToken = token;
                        }
                        postPrefixTokens.add(token);
                    }
                    if (++tokenNumber != 3) continue;
                    tokenNumber = 0;
                }
                tokenizer.end();
                tokenizer.close();
                BooleanQuery.Builder ngramBuilder = new BooleanQuery.Builder();
                int numClauses = 0;
                for (String token : postPrefixTokens) {
                    this.addClause(token, ngramBuilder, BooleanClause.Occur.SHOULD);
                    ++numClauses;
                }
                if (numClauses > fuzziness.asDistance(searchTerm)) {
                    ngramBuilder.setMinimumNumberShouldMatch(numClauses - fuzziness.asDistance(searchTerm));
                    approxBuilder.add((Query)ngramBuilder.build(), BooleanClause.Occur.MUST);
                }
                BooleanQuery ngramQ = approxBuilder.build();
                FuzzyQuery fuzzyQuery = fq = rewriteMethod == null ? new FuzzyQuery(new Term(this.name(), searchTerm), fuzziness.asDistance(searchTerm), prefixLength, maxExpansions, transpositions) : new FuzzyQuery(new Term(this.name(), searchTerm), fuzziness.asDistance(searchTerm), prefixLength, maxExpansions, transpositions, rewriteMethod);
                if (ngramQ.clauses().size() == 0) {
                    return BinaryDvConfirmedQuery.fromAutomaton((Query)new MatchAllDocsQuery(), this.name(), searchTerm, fq.getAutomata().automaton);
                }
                return BinaryDvConfirmedQuery.fromAutomaton((Query)ngramQ, this.name(), searchTerm, fq.getAutomata().automaton);
            }
            catch (IOException ioe) {
                throw new ElasticsearchParseException("Error parsing wildcard field fuzzy string [" + searchTerm + "]", new Object[0]);
            }
        }

        public String typeName() {
            return WildcardFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "keyword";
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            String searchTerm = BytesRefs.toString((Object)value);
            BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
            Integer numClauses = this.getApproxWildCardQuery(WildcardFieldType.escapeWildcardSyntax(searchTerm), rewritten);
            if (numClauses != null && numClauses > 0) {
                BooleanQuery approxQuery = rewritten.build();
                return BinaryDvConfirmedQuery.fromTerms((Query)approxQuery, this.name(), new BytesRef((CharSequence)searchTerm));
            }
            return BinaryDvConfirmedQuery.fromTerms((Query)new MatchAllDocsQuery(), this.name(), new BytesRef((CharSequence)searchTerm));
        }

        public Query termsQuery(Collection<?> values, @Nullable SearchExecutionContext context) {
            BooleanQuery aproxQuery;
            BytesRef[] terms = WildcardFieldType.buildTerms(values);
            if (terms.length < 16) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                for (BytesRef term : terms) {
                    BooleanQuery.Builder rewritten = new BooleanQuery.Builder();
                    Integer numClauses = this.getApproxWildCardQuery(WildcardFieldType.escapeWildcardSyntax(term.utf8ToString()), rewritten);
                    if (numClauses == null || numClauses <= 0) continue;
                    builder.add((Query)rewritten.build(), BooleanClause.Occur.SHOULD);
                }
                aproxQuery = builder.build();
            } else {
                LinkedHashSet<String> tokens = new LinkedHashSet<String>();
                TreeSet<BytesRef> tokenList = new TreeSet<BytesRef>();
                for (BytesRef term : terms) {
                    boolean matchAll = this.breakIntoTokens(WildcardFieldType.escapeWildcardSyntax(term.utf8ToString()), tokens);
                    assert (!matchAll);
                    if (!tokens.isEmpty()) {
                        tokenList.add(WildcardFieldType.getMiddleToken(tokens));
                    }
                    tokens.clear();
                }
                aproxQuery = new TermInSetQuery(this.name(), tokenList);
            }
            return BinaryDvConfirmedQuery.fromTerms((Query)new ConstantScoreQuery((Query)aproxQuery), this.name(), terms);
        }

        private static BytesRef getMiddleToken(Set<String> tokens) {
            int mid = (tokens.size() + 1) / 2;
            Iterator<String> iterator = tokens.iterator();
            for (int i = 0; i < mid - 1; ++i) {
                iterator.next();
            }
            assert (iterator.hasNext());
            return BytesRefs.toBytesRef((Object)iterator.next());
        }

        private static BytesRef[] buildTerms(Collection<?> values) {
            HashSet dedupe = new HashSet(values);
            BytesRef[] terms = new BytesRef[dedupe.size()];
            Iterator iterator = dedupe.iterator();
            for (int i = 0; i < dedupe.size(); ++i) {
                terms[i] = BytesRefs.toBytesRef(iterator.next());
            }
            return terms;
        }

        private static String escapeWildcardSyntax(String term) {
            int length;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < term.length(); i += length) {
                int c = term.codePointAt(i);
                length = Character.charCount(c);
                if (c == 42 || c == 63 || c == 92) {
                    result.append("\\");
                }
                result.appendCodePoint(c);
            }
            return result.toString();
        }

        public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
            String searchTerm = BytesRefs.toString((Object)value);
            return this.wildcardQuery(WildcardFieldType.escapeWildcardSyntax(searchTerm), MultiTermQuery.CONSTANT_SCORE_REWRITE, true, context);
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            return this.wildcardQuery(WildcardFieldType.escapeWildcardSyntax(value) + "*", method, caseInsensitive, context);
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues()) {
                return new BlockDocValuesReader.BytesRefsFromBinaryBlockLoader(this.name());
            }
            return null;
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> new StringBinaryIndexFieldData(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, WildcardDocValuesField::new);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (ignoreAbove.isIgnored(keywordValue)) {
                        return null;
                    }
                    return keywordValue;
                }
            };
        }
    }

    private class WildcardSyntheticFieldLoader
    implements CompositeSyntheticFieldLoader.DocValuesLayer {
        private final ByteArrayStreamInput docValuesStream = new ByteArrayStreamInput();
        private int docValueCount;
        private BytesRef docValueBytes;

        private WildcardSyntheticFieldLoader() {
        }

        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            BinaryDocValues values = leafReader.getBinaryDocValues(WildcardFieldMapper.this.fullPath());
            if (values == null) {
                this.docValueCount = 0;
                return null;
            }
            return docId -> {
                if (!values.advanceExact(docId)) {
                    this.docValueCount = 0;
                    return this.hasValue();
                }
                this.docValueBytes = values.binaryValue();
                this.docValuesStream.reset(this.docValueBytes.bytes);
                this.docValuesStream.setPosition(this.docValueBytes.offset);
                this.docValueCount = this.docValuesStream.readVInt();
                return this.hasValue();
            };
        }

        public boolean hasValue() {
            return this.docValueCount > 0;
        }

        public long valueCount() {
            return this.docValueCount;
        }

        public void write(XContentBuilder b) throws IOException {
            for (int i = 0; i < this.docValueCount; ++i) {
                int length = this.docValuesStream.readVInt();
                b.utf8Value(this.docValueBytes.bytes, this.docValuesStream.getPosition(), length);
                this.docValuesStream.skipBytes((long)length);
            }
        }

        public String fieldName() {
            return WildcardFieldMapper.this.fullPath();
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final TextSearchInfo TEXT_SEARCH_INFO;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setStoreTermVectorOffsets(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
            TEXT_SEARCH_INFO = new TextSearchInfo(FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        }
    }

    public static final class PunctuationFoldingFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        public PunctuationFoldingFilter(TokenStream in) {
            super(in);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                PunctuationFoldingFilter.normalize(this.termAtt.buffer(), 0, this.termAtt.length());
                return true;
            }
            return false;
        }

        public static String normalize(String s) {
            char[] chars = s.toCharArray();
            PunctuationFoldingFilter.normalize(chars, 0, chars.length);
            return new String(chars);
        }

        public static void normalize(char[] buffer, int offset, int limit) {
            int codepoint;
            assert (buffer.length >= limit);
            assert (0 <= offset && offset <= buffer.length);
            for (int i = offset; i < limit; i += Character.toChars(PunctuationFoldingFilter.normalize(codepoint), buffer, i)) {
                codepoint = Character.codePointAt(buffer, i, limit);
            }
        }

        private static int normalize(int codepoint) {
            if (codepoint == 0) {
                return codepoint;
            }
            if (!Character.isLetterOrDigit(codepoint)) {
                return 47;
            }
            if (codepoint > 48 && codepoint <= 128 && codepoint % 2 == 0) {
                return codepoint - 1;
            }
            return codepoint;
        }
    }
}

