/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.FailureCollector;
import org.elasticsearch.compute.operator.ResponseHeadersCollector;

public abstract class DriverRunner {
    private final ThreadContext threadContext;

    public DriverRunner(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    protected abstract void start(Driver var1, ActionListener<Void> var2);

    public void runToCompletion(final List<Driver> drivers, final ActionListener<Void> listener) {
        final ResponseHeadersCollector responseHeadersCollector = new ResponseHeadersCollector(this.threadContext);
        final FailureCollector failure = new FailureCollector();
        final CountDown counter = new CountDown(drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            final Driver driver = drivers.get(i);
            ActionListener<Void> driverListener = new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    this.done();
                }

                public void onFailure(Exception e) {
                    failure.unwrapAndCollect(e);
                    for (Driver d : drivers) {
                        if (driver == d) continue;
                        d.cancel("Driver [" + driver.sessionId() + "] was cancelled or failed");
                    }
                    this.done();
                }

                private void done() {
                    responseHeadersCollector.collect();
                    if (counter.countDown()) {
                        responseHeadersCollector.finish();
                        Exception error = failure.getFailure();
                        if (error != null) {
                            listener.onFailure(error);
                        } else {
                            listener.onResponse(null);
                        }
                    }
                }
            };
            this.start(driver, driverListener);
        }
    }
}

