/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LocalCircuitBreaker;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class DriverContext {
    Set<Releasable> workingSet = Collections.newSetFromMap(new IdentityHashMap());
    private final AtomicReference<Snapshot> snapshot = new AtomicReference();
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final AsyncActions asyncActions = new AsyncActions();
    private final WarningsMode warningsMode;
    private Runnable earlyTerminationChecker = () -> {};

    public DriverContext(BigArrays bigArrays, BlockFactory blockFactory) {
        this(bigArrays, blockFactory, WarningsMode.COLLECT);
    }

    private DriverContext(BigArrays bigArrays, BlockFactory blockFactory, WarningsMode warningsMode) {
        Objects.requireNonNull(bigArrays);
        Objects.requireNonNull(blockFactory);
        this.bigArrays = bigArrays;
        this.blockFactory = blockFactory;
        this.warningsMode = warningsMode;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public CircuitBreaker breaker() {
        return this.blockFactory.breaker();
    }

    public BlockFactory blockFactory() {
        return this.blockFactory;
    }

    public boolean addReleasable(Releasable releasable) {
        return this.workingSet.add(releasable);
    }

    public boolean removeReleasable(Releasable releasable) {
        return this.workingSet.remove(releasable);
    }

    public Snapshot getSnapshot() {
        this.ensureFinished();
        return this.snapshot.get();
    }

    public boolean isFinished() {
        return this.snapshot.get() != null;
    }

    public void finish() {
        if (this.isFinished()) {
            return;
        }
        this.asyncActions.finish();
        Iterator<Releasable> itr = this.workingSet.iterator();
        this.workingSet = null;
        Set<Releasable> releasableSet = Collections.newSetFromMap(new IdentityHashMap());
        while (itr.hasNext()) {
            Releasable r = itr.next();
            releasableSet.add(r);
            itr.remove();
        }
        this.snapshot.compareAndSet(null, new Snapshot(releasableSet));
    }

    private void ensureFinished() {
        if (!this.isFinished()) {
            throw new IllegalStateException("not finished");
        }
    }

    public void waitForAsyncActions(ActionListener<Void> listener) {
        this.asyncActions.addListener(listener);
    }

    public void addAsyncAction() {
        this.asyncActions.addInstance();
    }

    public void removeAsyncAction() {
        this.asyncActions.removeInstance();
    }

    public void checkForEarlyTermination() {
        this.earlyTerminationChecker.run();
    }

    public void initializeEarlyTerminationChecker(Runnable checker) {
        this.earlyTerminationChecker = checker;
    }

    public WarningsMode warningsMode() {
        return this.warningsMode;
    }

    public boolean assertBeginRunLoop() {
        CircuitBreaker circuitBreaker = this.blockFactory.breaker();
        if (circuitBreaker instanceof LocalCircuitBreaker) {
            LocalCircuitBreaker localBreaker = (LocalCircuitBreaker)circuitBreaker;
            assert (localBreaker.assertBeginRunLoop());
        }
        return true;
    }

    public boolean assertEndRunLoop() {
        CircuitBreaker circuitBreaker = this.blockFactory.breaker();
        if (circuitBreaker instanceof LocalCircuitBreaker) {
            LocalCircuitBreaker localBreaker = (LocalCircuitBreaker)circuitBreaker;
            assert (localBreaker.assertEndRunLoop());
        }
        return true;
    }

    public static enum WarningsMode {
        COLLECT,
        IGNORE;

    }

    private static class AsyncActions {
        private final SubscribableListener<Void> completion = new SubscribableListener();
        private final AtomicBoolean finished = new AtomicBoolean();
        private final AtomicInteger instances = new AtomicInteger(1);

        private AsyncActions() {
        }

        void addInstance() {
            if (this.finished.get()) {
                throw new IllegalStateException("DriverContext was finished already");
            }
            this.instances.incrementAndGet();
        }

        void removeInstance() {
            if (this.instances.decrementAndGet() == 0) {
                this.completion.onResponse(null);
            }
        }

        void addListener(ActionListener<Void> listener) {
            this.completion.addListener(listener);
        }

        void finish() {
            if (this.finished.compareAndSet(false, true)) {
                this.removeInstance();
            }
        }
    }

    public record Snapshot(Set<Releasable> releasables) implements Releasable
    {
        public void close() {
            Releasables.close(this.releasables);
        }
    }
}

