/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import org.apache.lucene.index.SortedDocValues;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.SingletonOrdinalsBuilder;
import org.elasticsearch.index.mapper.BlockLoader;

public abstract class DelegatingBlockLoaderFactory
implements BlockLoader.BlockFactory {
    protected final BlockFactory factory;

    protected DelegatingBlockLoaderFactory(BlockFactory factory) {
        this.factory = factory;
    }

    public BlockLoader.BooleanBuilder booleansFromDocValues(int expectedCount) {
        return this.factory.newBooleanBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
    }

    public BlockLoader.BooleanBuilder booleans(int expectedCount) {
        return this.factory.newBooleanBlockBuilder(expectedCount);
    }

    public BlockLoader.BytesRefBuilder bytesRefsFromDocValues(int expectedCount) {
        return this.factory.newBytesRefBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
    }

    public BlockLoader.BytesRefBuilder bytesRefs(int expectedCount) {
        return this.factory.newBytesRefBlockBuilder(expectedCount);
    }

    public BlockLoader.DoubleBuilder doublesFromDocValues(int expectedCount) {
        return this.factory.newDoubleBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
    }

    public BlockLoader.DoubleBuilder doubles(int expectedCount) {
        return this.factory.newDoubleBlockBuilder(expectedCount);
    }

    public BlockLoader.FloatBuilder denseVectors(int expectedVectorsCount, int dimensions) {
        return this.factory.newFloatBlockBuilder(expectedVectorsCount * dimensions);
    }

    public BlockLoader.IntBuilder intsFromDocValues(int expectedCount) {
        return this.factory.newIntBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
    }

    public BlockLoader.IntBuilder ints(int expectedCount) {
        return this.factory.newIntBlockBuilder(expectedCount);
    }

    public BlockLoader.LongBuilder longsFromDocValues(int expectedCount) {
        return this.factory.newLongBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.SORTED_ASCENDING);
    }

    public BlockLoader.LongBuilder longs(int expectedCount) {
        return this.factory.newLongBlockBuilder(expectedCount);
    }

    public BlockLoader.Builder nulls(int expectedCount) {
        return ElementType.NULL.newBlockBuilder(expectedCount, this.factory);
    }

    public BlockLoader.SingletonOrdinalsBuilder singletonOrdinalsBuilder(SortedDocValues ordinals, int count) {
        return new SingletonOrdinalsBuilder(this.factory, ordinals, count);
    }

    public BlockLoader.AggregateMetricDoubleBuilder aggregateMetricDoubleBuilder(int count) {
        return this.factory.newAggregateMetricDoubleBlockBuilder(count);
    }
}

