/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.List;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.ReleasableIterator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AggregateMetricDoubleBlock
extends Block {
    @Override
    public AggregateMetricDoubleBlock filter(int ... var1);

    @Override
    public AggregateMetricDoubleBlock keepMask(BooleanVector var1);

    public ReleasableIterator<? extends AggregateMetricDoubleBlock> lookup(IntBlock var1, ByteSizeValue var2);

    @Override
    public AggregateMetricDoubleBlock expand();

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(AggregateMetricDoubleBlock block1, AggregateMetricDoubleBlock block2) {
        if (block1 == block2) {
            return true;
        }
        int positions = block1.getPositionCount();
        if (positions != block2.getPositionCount()) {
            return false;
        }
        for (AggregateMetricDoubleBlockBuilder.Metric doubleMetric : List.of(AggregateMetricDoubleBlockBuilder.Metric.MIN, AggregateMetricDoubleBlockBuilder.Metric.MAX, AggregateMetricDoubleBlockBuilder.Metric.SUM)) {
            DoubleBlock doubleBlock2;
            DoubleBlock doubleBlock1 = (DoubleBlock)block1.getMetricBlock(doubleMetric.getIndex());
            if (DoubleBlock.equals(doubleBlock1, doubleBlock2 = (DoubleBlock)block2.getMetricBlock(doubleMetric.getIndex()))) continue;
            return false;
        }
        IntBlock intBlock1 = block1.countBlock();
        IntBlock intBlock2 = block2.countBlock();
        return IntBlock.equals(intBlock1, intBlock2);
    }

    public static int hash(AggregateMetricDoubleBlock block) {
        int positions = block.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                result = 31 * result - 1;
                continue;
            }
            int valueCount = block.getValueCount(pos);
            result = 31 * result + valueCount;
            int firstValueIdx = block.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                for (DoubleBlock b : List.of(block.minBlock(), block.maxBlock(), block.sumBlock())) {
                    result *= 31;
                    result += b.isNull(firstValueIdx + valueIndex) ? -1 : Double.hashCode(b.getDouble(firstValueIdx + valueIndex));
                }
                result *= 31;
                result += block.countBlock().isNull(firstValueIdx + valueIndex) ? -1 : block.countBlock().getInt(firstValueIdx + valueIndex);
            }
        }
        return result;
    }

    public DoubleBlock minBlock();

    public DoubleBlock maxBlock();

    public DoubleBlock sumBlock();

    public IntBlock countBlock();

    public Block getMetricBlock(int var1);
}

