/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopBytesRefAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopBytesRefGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopBytesRefAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopBytesRefAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopBytesRefAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopBytesRefGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopBytesRefAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopBytesRefAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopBytesRefGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopBytesRefGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of bytes";
    }
}

