/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.profiling.action.NumberUtils;

public class GetFlamegraphResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final int size;
    private final double samplingRate;
    private final long selfCPU;
    private final long totalCPU;
    private final long totalSamples;
    private final List<Map<String, Integer>> edges;
    private final List<String> fileIds;
    private final List<Integer> frameTypes;
    private final List<Boolean> inlineFrames;
    private final List<String> fileNames;
    private final List<Integer> addressOrLines;
    private final List<String> functionNames;
    private final List<Integer> functionOffsets;
    private final List<String> sourceFileNames;
    private final List<Integer> sourceLines;
    private final List<Long> countInclusive;
    private final List<Long> countExclusive;
    private final List<Double> annualCO2TonsInclusive;
    private final List<Double> annualCO2TonsExclusive;
    private final List<Double> annualCostsUSDInclusive;
    private final List<Double> annualCostsUSDExclusive;

    public GetFlamegraphResponse(int size, double samplingRate, List<Map<String, Integer>> edges, List<String> fileIds, List<Integer> frameTypes, List<Boolean> inlineFrames, List<String> fileNames, List<Integer> addressOrLines, List<String> functionNames, List<Integer> functionOffsets, List<String> sourceFileNames, List<Integer> sourceLines, List<Long> countInclusive, List<Long> countExclusive, List<Double> annualCO2TonsInclusive, List<Double> annualCO2TonsExclusive, List<Double> annualCostsUSDInclusive, List<Double> annualCostsUSDExclusive, long selfCPU, long totalCPU, long totalSamples) {
        this.size = size;
        this.samplingRate = samplingRate;
        this.edges = edges;
        this.fileIds = fileIds;
        this.frameTypes = frameTypes;
        this.inlineFrames = inlineFrames;
        this.fileNames = fileNames;
        this.addressOrLines = addressOrLines;
        this.functionNames = functionNames;
        this.functionOffsets = functionOffsets;
        this.sourceFileNames = sourceFileNames;
        this.sourceLines = sourceLines;
        this.countInclusive = countInclusive;
        this.countExclusive = countExclusive;
        this.annualCO2TonsInclusive = annualCO2TonsInclusive;
        this.annualCO2TonsExclusive = annualCO2TonsExclusive;
        this.annualCostsUSDInclusive = annualCostsUSDInclusive;
        this.annualCostsUSDExclusive = annualCostsUSDExclusive;
        this.selfCPU = selfCPU;
        this.totalCPU = totalCPU;
        this.totalSamples = totalSamples;
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public int getSize() {
        return this.size;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public List<Long> getCountInclusive() {
        return this.countInclusive;
    }

    public List<Long> getCountExclusive() {
        return this.countExclusive;
    }

    public List<Map<String, Integer>> getEdges() {
        return this.edges;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public List<Integer> getFrameTypes() {
        return this.frameTypes;
    }

    public List<Boolean> getInlineFrames() {
        return this.inlineFrames;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public List<Integer> getAddressOrLines() {
        return this.addressOrLines;
    }

    public List<String> getFunctionNames() {
        return this.functionNames;
    }

    public List<Integer> getFunctionOffsets() {
        return this.functionOffsets;
    }

    public List<String> getSourceFileNames() {
        return this.sourceFileNames;
    }

    public List<Integer> getSourceLines() {
        return this.sourceLines;
    }

    public List<Double> getAnnualCO2TonsInclusive() {
        return this.annualCO2TonsInclusive;
    }

    public List<Double> getAnnualCostsUSDInclusive() {
        return this.annualCostsUSDInclusive;
    }

    public long getSelfCPU() {
        return this.selfCPU;
    }

    public long getTotalCPU() {
        return this.totalCPU;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder((ToXContent.Params)params).object(ob -> {
            ob.array("Edges", this.edges.iterator(), (eb, e) -> eb.array(GetFlamegraphResponse.intValues(e.values())));
            ob.array("FileID", (String[])this.fileIds.toArray(String[]::new));
            ob.array("FrameType", GetFlamegraphResponse.intValues(this.frameTypes));
            ob.array("Inline", this.inlineFrames.iterator(), e -> (b, p) -> b.value(e));
            ob.array("ExeFilename", (String[])this.fileNames.toArray(String[]::new));
            ob.array("AddressOrLine", GetFlamegraphResponse.intValues(this.addressOrLines));
            ob.array("FunctionName", (String[])this.functionNames.toArray(String[]::new));
            ob.array("FunctionOffset", GetFlamegraphResponse.intValues(this.functionOffsets));
            ob.array("SourceFilename", (String[])this.sourceFileNames.toArray(String[]::new));
            ob.array("SourceLine", GetFlamegraphResponse.intValues(this.sourceLines));
            ob.array("CountInclusive", GetFlamegraphResponse.longValues(this.countInclusive));
            ob.array("CountExclusive", GetFlamegraphResponse.longValues(this.countExclusive));
            ob.array("AnnualCO2TonsInclusive", GetFlamegraphResponse.doubleValues(this.annualCO2TonsInclusive));
            ob.array("AnnualCO2TonsExclusive", GetFlamegraphResponse.doubleValues(this.annualCO2TonsExclusive));
            ob.array("AnnualCostsUSDInclusive", GetFlamegraphResponse.doubleValues(this.annualCostsUSDInclusive));
            ob.array("AnnualCostsUSDExclusive", GetFlamegraphResponse.doubleValues(this.annualCostsUSDExclusive));
            ob.field("Size", this.size);
            ob.field("SamplingRate", this.samplingRate);
            ob.field("SelfCPU", this.selfCPU);
            ob.field("TotalCPU", this.totalCPU);
            ob.field("TotalSamples", this.totalSamples);
        });
    }

    private static Iterator<ToXContent> intValues(Collection<Integer> values) {
        return Iterators.single((b, p) -> {
            for (Integer i : values) {
                b.value(i);
            }
            return b;
        });
    }

    private static Iterator<ToXContent> longValues(Collection<Long> values) {
        return Iterators.single((b, p) -> {
            for (Long l : values) {
                b.value(l);
            }
            return b;
        });
    }

    private static Iterator<ToXContent> doubleValues(Collection<Double> values) {
        return Iterators.single((b, p) -> {
            for (Double d : values) {
                b.rawValue(NumberUtils.doubleToString(d));
            }
            return b;
        });
    }
}

