/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative.tool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cli.MultiCommand;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cli.KeyStoreAwareCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.CommandLineHttpClient;
import org.elasticsearch.xpack.core.security.HttpResponse;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;

@Deprecated
class SetupPasswordTool
extends MultiCommand {
    private static final char[] CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    public static final List<String> USERS = Arrays.asList("elastic", "apm_system", "kibana", "kibana_system", "logstash_system", "beats_system", "remote_monitoring_user");
    public static final Map<String, String> USERS_WITH_SHARED_PASSWORDS = Map.of("kibana_system", "kibana");
    private final Function<Environment, CommandLineHttpClient> clientFunction;
    private final CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction;
    private CommandLineHttpClient client;

    SetupPasswordTool() {
        this(environment -> new CommandLineHttpClient(environment), (CheckedFunction<Environment, KeyStoreWrapper, Exception>)((CheckedFunction)environment -> {
            KeyStoreWrapper keyStoreWrapper = KeyStoreWrapper.load((Path)environment.configDir());
            if (keyStoreWrapper == null) {
                throw new UserException(78, "Elasticsearch keystore file is missing [" + String.valueOf(KeyStoreWrapper.keystorePath((Path)environment.configDir())) + "]");
            }
            return keyStoreWrapper;
        }));
    }

    SetupPasswordTool(Function<Environment, CommandLineHttpClient> clientFunction, CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction) {
        super("Sets the passwords for reserved users");
        this.subcommands.put("auto", this.newAutoSetup());
        this.subcommands.put("interactive", this.newInteractiveSetup());
        this.clientFunction = clientFunction;
        this.keyStoreFunction = keyStoreFunction;
    }

    protected AutoSetup newAutoSetup() {
        return new AutoSetup();
    }

    protected InteractiveSetup newInteractiveSetup() {
        return new InteractiveSetup();
    }

    OptionParser getParser() {
        return this.parser;
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] internalBuffer = new byte[1024];
        int read = is.read(internalBuffer);
        while (read != -1) {
            baos.write(internalBuffer, 0, read);
            read = is.read(internalBuffer);
        }
        return baos.toByteArray();
    }

    class AutoSetup
    extends SetupCommand {
        AutoSetup() {
            super("Uses randomly generated passwords");
        }

        public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Running with configuration path: " + String.valueOf(env.configDir())));
            this.setupOptions(terminal, options, env);
            this.checkElasticKeystorePasswordValid(terminal, env);
            this.checkClusterHealth(terminal);
            if (this.shouldPrompt) {
                terminal.println((CharSequence)"******************************************************************************");
                terminal.println((CharSequence)"Note: The 'elasticsearch-setup-passwords' tool has been deprecated. This       command will be removed in a future release.");
                terminal.println((CharSequence)"******************************************************************************");
                terminal.println((CharSequence)"");
                terminal.println((CharSequence)("Initiating the setup of passwords for reserved users " + String.join((CharSequence)",", USERS) + "."));
                terminal.println((CharSequence)"The passwords will be randomly generated and printed to the console.");
                boolean shouldContinue = terminal.promptYesNo("Please confirm that you would like to continue", false);
                terminal.println((CharSequence)"\n");
                if (!shouldContinue) {
                    throw new UserException(0, "User cancelled operation");
                }
            }
            SecureRandom secureRandom = new SecureRandom();
            this.changePasswords((CheckedFunction<String, SecureString, UserException>)((CheckedFunction)user -> AutoSetup.generatePassword(secureRandom, user)), (CheckedBiConsumer<String, SecureString, Exception>)((CheckedBiConsumer)(user, password) -> AutoSetup.changedPasswordCallback(terminal, user, password)), terminal);
        }

        private static SecureString generatePassword(SecureRandom secureRandom, String user) {
            int passwordLength = 20;
            char[] characters = new char[passwordLength];
            for (int i = 0; i < passwordLength; ++i) {
                characters[i] = CHARS[secureRandom.nextInt(CHARS.length)];
            }
            return new SecureString(characters);
        }

        private static void changedPasswordCallback(Terminal terminal, String user, SecureString password) {
            terminal.println((CharSequence)("Changed password for user " + user + "\nPASSWORD " + user + " = " + String.valueOf(password) + "\n"));
        }
    }

    class InteractiveSetup
    extends SetupCommand {
        InteractiveSetup() {
            super("Uses passwords entered by a user");
        }

        public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Running with configuration path: " + String.valueOf(env.configDir())));
            this.setupOptions(terminal, options, env);
            this.checkElasticKeystorePasswordValid(terminal, env);
            this.checkClusterHealth(terminal);
            if (this.shouldPrompt) {
                terminal.println((CharSequence)"******************************************************************************");
                terminal.println((CharSequence)"Note: The 'elasticsearch-setup-passwords' tool has been deprecated. This       command will be removed in a future release.");
                terminal.println((CharSequence)"******************************************************************************");
                terminal.println((CharSequence)"");
                terminal.println((CharSequence)("Initiating the setup of passwords for reserved users " + String.join((CharSequence)",", USERS) + "."));
                terminal.println((CharSequence)"You will be prompted to enter passwords as the process progresses.");
                boolean shouldContinue = terminal.promptYesNo("Please confirm that you would like to continue", false);
                terminal.println((CharSequence)"\n");
                if (!shouldContinue) {
                    throw new UserException(0, "User cancelled operation");
                }
            }
            this.changePasswords((CheckedFunction<String, SecureString, UserException>)((CheckedFunction)user -> InteractiveSetup.promptForPassword(terminal, user)), (CheckedBiConsumer<String, SecureString, Exception>)((CheckedBiConsumer)(user, password) -> InteractiveSetup.changedPasswordCallback(terminal, user, password)), terminal);
        }

        private static SecureString promptForPassword(Terminal terminal, String user) throws UserException {
            SecureString password1;
            while (true) {
                Validation.Error err;
                if ((err = Validation.Users.validatePassword((SecureString)(password1 = new SecureString(terminal.readSecret("Enter password for [" + user + "]: "))))) != null) {
                    terminal.errorPrintln(err.toString());
                    terminal.errorPrintln("Try again.");
                    password1.close();
                    continue;
                }
                SecureString password2 = new SecureString(terminal.readSecret("Reenter password for [" + user + "]: "));
                try {
                    if (password1.equals((Object)password2)) break;
                    terminal.errorPrintln("Passwords do not match.");
                    terminal.errorPrintln("Try again.");
                    password1.close();
                    continue;
                }
                finally {
                    password2.close();
                    continue;
                }
                break;
            }
            return password1;
        }

        private static void changedPasswordCallback(Terminal terminal, String user, SecureString password) {
            terminal.println((CharSequence)("Changed password for user [" + user + "]"));
        }
    }

    static class XPackSecurityFeatureConfig {
        final boolean isAvailable;
        final boolean isEnabled;

        XPackSecurityFeatureConfig(boolean isAvailable, boolean isEnabled) {
            this.isAvailable = isAvailable;
            this.isEnabled = isEnabled;
        }
    }

    private abstract class SetupCommand
    extends KeyStoreAwareCommand {
        boolean shouldPrompt;
        private OptionSpec<String> urlOption;
        private OptionSpec<String> noPromptOption;
        private String elasticUser;
        private SecureString elasticUserPassword;
        private KeyStoreWrapper keyStoreWrapper;
        private URL url;

        SetupCommand(String description) {
            super(description);
            this.elasticUser = "elastic";
            this.setParser();
        }

        public void close() {
            if (this.keyStoreWrapper != null) {
                this.keyStoreWrapper.close();
            }
            if (this.elasticUserPassword != null) {
                this.elasticUserPassword.close();
            }
        }

        void setupOptions(Terminal terminal, OptionSet options, Environment env) throws Exception {
            this.keyStoreWrapper = (KeyStoreWrapper)SetupPasswordTool.this.keyStoreFunction.apply((Object)env);
            SetupCommand.decryptKeyStore((KeyStoreWrapper)this.keyStoreWrapper, (Terminal)terminal);
            Settings.Builder settingsBuilder = Settings.builder();
            settingsBuilder.put(env.settings(), true);
            if (settingsBuilder.getSecureSettings() == null) {
                settingsBuilder.setSecureSettings((SecureSettings)this.keyStoreWrapper);
            }
            Settings settings = settingsBuilder.build();
            this.elasticUserPassword = (SecureString)ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.get(settings);
            Environment newEnv = new Environment(settings, env.configDir());
            Environment.assertEquivalent((Environment)newEnv, (Environment)env);
            SetupPasswordTool.this.client = SetupPasswordTool.this.clientFunction.apply(newEnv);
            String providedUrl = (String)this.urlOption.value(options);
            this.url = new URL(providedUrl == null ? SetupPasswordTool.this.client.getDefaultURL() : providedUrl);
            this.setShouldPrompt(options);
        }

        private void setParser() {
            this.urlOption = this.parser.acceptsAll(Arrays.asList("u", "url"), "The url for the change password request.").withRequiredArg();
            this.noPromptOption = this.parser.acceptsAll(Arrays.asList("b", "batch"), "If enabled, run the change password process without prompting the user.").withOptionalArg();
        }

        private void setShouldPrompt(OptionSet options) {
            String optionalNoPrompt = (String)this.noPromptOption.value(options);
            this.shouldPrompt = options.has(this.noPromptOption) ? optionalNoPrompt != null && !Booleans.parseBoolean((String)optionalNoPrompt) : true;
        }

        void checkElasticKeystorePasswordValid(Terminal terminal, Environment env) throws Exception {
            URL route = SetupCommand.createURL(this.url, "/_security/_authenticate", "?pretty");
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"");
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Testing if bootstrap password is valid for " + route.toString()));
            try {
                HttpResponse httpResponse = SetupPasswordTool.this.client.execute("GET", route, this.elasticUser, this.elasticUserPassword, () -> null, is -> SetupCommand.responseBuilder(is, terminal));
                int httpCode = httpResponse.getHttpStatus();
                if (httpCode == 401) {
                    terminal.errorPrintln("");
                    terminal.errorPrintln("Failed to authenticate user '" + this.elasticUser + "' against " + route.toString());
                    terminal.errorPrintln("Possible causes include:");
                    terminal.errorPrintln(" * The password for the '" + this.elasticUser + "' user has already been changed on this cluster");
                    terminal.errorPrintln(" * Your elasticsearch node is running against a different keystore");
                    terminal.errorPrintln("   This tool used the keystore at " + String.valueOf(KeyStoreWrapper.keystorePath((Path)env.configDir())));
                    terminal.errorPrintln("");
                    terminal.errorPrintln("You can use the `elasticsearch-reset-password` CLI tool to reset the password of the '" + this.elasticUser + "' user");
                    terminal.errorPrintln("");
                    throw new UserException(78, "Failed to verify bootstrap password");
                }
                if (httpCode != 200) {
                    terminal.errorPrintln("");
                    terminal.errorPrintln("Unexpected response code [" + httpCode + "] from calling GET " + route.toString());
                    XPackSecurityFeatureConfig xPackSecurityFeatureConfig = this.getXPackSecurityConfig(terminal);
                    if (!xPackSecurityFeatureConfig.isAvailable) {
                        terminal.errorPrintln("It doesn't look like the X-Pack security feature is available on this Elasticsearch node.");
                        terminal.errorPrintln("Please check if you have installed a license that allows access to X-Pack Security feature.");
                        terminal.errorPrintln("");
                        throw new UserException(78, "X-Pack Security is not available.");
                    }
                    if (!xPackSecurityFeatureConfig.isEnabled) {
                        terminal.errorPrintln("It doesn't look like the X-Pack security feature is enabled on this Elasticsearch node.");
                        terminal.errorPrintln("Please check if you have enabled X-Pack security in your elasticsearch.yml configuration file.");
                        terminal.errorPrintln("");
                        throw new UserException(78, "X-Pack Security is disabled by configuration.");
                    }
                    terminal.errorPrintln("X-Pack security feature is available and enabled on this Elasticsearch node.");
                    terminal.errorPrintln("Possible causes include:");
                    terminal.errorPrintln(" * The relative path of the URL is incorrect. Is there a proxy in-between?");
                    terminal.errorPrintln(" * The protocol (http/https) does not match the port.");
                    terminal.errorPrintln(" * Is this really an Elasticsearch server?");
                    terminal.errorPrintln("");
                    throw new UserException(78, "Unknown error");
                }
            }
            catch (SSLException e) {
                terminal.errorPrintln("");
                terminal.errorPrintln("SSL connection to " + route.toString() + " failed: " + e.getMessage());
                terminal.errorPrintln("Please check the elasticsearch SSL settings under " + XPackSettings.HTTP_SSL_PREFIX);
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.errorPrintln("");
                throw new UserException(78, "Failed to establish SSL connection to elasticsearch at " + route.toString() + ".", (Throwable)e);
            }
            catch (IOException e) {
                terminal.errorPrintln("");
                terminal.errorPrintln("Connection failure to: " + route.toString() + " failed: " + e.getMessage());
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.errorPrintln("");
                throw new UserException(78, "Failed to connect to elasticsearch at " + route.toString() + ". Is the URL correct and elasticsearch running?", (Throwable)e);
            }
        }

        private XPackSecurityFeatureConfig getXPackSecurityConfig(Terminal terminal) throws Exception {
            Map featureInfo;
            Map features;
            URL route = SetupCommand.createURL(this.url, "/_xpack", "?categories=features&human=false&pretty");
            HttpResponse httpResponse = SetupPasswordTool.this.client.execute("GET", route, this.elasticUser, this.elasticUserPassword, () -> null, is -> SetupCommand.responseBuilder(is, terminal));
            if (httpResponse.getHttpStatus() != 200) {
                terminal.errorPrintln("");
                terminal.errorPrintln("Unexpected response code [" + httpResponse.getHttpStatus() + "] from calling GET " + route.toString());
                if (httpResponse.getHttpStatus() == 400) {
                    terminal.errorPrintln("It doesn't look like the X-Pack is available on this Elasticsearch node.");
                    terminal.errorPrintln("Please check that you have followed all installation instructions and that this tool");
                    terminal.errorPrintln("   is pointing to the correct Elasticsearch server.");
                    terminal.errorPrintln("");
                    throw new UserException(78, "X-Pack is not available on this Elasticsearch node.");
                }
                terminal.errorPrintln("* Try running this tool again.");
                terminal.errorPrintln("* Verify that the tool is pointing to the correct Elasticsearch server.");
                terminal.errorPrintln("* Check the elasticsearch logs for additional error details.");
                terminal.errorPrintln("");
                throw new UserException(75, "Failed to determine x-pack security feature configuration.");
            }
            if (httpResponse.getHttpStatus() == 200 && httpResponse.getResponseBody() != null && (features = (Map)httpResponse.getResponseBody().get("features")) != null && (featureInfo = (Map)features.get("security")) != null) {
                XPackSecurityFeatureConfig xPackSecurityFeatureConfig = new XPackSecurityFeatureConfig(Boolean.parseBoolean(featureInfo.get("available").toString()), Boolean.parseBoolean(featureInfo.get("enabled").toString()));
                return xPackSecurityFeatureConfig;
            }
            terminal.println((CharSequence)"");
            terminal.println((CharSequence)("Unexpected response from calling GET " + route.toString()));
            terminal.println((CharSequence)"* Try running this tool again.");
            terminal.println((CharSequence)"* Verify that the tool is pointing to the correct Elasticsearch server.");
            terminal.println((CharSequence)"* Check the elasticsearch logs for additional error details.");
            terminal.println((CharSequence)"");
            throw new UserException(75, "Failed to determine x-pack security feature configuration.");
        }

        void checkClusterHealth(Terminal terminal) throws Exception {
            URL route = SetupCommand.createURL(this.url, "/_cluster/health", "?pretty");
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"");
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Checking cluster health: " + route.toString()));
            HttpResponse httpResponse = SetupPasswordTool.this.client.execute("GET", route, this.elasticUser, this.elasticUserPassword, () -> null, is -> SetupCommand.responseBuilder(is, terminal));
            if (httpResponse.getHttpStatus() != 200) {
                terminal.errorPrintln("");
                terminal.errorPrintln("Failed to determine the health of the cluster running at " + String.valueOf(this.url));
                terminal.errorPrintln("Unexpected response code [" + httpResponse.getHttpStatus() + "] from calling GET " + route.toString());
                String cause = CommandLineHttpClient.getErrorCause((HttpResponse)httpResponse);
                if (cause != null) {
                    terminal.errorPrintln("Cause: " + cause);
                }
            } else {
                String clusterStatus = Objects.toString(httpResponse.getResponseBody().get("status"), "");
                if (clusterStatus.isEmpty()) {
                    terminal.errorPrintln("");
                    terminal.errorPrintln("Failed to determine the health of the cluster running at " + String.valueOf(this.url));
                    terminal.errorPrintln("Could not find a 'status' value at " + route.toString());
                } else if ("red".equalsIgnoreCase(clusterStatus)) {
                    terminal.errorPrintln("");
                    terminal.errorPrintln("Your cluster health is currently RED.");
                    terminal.errorPrintln("This means that some cluster data is unavailable and your cluster is not fully functional.");
                } else {
                    return;
                }
            }
            terminal.errorPrintln("");
            terminal.errorPrintln("It is recommended that you resolve the issues with your cluster before running elasticsearch-setup-passwords.");
            terminal.errorPrintln("It is very likely that the password changes will fail when run against an unhealthy cluster.");
            terminal.errorPrintln("");
            if (this.shouldPrompt) {
                boolean keepGoing = terminal.promptYesNo("Do you want to continue with the password setup process", false);
                if (!keepGoing) {
                    throw new UserException(0, "User cancelled operation");
                }
                terminal.println((CharSequence)"");
            }
        }

        private void changeUserPassword(String user, SecureString password, Terminal terminal) throws Exception {
            URL route = SetupCommand.createURL(this.url, "/_security/user/" + user + "/_password", "?pretty");
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"");
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Trying user password change call " + route.toString()));
            try {
                SecureString supplierPassword = password.clone();
                HttpResponse httpResponse = SetupPasswordTool.this.client.execute("PUT", route, this.elasticUser, this.elasticUserPassword, () -> {
                    try {
                        XContentBuilder xContentBuilder = JsonXContent.contentBuilder();
                        xContentBuilder.startObject().field("password", supplierPassword.toString()).endObject();
                        String string = Strings.toString((XContentBuilder)xContentBuilder);
                        return string;
                    }
                    finally {
                        supplierPassword.close();
                    }
                }, is -> SetupCommand.responseBuilder(is, terminal));
                if (httpResponse.getHttpStatus() != 200) {
                    terminal.errorPrintln("");
                    terminal.errorPrintln("Unexpected response code [" + httpResponse.getHttpStatus() + "] from calling PUT " + route.toString());
                    String cause = CommandLineHttpClient.getErrorCause((HttpResponse)httpResponse);
                    if (cause != null) {
                        terminal.errorPrintln("Cause: " + cause);
                        terminal.errorPrintln("");
                    }
                    terminal.errorPrintln("Possible next steps:");
                    terminal.errorPrintln("* Try running this tool again.");
                    terminal.errorPrintln("* Try running with the --verbose parameter for additional messages.");
                    terminal.errorPrintln("* Check the elasticsearch logs for additional error details.");
                    terminal.errorPrintln("* Use the change password API manually.");
                    terminal.errorPrintln("");
                    throw new UserException(75, "Failed to set password for user [" + user + "].");
                }
            }
            catch (IOException e) {
                terminal.errorPrintln("");
                terminal.errorPrintln("Connection failure to: " + route.toString() + " failed: " + e.getMessage());
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, "");
                terminal.errorPrintln(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.errorPrintln("");
                throw new UserException(75, "Failed to set password for user [" + user + "].", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void changePasswords(CheckedFunction<String, SecureString, UserException> passwordFn, CheckedBiConsumer<String, SecureString, Exception> successCallback, Terminal terminal) throws Exception {
            LinkedHashMap passwordsMap = Maps.newLinkedHashMapWithExpectedSize((int)USERS.size());
            try {
                for (String user2 : USERS) {
                    if (USERS_WITH_SHARED_PASSWORDS.containsValue(user2)) continue;
                    SecureString password = (SecureString)passwordFn.apply((Object)user2);
                    passwordsMap.put(user2, password);
                    if (!USERS_WITH_SHARED_PASSWORDS.containsKey(user2)) continue;
                    passwordsMap.put(USERS_WITH_SHARED_PASSWORDS.get(user2), password.clone());
                }
                Map.Entry superUserEntry = null;
                for (Map.Entry entry : passwordsMap.entrySet()) {
                    if (((String)entry.getKey()).equals(this.elasticUser)) {
                        superUserEntry = entry;
                        continue;
                    }
                    this.changeUserPassword((String)entry.getKey(), (SecureString)entry.getValue(), terminal);
                    successCallback.accept((Object)((String)entry.getKey()), (Object)((SecureString)entry.getValue()));
                }
                if (superUserEntry != null) {
                    this.changeUserPassword((String)superUserEntry.getKey(), (SecureString)superUserEntry.getValue(), terminal);
                    successCallback.accept((Object)((String)superUserEntry.getKey()), (Object)((SecureString)superUserEntry.getValue()));
                }
            }
            finally {
                passwordsMap.forEach((user, pass) -> pass.close());
            }
        }

        private static HttpResponse.HttpResponseBuilder responseBuilder(InputStream is, Terminal terminal) throws IOException {
            HttpResponse.HttpResponseBuilder httpResponseBuilder = new HttpResponse.HttpResponseBuilder();
            if (is != null) {
                byte[] bytes = SetupPasswordTool.toByteArray(is);
                String responseBody = new String(bytes, StandardCharsets.UTF_8);
                terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)responseBody);
                httpResponseBuilder.withResponseBody(responseBody);
            } else {
                terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"<Empty response>");
            }
            return httpResponseBuilder;
        }

        private static URL createURL(URL url, String path, String query) throws MalformedURLException, URISyntaxException {
            return new URL(url, (url.toURI().getPath() + path).replaceAll("//+", "/") + query);
        }
    }
}

