/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.content;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.xpack.sql.proto.content.AbstractObjectParser;
import org.elasticsearch.xpack.sql.proto.content.ParseException;
import org.elasticsearch.xpack.sql.proto.content.ParserUtils;

public class ObjectParser<Value, Context>
extends AbstractObjectParser<Value, Context> {
    private final Map<String, FieldParser> fieldParsers = new HashMap<String, FieldParser>();
    private final List<String[]> requiredFieldSets = new ArrayList<String[]>();
    private final String name;
    private final Function<Context, Value> valueBuilder;
    private final UnknownFieldParser<Value, Context> unknownFieldParser;

    private static <Value, Context> UnknownFieldParser<Value, Context> ignoreUnknown() {
        return (op, f, l, p, v, c) -> p.skipChildren();
    }

    private static <Value, Context> UnknownFieldParser<Value, Context> errorOnUnknown() {
        return (op, f, l, p, v, c) -> {
            throw new ParseException(ParserUtils.location(l), "[" + op.name + "] unknown field [" + f + "]");
        };
    }

    public ObjectParser(String name, boolean ignoreUnknownFields, Supplier<Value> valueSupplier) {
        this.name = name;
        this.unknownFieldParser = ignoreUnknownFields ? ObjectParser.ignoreUnknown() : ObjectParser.errorOnUnknown();
        this.valueBuilder = ObjectParser.wrapValueSupplier(valueSupplier);
    }

    private static <C, V> Function<C, V> wrapValueSupplier(Supplier<V> valueSupplier) {
        return valueSupplier == null ? c -> {
            throw new NullPointerException();
        } : c -> valueSupplier.get();
    }

    @Override
    public <T> void declareField(BiConsumer<Value, T> consumer, AbstractObjectParser.ContextParser<Context, T> parser, String field, AbstractObjectParser.ValueType type) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (parser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        this.declareField((p, v, c) -> consumer.accept(v, parser.parse(p, c)), field, type);
    }

    public void declareField(Parser<Value, Context> p, String parseField, AbstractObjectParser.ValueType type) {
        this.fieldParsers.put(parseField, new FieldParser(p, parseField, type));
    }

    public void declareRequiredFieldSet(String ... requiredSet) {
        if (requiredSet.length == 0) {
            return;
        }
        this.requiredFieldSets.add(requiredSet);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Value parse(JsonParser parser, Context context) throws IOException {
        return this.parse(parser, this.valueBuilder.apply(context), context);
    }

    Value parse(JsonParser parser, Value value, Context context) throws IOException {
        ArrayList<String[]> requiredFields;
        JsonToken token;
        if (parser.currentToken() != JsonToken.START_OBJECT && (token = parser.nextToken()) != JsonToken.START_OBJECT) {
            this.throwExpectedStartObject(parser, token);
        }
        FieldParser fieldParser = null;
        String currentFieldName = null;
        JsonLocation currentPosition = null;
        ArrayList<String[]> arrayList = requiredFields = this.requiredFieldSets.isEmpty() ? null : new ArrayList<String[]>(this.requiredFieldSets);
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                currentFieldName = parser.currentName();
                currentPosition = parser.getTokenLocation();
                fieldParser = this.fieldParsers.get(currentFieldName);
                continue;
            }
            if (currentFieldName == null) {
                this.throwNoFieldFound(parser);
            }
            if (fieldParser == null) {
                this.unknownFieldParser.acceptUnknownField(this, currentFieldName, currentPosition, parser, value, context);
            } else {
                fieldParser.assertSupports(parser, currentFieldName);
                if (requiredFields != null) {
                    ObjectParser.maybeMarkRequiredField(currentFieldName, requiredFields);
                }
                this.parseSub(parser, fieldParser, currentFieldName, value, context);
            }
            fieldParser = null;
        }
        if (requiredFields != null && !requiredFields.isEmpty()) {
            ObjectParser.throwMissingRequiredFields(requiredFields);
        }
        return value;
    }

    private static void maybeMarkRequiredField(String currentFieldName, List<String[]> requiredFields) {
        Iterator<String[]> iter = requiredFields.iterator();
        block0: while (iter.hasNext()) {
            String[] requiredFieldNames;
            for (String field : requiredFieldNames = iter.next()) {
                if (!field.equals(currentFieldName)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private void parseSub(JsonParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) {
        JsonToken token = parser.currentToken();
        switch (token) {
            case START_OBJECT: {
                this.parseValue(parser, fieldParser, currentFieldName, value, context);
                if (parser.currentToken() == JsonToken.END_OBJECT) break;
                ObjectParser.throwMustEndOn(parser, currentFieldName, JsonToken.END_OBJECT);
                break;
            }
            case START_ARRAY: {
                this.parseArray(parser, fieldParser, currentFieldName, value, context);
                if (parser.currentToken() == JsonToken.END_ARRAY) break;
                ObjectParser.throwMustEndOn(parser, currentFieldName, JsonToken.END_ARRAY);
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw this.throwUnexpectedToken(parser, token);
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_EMBEDDED_OBJECT: 
            case VALUE_NULL: {
                this.parseValue(parser, fieldParser, currentFieldName, value, context);
            }
        }
    }

    private void parseArray(JsonParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) {
        this.throwExpectedStartArray(parser);
        this.parseValue(parser, fieldParser, currentFieldName, value, context);
    }

    private void parseValue(JsonParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) {
        try {
            fieldParser.parser.parse(parser, value, context);
        }
        catch (Exception ex) {
            this.throwFailedToParse(parser, currentFieldName, ex);
        }
    }

    private static void throwMustEndOn(JsonParser parser, String currentFieldName, JsonToken token) {
        throw new ParseException(ParserUtils.location(parser), "parser for [" + currentFieldName + "] did not end on " + (Object)((Object)token));
    }

    private ParseException throwUnexpectedToken(JsonParser parser, JsonToken token) {
        return new ParseException(ParserUtils.location(parser), "[" + this.name + "]" + (Object)((Object)token) + " is unexpected");
    }

    private void throwExpectedStartObject(JsonParser parser, JsonToken token) {
        throw new ParseException(ParserUtils.location(parser), "[" + this.name + "] Expected START_OBJECT but was: " + (Object)((Object)token));
    }

    private void throwExpectedStartArray(JsonParser parser) {
        if (parser.currentToken() != JsonToken.START_ARRAY) {
            throw new ParseException(ParserUtils.location(parser), "[" + this.name + "] Expected START_ARRAY but was: " + (Object)((Object)parser.currentToken()));
        }
    }

    private void throwNoFieldFound(JsonParser parser) {
        throw new ParseException(ParserUtils.location(parser), "[" + this.name + "] no field found");
    }

    private void throwFailedToParse(JsonParser parser, String currentFieldName, Exception ex) {
        throw new ParseException(ParserUtils.location(parser), "[" + this.name + "] failed to parse field [" + currentFieldName + "]", ex);
    }

    private static void throwMissingRequiredFields(List<String[]> requiredFields) {
        StringBuilder message = new StringBuilder();
        for (Object[] objectArray : requiredFields) {
            message.append("Required one of fields ").append(Arrays.toString(objectArray)).append(", but none were specified.");
        }
        throw new ParseException(message.toString());
    }

    private static interface UnknownFieldParser<Value, Context> {
        public void acceptUnknownField(ObjectParser<Value, Context> var1, String var2, JsonLocation var3, JsonParser var4, Value var5, Context var6) throws IOException;
    }

    public static interface Parser<Value, Context> {
        public void parse(JsonParser var1, Value var2, Context var3) throws IOException;
    }

    private class FieldParser {
        private final Parser<Value, Context> parser;
        private final String field;
        private final AbstractObjectParser.ValueType type;

        FieldParser(Parser<Value, Context> parser, String field, AbstractObjectParser.ValueType type) {
            this.parser = parser;
            this.field = field;
            this.type = type;
        }

        void assertSupports(JsonParser jsonParser, String currentFieldName) {
            JsonToken currentToken = jsonParser.currentToken();
            if (!currentFieldName.equals(this.field)) {
                throw new ParseException(ParserUtils.location(jsonParser), "[" + ObjectParser.this.name + "] doesn't accept: " + currentFieldName);
            }
            if (!this.type.supportedTokens().contains((Object)currentToken)) {
                throw new ParseException(ParserUtils.location(jsonParser), "[" + ObjectParser.this.name + "] " + currentFieldName + " doesn't support values of type: " + (Object)((Object)currentToken));
            }
        }
    }
}

