/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli.command;

import java.sql.SQLException;
import org.elasticsearch.xpack.sql.cli.command.CliSessionConfiguration;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.ClientVersion;
import org.elasticsearch.xpack.sql.client.HttpClient;
import org.elasticsearch.xpack.sql.proto.MainResponse;
import org.elasticsearch.xpack.sql.proto.SqlVersion;

public class CliSession {
    private final HttpClient httpClient;
    private final CliSessionConfiguration configuration;

    public CliSession(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.configuration = new CliSessionConfiguration();
    }

    public HttpClient getClient() {
        return this.httpClient;
    }

    public CliSessionConfiguration cfg() {
        return this.configuration;
    }

    public void checkConnection() throws ClientException {
        MainResponse response;
        try {
            response = this.httpClient.serverInfo();
        }
        catch (SQLException ex) {
            throw new ClientException(ex);
        }
        SqlVersion version = SqlVersion.fromString(response.getVersion());
        if (!ClientVersion.isServerCompatible(version)) {
            throw new ClientException("This version of the CLI is only compatible with Elasticsearch version " + ClientVersion.CURRENT.majorMinorToString() + " or newer; attempting to connect to a server version " + version.toString());
        }
    }
}

