/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RatedDocument
implements Writeable,
ToXContentObject {
    static final ParseField RATING_FIELD = new ParseField("rating", new String[0]);
    static final ParseField DOC_ID_FIELD = new ParseField("_id", new String[0]);
    static final ParseField INDEX_FIELD = new ParseField("_index", new String[0]);
    private static final ConstructingObjectParser<RatedDocument, Void> PARSER = new ConstructingObjectParser("rated_document", a -> new RatedDocument((String)a[0], (String)a[1], (Integer)a[2]));
    private final int rating;
    private final DocumentKey key;

    public RatedDocument(String index, String id, int rating) {
        this.key = new DocumentKey(index, id);
        this.rating = rating;
    }

    RatedDocument(StreamInput in) throws IOException {
        this.key = new DocumentKey(in.readString(), in.readString());
        this.rating = in.readVInt();
    }

    public DocumentKey getKey() {
        return this.key;
    }

    public String getIndex() {
        return this.key.index();
    }

    public String getDocID() {
        return this.key.docId();
    }

    public int getRating() {
        return this.rating;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.key.index());
        out.writeString(this.key.docId());
        out.writeVInt(this.rating);
    }

    static RatedDocument fromXContent(XContentParser parser) {
        return (RatedDocument)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_FIELD.getPreferredName(), this.key.index());
        builder.field(DOC_ID_FIELD.getPreferredName(), this.key.docId());
        builder.field(RATING_FIELD.getPreferredName(), this.rating);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RatedDocument other = (RatedDocument)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.rating, other.rating);
    }

    public final int hashCode() {
        return Objects.hash(this.key, this.rating);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DOC_ID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), RATING_FIELD);
    }

    record DocumentKey(String index, String docId) {
        DocumentKey {
            if (Strings.isNullOrEmpty((String)index)) {
                throw new IllegalArgumentException("Index must be set for each rated document");
            }
            if (Strings.isNullOrEmpty((String)docId)) {
                throw new IllegalArgumentException("DocId must be set for each rated document");
            }
        }

        @Override
        public String toString() {
            return "{\"_index\":\"" + this.index + "\",\"_id\":\"" + this.docId + "\"}";
        }
    }
}

