/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bridge;

import java.util.Optional;
import java.util.Set;

public class Util {
    public static final Class<?> NO_CLASS = new Object(){}.getClass();
    private static final Set<String> skipInternalPackages = Set.of("java.lang.invoke", "java.lang.reflect", "jdk.internal.reflect");

    public static Class<?> getCallerClass() {
        Optional callerClassIfAny = StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE, StackWalker.Option.SHOW_HIDDEN_FRAMES)).walk(frames -> frames.skip(2L).filter(frame -> !skipInternalPackages.contains(frame.getDeclaringClass().getPackageName())).findFirst().map(StackWalker.StackFrame::getDeclaringClass));
        return callerClassIfAny.orElse(NO_CLASS);
    }
}

