/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageSaveContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateClientStorageSaveContext
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String SAVE_NOT_NEEDED = "NoSaveNeeded";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateClientStorageSaveContext.class);
    @Nonnull
    @NonnullElements
    private Collection<ClientStorageService> storageServices = Collections.emptyList();

    public void setStorageServices(@Nonnull @NonnullElements Collection<ClientStorageService> services) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageServices = List.copyOf((Collection)Constraint.isNotNull(services, (String)"StorageService collection cannot be null"));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)SAVE_NOT_NEEDED);
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)SAVE_NOT_NEEDED);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClientStorageSaveContext saveCtx = new ClientStorageSaveContext();
        for (ClientStorageService service : this.storageServices) {
            ClientStorageServiceOperation operation = service.save();
            if (operation == null) continue;
            saveCtx.getStorageOperations().add(operation);
        }
        if (saveCtx.getStorageOperations().isEmpty()) {
            this.log.debug("{} No ClientStorageServices require saving, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)SAVE_NOT_NEEDED);
        } else {
            profileRequestContext.addSubcontext((BaseContext)saveCtx, true);
            if (this.log.isDebugEnabled()) {
                Collection ids = saveCtx.getStorageOperations().stream().map(ClientStorageServiceOperation::getStorageServiceID).collect(Collectors.toList());
                this.log.debug("{} ClientStorageServices requiring save: {}", (Object)this.getLogPrefix(), (Object)ids);
            }
        }
    }
}

